```
number: 5
id: 656
title: repo.yona.io 서버 구성
type: BOARD_POST
author:
  loginId: doortts
  name: doortts
  email: doortts@gmail.com
createdAt: '2017-02-10 PM 01:21:46 +0900'
updatedAt: '2017-02-10 PM 05:31:13 +0900'
attachments:
  - id: 1273
    name: 62092177716.png
    hash: 16d89cf95df73d724a5133976924044d18d6e8cf
    mimeType: image/png
    size: 179458
    createdDate: 1486699276000
    ownerLoginId: doortts
  - id: 1274
    name: 1344702792288.png
    hash: 90d801f7a555c3c5851b69125d3f1e652b0328a5
    mimeType: image/png
    size: 17219
    createdDate: 1486699427000
    ownerLoginId: doortts
comments:
  - id: 59
    author:
      loginId: postimg
      name: 더미
      email: postimg@yopmail.com
    createdAt: '2017-02-10 PM 01:43:22 +0900'
    body: "SSL 설정은 웹서버와 버전에따라서 약간씩 다를 수 있습니다.\r\n\r\n[ssl-config-generator](https://mozilla.github.io/server-side-tls/ssl-config-generator/)를 참고 하시어 작성 하시면 좋습니다.\r\n\r\n[HSTS](https://lesstif.gitbooks.io/web-service-hardening/content/ssl-tls-https.html#hstshttp-strict-transport-security)설정은 필요 여부에 따라 설정하세요.\r\n\r\n설정한 시간동안은 http로 접속을 해도 https로 접속됩니다."
  - id: 60
    author:
      loginId: doortts
      name: doortts
      email: doortts@gmail.com
    createdAt: '2017-02-10 PM 01:45:29 +0900'
    body: "@postimg +1 \r\n저런 좋은 사이트가 있었는지 몰랐네요. 고맙습니다!!"
```
repo.yona.io 서버 구성
===

현재 데모 서버로 운영중인 repo.yona.io 는 2개의 서버로 운영중입니다.

각각을 Yona1 Yona2로 부르고 있고 Yona2는 Yona1의 Fail Over(접속 실패시 서비스 이전) 기능을 수행하고 있습니다. 
이 부분은 [Apache의 Proxy Load Balancer](https://httpd.apache.org/docs/2.4/mod/mod_proxy_balancer.html)를 이용해서 헬스체크 후 서비스가 넘어가게 구성했습니다. 하단의 ssl.conf 설정 부분에서 확인할 수 있습니다.

Yona1
---
- OS: CentOS release 6.7 (Final)
- [yona.io](http://yona.io) 및 [repo.yona.io](https://repo.yona.io) 메인서비스 서버
- 설치 및 운영 SW
  - Yona (최신 개발중인 상태)
  - Maria DB 
  - Apache 2.2

Yona2
----
- OS: CentOS Linux release 7.3 (Core)
- repo.yona.io fail over 서버
- 설치 및 운영 SW
  - Yona (최신 개발중인 상태)
  - Apache 2.2


Apache HTTP Server 주요 구성
---

### http.conf
```
<VirtualHost *:80>
  ProxyPreserveHost On
  ServerName yona.io
  DocumentRoot "/data/html"
</VirtualHost>
<VirtualHost *:80>
  ServerName repo.yona.io
  Redirect permanent / https://repo.yona.io/
  ErrorDocument 503 503.html
</VirtualHost>
```

repo.yona.io의 경우 http로 들어오는 요청은 모두 https로 redirect 하도록 구성해 놓았습니다.
그 외는 특별한 건 없습니다.

### ssl.conf (https 서비스용)
```
<Proxy balancer://myset>
    BalancerMember http://127.0.0.1:9000
    BalancerMember http://yona2:9000 status=+H
    ProxySet lbmethod=byrequests
</Proxy>

<VirtualHost _default_:443>
ProxyPreserveHost On
ServerName repo.yona.io:443
ProxyPass  /excluded !
ProxyPass  /robots.txt !
ProxyPass / "balancer://myset/"
ProxyPassReverse / "balancer://myset/"
DocumentRoot "/data/html"
ErrorDocument 503 http://yona.io/503.html

Header always set Strict-Transport-Security "max-age=63072000; includeSubdomains; preload"

<Proxy "https://repo.yona.io">
  ProxySet connectiontimeout=3 timeout=5
</Proxy>

SSLEngine on

SSLProtocol all -SSLv2 -SSLv3
SSLHonorCipherOrder on

SSLCipherSuite "EECDH+ECDSA+AESGCM EECDH+aRSA+AESGCM EECDH+ECDSA+SHA384 EECDH+ECDSA+SHA256 EECDH+aRSA+SHA384 EECDH+aRSA+SHA256 EECDH+aRSA+RC4 EECDH EDH+aRSA RC4 !aNULL !eNULL !LOW !3DES !MD5 !EXP !PSK !SRP !DSS !RC4"
```

- yona2는 외부에서 직접 접근이 안되는 내부망에 있고 yona1의 apache server가 reverse proxy로 중계를 해주고 있습니다.
- SSL의 경우 오래된 protocol들은 disable 시켜 놓았습니다. (sslv2 sslv3, sslv3같은 경우엔 tls 1.0이랑 동일해서 tls를 1.1이상으로 제한하지 않는 이상 큰 의미는 없습니다만 어쨌든.)
- SSLCipherSuite 도 약한 것들은 제외시켜 놓았고요.

이렇게 구성하면 대략 테스트 점수가 이렇게 나옵니다.

![62092177716.png](/files/1273)
출처: https://www.ssllabs.com/ssltest


Yona 구성
---
- 소스 버전으로 운영중이며 개발시 새로운 패치나 기능이 추가되면 거의 바로 일치시켜 놓습니다.
   - 개발 브랜치는 [next](https://github.com/yona-projects/yona/commits/next) 입니다. (릴리즈는 master 브랜치입니다.)
- 시작/재시작을 위한 스크립트로 yona-run.sh 을 따로 만들어 놓았습니다.

### yona-run.sh
```
PORT=9000
YONA_DATA=/data/yona;export YONA_DATA
PLAY2_HOME=/home/doortts/apps/play2

pid=`ps -ef | grep java | grep Dhttp.port=$PORT | awk '{print $2}'`
kill $pid
_JAVA_OPTIONS="-Xmx4096m -Xms4096m -Dyona.data=$YONA_DATA" $PLAY2_HOME/activator "start -DapplyEvolutions.default=true -Dhttp.port=$PORT"
```
참고: https://github.com/yona-projects/yona/blob/master/restart.sh


### sync-to-yona1.sh

yona2 서버랑 yona1 서버는 rsync를 이용해 서로 상호 파일 sync 하도록 만들어 놓았습니다.

```
date >> /home/doortts/sync.log
rsync -aP doortts@yona1:/data/yona/uploads/ /home/doortts/yona/uploads >> /home/doortts/sync.log
rsync -aP --delete doortts@yona1:/data/yona/repo/ /home/doortts/yona/repo >> /home/doortts/sync.log
```

### is-alive-bot.sh

서버 상태에 대한 알람은 Telegram Bot을 통해서 알람을 받게 만들어 놓았습니다.

참고: 
- https://github.com/doortts/is-alive-bot.sh
- https://github.com/yona-projects/yona/blob/master/is-alive-bot.sh

예를 들어 업데이트시에 메인서버인 Yona1을 잠시 죽이면 아래처럼 메시지가 옵니다.
![1290636349781.png](/files/1275)

그 외는 보통 일반적인 서버 설정들을 해 놓았습니다.
이를테면 Dos 공격막기 위한 iptable 처리나 Ban처리(fail2ban), ssh 설정, id/pw를 통한 로그인 금지 등등 같은 것들요.

적고보니 별건 없네요 ㅎ