```
number: 4
id: 653
title: Yona에서 Github으로 이사가는 방법
type: BOARD_POST
author:
  loginId: doortts
  name: doortts
  email: doortts@gmail.com
createdAt: '2017-02-07 AM 09:20:15 +0900'
updatedAt: '2017-02-08 AM 12:45:13 +0900'
```
Yona 에서 Github으로 이사가는 방법
===

어떤 제품을 사용하는데에 있어, 특히 온라인 서비스이면서 동시에 자신의 중요한 데이터들이 들어 있는 경우에라면 '백업'과 '이동'이 보장되어야 하는 것이 당연합니다. 만약 Yona를 운영/사용하다가 기능이나 운영등의 이슈로 이동을 원할때 아직은 제한적이지만 2가지 방법으로 이동이 가능합니다.

우선은 사용자의 소중한 데이터들의 편하 보관과 필요시의 이동/이전을 위해 Yona v1.1 버전부터 로컬PC로 프로젝트 데이터를 내려받는 방법([Yona Export](https://github.com/yona-projects/yona-export/))과 Yona 유사 기능을 상위세트로 제공하고 있는 Github으로 이사하는 방법(Migration)을 제공하고 있습니다.

이어지는 내용은 Yona에서 Github으로 이사가능 방법에 대한 설명입니다.

How to Yona to Github
===

Yona에서 Github으로 특정 프로젝트를 옮기려면 아래와 같은 준비가 우선 필요합니다.

준비사항
---
- Yona v1.1 이상
- Github 계정 

준비가 끝났으면 Yona와 Github 계정에 대해 각각 아래와 같은 작업을 진행합니다.

환경세팅 전체적인 진행순서
---
- Github: OAuth application 등록하고 client id와 secret 키 받기
- Yona: application.conf 에서 허용여부와 github 키들을 등록하고 재시작하기
- 설치된 Yona 서버에서 이제 /migration URL에서 github migration을 제공합니다.

이제 하나씩 자세히 살펴보도록 하겠습니다.

Github
---
계정 Settings 에 자신만의 OAuth application 등록

![1249365838131.png](/files/1156)

![1107459599319.png](/files/1157)

Developer settings 의 OAuth Applications를 선택한 다음

![349457845360.png](/files/1158)
Register new application 버튼을 누릅니다. 위 스크린샷에는 제가 이미 만들어 놓은 application이 보이고 있습니다.

![1440702016370.png](/files/1161)

Homepage URL: 설치하신 yona 서버 url이나 안내문을 볼수 있는 url을 적으시면 됩니다.
중요한 부분은 `Authorization callback URL` 인데요 여기에 설치한 yona 서버의 migration url을 정확히 적으셔야 합니다.
예를 들어 설치하신 yona의 서버 url이 `http://my-yona.com:9000` 이었다면 
Authorization callback URL은 `http://my-yona.com:9000/migration` 으로 적어주셔야 합니다.

repo.yona.io 같은 경우에는 아래처럼 만들었습니다.

![1333336021180.png](/files/1160)


생성하면 이제 client id와 secret를 볼 수 있게 됩니다.

![232200672739.png](/files/1162)

이제 설치한 Yona 서버쪽에 설정을 할 차례입니다.

Yona 설정
---

conf 파일 하단의 application.conf 파일에 아래 내용을 추가하거나 수정합니다.

예)
```
github.allow.migration = true
github.client.id = "e7f9ad76a3a4ba19b2c5" 
github.client.secret = "cb2aac9a67fb33ee5c42501f6c485bf285cf5"

```
**위 키값들은 예시용입니다. 그대로 사용하시면 동작안합니다~**

- github.allow.migration 의 기본값은 false 이고 true로 변경후 재시작하지 않으면 /migration 으로 접근하면 허용하지 않는 요청이라고 표시됩니다.
- `github.client.id`와 `github.client.secret`에 각각 앞에서 github에서 설정한 client id 와 secret 값을 복사해서 붙여 넣습니다.
- Yona 서버를 재시작하고 /migration URL로 접속하면 최초접속시에는 자동으로 github 으로 이동해서 로그인을 요청하게 됩니다.
- Gihtub 로그인을 하면 앞에서 만든 OAuth 애플리케이션에서 권한을 요청하는 화면이 등장합니다. 이때 Yes를 선택하셔야 정상적으로 권할을 부여받아서 Github 으로 프로젝트를 이동하는 것이 가능해집니다.
- 권한을 부여받으면 다시 설치한 Yona 서버로 자동으로 되돌아옵니다. (앞서 등록한 callback url 덕분입니다)

![64796853386.png](/files/1159)


- source와 destination를 선택해서 이동하면 Yona의 이슈와 게시글은 github 이슈로, milestone을 마찬가지로 github milestone으로 이동됩니다. 
- 단, github은 게시판이 없기때문에 Yona의 게시글은 '게시글' 라벨이 붙어서 github 이슈로 이동되는점을 유의해 주세요

이제 환경적인 준비는 다 되었고 실제로 프로젝트들을 이동하는 작업애 대해 설명합니다.

프로젝트 옮기기
===

준비사항
---
- git client 

전체적인 진행순서
--
- github 에 프로젝트 만들어 놓기
- 설치된 Yona 서버 migration url 에서 source와 destination(=github project) 선택
- 순서대로 이동
- wiki 페이지 생성
- Yona Export 를 이용햐서 첨부파일 이동

상세설명
---

- Github에 Yona 프로젝트에서 이동할 프로젝트를 만듭니다.

- 설치된 Yona v1.1 이상의 서버에서 /migration URL로 접근합니다.
```
예) http://127.0.0.1:9000/migration
```
- Source 에는 자신이 admin인 Yona 프로젝트 목록이, Destination 에는 이동 가능한 github 프로젝트 목록이 보입니다.
- 이동시에는 대상 프로젝트의 이슈를 지우거나 수정하지 않습니다. 따라서 여러번 이동을 누르면 중복해서 이슈가 게시글이 등록된다는 점을 유의해 주세요.
- 이미 이슈가 있는 프로젝트는 경고가 뜨니까 확인해 주쎄요
- 이슈를 먼저 이동하면 게시글 이동할때는 마찬가지로 이미 이슈가 등록되어있다고 경고가 뜨지만 그럴수 밖에 없습니다. Yona의 이슈와 게시글을 github에서는 다 이슈로 이동하기때문입니다.
- 기다리면 상단에 메시지와 이동 진행막대가 보일겁니다.
- 만약 이동중에 문제가 생기면 github 프로젝트를 지우고 다시 생성해서 진행하시면 됩니다.

첨부파일 이동
---
- 이슈나 게시판을 옮기고 보면 첨부파일들이 모두 빠져있는것으로 보입니다.
- 첨부파일 이동은 github의 wiki 기능을 이용해서 한번에 옮기도록 만들었습니다.
- 대상 github 프로젝트가서 wiki 메뉴에서 페이지를 만듭니다. (만든적이 있으면 생략가능)
![591968731021.png](/files/1151)
![1421371255546.png](/files/1152)
특별히 내용입력할 필요 없습니다. `Save Page` 누르세요.
- 만들고 나면 wiki 페이지를 clone 할 수 있는 url 이 보입니다.
![1072515748554.png](/files/1153)
- [Yona Export](https://github.com/yona-projects/yona-export) 를 이용해서 이동대상 프로젝트의 첨부파일을 내려받습니다.
- Yona Exoprt 를 사용하면 로컬 exported 폴더에 대상 프로젝트의 글들과 files 폴더가 생겨있는걸 볼 수 있습니다.
![47350399837.png](/files/1154)

이제 위에서 만들어진 wiki URL을 이용해서 files를 wiki 저장소로 집어 넣으면 됩니다. 
아래는 wiki URL이 https://github.com/doortts/test.wiki.git 일 경우에 대한 예시입니다.
```
git init
git remote add origin https://github.com/doortts/test.wiki.git
git add files
git commit -m "Upload files"
git push origin master -u
``` 
- github id와 password를 물어보면 잘 입력합니다.
- 참고로 50M 이하의 파일만 정상적으로 업로드가 되니 유의하세요!

- 첨부파일 업로드가 다 끝나면 이제 이슈와 게시글의 첨부파일들이 잘 보이는지 확인해 봅니다.

끝!

주의사항!!
---
- Github은 api call limit 이 있습니다. 분당 150을 넘어가면 abuse detection 이 뜨면서 한 시간동안 api call을 할 수 없게 됩니다.
- 그래서 일부러 조금 느리게 보내도록 되어 있습니다만 같은 서버내에서 동시에 어려명이 이사를 시도하면 이 limit에 쉽게 걸릴테니 담당자를 정하거나 적절히 잘 분배해서 진행하시길 권합니다.
- 첨부파일은 참고로 50M 이하의 파일만 정상적으로 업로드가 되니 유의하세요!