/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ning;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.Realm;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import play.libs.F;
import play.libs.ws.WSAuthScheme;
import play.libs.ws.WSRequest;
import play.libs.ws.WSResponse;
import play.libs.ws.ning.NingWSClient;
import play.libs.ws.ning.NingWSResponse;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

public class NingWSRequest
implements WSRequest {
    private final FluentCaseInsensitiveStringsMap headers;
    private final String method;
    private final RequestBuilder builder;
    private final NingWSClient client;
    private final byte[] body;

    public NingWSRequest(NingWSClient ningWSClient, String string, String string2, Map<String, Collection<String>> map, Map<String, Collection<String>> map2) {
        this(ningWSClient, string, string2, map, new FluentCaseInsensitiveStringsMap(map2), null);
    }

    public NingWSRequest(NingWSClient ningWSClient, String string, String string2, Map<String, Collection<String>> map, FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap) {
        this(ningWSClient, string, string2, map, fluentCaseInsensitiveStringsMap, null);
    }

    public NingWSRequest(NingWSClient ningWSClient, String string, String string2, Map<String, Collection<String>> map, FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap, byte[] byArray) {
        this.client = ningWSClient;
        this.builder = new RequestBuilder(string);
        this.method = string;
        this.headers = fluentCaseInsensitiveStringsMap;
        this.body = byArray;
        this.builder.setUrl(string2).setQueryParameters(new FluentStringsMap(map)).setHeaders(fluentCaseInsensitiveStringsMap);
    }

    @Override
    public Map<String, List<String>> getAllHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeader(String string) {
        List list = this.headers.get((Object)string);
        if (list == null) {
            return new ArrayList<String>();
        }
        return list;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getUrl() {
        return this.builder.build().getUrl();
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    public WSRequest auth(String string, String string2, WSAuthScheme wSAuthScheme) {
        Realm.AuthScheme authScheme = this.getAuthScheme(wSAuthScheme);
        this.builder.setRealm(new Realm.RealmBuilder().setScheme(authScheme).setPrincipal(string).setPassword(string2).setUsePreemptiveAuth(true).build());
        return this;
    }

    @Override
    public F.Promise<WSResponse> execute() {
        final Promise promise = Promise$.MODULE$.apply();
        try {
            AsyncHttpClient asyncHttpClient = (AsyncHttpClient)this.client.getUnderlying();
            asyncHttpClient.executeRequest(this.getBuilder().build(), (AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) {
                    Response response2 = response;
                    promise.success((Object)new NingWSResponse(response2));
                    return response;
                }

                public void onThrowable(Throwable throwable) {
                    promise.failure(throwable);
                }
            });
        }
        catch (IOException iOException) {
            promise.failure((Throwable)iOException);
        }
        return new F.Promise(promise.future());
    }

    @Override
    @Deprecated
    public NingWSRequest setHeader(String string, String string2) {
        this.builder.setHeader(string, string2);
        return this;
    }

    @Override
    @Deprecated
    public NingWSRequest addHeader(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.builder.addHeader(string, string2);
        return this;
    }

    @Override
    @Deprecated
    public NingWSRequest setHeaders(Map<String, Collection<String>> map) {
        this.builder.setHeaders(map);
        return this;
    }

    @Override
    @Deprecated
    public NingWSRequest setUrl(String string) {
        this.builder.setUrl(string);
        return this;
    }

    NingWSRequest setBody(String string) {
        this.builder.setBody(string);
        return this;
    }

    NingWSRequest setBodyEncoding(String string) {
        this.builder.setBodyEncoding(string);
        return this;
    }

    NingWSRequest setBody(InputStream inputStream) {
        this.builder.setBody((BodyGenerator)new InputStreamBodyGenerator(inputStream));
        return this;
    }

    NingWSRequest setPerRequestConfig(PerRequestConfig perRequestConfig) {
        this.builder.setPerRequestConfig(perRequestConfig);
        return this;
    }

    NingWSRequest setFollowRedirects(Boolean bl) {
        this.builder.setFollowRedirects(bl.booleanValue());
        return this;
    }

    NingWSRequest setBody(File file) {
        this.builder.setBody(file);
        return this;
    }

    NingWSRequest setVirtualHost(String string) {
        this.builder.setVirtualHost(string);
        return this;
    }

    RequestBuilder getBuilder() {
        return this.builder;
    }

    Realm.AuthScheme getAuthScheme(WSAuthScheme wSAuthScheme) {
        return Realm.AuthScheme.valueOf((String)wSAuthScheme.name());
    }
}

