/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ning;

import com.ning.http.client.AsyncHttpClientConfig;
import java.util.concurrent.atomic.AtomicReference;
import play.Application;
import play.api.Configuration;
import play.api.libs.ws.DefaultWSConfigParser;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ning.NingAsyncHttpClientConfigBuilder;
import play.libs.F;
import play.libs.ws.WSAPI;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.ning.NingWSClient;

public class NingWSAPI
implements WSAPI {
    private final AtomicReference<F.Option<NingWSClient>> clientHolder = new AtomicReference<F.None>(F.None());
    private Application app;

    public NingWSAPI(Application application) {
        this.app = application;
    }

    private NingWSClient newClient() {
        Configuration configuration = this.app.configuration().getWrappedConfiguration();
        DefaultWSConfigParser defaultWSConfigParser = new DefaultWSConfigParser(configuration, this.app.classloader());
        WSClientConfig wSClientConfig = defaultWSConfigParser.parse();
        NingAsyncHttpClientConfigBuilder ningAsyncHttpClientConfigBuilder = new NingAsyncHttpClientConfigBuilder(wSClientConfig, new AsyncHttpClientConfig.Builder());
        AsyncHttpClientConfig asyncHttpClientConfig = ningAsyncHttpClientConfigBuilder.build();
        return new NingWSClient(asyncHttpClientConfig);
    }

    protected void resetClient() {
        this.clientHolder.getAndSet((F.Option<NingWSClient>)F.None()).map((F.Function)new F.Function<NingWSClient, F.Option<NingWSClient>>(){

            public F.Option<NingWSClient> apply(NingWSClient ningWSClient) throws Throwable {
                ningWSClient.close();
                return F.Option.None();
            }
        });
    }

    @Override
    public synchronized WSClient client() {
        F.Option<NingWSClient> option = this.clientHolder.get();
        if (option.isEmpty()) {
            NingWSClient ningWSClient = this.newClient();
            this.clientHolder.set((F.Option<NingWSClient>)F.Some((Object)ningWSClient));
            return ningWSClient;
        }
        return (WSClient)option.get();
    }

    @Override
    public WSRequestHolder url(String string) {
        return this.client().url(string);
    }
}

