/*
 * Decompiled with CFR 0.152.
 */
package play.core.system;

import play.api.Application;
import play.api.Configuration;
import play.api.Play$;
import play.api.Plugin;
import play.api.Plugin$class;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001\u0013\tyQ*[4sCRLwN\u001c%fYB,'O\u0003\u0002\u0004\t\u000511/_:uK6T!!\u0002\u0004\u0002\t\r|'/\u001a\u0006\u0002\u000f\u0005!\u0001\u000f\\1z\u0007\u0001\u00192\u0001\u0001\u0006\u0011!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0003F\u0007\u0002%)\u00111CB\u0001\u0004CBL\u0017BA\u000b\u0013\u0005\u0019\u0001F.^4j]\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\u0002baB\u0004\"!E\r\n\u0005i\u0011\"aC!qa2L7-\u0019;j_:DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtDC\u0001\u0010!!\ty\u0002!D\u0001\u0003\u0011\u001592\u00041\u0001\u0019\u0011\u0015\u0011\u0003\u0001\"\u0011$\u0003\u001dygn\u0015;beR$\u0012\u0001\n\t\u0003\u0017\u0015J!A\n\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006Q\u0001!\t!K\u0001\u0013G\",7m[*fgNLwN\\'bq\u0006;W-F\u0001+!\rY1\u0006J\u0005\u0003Y1\u0011aa\u00149uS>t\u0007\"\u0002\u0018\u0001\t\u0003z\u0013aB3oC\ndW\rZ\u000b\u0002aA\u00111\"M\u0005\u0003e1\u0011qAQ8pY\u0016\fg\u000e")
public class MigrationHelper
implements Plugin {
    private final Application app;

    @Override
    public void onStop() {
        Plugin$class.onStop(this);
    }

    @Override
    public void onStart() {
        this.checkSessionMaxAge();
    }

    public Option<BoxedUnit> checkSessionMaxAge() {
        Configuration qual$1 = this.app.configuration();
        String x$2 = "session.maxAge";
        Option<Set<String>> x$3 = qual$1.getString$default$2();
        return qual$1.getString(x$2, x$3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String maxAge) {
                if (maxAge.matches("\\d+") && new StringOps(Predef$.MODULE$.augmentString(maxAge)).toLong() < 600000L) {
                    Play$.MODULE$.logger().warn((Function0<String>)new Serializable(this, maxAge){
                        public static final long serialVersionUID = 0L;
                        private final String maxAge$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n              |In Play 2.3, session.maxAge was changed from being an integer for the number of seconds to being a\n              |duration. This means you can now specify time units, for example 1h, or 30m etc. If however, no time\n              |unit is specified, it defaults to milliseconds, making this a breaking change. The configured value\n              |in this application (", ") does not have a time unit, and is suspiciously low for a session\n              |timeout, you may need to update your configuration. To prevent this warning message from showing in\n              |future, either add a time unit to the session.maxAge configuration item (eg, ms), or disable the\n              |migration helper plugin using play.migrationhelper=disabled.\n            "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.maxAge$1})))).stripMargin();
                        }
                        {
                            this.maxAge$1 = maxAge$1;
                        }
                    });
                }
            }
        });
    }

    @Override
    public boolean enabled() {
        Configuration qual$2 = this.app.configuration();
        String x$4 = "play.migrationhelper";
        Option<Set<String>> x$5 = qual$2.getString$default$2();
        return qual$2.getString(x$4, x$5).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                String string = x$1;
                String string2 = "disabled";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        });
    }

    public MigrationHelper(Application app) {
        this.app = app;
        Plugin$class.$init$(this);
    }
}

