/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.enhance.agent;

import com.avaje.ebean.enhance.agent.ClassBytesReader;
import com.avaje.ebean.enhance.agent.InputStreamTransform;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassPathClassBytesReader
implements ClassBytesReader {
    private final URL[] urls;

    public ClassPathClassBytesReader(URL[] urls) {
        this.urls = urls == null ? new URL[]{} : urls;
    }

    @Override
    public byte[] getClassBytes(String className, ClassLoader classLoader) {
        URLClassLoader cl = new URLClassLoader(this.urls, classLoader);
        String resource = className.replace('.', '/') + ".class";
        InputStream is = null;
        try {
            byte[] classBytes;
            URL url = cl.getResource(resource);
            if (url == null) {
                throw new RuntimeException("Class Resource not found for " + resource);
            }
            is = url.openStream();
            byte[] byArray = classBytes = InputStreamTransform.readBytes(is);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException reading bytes for " + className, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing InputStream for " + className, e);
                }
            }
        }
    }
}

