/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.enhance.agent;

import com.avaje.ebean.enhance.agent.AnnotationInfo;
import com.avaje.ebean.enhance.asm.AnnotationVisitor;

public class AnnotationInfoVisitor
implements AnnotationVisitor {
    final AnnotationVisitor av;
    final AnnotationInfo info;
    final String prefix;

    public AnnotationInfoVisitor(String prefix, AnnotationInfo info, AnnotationVisitor av) {
        this.av = av;
        this.info = info;
        this.prefix = prefix;
    }

    @Override
    public void visit(String name, Object value) {
        this.info.add(this.prefix, name, value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return this.create(name);
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        return this.create(name);
    }

    private AnnotationInfoVisitor create(String name) {
        String newPrefix = this.prefix == null ? name : this.prefix + "." + name;
        return new AnnotationInfoVisitor(newPrefix, this.info, this.av);
    }

    @Override
    public void visitEnd() {
        this.av.visitEnd();
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.info.addEnum(this.prefix, name, desc, value);
        this.av.visitEnum(name, desc, value);
    }
}

