/*
 * Decompiled with CFR 0.152.
 */
package validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.data.validation.Constraints;
import play.libs.F;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ExConstraints {

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class RestrictedValidator
    extends Constraints.Validator<Object>
    implements ConstraintValidator<Restricted, Object> {
        public static final String message = "error.restricted";
        private String[] words;
        private boolean ignoreCase;

        public void initialize(Restricted constraintAnnotation) {
            this.words = constraintAnnotation.value();
            this.ignoreCase = constraintAnnotation.ignoreCase();
        }

        public boolean isValid(Object object) {
            if (object == null) {
                return false;
            }
            if (this.words == null) {
                return true;
            }
            String value = String.valueOf(object);
            for (String word : this.words) {
                if (!this.ignoreCase && value.equalsIgnoreCase(word)) {
                    return false;
                }
                if (!this.ignoreCase || !value.equals(word)) continue;
                return false;
            }
            return true;
        }

        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[0]);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={RestrictedValidator.class})
    @Form.Display(name="constraint.restricted")
    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static @interface Restricted {
        public String message() default "error.restricted";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public String[] value();

        public boolean ignoreCase() default false;
    }
}

