/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class diff_match_patch {
    public float Diff_Timeout = 1.0f;
    public short Diff_EditCost = (short)4;
    public short Diff_DualThreshold = (short)32;
    public float Match_Threshold = 0.5f;
    public int Match_Distance = 1000;
    public float Patch_DeleteThreshold = 0.5f;
    public short Patch_Margin = (short)4;
    private int Match_MaxBits = 32;
    private Pattern BLANKLINEEND = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private Pattern BLANKLINESTART = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    public LinkedList<Diff> diff_main(String text1, String text2) {
        return this.diff_main(text1, text2, true);
    }

    public LinkedList<Diff> diff_main(String text1, String text2, boolean checklines) {
        if (text1.equals(text2)) {
            LinkedList<Diff> diffs = new LinkedList<Diff>();
            diffs.add(new Diff(Operation.EQUAL, text1));
            return diffs;
        }
        int commonlength = this.diff_commonPrefix(text1, text2);
        String commonprefix = text1.substring(0, commonlength);
        text1 = text1.substring(commonlength);
        text2 = text2.substring(commonlength);
        commonlength = this.diff_commonSuffix(text1, text2);
        String commonsuffix = text1.substring(text1.length() - commonlength);
        text1 = text1.substring(0, text1.length() - commonlength);
        text2 = text2.substring(0, text2.length() - commonlength);
        LinkedList<Diff> diffs = this.diff_compute(text1, text2, checklines);
        if (commonprefix.length() != 0) {
            diffs.addFirst(new Diff(Operation.EQUAL, commonprefix));
        }
        if (commonsuffix.length() != 0) {
            diffs.addLast(new Diff(Operation.EQUAL, commonsuffix));
        }
        this.diff_cleanupMerge(diffs);
        return diffs;
    }

    protected LinkedList<Diff> diff_compute(String text1, String text2, boolean checklines) {
        String shorttext;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        if (text1.length() == 0) {
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        if (text2.length() == 0) {
            diffs.add(new Diff(Operation.DELETE, text1));
            return diffs;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        int i = longtext.indexOf(shorttext = text1.length() > text2.length() ? text2 : text1);
        if (i != -1) {
            Operation op = text1.length() > text2.length() ? Operation.DELETE : Operation.INSERT;
            diffs.add(new Diff(op, longtext.substring(0, i)));
            diffs.add(new Diff(Operation.EQUAL, shorttext));
            diffs.add(new Diff(op, longtext.substring(i + shorttext.length())));
            return diffs;
        }
        shorttext = null;
        longtext = null;
        String[] hm = this.diff_halfMatch(text1, text2);
        if (hm != null) {
            String text1_a = hm[0];
            String text1_b = hm[1];
            String text2_a = hm[2];
            String text2_b = hm[3];
            String mid_common = hm[4];
            LinkedList<Diff> diffs_a = this.diff_main(text1_a, text2_a, checklines);
            LinkedList<Diff> diffs_b = this.diff_main(text1_b, text2_b, checklines);
            diffs = diffs_a;
            diffs.add(new Diff(Operation.EQUAL, mid_common));
            diffs.addAll(diffs_b);
            return diffs;
        }
        if (checklines && (text1.length() < 100 || text2.length() < 100)) {
            checklines = false;
        }
        List<String> linearray = null;
        if (checklines) {
            LinesToCharsResult b = this.diff_linesToChars(text1, text2);
            text1 = b.chars1;
            text2 = b.chars2;
            linearray = b.lineArray;
        }
        if ((diffs = this.diff_map(text1, text2)) == null) {
            diffs = new LinkedList();
            diffs.add(new Diff(Operation.DELETE, text1));
            diffs.add(new Diff(Operation.INSERT, text2));
        }
        if (checklines) {
            this.diff_charsToLines(diffs, linearray);
            this.diff_cleanupSemantic(diffs);
            diffs.add(new Diff(Operation.EQUAL, ""));
            int count_delete = 0;
            int count_insert = 0;
            String text_delete = "";
            String text_insert = "";
            ListIterator<Diff> pointer = diffs.listIterator();
            Diff thisDiff = (Diff)pointer.next();
            while (thisDiff != null) {
                Diff diff2 = thisDiff;
                Object object = null;
                object = diff2.getOperation();
                switch (object) {
                    case INSERT: {
                        ++count_insert;
                        diff2 = thisDiff;
                        object = null;
                        object = diff2.getText();
                        text_insert = text_insert + (String)object;
                        break;
                    }
                    case DELETE: {
                        ++count_delete;
                        diff2 = thisDiff;
                        object = null;
                        object = diff2.getText();
                        text_delete = text_delete + (String)object;
                        break;
                    }
                    case EQUAL: {
                        if (count_delete >= 1 && count_insert >= 1) {
                            pointer.previous();
                            for (int j = 0; j < count_delete + count_insert; ++j) {
                                pointer.previous();
                                pointer.remove();
                            }
                            for (Diff newDiff : this.diff_main(text_delete, text_insert, false)) {
                                pointer.add(newDiff);
                            }
                        }
                        count_insert = 0;
                        count_delete = 0;
                        text_delete = "";
                        text_insert = "";
                    }
                }
                thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
            }
            diffs.removeLast();
        }
        return diffs;
    }

    protected LinesToCharsResult diff_linesToChars(String text1, String text2) {
        ArrayList<String> lineArray = new ArrayList<String>();
        HashMap<String, Integer> lineHash = new HashMap<String, Integer>();
        lineArray.add("");
        String chars1 = this.diff_linesToCharsMunge(text1, lineArray, lineHash);
        String chars2 = this.diff_linesToCharsMunge(text2, lineArray, lineHash);
        return new LinesToCharsResult(chars1, chars2, lineArray);
    }

    private String diff_linesToCharsMunge(String text, List<String> lineArray, Map<String, Integer> lineHash) {
        int lineStart = 0;
        int lineEnd = -1;
        StringBuilder chars = new StringBuilder();
        while (lineEnd < text.length() - 1) {
            lineEnd = text.indexOf(10, lineStart);
            if (lineEnd == -1) {
                lineEnd = text.length() - 1;
            }
            String line = text.substring(lineStart, lineEnd + 1);
            lineStart = lineEnd + 1;
            if (lineHash.containsKey(line)) {
                chars.append(String.valueOf((char)lineHash.get(line).intValue()));
                continue;
            }
            lineArray.add(line);
            lineHash.put(line, lineArray.size() - 1);
            chars.append(String.valueOf((char)(lineArray.size() - 1)));
        }
        return chars.toString();
    }

    protected void diff_charsToLines(LinkedList<Diff> diffs, List<String> lineArray) {
        for (Diff diff2 : diffs) {
            String string;
            Diff diff3;
            StringBuilder text = new StringBuilder();
            int y = 0;
            while (true) {
                diff3 = diff2;
                string = null;
                string = diff3.getText();
                if (y >= string.length()) break;
                diff3 = diff2;
                string = null;
                string = diff3.getText();
                text.append(lineArray.get(string.charAt(y)));
                ++y;
            }
            string = text.toString();
            diff3 = diff2;
            diff3.setText(string);
        }
    }

    protected LinkedList<Diff> diff_map(String text1, String text2) {
        int text2_length;
        long ms_end = System.currentTimeMillis() + (long)(this.Diff_Timeout * 1000.0f);
        int text1_length = text1.length();
        int max_d = text1_length + (text2_length = text2.length()) - 1;
        boolean doubleEnd = this.Diff_DualThreshold * 2 < max_d;
        List<Set<Long>> v_map1 = new ArrayList<Set<Long>>();
        List<Set<Long>> v_map2 = new ArrayList();
        HashMap<Integer, Integer> v1 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> v2 = new HashMap<Integer, Integer>();
        v1.put(1, 0);
        v2.put(1, 0);
        Long footstep = 0L;
        HashMap<Long, Integer> footsteps = new HashMap<Long, Integer>();
        boolean done = false;
        boolean front = (text1_length + text2_length) % 2 == 1;
        for (int d = 0; d < max_d; ++d) {
            int y;
            int x;
            int k;
            if (this.Diff_Timeout > 0.0f && System.currentTimeMillis() > ms_end) {
                return null;
            }
            v_map1.add(new HashSet());
            for (k = -d; k <= d; k += 2) {
                x = k == -d || k != d && (Integer)v1.get(k - 1) < (Integer)v1.get(k + 1) ? (Integer)v1.get(k + 1) : (Integer)v1.get(k - 1) + 1;
                y = x - k;
                if (doubleEnd) {
                    footstep = this.diff_footprint(x, y);
                    if (front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (!front) {
                        footsteps.put(footstep, d);
                    }
                }
                while (!done && x < text1_length && y < text2_length && text1.charAt(x) == text2.charAt(y)) {
                    ++x;
                    ++y;
                    if (!doubleEnd) continue;
                    footstep = this.diff_footprint(x, y);
                    if (front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (front) continue;
                    footsteps.put(footstep, d);
                }
                v1.put(k, x);
                ((Set)v_map1.get(d)).add(this.diff_footprint(x, y));
                if (x == text1_length && y == text2_length) {
                    return this.diff_path1(v_map1, text1, text2);
                }
                if (!done) continue;
                v_map2 = v_map2.subList(0, (Integer)footsteps.get(footstep) + 1);
                LinkedList<Diff> a = this.diff_path1(v_map1, text1.substring(0, x), text2.substring(0, y));
                a.addAll(this.diff_path2(v_map2, text1.substring(x), text2.substring(y)));
                return a;
            }
            if (!doubleEnd) continue;
            v_map2.add(new HashSet());
            for (k = -d; k <= d; k += 2) {
                x = k == -d || k != d && (Integer)v2.get(k - 1) < (Integer)v2.get(k + 1) ? (Integer)v2.get(k + 1) : (Integer)v2.get(k - 1) + 1;
                y = x - k;
                footstep = this.diff_footprint(text1_length - x, text2_length - y);
                if (!front && footsteps.containsKey(footstep)) {
                    done = true;
                }
                if (front) {
                    footsteps.put(footstep, d);
                }
                while (!done && x < text1_length && y < text2_length && text1.charAt(text1_length - x - 1) == text2.charAt(text2_length - y - 1)) {
                    footstep = this.diff_footprint(text1_length - ++x, text2_length - ++y);
                    if (!front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (!front) continue;
                    footsteps.put(footstep, d);
                }
                v2.put(k, x);
                ((Set)v_map2.get(d)).add(this.diff_footprint(x, y));
                if (!done) continue;
                v_map1 = v_map1.subList(0, (Integer)footsteps.get(footstep) + 1);
                LinkedList<Diff> a = this.diff_path1(v_map1, text1.substring(0, text1_length - x), text2.substring(0, text2_length - y));
                a.addAll(this.diff_path2(v_map2, text1.substring(text1_length - x), text2.substring(text2_length - y)));
                return a;
            }
        }
        return null;
    }

    protected LinkedList<Diff> diff_path1(List<Set<Long>> v_map, String text1, String text2) {
        LinkedList<Diff> path = new LinkedList<Diff>();
        int x = text1.length();
        int y = text2.length();
        Operation last_op = null;
        block0: for (int d = v_map.size() - 2; d >= 0; --d) {
            while (true) {
                String string;
                Diff diff2;
                if (v_map.get(d).contains(this.diff_footprint(x - 1, y))) {
                    --x;
                    if (last_op == Operation.DELETE) {
                        diff2 = path.getFirst();
                        string = null;
                        string = diff2.getText();
                        string = text1.charAt(x) + string;
                        diff2 = path.getFirst();
                        diff2.setText(string);
                    } else {
                        path.addFirst(new Diff(Operation.DELETE, text1.substring(x, x + 1)));
                    }
                    last_op = Operation.DELETE;
                    continue block0;
                }
                if (v_map.get(d).contains(this.diff_footprint(x, y - 1))) {
                    --y;
                    if (last_op == Operation.INSERT) {
                        diff2 = path.getFirst();
                        string = null;
                        string = diff2.getText();
                        string = text2.charAt(y) + string;
                        diff2 = path.getFirst();
                        diff2.setText(string);
                    } else {
                        path.addFirst(new Diff(Operation.INSERT, text2.substring(y, y + 1)));
                    }
                    last_op = Operation.INSERT;
                    continue block0;
                }
                assert (text1.charAt(--x) == text2.charAt(--y)) : "No diagonal.  Can't happen. (diff_path1)";
                if (last_op == Operation.EQUAL) {
                    diff2 = path.getFirst();
                    string = null;
                    string = diff2.getText();
                    string = text1.charAt(x) + string;
                    diff2 = path.getFirst();
                    diff2.setText(string);
                } else {
                    path.addFirst(new Diff(Operation.EQUAL, text1.substring(x, x + 1)));
                }
                last_op = Operation.EQUAL;
            }
        }
        return path;
    }

    protected LinkedList<Diff> diff_path2(List<Set<Long>> v_map, String text1, String text2) {
        LinkedList<Diff> path = new LinkedList<Diff>();
        int x = text1.length();
        int y = text2.length();
        Operation last_op = null;
        block0: for (int d = v_map.size() - 2; d >= 0; --d) {
            while (true) {
                String string;
                Diff diff2;
                if (v_map.get(d).contains(this.diff_footprint(x - 1, y))) {
                    --x;
                    if (last_op == Operation.DELETE) {
                        diff2 = path.getLast();
                        string = null;
                        string = diff2.getText();
                        string = string + text1.charAt(text1.length() - x - 1);
                        diff2.setText(string);
                    } else {
                        path.addLast(new Diff(Operation.DELETE, text1.substring(text1.length() - x - 1, text1.length() - x)));
                    }
                    last_op = Operation.DELETE;
                    continue block0;
                }
                if (v_map.get(d).contains(this.diff_footprint(x, y - 1))) {
                    --y;
                    if (last_op == Operation.INSERT) {
                        diff2 = path.getLast();
                        string = null;
                        string = diff2.getText();
                        string = string + text2.charAt(text2.length() - y - 1);
                        diff2.setText(string);
                    } else {
                        path.addLast(new Diff(Operation.INSERT, text2.substring(text2.length() - y - 1, text2.length() - y)));
                    }
                    last_op = Operation.INSERT;
                    continue block0;
                }
                assert (text1.charAt(text1.length() - --x - 1) == text2.charAt(text2.length() - --y - 1)) : "No diagonal.  Can't happen. (diff_path2)";
                if (last_op == Operation.EQUAL) {
                    diff2 = path.getLast();
                    string = null;
                    string = diff2.getText();
                    string = string + text1.charAt(text1.length() - x - 1);
                    diff2.setText(string);
                } else {
                    path.addLast(new Diff(Operation.EQUAL, text1.substring(text1.length() - x - 1, text1.length() - x)));
                }
                last_op = Operation.EQUAL;
            }
        }
        return path;
    }

    protected long diff_footprint(int x, int y) {
        long result2 = x;
        result2 <<= 32;
        return result2 += (long)y;
    }

    public int diff_commonPrefix(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        for (int i = 0; i < n; ++i) {
            if (text1.charAt(i) == text2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public int diff_commonSuffix(String text1, String text2) {
        int text1_length = text1.length();
        int text2_length = text2.length();
        int n = Math.min(text1_length, text2_length);
        for (int i = 1; i <= n; ++i) {
            if (text1.charAt(text1_length - i) == text2.charAt(text2_length - i)) continue;
            return i - 1;
        }
        return n;
    }

    protected String[] diff_halfMatch(String text1, String text2) {
        String[] hm;
        String shorttext;
        String longtext = text1.length() > text2.length() ? text1 : text2;
        String string = shorttext = text1.length() > text2.length() ? text2 : text1;
        if (longtext.length() < 10 || shorttext.length() < 1) {
            return null;
        }
        String[] hm1 = this.diff_halfMatchI(longtext, shorttext, (longtext.length() + 3) / 4);
        String[] hm2 = this.diff_halfMatchI(longtext, shorttext, (longtext.length() + 1) / 2);
        if (hm1 == null && hm2 == null) {
            return null;
        }
        if (hm2 == null) {
            hm = hm1;
        } else if (hm1 == null) {
            hm = hm2;
        } else {
            String[] stringArray = hm = hm1[4].length() > hm2[4].length() ? hm1 : hm2;
        }
        if (text1.length() > text2.length()) {
            return hm;
        }
        return new String[]{hm[2], hm[3], hm[0], hm[1], hm[4]};
    }

    private String[] diff_halfMatchI(String longtext, String shorttext, int i) {
        String seed = longtext.substring(i, i + longtext.length() / 4);
        int j = -1;
        String best_common = "";
        String best_longtext_a = "";
        String best_longtext_b = "";
        String best_shorttext_a = "";
        String best_shorttext_b = "";
        while ((j = shorttext.indexOf(seed, j + 1)) != -1) {
            int prefixLength = this.diff_commonPrefix(longtext.substring(i), shorttext.substring(j));
            int suffixLength = this.diff_commonSuffix(longtext.substring(0, i), shorttext.substring(0, j));
            if (best_common.length() >= suffixLength + prefixLength) continue;
            best_common = shorttext.substring(j - suffixLength, j) + shorttext.substring(j, j + prefixLength);
            best_longtext_a = longtext.substring(0, i - suffixLength);
            best_longtext_b = longtext.substring(i + prefixLength);
            best_shorttext_a = shorttext.substring(0, j - suffixLength);
            best_shorttext_b = shorttext.substring(j + prefixLength);
        }
        if (best_common.length() >= longtext.length() / 2) {
            return new String[]{best_longtext_a, best_longtext_b, best_shorttext_a, best_shorttext_b, best_common};
        }
        return null;
    }

    public void diff_cleanupSemantic(LinkedList<Diff> diffs) {
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        Object lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        int length_changes1 = 0;
        int length_changes2 = 0;
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            Diff diff2 = thisDiff;
            Object object = null;
            object = diff2.getOperation();
            if (object == Operation.EQUAL) {
                equalities.push(thisDiff);
                length_changes1 = length_changes2;
                length_changes2 = 0;
                diff2 = thisDiff;
                object = null;
                lastequality = object = diff2.getText();
            } else {
                diff2 = thisDiff;
                object = null;
                object = diff2.getText();
                if (lastequality != null && ((String)lastequality).length() <= length_changes1 && ((String)lastequality).length() <= (length_changes2 += ((String)object).length())) {
                    while (thisDiff != equalities.lastElement()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, (String)lastequality));
                    pointer.add(new Diff(Operation.INSERT, (String)lastequality));
                    equalities.pop();
                    if (!equalities.empty()) {
                        equalities.pop();
                    }
                    if (equalities.empty()) {
                        while (pointer.hasPrevious()) {
                            pointer.previous();
                        }
                    } else {
                        thisDiff = (Diff)equalities.lastElement();
                        while (thisDiff != pointer.previous()) {
                        }
                    }
                    length_changes1 = 0;
                    length_changes2 = 0;
                    lastequality = null;
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diff_cleanupMerge(diffs);
        }
        this.diff_cleanupSemanticLossless(diffs);
    }

    public void diff_cleanupSemanticLossless(LinkedList<Diff> diffs) {
        Diff nextDiff;
        ListIterator pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff2 = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            Diff diff3 = prevDiff;
            Object object = null;
            object = diff3.getOperation();
            if (object == Operation.EQUAL) {
                diff3 = nextDiff;
                object = null;
                object = diff3.getOperation();
                if (object == Operation.EQUAL) {
                    diff3 = prevDiff;
                    object = null;
                    Object equality1 = object = diff3.getText();
                    diff3 = thisDiff;
                    object = null;
                    Object edit2 = object = diff3.getText();
                    diff3 = nextDiff;
                    object = null;
                    Object equality2 = object = diff3.getText();
                    int commonOffset = this.diff_commonSuffix((String)equality1, (String)edit2);
                    if (commonOffset != 0) {
                        String commonString = ((String)edit2).substring(((String)edit2).length() - commonOffset);
                        equality1 = ((String)equality1).substring(0, ((String)equality1).length() - commonOffset);
                        edit2 = commonString + ((String)edit2).substring(0, ((String)edit2).length() - commonOffset);
                        equality2 = commonString + (String)equality2;
                    }
                    Object bestEquality1 = equality1;
                    Object bestEdit = edit2;
                    Object bestEquality2 = equality2;
                    int bestScore = this.diff_cleanupSemanticScore((String)equality1, (String)edit2) + this.diff_cleanupSemanticScore((String)edit2, (String)equality2);
                    while (((String)edit2).length() != 0 && ((String)equality2).length() != 0 && ((String)edit2).charAt(0) == ((String)equality2).charAt(0)) {
                        equality1 = (String)equality1 + ((String)edit2).charAt(0);
                        edit2 = ((String)edit2).substring(1) + ((String)equality2).charAt(0);
                        equality2 = ((String)equality2).substring(1);
                        int score = this.diff_cleanupSemanticScore((String)equality1, (String)edit2) + this.diff_cleanupSemanticScore((String)edit2, (String)equality2);
                        if (score < bestScore) continue;
                        bestScore = score;
                        bestEquality1 = equality1;
                        bestEdit = edit2;
                        bestEquality2 = equality2;
                    }
                    diff3 = prevDiff;
                    object = null;
                    object = diff3.getText();
                    if (!((String)object).equals(bestEquality1)) {
                        if (((String)bestEquality1).length() != 0) {
                            object = bestEquality1;
                            diff3 = prevDiff;
                            diff3.setText((String)object);
                        } else {
                            pointer.previous();
                            pointer.previous();
                            pointer.previous();
                            pointer.remove();
                            pointer.next();
                            pointer.next();
                        }
                        object = bestEdit;
                        diff3 = thisDiff;
                        diff3.setText((String)object);
                        if (((String)bestEquality2).length() != 0) {
                            object = bestEquality2;
                            diff3 = nextDiff;
                            diff3.setText((String)object);
                        } else {
                            pointer.remove();
                            nextDiff = thisDiff;
                            thisDiff = prevDiff;
                        }
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    private int diff_cleanupSemanticScore(String one, String two) {
        if (one.length() == 0 || two.length() == 0) {
            return 5;
        }
        int score = 0;
        if (!Character.isLetterOrDigit(one.charAt(one.length() - 1)) || !Character.isLetterOrDigit(two.charAt(0))) {
            ++score;
            if (Character.isWhitespace(one.charAt(one.length() - 1)) || Character.isWhitespace(two.charAt(0))) {
                ++score;
                if (Character.getType(one.charAt(one.length() - 1)) == 15 || Character.getType(two.charAt(0)) == 15) {
                    ++score;
                    if (this.BLANKLINEEND.matcher(one).find() || this.BLANKLINESTART.matcher(two).find()) {
                        ++score;
                    }
                }
            }
        }
        return score;
    }

    public void diff_cleanupEfficiency(LinkedList<Diff> diffs) {
        Diff thisDiff;
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        Object lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        boolean pre_ins = false;
        boolean pre_del = false;
        boolean post_ins = false;
        boolean post_del = false;
        Diff safeDiff = thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            Diff diff2 = thisDiff;
            Object object = null;
            object = diff2.getOperation();
            if (object == Operation.EQUAL) {
                diff2 = thisDiff;
                object = null;
                object = diff2.getText();
                if (((String)object).length() < this.Diff_EditCost && (post_ins || post_del)) {
                    equalities.push(thisDiff);
                    pre_ins = post_ins;
                    pre_del = post_del;
                    diff2 = thisDiff;
                    object = null;
                    lastequality = object = diff2.getText();
                } else {
                    equalities.clear();
                    lastequality = null;
                    safeDiff = thisDiff;
                }
                post_del = false;
                post_ins = false;
            } else {
                diff2 = thisDiff;
                object = null;
                object = diff2.getOperation();
                if (object == Operation.DELETE) {
                    post_del = true;
                } else {
                    post_ins = true;
                }
                if (lastequality != null && (pre_ins && pre_del && post_ins && post_del || ((String)lastequality).length() < this.Diff_EditCost / 2 && (pre_ins ? 1 : 0) + (pre_del ? 1 : 0) + (post_ins ? 1 : 0) + (post_del ? 1 : 0) == 3)) {
                    while (thisDiff != equalities.lastElement()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, (String)lastequality));
                    thisDiff = new Diff(Operation.INSERT, (String)lastequality);
                    pointer.add(thisDiff);
                    equalities.pop();
                    lastequality = null;
                    if (pre_ins && pre_del) {
                        post_del = true;
                        post_ins = true;
                        equalities.clear();
                        safeDiff = thisDiff;
                    } else {
                        if (!equalities.empty()) {
                            equalities.pop();
                        }
                        thisDiff = equalities.empty() ? safeDiff : (Diff)equalities.lastElement();
                        while (thisDiff != pointer.previous()) {
                        }
                        post_del = false;
                        post_ins = false;
                    }
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diff_cleanupMerge(diffs);
        }
    }

    public void diff_cleanupMerge(LinkedList<Diff> diffs) {
        Diff nextDiff;
        Object object;
        Diff diff2;
        diffs.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> pointer = diffs.listIterator();
        int count_delete = 0;
        int count_insert = 0;
        String text_delete = "";
        String text_insert = "";
        Diff thisDiff = (Diff)pointer.next();
        Diff prevEqual = null;
        while (thisDiff != null) {
            diff2 = thisDiff;
            object = null;
            object = diff2.getOperation();
            switch (object) {
                case INSERT: {
                    ++count_insert;
                    diff2 = thisDiff;
                    object = null;
                    object = diff2.getText();
                    text_insert = text_insert + (String)object;
                    prevEqual = null;
                    break;
                }
                case DELETE: {
                    ++count_delete;
                    diff2 = thisDiff;
                    object = null;
                    object = diff2.getText();
                    text_delete = text_delete + (String)object;
                    prevEqual = null;
                    break;
                }
                case EQUAL: {
                    if (count_delete != 0 || count_insert != 0) {
                        pointer.previous();
                        while (count_delete-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        while (count_insert-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        if (count_delete != 0 && count_insert != 0) {
                            int commonlength = this.diff_commonPrefix(text_insert, text_delete);
                            if (commonlength != 0) {
                                if (pointer.hasPrevious()) {
                                    thisDiff = (Diff)pointer.previous();
                                    if (!$assertionsDisabled) {
                                        diff2 = thisDiff;
                                        object = null;
                                        object = diff2.getOperation();
                                        if (object != Operation.EQUAL) {
                                            throw new AssertionError((Object)"Previous diff should have been an equality.");
                                        }
                                    }
                                    diff2 = thisDiff;
                                    object = null;
                                    object = diff2.getText();
                                    object = (String)object + text_insert.substring(0, commonlength);
                                    diff2.setText((String)object);
                                    pointer.next();
                                } else {
                                    pointer.add(new Diff(Operation.EQUAL, text_insert.substring(0, commonlength)));
                                }
                                text_insert = text_insert.substring(commonlength);
                                text_delete = text_delete.substring(commonlength);
                            }
                            if ((commonlength = this.diff_commonSuffix(text_insert, text_delete)) != 0) {
                                diff2 = thisDiff = (Diff)pointer.next();
                                object = null;
                                object = diff2.getText();
                                object = text_insert.substring(text_insert.length() - commonlength) + (String)object;
                                diff2 = thisDiff;
                                diff2.setText((String)object);
                                text_insert = text_insert.substring(0, text_insert.length() - commonlength);
                                text_delete = text_delete.substring(0, text_delete.length() - commonlength);
                                pointer.previous();
                            }
                        }
                        if (text_delete.length() != 0) {
                            pointer.add(new Diff(Operation.DELETE, text_delete));
                        }
                        if (text_insert.length() != 0) {
                            pointer.add(new Diff(Operation.INSERT, text_insert));
                        }
                        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    } else if (prevEqual != null) {
                        Diff diff3 = prevEqual;
                        diff2 = diff3;
                        object = null;
                        object = diff2.getText();
                        StringBuilder stringBuilder = new StringBuilder().append((String)object);
                        diff2 = thisDiff;
                        object = null;
                        object = diff2.getText();
                        object = stringBuilder.append((String)object).toString();
                        diff2 = diff3;
                        diff2.setText((String)object);
                        pointer.remove();
                        thisDiff = (Diff)pointer.previous();
                        pointer.next();
                    }
                    count_insert = 0;
                    count_delete = 0;
                    text_delete = "";
                    text_insert = "";
                    prevEqual = thisDiff;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        diff2 = diffs.getLast();
        object = null;
        object = diff2.getText();
        if (((String)object).length() == 0) {
            diffs.removeLast();
        }
        boolean changes = false;
        pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff4 = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            diff2 = prevDiff;
            object = null;
            object = diff2.getOperation();
            if (object == Operation.EQUAL) {
                diff2 = nextDiff;
                object = null;
                object = diff2.getOperation();
                if (object == Operation.EQUAL) {
                    diff2 = thisDiff;
                    object = null;
                    Operation operation = object = diff2.getText();
                    diff2 = prevDiff;
                    object = null;
                    object = diff2.getText();
                    if (((String)((Object)operation)).endsWith((String)object)) {
                        diff2 = prevDiff;
                        object = null;
                        object = diff2.getText();
                        StringBuilder stringBuilder = new StringBuilder().append((String)object);
                        diff2 = thisDiff;
                        object = null;
                        Operation operation2 = object = diff2.getText();
                        diff2 = thisDiff;
                        object = null;
                        object = diff2.getText();
                        int n = ((String)object).length();
                        diff2 = prevDiff;
                        object = null;
                        object = diff2.getText();
                        object = stringBuilder.append(((String)((Object)operation2)).substring(0, n - ((String)object).length())).toString();
                        diff2 = thisDiff;
                        diff2.setText((String)object);
                        diff2 = prevDiff;
                        object = null;
                        object = diff2.getText();
                        StringBuilder stringBuilder2 = new StringBuilder().append((String)object);
                        diff2 = nextDiff;
                        object = null;
                        object = diff2.getText();
                        object = stringBuilder2.append((String)object).toString();
                        diff2 = nextDiff;
                        diff2.setText((String)object);
                        pointer.previous();
                        pointer.previous();
                        pointer.previous();
                        pointer.remove();
                        pointer.next();
                        thisDiff = (Diff)pointer.next();
                        nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                        changes = true;
                    } else {
                        diff2 = thisDiff;
                        object = null;
                        Operation operation3 = object = diff2.getText();
                        diff2 = nextDiff;
                        object = null;
                        object = diff2.getText();
                        if (((String)((Object)operation3)).startsWith((String)object)) {
                            Diff diff5 = prevDiff;
                            diff2 = diff5;
                            object = null;
                            object = diff2.getText();
                            StringBuilder stringBuilder = new StringBuilder().append((String)object);
                            diff2 = nextDiff;
                            object = null;
                            object = diff2.getText();
                            object = stringBuilder.append((String)object).toString();
                            diff2 = diff5;
                            diff2.setText((String)object);
                            diff2 = thisDiff;
                            object = null;
                            Operation operation4 = object = diff2.getText();
                            diff2 = nextDiff;
                            object = null;
                            object = diff2.getText();
                            StringBuilder stringBuilder3 = new StringBuilder().append(((String)((Object)operation4)).substring(((String)object).length()));
                            diff2 = nextDiff;
                            object = null;
                            object = diff2.getText();
                            object = stringBuilder3.append((String)object).toString();
                            diff2 = thisDiff;
                            diff2.setText((String)object);
                            pointer.remove();
                            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                            changes = true;
                        }
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diff_cleanupMerge(diffs);
        }
    }

    public int diff_xIndex(LinkedList<Diff> diffs, int loc) {
        Object object;
        Diff diff2;
        int chars1 = 0;
        int chars2 = 0;
        int last_chars1 = 0;
        int last_chars2 = 0;
        Diff lastDiff = null;
        Iterator iterator = diffs.iterator();
        while (iterator.hasNext()) {
            Diff aDiff;
            diff2 = aDiff = (Diff)iterator.next();
            object = null;
            object = diff2.getOperation();
            if (object != Operation.INSERT) {
                diff2 = aDiff;
                object = null;
                object = diff2.getText();
                chars1 += ((String)object).length();
            }
            diff2 = aDiff;
            object = null;
            object = diff2.getOperation();
            if (object != Operation.DELETE) {
                diff2 = aDiff;
                object = null;
                object = diff2.getText();
                chars2 += ((String)object).length();
            }
            if (chars1 > loc) {
                lastDiff = aDiff;
                break;
            }
            last_chars1 = chars1;
            last_chars2 = chars2;
        }
        if (lastDiff != null) {
            diff2 = lastDiff;
            object = null;
            object = diff2.getOperation();
            if (object == Operation.DELETE) {
                return last_chars2;
            }
        }
        return last_chars2 + (loc - last_chars1);
    }

    public String diff_prettyHtml(LinkedList<Diff> diffs) {
        StringBuilder html = new StringBuilder();
        int i = 0;
        Iterator iterator = diffs.iterator();
        while (iterator.hasNext()) {
            Diff aDiff;
            Diff diff2 = aDiff = (Diff)iterator.next();
            Object object = null;
            object = diff2.getText();
            String text = object.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "&para;<BR>");
            diff2 = aDiff;
            object = null;
            object = diff2.getOperation();
            switch (1.$SwitchMap$utils$diff_match_patch$Operation[((Enum)object).ordinal()]) {
                case 1: {
                    html.append("<INS STYLE=\"background:#E6FFE6;\" TITLE=\"i=").append(i).append("\">").append(text).append("</INS>");
                    break;
                }
                case 2: {
                    html.append("<DEL STYLE=\"background:#FFE6E6;\" TITLE=\"i=").append(i).append("\">").append(text).append("</DEL>");
                    break;
                }
                case 3: {
                    html.append("<SPAN TITLE=\"i=").append(i).append("\">").append(text).append("</SPAN>");
                }
            }
            diff2 = aDiff;
            object = null;
            object = diff2.getOperation();
            if (object == Operation.DELETE) continue;
            diff2 = aDiff;
            object = null;
            object = diff2.getText();
            i += object.length();
        }
        return html.toString();
    }

    public String diff_text1(LinkedList<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        Iterator iterator = diffs.iterator();
        while (iterator.hasNext()) {
            Diff aDiff;
            Diff diff2 = aDiff = (Diff)iterator.next();
            Object object = null;
            object = diff2.getOperation();
            if (object == Operation.INSERT) continue;
            diff2 = aDiff;
            object = null;
            object = diff2.getText();
            text.append((String)object);
        }
        return text.toString();
    }

    public String diff_text2(LinkedList<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        Iterator iterator = diffs.iterator();
        while (iterator.hasNext()) {
            Diff aDiff;
            Diff diff2 = aDiff = (Diff)iterator.next();
            Object object = null;
            object = diff2.getOperation();
            if (object == Operation.DELETE) continue;
            diff2 = aDiff;
            object = null;
            object = diff2.getText();
            text.append((String)object);
        }
        return text.toString();
    }

    public int diff_levenshtein(LinkedList<Diff> diffs) {
        int levenshtein = 0;
        int insertions = 0;
        int deletions = 0;
        Iterator iterator = diffs.iterator();
        while (iterator.hasNext()) {
            Diff aDiff;
            Diff diff2 = aDiff = (Diff)iterator.next();
            Object object = null;
            object = diff2.getOperation();
            switch (1.$SwitchMap$utils$diff_match_patch$Operation[((Enum)object).ordinal()]) {
                case 1: {
                    diff2 = aDiff;
                    object = null;
                    object = diff2.getText();
                    insertions += ((String)object).length();
                    break;
                }
                case 2: {
                    diff2 = aDiff;
                    object = null;
                    object = diff2.getText();
                    deletions += ((String)object).length();
                    break;
                }
                case 3: {
                    levenshtein += Math.max(insertions, deletions);
                    insertions = 0;
                    deletions = 0;
                }
            }
        }
        return levenshtein += Math.max(insertions, deletions);
    }

    public String diff_toDelta(LinkedList<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        Iterator iterator = diffs.iterator();
        while (iterator.hasNext()) {
            Diff aDiff;
            Diff diff2 = aDiff = (Diff)iterator.next();
            Object object = null;
            object = diff2.getOperation();
            switch (1.$SwitchMap$utils$diff_match_patch$Operation[((Enum)object).ordinal()]) {
                case 1: {
                    try {
                        diff2 = aDiff;
                        object = null;
                        object = diff2.getText();
                        text.append("+").append(URLEncoder.encode((String)object, "UTF-8").replace('+', ' ')).append("\t");
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("This system does not support UTF-8.", e);
                    }
                }
                case 2: {
                    diff2 = aDiff;
                    object = null;
                    object = diff2.getText();
                    text.append("-").append(((String)object).length()).append("\t");
                    break;
                }
                case 3: {
                    diff2 = aDiff;
                    object = null;
                    object = diff2.getText();
                    text.append("=").append(((String)object).length()).append("\t");
                }
            }
        }
        String delta = text.toString();
        if (delta.length() != 0) {
            delta = delta.substring(0, delta.length() - 1);
            delta = diff_match_patch.unescapeForEncodeUriCompatability(delta);
        }
        return delta;
    }

    public LinkedList<Diff> diff_fromDelta(String text1, String delta) throws IllegalArgumentException {
        String[] tokens;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        int pointer = 0;
        block11: for (String token : tokens = delta.split("\t")) {
            if (token.length() == 0) continue;
            String param = token.substring(1);
            switch (token.charAt(0)) {
                case '+': {
                    param = param.replace("+", "%2B");
                    try {
                        param = URLDecoder.decode(param, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("This system does not support UTF-8.", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Illegal escape in diff_fromDelta: " + param, e);
                    }
                    diffs.add(new Diff(Operation.INSERT, param));
                    continue block11;
                }
                case '-': 
                case '=': {
                    String text;
                    int n;
                    try {
                        n = Integer.parseInt(param);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid number in diff_fromDelta: " + param, e);
                    }
                    if (n < 0) {
                        throw new IllegalArgumentException("Negative number in diff_fromDelta: " + param);
                    }
                    try {
                        text = text1.substring(pointer, pointer += n);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("Delta length (" + pointer + ") larger than source text length (" + text1.length() + ").", e);
                    }
                    if (token.charAt(0) == '=') {
                        diffs.add(new Diff(Operation.EQUAL, text));
                        continue block11;
                    }
                    diffs.add(new Diff(Operation.DELETE, text));
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Invalid diff operation in diff_fromDelta: " + token.charAt(0));
                }
            }
        }
        if (pointer != text1.length()) {
            throw new IllegalArgumentException("Delta length (" + pointer + ") smaller than source text length (" + text1.length() + ").");
        }
        return diffs;
    }

    public int match_main(String text, String pattern, int loc) {
        loc = Math.max(0, Math.min(loc, text.length()));
        if (text.equals(pattern)) {
            return 0;
        }
        if (text.length() == 0) {
            return -1;
        }
        if (loc + pattern.length() <= text.length() && text.substring(loc, loc + pattern.length()).equals(pattern)) {
            return loc;
        }
        return this.match_bitap(text, pattern, loc);
    }

    protected int match_bitap(String text, String pattern, int loc) {
        assert (this.Match_MaxBits == 0 || pattern.length() <= this.Match_MaxBits) : "Pattern too long for this application.";
        Map<Character, Integer> s = this.match_alphabet(pattern);
        double score_threshold = this.Match_Threshold;
        int best_loc = text.indexOf(pattern, loc);
        if (best_loc != -1) {
            score_threshold = Math.min(this.match_bitapScore(0, best_loc, loc, pattern), score_threshold);
            best_loc = text.lastIndexOf(pattern, loc + pattern.length());
            if (best_loc != -1) {
                score_threshold = Math.min(this.match_bitapScore(0, best_loc, loc, pattern), score_threshold);
            }
        }
        int matchmask = 1 << pattern.length() - 1;
        best_loc = -1;
        int bin_max = pattern.length() + text.length();
        int[] last_rd = new int[]{};
        for (int d = 0; d < pattern.length(); ++d) {
            int bin_min = 0;
            int bin_mid = bin_max;
            while (bin_min < bin_mid) {
                if (this.match_bitapScore(d, loc + bin_mid, loc, pattern) <= score_threshold) {
                    bin_min = bin_mid;
                } else {
                    bin_max = bin_mid;
                }
                bin_mid = (bin_max - bin_min) / 2 + bin_min;
            }
            bin_max = bin_mid;
            int start = Math.max(1, loc - bin_mid + 1);
            int finish = Math.min(loc + bin_mid, text.length()) + pattern.length();
            int[] rd = new int[finish + 2];
            rd[finish + 1] = (1 << d) - 1;
            for (int j = finish; j >= start; --j) {
                double score;
                int charMatch = text.length() <= j - 1 || !s.containsKey(Character.valueOf(text.charAt(j - 1))) ? 0 : s.get(Character.valueOf(text.charAt(j - 1)));
                rd[j] = d == 0 ? (rd[j + 1] << 1 | 1) & charMatch : (rd[j + 1] << 1 | 1) & charMatch | ((last_rd[j + 1] | last_rd[j]) << 1 | 1) | last_rd[j + 1];
                if ((rd[j] & matchmask) == 0 || !((score = this.match_bitapScore(d, j - 1, loc, pattern)) <= score_threshold)) continue;
                score_threshold = score;
                best_loc = j - 1;
                if (best_loc <= loc) break;
                start = Math.max(1, 2 * loc - best_loc);
            }
            if (this.match_bitapScore(d + 1, loc, loc, pattern) > score_threshold) break;
            last_rd = rd;
        }
        return best_loc;
    }

    private double match_bitapScore(int e, int x, int loc, String pattern) {
        float accuracy = (float)e / (float)pattern.length();
        int proximity = Math.abs(loc - x);
        if (this.Match_Distance == 0) {
            return proximity == 0 ? (double)accuracy : 1.0;
        }
        return accuracy + (float)proximity / (float)this.Match_Distance;
    }

    protected Map<Character, Integer> match_alphabet(String pattern) {
        char[] char_pattern;
        HashMap<Character, Integer> s = new HashMap<Character, Integer>();
        for (char c : char_pattern = pattern.toCharArray()) {
            s.put(Character.valueOf(c), 0);
        }
        int i = 0;
        for (char c : char_pattern) {
            s.put(Character.valueOf(c), (Integer)s.get(Character.valueOf(c)) | 1 << pattern.length() - i - 1);
            ++i;
        }
        return s;
    }

    protected void patch_addContext(Patch patch, String text) {
        if (text.length() == 0) {
            return;
        }
        Patch patch2 = patch;
        int n = 0;
        int n2 = n = patch2.getStart2();
        patch2 = patch;
        n = 0;
        int n3 = n = patch2.getStart2();
        patch2 = patch;
        n = 0;
        n = patch2.getLength1();
        String pattern = text.substring(n2, n3 + n);
        int padding = 0;
        while (text.indexOf(pattern) != text.lastIndexOf(pattern) && pattern.length() < this.Match_MaxBits - this.Patch_Margin - this.Patch_Margin) {
            patch2 = patch;
            n = 0;
            n = patch2.getStart2();
            int n4 = Math.max(0, n - (padding += this.Patch_Margin));
            patch2 = patch;
            n = 0;
            int n5 = n = patch2.getStart2();
            patch2 = patch;
            n = 0;
            n = patch2.getLength1();
            pattern = text.substring(n4, Math.min(text.length(), n5 + n + padding));
        }
        patch2 = patch;
        n = 0;
        n = patch2.getStart2();
        int n6 = Math.max(0, n - (padding += this.Patch_Margin));
        patch2 = patch;
        n = 0;
        n = patch2.getStart2();
        String prefix = text.substring(n6, n);
        if (prefix.length() != 0) {
            patch2 = patch;
            LinkedList<Diff> linkedList = null;
            linkedList = patch2.getDiffs();
            linkedList.addFirst(new Diff(Operation.EQUAL, prefix));
        }
        patch2 = patch;
        int n7 = 0;
        int n8 = n7 = patch2.getStart2();
        patch2 = patch;
        n7 = 0;
        n7 = patch2.getLength1();
        int n9 = n8 + n7;
        patch2 = patch;
        n7 = 0;
        int n10 = n7 = patch2.getStart2();
        patch2 = patch;
        n7 = 0;
        n7 = patch2.getLength1();
        String suffix = text.substring(n9, Math.min(text.length(), n10 + n7 + padding));
        if (suffix.length() != 0) {
            patch2 = patch;
            LinkedList<Diff> linkedList = null;
            linkedList = patch2.getDiffs();
            linkedList.addLast(new Diff(Operation.EQUAL, suffix));
        }
        patch2 = patch;
        int n11 = 0;
        n11 = patch2.getStart1();
        patch2.setStart1(n11 -= prefix.length());
        patch2 = patch;
        n11 = 0;
        n11 = patch2.getStart2();
        patch2.setStart2(n11 -= prefix.length());
        patch2 = patch;
        n11 = 0;
        n11 = patch2.getLength1();
        patch2.setLength1(n11 += prefix.length() + suffix.length());
        patch2 = patch;
        n11 = 0;
        n11 = patch2.getLength2();
        patch2.setLength2(n11 += prefix.length() + suffix.length());
    }

    public LinkedList<Patch> patch_make(String text1, String text2) {
        LinkedList<Diff> diffs = this.diff_main(text1, text2, true);
        if (diffs.size() > 2) {
            this.diff_cleanupSemantic(diffs);
            this.diff_cleanupEfficiency(diffs);
        }
        return this.patch_make(text1, diffs);
    }

    public LinkedList<Patch> patch_make(LinkedList<Diff> diffs) {
        String text1 = this.diff_text1(diffs);
        return this.patch_make(text1, diffs);
    }

    @Deprecated
    public LinkedList<Patch> patch_make(String text1, String text2, LinkedList<Diff> diffs) {
        return this.patch_make(text1, diffs);
    }

    public LinkedList<Patch> patch_make(String text1, LinkedList<Diff> diffs) {
        Object object;
        Object object2;
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (diffs.isEmpty()) {
            return patches;
        }
        Patch patch = new Patch();
        int char_count1 = 0;
        int char_count2 = 0;
        String prepatch_text = text1;
        String postpatch_text = text1;
        for (Diff aDiff : diffs) {
            object2 = patch;
            object = null;
            object = ((Patch)object2).getDiffs();
            if (object.isEmpty()) {
                object2 = aDiff;
                object = null;
                object = ((Diff)object2).getOperation();
                if (object != Operation.EQUAL) {
                    int n = char_count1;
                    object2 = patch;
                    ((Patch)object2).setStart1(n);
                    n = char_count2;
                    object2 = patch;
                    ((Patch)object2).setStart2(n);
                }
            }
            object2 = aDiff;
            object = null;
            object = ((Diff)object2).getOperation();
            switch (1.$SwitchMap$utils$diff_match_patch$Operation[((Enum)object).ordinal()]) {
                case 1: {
                    object2 = patch;
                    object = null;
                    object = ((Patch)object2).getDiffs();
                    object.add(aDiff);
                    Patch patch2 = patch;
                    object2 = patch2;
                    int n = 0;
                    n = ((Patch)object2).getLength2();
                    object2 = aDiff;
                    String string = null;
                    string = ((Diff)object2).getText();
                    int n2 = n + string.length();
                    object2 = patch2;
                    ((Patch)object2).setLength2(n2);
                    object2 = aDiff;
                    object = null;
                    object = ((Diff)object2).getText();
                    postpatch_text = postpatch_text.substring(0, char_count2) + (String)object + postpatch_text.substring(char_count2);
                    break;
                }
                case 2: {
                    Patch patch3 = patch;
                    object2 = patch3;
                    int n = 0;
                    n = ((Patch)object2).getLength1();
                    object2 = aDiff;
                    String string = null;
                    string = ((Diff)object2).getText();
                    int n3 = n + string.length();
                    object2 = patch3;
                    ((Patch)object2).setLength1(n3);
                    object2 = patch;
                    object = null;
                    object = ((Patch)object2).getDiffs();
                    object.add(aDiff);
                    object2 = aDiff;
                    object = null;
                    object = ((Diff)object2).getText();
                    postpatch_text = postpatch_text.substring(0, char_count2) + postpatch_text.substring(char_count2 + ((String)object).length());
                    break;
                }
                case 3: {
                    object2 = aDiff;
                    object = null;
                    object = ((Diff)object2).getText();
                    if (((String)object).length() <= 2 * this.Patch_Margin) {
                        object2 = patch;
                        object = null;
                        object = ((Patch)object2).getDiffs();
                        if (!object.isEmpty() && aDiff != diffs.getLast()) {
                            object2 = patch;
                            object = null;
                            object = ((Patch)object2).getDiffs();
                            object.add(aDiff);
                            Patch patch4 = patch;
                            object2 = patch4;
                            int n = 0;
                            n = ((Patch)object2).getLength1();
                            object2 = aDiff;
                            String string = null;
                            string = ((Diff)object2).getText();
                            int n4 = n + string.length();
                            object2 = patch4;
                            ((Patch)object2).setLength1(n4);
                            Patch patch5 = patch;
                            object2 = patch5;
                            n4 = 0;
                            n4 = ((Patch)object2).getLength2();
                            object2 = aDiff;
                            String string2 = null;
                            string2 = ((Diff)object2).getText();
                            int n5 = n4 + string2.length();
                            object2 = patch5;
                            ((Patch)object2).setLength2(n5);
                        }
                    }
                    object2 = aDiff;
                    object = null;
                    object = ((Diff)object2).getText();
                    if (((String)object).length() < 2 * this.Patch_Margin) break;
                    object2 = patch;
                    object = null;
                    object = ((Patch)object2).getDiffs();
                    if (object.isEmpty()) break;
                    this.patch_addContext(patch, prepatch_text);
                    patches.add(patch);
                    patch = new Patch();
                    prepatch_text = postpatch_text;
                    char_count1 = char_count2;
                }
            }
            object2 = aDiff;
            object = null;
            object = ((Diff)object2).getOperation();
            if (object != Operation.INSERT) {
                object2 = aDiff;
                object = null;
                object = ((Diff)object2).getText();
                char_count1 += ((String)object).length();
            }
            object2 = aDiff;
            object = null;
            object = ((Diff)object2).getOperation();
            if (object == Operation.DELETE) continue;
            object2 = aDiff;
            object = null;
            object = ((Diff)object2).getText();
            char_count2 += ((String)object).length();
        }
        object2 = patch;
        object = null;
        object = ((Patch)object2).getDiffs();
        if (!object.isEmpty()) {
            this.patch_addContext(patch, prepatch_text);
            patches.add(patch);
        }
        return patches;
    }

    public LinkedList<Patch> patch_deepCopy(LinkedList<Patch> patches) {
        LinkedList<Patch> patchesCopy = new LinkedList<Patch>();
        for (Patch aPatch : patches) {
            Patch patchCopy = new Patch();
            Object object = aPatch;
            Object object2 = null;
            object2 = ((Patch)object).getDiffs();
            Iterator iterator = ((AbstractSequentialList)object2).iterator();
            while (iterator.hasNext()) {
                Diff aDiff = (Diff)iterator.next();
                object = aDiff;
                object2 = null;
                object2 = ((Diff)object).getOperation();
                Object object3 = object2;
                object = aDiff;
                object2 = null;
                object2 = ((Diff)object).getText();
                Diff diffCopy = new Diff((Operation)((Object)object3), (String)object2);
                object = patchCopy;
                object2 = null;
                object2 = ((Patch)object).getDiffs();
                ((LinkedList)object2).add((Diff)diffCopy);
            }
            object = aPatch;
            int n = 0;
            n = ((Patch)object).getStart1();
            object = patchCopy;
            ((Patch)object).setStart1(n);
            object = aPatch;
            n = 0;
            n = ((Patch)object).getStart2();
            object = patchCopy;
            ((Patch)object).setStart2(n);
            object = aPatch;
            n = 0;
            n = ((Patch)object).getLength1();
            object = patchCopy;
            ((Patch)object).setLength1(n);
            object = aPatch;
            n = 0;
            n = ((Patch)object).getLength2();
            object = patchCopy;
            ((Patch)object).setLength2(n);
            patchesCopy.add(patchCopy);
        }
        return patchesCopy;
    }

    public Object[] patch_apply(LinkedList<Patch> patches, String text) {
        if (patches.isEmpty()) {
            return new Object[]{text, new boolean[0]};
        }
        patches = this.patch_deepCopy(patches);
        String nullPadding = this.patch_addPadding(patches);
        text = nullPadding + text + nullPadding;
        this.patch_splitMax(patches);
        int x = 0;
        int delta = 0;
        boolean[] results = new boolean[patches.size()];
        for (Patch aPatch : patches) {
            int start_loc;
            Object object = aPatch;
            int n = 0;
            n = ((Patch)object).getStart2();
            int expected_loc = n + delta;
            object = aPatch;
            Object object2 = null;
            object2 = ((Patch)object).getDiffs();
            String text1 = this.diff_text1((LinkedList<Diff>)object2);
            int end_loc = -1;
            if (text1.length() > this.Match_MaxBits) {
                start_loc = this.match_main(text, text1.substring(0, this.Match_MaxBits), expected_loc);
                if (start_loc != -1 && ((end_loc = this.match_main(text, text1.substring(text1.length() - this.Match_MaxBits), expected_loc + text1.length() - this.Match_MaxBits)) == -1 || start_loc >= end_loc)) {
                    start_loc = -1;
                }
            } else {
                start_loc = this.match_main(text, text1, expected_loc);
            }
            if (start_loc == -1) {
                results[x] = false;
                object = aPatch;
                int n2 = 0;
                int n3 = n2 = ((Patch)object).getLength2();
                object = aPatch;
                n2 = 0;
                n2 = ((Patch)object).getLength1();
                delta -= n3 - n2;
            } else {
                results[x] = true;
                delta = start_loc - expected_loc;
                String text2 = end_loc == -1 ? text.substring(start_loc, Math.min(start_loc + text1.length(), text.length())) : text.substring(start_loc, Math.min(end_loc + this.Match_MaxBits, text.length()));
                if (text1.equals(text2)) {
                    object = aPatch;
                    object2 = null;
                    object2 = ((Patch)object).getDiffs();
                    text = text.substring(0, start_loc) + this.diff_text2((LinkedList<Diff>)object2) + text.substring(start_loc + text1.length());
                } else {
                    LinkedList<Diff> diffs = this.diff_main(text1, text2, false);
                    if (text1.length() > this.Match_MaxBits && (float)this.diff_levenshtein(diffs) / (float)text1.length() > this.Patch_DeleteThreshold) {
                        results[x] = false;
                    } else {
                        this.diff_cleanupSemanticLossless(diffs);
                        int index1 = 0;
                        object = aPatch;
                        object2 = null;
                        object2 = ((Patch)object).getDiffs();
                        for (Diff aDiff : object2) {
                            object = aDiff;
                            object2 = null;
                            object2 = ((Diff)object).getOperation();
                            if (object2 != Operation.EQUAL) {
                                int index2 = this.diff_xIndex(diffs, index1);
                                object = aDiff;
                                object2 = null;
                                object2 = ((Diff)object).getOperation();
                                if (object2 == Operation.INSERT) {
                                    object = aDiff;
                                    object2 = null;
                                    object2 = ((Diff)object).getText();
                                    text = text.substring(0, start_loc + index2) + object2 + text.substring(start_loc + index2);
                                } else {
                                    object = aDiff;
                                    object2 = null;
                                    object2 = ((Diff)object).getOperation();
                                    if (object2 == Operation.DELETE) {
                                        object = aDiff;
                                        object2 = null;
                                        object2 = ((Diff)object).getText();
                                        text = text.substring(0, start_loc + index2) + text.substring(start_loc + this.diff_xIndex(diffs, index1 + ((String)object2).length()));
                                    }
                                }
                            }
                            object = aDiff;
                            object2 = null;
                            object2 = ((Diff)object).getOperation();
                            if (object2 == Operation.DELETE) continue;
                            object = aDiff;
                            object2 = null;
                            object2 = ((Diff)object).getText();
                            index1 += ((String)object2).length();
                        }
                    }
                }
            }
            ++x;
        }
        text = text.substring(nullPadding.length(), text.length() - nullPadding.length());
        return new Object[]{text, results};
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public String patch_addPadding(LinkedList<Patch> patches) {
        paddingLength = this.Patch_Margin;
        nullPadding = "";
        for (x = 1; x <= paddingLength; ++x) {
            nullPadding = nullPadding + String.valueOf((char)x);
        }
        for (Patch aPatch : patches) {
            var8_7 = aPatch;
            var9_8 = 0;
            var9_8 = var8_7.getStart1();
            var8_7.setStart1(var9_8 += paddingLength);
            var8_7 = aPatch;
            var9_8 = 0;
            var9_8 = var8_7.getStart2();
            var8_7.setStart2(var9_8 += paddingLength);
        }
        patch = patches.getFirst();
        var8_7 = patch;
        var9_9 /* !! */  = null;
        var9_9 /* !! */  = var8_7.getDiffs();
        diffs /* !! */  = var9_9 /* !! */ ;
        if (diffs /* !! */ .isEmpty()) ** GOTO lbl-1000
        var8_7 = diffs /* !! */ .getFirst();
        var9_9 /* !! */  = null;
        var9_9 /* !! */  = var8_7.getOperation();
        if (var9_9 /* !! */  != Operation.EQUAL) lbl-1000:
        // 2 sources

        {
            diffs /* !! */ .addFirst(new Diff(Operation.EQUAL, nullPadding));
            var8_7 = patch;
            var9_10 = 0;
            var9_10 = var8_7.getStart1();
            var8_7.setStart1(var9_10 -= paddingLength);
            var8_7 = patch;
            var9_10 = 0;
            var9_10 = var8_7.getStart2();
            var8_7.setStart2(var9_10 -= paddingLength);
            var8_7 = patch;
            var9_10 = 0;
            var9_10 = var8_7.getLength1();
            var8_7.setLength1(var9_10 += paddingLength);
            var8_7 = patch;
            var9_10 = 0;
            var9_10 = var8_7.getLength2();
            var8_7.setLength2(var9_10 += paddingLength);
        } else {
            var8_7 = diffs /* !! */ .getFirst();
            var9_9 /* !! */  = null;
            var9_9 /* !! */  = var8_7.getText();
            if (paddingLength > var9_9 /* !! */ .length()) {
                firstDiff = diffs /* !! */ .getFirst();
                var8_7 = firstDiff;
                var9_9 /* !! */  = null;
                var9_9 /* !! */  = var8_7.getText();
                extraLength = paddingLength - var9_9 /* !! */ .length();
                var8_7 = firstDiff;
                var9_9 /* !! */  = null;
                var9_9 /* !! */  = var8_7.getText();
                v0 = new StringBuilder().append(nullPadding.substring(var9_9 /* !! */ .length()));
                var8_7 = firstDiff;
                var9_9 /* !! */  = null;
                var9_9 /* !! */  = var8_7.getText();
                var9_9 /* !! */  = v0.append((String)var9_9 /* !! */ ).toString();
                var8_7 = firstDiff;
                var8_7.setText((String)var9_9 /* !! */ );
                var8_7 = patch;
                var9_11 = 0;
                var9_11 = var8_7.getStart1();
                var8_7.setStart1(var9_11 -= extraLength);
                var8_7 = patch;
                var9_11 = 0;
                var9_11 = var8_7.getStart2();
                var8_7.setStart2(var9_11 -= extraLength);
                var8_7 = patch;
                var9_11 = 0;
                var9_11 = var8_7.getLength1();
                var8_7.setLength1(var9_11 += extraLength);
                var8_7 = patch;
                var9_11 = 0;
                var9_11 = var8_7.getLength2();
                var8_7.setLength2(var9_11 += extraLength);
            }
        }
        patch = patches.getLast();
        var8_7 = patch;
        var9_13 /* !! */  = null;
        var9_13 /* !! */  = var8_7.getDiffs();
        diffs /* !! */  = var9_13 /* !! */ ;
        if (diffs /* !! */ .isEmpty()) ** GOTO lbl-1000
        var8_7 = diffs /* !! */ .getLast();
        var9_13 /* !! */  = null;
        var9_13 /* !! */  = var8_7.getOperation();
        if (var9_13 /* !! */  != Operation.EQUAL) lbl-1000:
        // 2 sources

        {
            diffs /* !! */ .addLast(new Diff(Operation.EQUAL, nullPadding));
            var8_7 = patch;
            var9_14 = 0;
            var9_14 = var8_7.getLength1();
            var8_7.setLength1(var9_14 += paddingLength);
            var8_7 = patch;
            var9_14 = 0;
            var9_14 = var8_7.getLength2();
            var8_7.setLength2(var9_14 += paddingLength);
        } else {
            var8_7 = diffs /* !! */ .getLast();
            var9_13 /* !! */  = null;
            var9_13 /* !! */  = var8_7.getText();
            if (paddingLength > var9_13 /* !! */ .length()) {
                lastDiff = diffs /* !! */ .getLast();
                var8_7 = lastDiff;
                var9_13 /* !! */  = null;
                var9_13 /* !! */  = var8_7.getText();
                extraLength = paddingLength - var9_13 /* !! */ .length();
                var8_7 = lastDiff;
                var9_13 /* !! */  = null;
                var9_13 /* !! */  = var8_7.getText();
                var9_13 /* !! */  = (String)var9_13 /* !! */  + nullPadding.substring(0, extraLength);
                var8_7.setText((String)var9_13 /* !! */ );
                var8_7 = patch;
                var9_15 = 0;
                var9_15 = var8_7.getLength1();
                var8_7.setLength1(var9_15 += extraLength);
                var8_7 = patch;
                var9_15 = 0;
                var9_15 = var8_7.getLength2();
                var8_7.setLength2(var9_15 += extraLength);
            }
        }
        return nullPadding;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void patch_splitMax(LinkedList<Patch> patches) {
        pointer = patches.listIterator();
        v0 = bigpatch = pointer.hasNext() != false ? (Patch)pointer.next() : null;
        while (bigpatch != null) {
            var13_13 = bigpatch;
            var14_14 = 0;
            var14_14 = var13_13.getLength1();
            if (var14_14 <= this.Match_MaxBits) {
                bigpatch = pointer.hasNext() != false ? (Patch)pointer.next() : null;
                continue;
            }
            pointer.remove();
            patch_size = this.Match_MaxBits;
            var13_13 = bigpatch;
            var14_14 = 0;
            start1 = var14_14 = var13_13.getStart1();
            var13_13 = bigpatch;
            var14_14 = 0;
            start2 = var14_14 = var13_13.getStart2();
            precontext = "";
            while (true) {
                block16: {
                    var13_13 = bigpatch;
                    var14_15 = null;
                    var14_15 = var13_13.getDiffs();
                    if (var14_15.isEmpty()) break;
                    patch = new Patch();
                    empty = true;
                    var14_16 = start1 - precontext.length();
                    var13_13 = patch;
                    var13_13.setStart1(var14_16);
                    var14_16 = start2 - precontext.length();
                    var13_13 = patch;
                    var13_13.setStart2(var14_16);
                    if (precontext.length() != 0) {
                        var14_16 = precontext.length();
                        var13_13 = patch;
                        var13_13.setLength2(var14_16);
                        var13_13 = patch;
                        var13_13.setLength1(var14_16);
                        var13_13 = patch;
                        var14_17 = null;
                        var14_17 = var13_13.getDiffs();
                        var14_17.add(new Diff(Operation.EQUAL, precontext));
                    }
                    while (true) {
                        var13_13 = bigpatch;
                        var14_18 = null;
                        var14_18 = var13_13.getDiffs();
                        if (var14_18.isEmpty()) break;
                        var13_13 = patch;
                        var14_19 = 0;
                        var14_19 = var13_13.getLength1();
                        if (var14_19 >= patch_size - this.Patch_Margin) break;
                        var13_13 = bigpatch;
                        var14_20 /* !! */  = null;
                        var14_20 /* !! */  = var13_13.getDiffs();
                        var13_13 = var14_20 /* !! */ .getFirst();
                        var14_20 /* !! */  = null;
                        var14_20 /* !! */  = var13_13.getOperation();
                        diff_type = var14_20 /* !! */ ;
                        var13_13 = bigpatch;
                        var14_20 /* !! */  = null;
                        var14_20 /* !! */  = var13_13.getDiffs();
                        var13_13 = (Diff)var14_20 /* !! */ .getFirst();
                        var14_20 /* !! */  = null;
                        var14_20 /* !! */  = var13_13.getText();
                        diff_text = var14_20 /* !! */ ;
                        if (diff_type == Operation.INSERT) {
                            var13_13 = patch;
                            var14_21 = 0;
                            var14_21 = var13_13.getLength2();
                            var13_13.setLength2(var14_21 += diff_text.length());
                            start2 += diff_text.length();
                            var13_13 = patch;
                            var14_22 = null;
                            v1 = var14_22 = var13_13.getDiffs();
                            var13_13 = bigpatch;
                            var14_22 = null;
                            var14_22 = var13_13.getDiffs();
                            v1.addLast(var14_22.removeFirst());
                            empty = false;
                            continue;
                        }
                        if (diff_type == Operation.DELETE) {
                            var13_13 = patch;
                            var14_20 /* !! */  = null;
                            var14_20 /* !! */  = var13_13.getDiffs();
                            if (var14_20 /* !! */ .size() == 1) {
                                var13_13 = patch;
                                var14_20 /* !! */  = null;
                                var14_20 /* !! */  = var13_13.getDiffs();
                                var13_13 = (Diff)var14_20 /* !! */ .getFirst();
                                var14_20 /* !! */  = null;
                                var14_20 /* !! */  = var13_13.getOperation();
                                if (var14_20 /* !! */  == Operation.EQUAL && diff_text.length() > 2 * patch_size) {
                                    var13_13 = patch;
                                    var14_23 = 0;
                                    var14_23 = var13_13.getLength1();
                                    var13_13.setLength1(var14_23 += diff_text.length());
                                    start1 += diff_text.length();
                                    empty = false;
                                    var13_13 = patch;
                                    var14_24 = null;
                                    var14_24 = var13_13.getDiffs();
                                    var14_24.add(new Diff((Operation)diff_type, (String)diff_text));
                                    var13_13 = bigpatch;
                                    var14_24 = null;
                                    var14_24 = var13_13.getDiffs();
                                    var14_24.removeFirst();
                                    continue;
                                }
                            }
                        }
                        var13_13 = patch;
                        var14_25 = 0;
                        var14_25 = var13_13.getLength1();
                        diff_text = diff_text.substring(0, Math.min(diff_text.length(), patch_size - var14_25 - this.Patch_Margin));
                        var13_13 = patch;
                        var14_25 = 0;
                        var14_25 = var13_13.getLength1();
                        var13_13.setLength1(var14_25 += diff_text.length());
                        start1 += diff_text.length();
                        if (diff_type == Operation.EQUAL) {
                            var13_13 = patch;
                            var14_25 = 0;
                            var14_25 = var13_13.getLength2();
                            var13_13.setLength2(var14_25 += diff_text.length());
                            start2 += diff_text.length();
                        } else {
                            empty = false;
                        }
                        var13_13 = patch;
                        var14_26 = null;
                        var14_26 = var13_13.getDiffs();
                        var14_26.add((Diff)new Diff((Operation)diff_type, (String)diff_text));
                        var13_13 = bigpatch;
                        var14_26 = null;
                        var14_26 = var13_13.getDiffs();
                        var13_13 = var14_26.getFirst();
                        var14_26 = null;
                        var14_26 = var13_13.getText();
                        if (diff_text.equals(var14_26)) {
                            var13_13 = bigpatch;
                            var14_26 = null;
                            var14_26 = var13_13.getDiffs();
                            var14_26.removeFirst();
                            continue;
                        }
                        var13_13 = bigpatch;
                        var14_26 = null;
                        var14_26 = var13_13.getDiffs();
                        var13_13 = bigpatch;
                        var14_26 = null;
                        var14_26 = var13_13.getDiffs();
                        var13_13 = var14_26.getFirst();
                        var14_26 = null;
                        var14_26 = var13_13.getText();
                        var14_26 = var14_26.substring(diff_text.length());
                        var13_13 = var14_26.getFirst();
                        var13_13.setText((String)var14_26);
                    }
                    var13_13 = patch;
                    var14_27 /* !! */  = null;
                    var14_27 /* !! */  = var13_13.getDiffs();
                    precontext = this.diff_text2(var14_27 /* !! */ );
                    precontext = precontext.substring(Math.max(0, precontext.length() - this.Patch_Margin));
                    var13_13 = bigpatch;
                    var14_27 /* !! */  = null;
                    var14_27 /* !! */  = var13_13.getDiffs();
                    if (this.diff_text1(var14_27 /* !! */ ).length() > this.Patch_Margin) {
                        var13_13 = bigpatch;
                        var14_27 /* !! */  = null;
                        var14_27 /* !! */  = var13_13.getDiffs();
                        postcontext = this.diff_text1(var14_27 /* !! */ ).substring(0, this.Patch_Margin);
                    } else {
                        var13_13 = bigpatch;
                        var14_27 /* !! */  = null;
                        var14_27 /* !! */  = var13_13.getDiffs();
                        postcontext = this.diff_text1(var14_27 /* !! */ );
                    }
                    if (postcontext.length() == 0) break block16;
                    var13_13 = patch;
                    var14_28 = 0;
                    var14_28 = var13_13.getLength1();
                    var13_13.setLength1(var14_28 += postcontext.length());
                    var13_13 = patch;
                    var14_28 = 0;
                    var14_28 = var13_13.getLength2();
                    var13_13.setLength2(var14_28 += postcontext.length());
                    var13_13 = patch;
                    var14_27 /* !! */  = null;
                    var14_27 /* !! */  = var13_13.getDiffs();
                    if (var14_27 /* !! */ .isEmpty()) ** GOTO lbl-1000
                    var13_13 = patch;
                    var14_27 /* !! */  = null;
                    var14_27 /* !! */  = var13_13.getDiffs();
                    var13_13 = var14_27 /* !! */ .getLast();
                    var14_27 /* !! */  = null;
                    var14_27 /* !! */  = var13_13.getOperation();
                    if (var14_27 /* !! */  == Operation.EQUAL) {
                        var13_13 = patch;
                        var14_27 /* !! */  = null;
                        var14_27 /* !! */  = var13_13.getDiffs();
                        var13_13 = (Diff)var14_27 /* !! */ .getLast();
                        var14_27 /* !! */  = null;
                        var14_27 /* !! */  = var13_13.getText();
                        var14_27 /* !! */  = (String)var14_27 /* !! */  + postcontext;
                        var13_13.setText((String)var14_27 /* !! */ );
                    } else lbl-1000:
                    // 2 sources

                    {
                        var13_13 = patch;
                        var14_27 /* !! */  = null;
                        var14_27 /* !! */  = var13_13.getDiffs();
                        var14_27 /* !! */ .add(new Diff(Operation.EQUAL, postcontext));
                    }
                }
                if (empty) continue;
                pointer.add(patch);
            }
            bigpatch = pointer.hasNext() != false ? (Patch)pointer.next() : null;
        }
    }

    public String patch_toText(List<Patch> patches) {
        StringBuilder text = new StringBuilder();
        for (Patch aPatch : patches) {
            text.append(aPatch);
        }
        return text.toString();
    }

    public List<Patch> patch_fromText(String textline) throws IllegalArgumentException {
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (textline.length() == 0) {
            return patches;
        }
        List<String> textList = Arrays.asList(textline.split("\n"));
        LinkedList<String> text = new LinkedList<String>(textList);
        Pattern patchHeader = Pattern.compile("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@$");
        block5: while (!text.isEmpty()) {
            Matcher m = patchHeader.matcher(text.getFirst());
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid patch string: " + text.getFirst());
            }
            Patch patch = new Patch();
            patches.add(patch);
            int n = Integer.parseInt(m.group(1));
            Patch patch2 = patch;
            patch2.setStart1(n);
            if (m.group(2).length() == 0) {
                patch2 = patch;
                n = 0;
                n = patch2.getStart1();
                patch2.setStart1(--n);
                n = 1;
                patch2 = patch;
                patch2.setLength1(n);
            } else if (m.group(2).equals("0")) {
                n = 0;
                patch2 = patch;
                patch2.setLength1(n);
            } else {
                patch2 = patch;
                n = 0;
                n = patch2.getStart1();
                patch2.setStart1(--n);
                n = Integer.parseInt(m.group(2));
                patch2 = patch;
                patch2.setLength1(n);
            }
            n = Integer.parseInt(m.group(3));
            patch2 = patch;
            patch2.setStart2(n);
            if (m.group(4).length() == 0) {
                patch2 = patch;
                n = 0;
                n = patch2.getStart2();
                patch2.setStart2(--n);
                n = 1;
                patch2 = patch;
                patch2.setLength2(n);
            } else if (m.group(4).equals("0")) {
                n = 0;
                patch2 = patch;
                patch2.setLength2(n);
            } else {
                patch2 = patch;
                n = 0;
                n = patch2.getStart2();
                patch2.setStart2(--n);
                n = Integer.parseInt(m.group(4));
                patch2 = patch;
                patch2.setLength2(n);
            }
            text.removeFirst();
            while (!text.isEmpty()) {
                LinkedList<Diff> linkedList;
                char sign;
                try {
                    sign = text.getFirst().charAt(0);
                }
                catch (IndexOutOfBoundsException e) {
                    text.removeFirst();
                    continue;
                }
                String line = text.getFirst().substring(1);
                line = line.replace("+", "%2B");
                try {
                    line = URLDecoder.decode(line, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("This system does not support UTF-8.", e);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Illegal escape in patch_fromText: " + line, e);
                }
                if (sign == '-') {
                    patch2 = patch;
                    linkedList = null;
                    linkedList = patch2.getDiffs();
                    linkedList.add(new Diff(Operation.DELETE, line));
                } else if (sign == '+') {
                    patch2 = patch;
                    linkedList = null;
                    linkedList = patch2.getDiffs();
                    linkedList.add(new Diff(Operation.INSERT, line));
                } else if (sign == ' ') {
                    patch2 = patch;
                    linkedList = null;
                    linkedList = patch2.getDiffs();
                    linkedList.add(new Diff(Operation.EQUAL, line));
                } else {
                    if (sign == '@') continue block5;
                    throw new IllegalArgumentException("Invalid patch mode '" + sign + "' in: " + line);
                }
                text.removeFirst();
            }
        }
        return patches;
    }

    private static String unescapeForEncodeUriCompatability(String str) {
        return str.replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%3B", ";").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%2C", ",").replace("%23", "#");
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class Patch {
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public LinkedList<Diff> diffs;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public int start1;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public int start2;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public int length1;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public int length2;

        public Patch() {
            LinkedList<Diff> linkedList = new LinkedList<Diff>();
            Patch patch = this;
            patch.setDiffs(linkedList);
        }

        public String toString() {
            String coords2;
            String coords1;
            Object object = this;
            int n = 0;
            n = ((Patch)object).getLength1();
            if (n == 0) {
                object = this;
                n = 0;
                n = ((Patch)object).getStart1();
                coords1 = n + ",0";
            } else {
                object = this;
                n = 0;
                n = ((Patch)object).getLength1();
                if (n == 1) {
                    object = this;
                    n = 0;
                    n = ((Patch)object).getStart1();
                    coords1 = Integer.toString(n + 1);
                } else {
                    object = this;
                    n = 0;
                    n = ((Patch)object).getStart1();
                    StringBuilder stringBuilder = new StringBuilder().append(n + 1).append(",");
                    object = this;
                    n = 0;
                    n = ((Patch)object).getLength1();
                    coords1 = stringBuilder.append(n).toString();
                }
            }
            object = this;
            n = 0;
            n = ((Patch)object).getLength2();
            if (n == 0) {
                object = this;
                n = 0;
                n = ((Patch)object).getStart2();
                coords2 = n + ",0";
            } else {
                object = this;
                n = 0;
                n = ((Patch)object).getLength2();
                if (n == 1) {
                    object = this;
                    n = 0;
                    n = ((Patch)object).getStart2();
                    coords2 = Integer.toString(n + 1);
                } else {
                    object = this;
                    n = 0;
                    n = ((Patch)object).getStart2();
                    StringBuilder stringBuilder = new StringBuilder().append(n + 1).append(",");
                    object = this;
                    n = 0;
                    n = ((Patch)object).getLength2();
                    coords2 = stringBuilder.append(n).toString();
                }
            }
            StringBuilder text = new StringBuilder();
            text.append("@@ -").append(coords1).append(" +").append(coords2).append(" @@\n");
            object = this;
            Object object2 = null;
            object2 = ((Patch)object).getDiffs();
            Iterator iterator = ((AbstractSequentialList)object2).iterator();
            while (iterator.hasNext()) {
                Diff aDiff = (Diff)iterator.next();
                object = aDiff;
                object2 = null;
                object2 = ((Diff)object).getOperation();
                switch (1.$SwitchMap$utils$diff_match_patch$Operation[((Enum)object2).ordinal()]) {
                    case 1: {
                        text.append('+');
                        break;
                    }
                    case 2: {
                        text.append('-');
                        break;
                    }
                    case 3: {
                        text.append(' ');
                    }
                }
                try {
                    object = aDiff;
                    object2 = null;
                    object2 = ((Diff)object).getText();
                    text.append(URLEncoder.encode((String)object2, "UTF-8").replace('+', ' ')).append("\n");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("This system does not support UTF-8.", e);
                }
            }
            return diff_match_patch.unescapeForEncodeUriCompatability(text.toString());
        }

        @PropertiesEnhancer.GeneratedAccessor
        public LinkedList<Diff> getDiffs() {
            return this.diffs;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setDiffs(LinkedList<Diff> linkedList) {
            this.diffs = linkedList;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public int getStart1() {
            return this.start1;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setStart1(int n) {
            this.start1 = n;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public int getStart2() {
            return this.start2;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setStart2(int n) {
            this.start2 = n;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public int getLength1() {
            return this.length1;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setLength1(int n) {
            this.length1 = n;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public int getLength2() {
            return this.length2;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setLength2(int n) {
            this.length2 = n;
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class Diff {
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public Operation operation;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String text;

        public Diff(Operation operation, String text) {
            Object object = operation;
            Diff diff2 = this;
            diff2.setOperation((Operation)((Object)object));
            object = text;
            diff2 = this;
            diff2.setText((String)object);
        }

        public String toString() {
            Diff diff2 = this;
            Object object = null;
            object = diff2.getText();
            String prettyText = object.replace('\n', '\u00b6');
            diff2 = this;
            object = null;
            object = diff2.getOperation();
            return "Diff(" + object + ",\"" + prettyText + "\")";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object d) {
            try {
                Diff diff2 = (Diff)d;
                Object var4_3 = null;
                Operation operation = diff2.getOperation();
                diff2 = this;
                Object var4_5 = null;
                Operation operation2 = diff2.getOperation();
                if (operation != operation2) return false;
                diff2 = (Diff)d;
                Object var4_7 = null;
                String string = diff2.getText();
                diff2 = this;
                Object var4_9 = null;
                String string2 = diff2.getText();
                if (!string.equals(string2)) return false;
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return super.hashCode();
        }

        @PropertiesEnhancer.GeneratedAccessor
        public Operation getOperation() {
            return this.operation;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getText() {
            return this.text;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setText(String string) {
            this.text = string;
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static enum Operation {
        DELETE,
        INSERT,
        EQUAL;

    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    protected static class LinesToCharsResult {
        protected String chars1;
        protected String chars2;
        protected List<String> lineArray;

        protected LinesToCharsResult(String chars1, String chars2, List<String> lineArray) {
            this.chars1 = chars1;
            this.chars2 = chars2;
            this.lineArray = lineArray;
        }
    }
}

