/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.Application;
import controllers.UserApp;
import controllers.routes;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import models.AbstractPosting;
import models.Attachment;
import models.Organization;
import models.Project;
import models.PullRequest;
import models.User;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Duration;
import play.Configuration;
import play.i18n.Messages;
import play.mvc.Call;
import play.twirl.api.Html;
import play.twirl.api.Html$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import utils.Config;
import utils.GravatarUtil;
import utils.JodaDateUtil;
import utils.TemplateHelper$Branches$;
import views.html.helper.FieldElements;

public final class TemplateHelper$ {
    public static final TemplateHelper$ MODULE$;

    static {
        new TemplateHelper$();
    }

    public boolean isAllowedOAuthProvider(String provider) {
        String[] allowedProviders = Configuration.root().getString("application.social.login.support", "").replaceAll(" ", "").split(",");
        return Predef$.MODULE$.refArrayOps((Object[])allowedProviders).toStream().contains((Object)provider);
    }

    public String showWatchers(AbstractPosting posting) {
        return new StringBuilder().append((Object)"<div class='show-watchers' data-toggle='tooltip' data-placement='top' data-trigger='hover' data-html='true' title='").append((Object)Messages.get((String)"watchers", (Object[])new Object[0])).append((Object)"'>").append((Object)"<button id='watcher-list-button' type='button' class='ybtn'><i class='yobicon-emo-happy'></i><span class='watcherCount'></span></button>").append((Object)"</div>").toString();
    }

    public String GithubLogo() {
        return "<span class=\"github\"><svg aria-hidden=\"true\" height=\"24\" version=\"1.1\" viewBox=\"0 0 16 16\" width=\"19\"><path\n  d=\"M8 0C3.58 0 0 3.58 0 8c0 3.54 2.29 6.53 5.47 7.59 0.4 0.07 0.55-0.17 0.55-0.38 0-0.19-0.01-0.82-0.01-1.49-2.01 0.37-2.53-0.49-2.69-0.94-0.09-0.23-0.48-0.94-0.82-1.13-0.28-0.15-0.68-0.52-0.01-0.53 0.63-0.01 1.08 0.58 1.23 0.82 0.72 1.21 1.87 0.87 2.33 0.66 0.07-0.52 0.28-0.87 0.51-1.07-1.78-0.2-3.64-0.89-3.64-3.95 0-0.87 0.31-1.59 0.82-2.15-0.08-0.2-0.36-1.02 0.08-2.12 0 0 0.67-0.21 2.2 0.82 0.64-0.18 1.32-0.27 2-0.27 0.68 0 1.36 0.09 2 0.27 1.53-1.04 2.2-0.82 2.2-0.82 0.44 1.1 0.16 1.92 0.08 2.12 0.51 0.56 0.82 1.27 0.82 2.15 0 3.07-1.87 3.75-3.65 3.95 0.29 0.25 0.54 0.73 0.54 1.48 0 1.07-0.01 1.93-0.01 2.2 0 0.21 0.15 0.46 0.55 0.38C13.71 14.53 16 11.53 16 8 16 3.58 12.42 0 8 0z\"></path></svg></span>";
    }

    public String GoogleLogo() {
        play.api.mvc.Call url = routes.Assets.at("images/provider-logo/btn_google_light_normal_ios.svg");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<span class=\"google\"><img src=\"", "\"></span>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url}));
    }

    public String providerWithLogo(String provider) {
        String string;
        String string2;
        play.api.mvc.Call googleLogo = routes.Assets.at("images/provider-logo/btn_google_light_normal_ios.svg");
        String string3 = string2 = provider;
        if (!("github" != null ? !"github".equals(string3) : string3 != null)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<span class=\"auth-provider-logo\">", " <span class=\"provider-name\">Sign in with ", "</span></span>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.GithubLogo(), Application.GITHUB_NAME}));
        } else {
            String string4 = string2;
            string = !("google" != null ? !"google".equals(string4) : string4 != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<span class=\"auth-provider-logo\"><img src=\"", "\" alt=\"login with Google\"> Sign in with Google</span>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{googleLogo})) : "";
        }
        return string;
    }

    public String buildQueryString(Call call, scala.collection.immutable.Map<String, String> queryMap) {
        String baseUrl = call.toString();
        String prefix = "?";
        ObjectRef query = new ObjectRef((Object)"");
        if (baseUrl.indexOf("?") != -1) {
            prefix = "&";
        }
        queryMap.map((Function1)new Serializable(query){
            public static final long serialVersionUID = 0L;
            private final ObjectRef query$1;

            public final void apply(Tuple2<String, String> v) {
                this.query$1.elem = new StringBuilder().append((Object)((String)this.query$1.elem)).append((Object)new StringBuilder().append((Object)((String)v._1())).append((Object)"=").append(v._2()).append((Object)"&").toString()).toString();
            }
            {
                this.query$1 = query$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return new StringBuilder().append((Object)baseUrl).append((Object)prefix).append(new StringOps(Predef$.MODULE$.augmentString((String)query.elem)).dropRight(1)).toString();
    }

    public String buildAttrString(Map<String, String> attrMap) {
        ObjectRef attr = new ObjectRef((Object)"");
        ((WrapAsScala)package$.MODULE$.wrapAll()).mapAsScalaMap(attrMap).map((Function1)new Serializable(attr){
            public static final long serialVersionUID = 0L;
            private final ObjectRef attr$1;

            public final void apply(Tuple2<String, String> v) {
                this.attr$1.elem = new StringBuilder().append((Object)((String)this.attr$1.elem)).append((Object)new StringBuilder().append((Object)((String)v._1())).append((Object)"=").append(v._2()).append((Object)" ").toString()).toString();
            }
            {
                this.attr$1 = attr$1;
            }
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)attr.elem)).dropRight(1);
    }

    public String agoString(Duration duration) {
        String string;
        if (duration == null) {
            string = "";
        } else {
            long sec = duration.getMillis() / 1000L;
            long l = sec;
            String string2 = l >= 86400L ? this.plural("common.time.day", Predef$.MODULE$.long2Long(duration.getStandardDays())) : (l >= 3600L ? this.plural("common.time.hour", Predef$.MODULE$.long2Long(duration.getStandardHours())) : (l >= 60L ? this.plural("common.time.minute", Predef$.MODULE$.long2Long(duration.getStandardMinutes())) : (l > 0L ? this.plural("common.time.second", Predef$.MODULE$.long2Long(duration.getStandardSeconds())) : (BoxesRunTime.boxToLong((long)l) == null ? "" : Messages.get((String)"common.time.just", (Object[])new Object[0])))));
            string = string2;
        }
        return string;
    }

    public String agoOrDateString(Date date) {
        String year = JodaDateUtil.getDateString(date, "yyyy");
        String thisYear = JodaDateUtil.getDateString(new Date(), "yyyy");
        Duration ago = JodaDateUtil.ago(date);
        return ago.getStandardDays() < 8L ? this.agoString(ago) : (thisYear.equals(year) ? JodaDateUtil.getDateString(date, "MM-dd") : JodaDateUtil.getDateString(date, "yyyy-MM-dd"));
    }

    public String plural(String key, Number count) {
        String _key = key;
        if (!BoxesRunTime.equalsNumObject((Number)count, (Object)BoxesRunTime.boxToInteger((int)1))) {
            _key = new StringBuilder().append((Object)key).append((Object)"s").toString();
        }
        return Messages.get((String)_key, (Object[])new Object[]{count.toString()});
    }

    public String urlToPicture(String email, int size) {
        return GravatarUtil.getAvatar(email, size);
    }

    public int urlToPicture$default$2() {
        return 64;
    }

    public Html simpleForm(FieldElements elements) {
        return elements.input();
    }

    public String getJSPath() {
        return routes.Assets.at("javascripts/").toString();
    }

    public boolean nullOrEquals(String a, String b) {
        return a == null || b == null || a.equals(b);
    }

    public String ifElse(boolean condition, String a, String b) {
        return condition ? a : b;
    }

    public String equalsThen(String a, String b, String thenStr) {
        return a != null && b != null && StringUtils.equals((CharSequence)a, (CharSequence)b) ? thenStr : "";
    }

    public int getPort(URI uri) {
        int n;
        int port;
        int n2 = port = uri.getPort();
        switch (n2) {
            default: {
                n = port;
                break;
            }
            case -1: {
                n = uri.toURL().getDefaultPort();
            }
        }
        return n;
    }

    public boolean resourceEquals(URI a, URI b) {
        return this.nullOrEquals(a.getHost(), b.getHost()) && this.getPort(a) == this.getPort(b) && StringUtils.equals((CharSequence)a.getPath(), (CharSequence)b.getPath());
    }

    public String urlToList(String referrer, String defaultURI) {
        String string;
        String string2 = referrer;
        String string3 = string2 != null && this.resourceEquals(this.fullURI$1(string = string2), this.fullURI$1(defaultURI)) ? string : defaultURI;
        return string3;
    }

    public String getUserAvatarUrl(User user, int avatarSize) {
        String string = user.avatarUrl();
        String string2 = UserApp.DEFAULT_AVATAR_URL;
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.urlToPicture(user.email, avatarSize) : user.avatarUrl();
    }

    public String getUserAvatar(User user, String avatarSize) {
        user.refresh();
        String userInfoURL = routes.UserApp.userInfo(user.loginId, routes.UserApp.userInfo$default$2(), routes.UserApp.userInfo$default$3()).toString();
        return new StringBuilder().append((Object)"<a href=\"").append((Object)userInfoURL).append((Object)"\" class=\"usf-group\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"").append((Object)user.name).append((Object)"\"><img src=\"").append((Object)user.avatarUrl()).append((Object)"\" class=\"avatar-wrap ").append((Object)avatarSize).append((Object)"\"></a>").toString();
    }

    public String getUserAvatar$default$2() {
        return "small";
    }

    public play.api.mvc.Call urlToProjectBG(Project project2) {
        java.util.List<Attachment> list2 = Attachment.findByContainer(project2.asResource());
        play.api.mvc.Call call = list2.size() > 0 ? routes.AttachmentApp.getFile(Predef$.MODULE$.Long2long(((Attachment)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(list2).head()).id)) : routes.Assets.at("images/project_default.jpg");
        return call;
    }

    public play.api.mvc.Call urlToProjectLogo(Project project2) {
        java.util.List<Attachment> list2 = Attachment.findByContainer(project2.asResource());
        play.api.mvc.Call call = list2.size() > 0 ? routes.AttachmentApp.getFile(Predef$.MODULE$.Long2long(((Attachment)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(list2).head()).id)) : routes.Assets.at("images/project_default_logo.png");
        return call;
    }

    public boolean hasProjectLogo(Project project2) {
        java.util.List<Attachment> list2 = Attachment.findByContainer(project2.asResource());
        boolean bl = list2.size() > 0;
        return bl;
    }

    public String branchItemName(String branch) {
        return TemplateHelper$Branches$.MODULE$.itemName(branch);
    }

    public String urlToCompare(Project project2, String compare2) {
        String[] commits = compare2.split(PullRequest.DELIMETER);
        return routes.CompareApp.compare(project2.owner, project2.name, commits[0], commits[1]).url();
    }

    public int getPercent(double unit, double total) {
        return (int)(unit / total * (double)100);
    }

    public String makeIssuesLink(Project project2, scala.collection.immutable.Map<String, String> param) {
        return this.buildQueryString((Call)routes.IssueApp.issues(project2.owner, project2.name, "open", routes.IssueApp.issues$default$4(), routes.IssueApp.issues$default$5()), param);
    }

    public play.api.mvc.Call urlToOrganizationLogo(Organization organization2) {
        java.util.List<Attachment> list2 = Attachment.findByContainer(organization2.asResource());
        play.api.mvc.Call call = list2.size() > 0 ? routes.AttachmentApp.getFile(Predef$.MODULE$.Long2long(((Attachment)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(list2).head()).id)) : routes.Assets.at("images/group_default.png");
        return call;
    }

    public boolean hasOrganizationLogo(Organization organization2) {
        java.util.List<Attachment> list2 = Attachment.findByContainer(organization2.asResource());
        boolean bl = list2.size() > 0;
        return bl;
    }

    public Html countHtml(String icon, String link, int count, String strong) {
        return Html$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("<a href=\"%s\"><span class=\"count-groups item-icon %s\">\n        <i class=\"yobicon-%s\"></i>\n      </span>\n      <span class=\"count-groups item-count %s\">\n        %d\n      </span></a> ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{link, strong, icon, strong, BoxesRunTime.boxToInteger((int)count)})));
    }

    public String countHtml$default$4() {
        return "";
    }

    public boolean isMarkdownExtension(String path) {
        String ext = FilenameUtils.getExtension((String)path).toLowerCase();
        List markdownExtenstions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"markdown", "mdown", "mkdn", "mkd", "md", "mdwn"}));
        return markdownExtenstions.contains((Object)ext);
    }

    public Object showHeaderWordsInBracketsIfExist(String title) {
        StringBuilder prefixes = new StringBuilder();
        Predef$.MODULE$.refArrayOps((Object[])this.extractHeaderWordsInBrackets(title)).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String prefix) {
                return prefix.trim().indexOf("[") == 0;
            }
        }).foreach((Function1)new Serializable(prefixes){
            public static final long serialVersionUID = 0L;
            private final StringBuilder prefixes$1;

            public final Object apply(String prefix) {
                return prefix.contains("]") ? this.prefixes$1.append(new StringBuilder().append((Object)"<a href='javascript:void(0)' class='title-prefix'>").append((Object)prefix.trim()).append((Object)"</a>").toString()) : BoxedUnit.UNIT;
            }
            {
                this.prefixes$1 = prefixes$1;
            }
        });
        return this.madeByHeaderWordsOnly(title) ? BoxedUnit.UNIT : Html$.MODULE$.apply(prefixes.toString());
    }

    public String removeHeaderWords(String title) {
        if (this.madeByHeaderWordsOnly(title)) {
            return title;
        }
        return title.replace(this.findHeaderWords(title).toString(), "");
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder findHeaderWords(String title) {
        void var2_2;
        StringBuilder prefixes = new StringBuilder();
        Predef$.MODULE$.refArrayOps((Object[])this.extractHeaderWordsInBrackets(title)).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String prefix) {
                return prefix.trim().indexOf("[") == 0;
            }
        }).foreach((Function1)new Serializable(prefixes){
            public static final long serialVersionUID = 0L;
            private final StringBuilder prefixes$2;

            public final Object apply(String prefix) {
                return prefix.contains("]") ? this.prefixes$2.append(prefix) : BoxedUnit.UNIT;
            }
            {
                this.prefixes$2 = prefixes$2;
            }
        });
        return var2_2;
    }

    private boolean madeByHeaderWordsOnly(String title) {
        return title.trim().indexOf("]") + 1 == title.trim().length() || StringUtils.isEmpty((CharSequence)title.replace((CharSequence)this.findHeaderWords(title), "").trim());
    }

    public String[] extractHeaderWordsInBrackets(String title) {
        return title.split("(=\\[)|(?<=\\])");
    }

    public String userInfo(String loginId) {
        return new StringBuilder().append((Object)Config.getContextRoot()).append((Object)loginId).toString();
    }

    public boolean containsInDefaultMenus(String menuName) {
        String[] menus = Configuration.root().getString("project.default.menus.when.create", "code, issue, pullRequest, review, milestone, board").replaceAll(" ", "").split(",");
        return Predef$.MODULE$.refArrayOps((Object[])menus).toStream().contains((Object)menuName);
    }

    private final URI fullURI$1(String u) {
        return Config.createFullURI(u).normalize();
    }

    private TemplateHelper$() {
        MODULE$ = this;
    }
}

