/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.routes;
import models.AbstractPosting;
import models.CodeComment;
import models.Comment;
import models.CommentThread;
import models.CommitComment;
import models.Issue;
import models.IssueComment;
import models.Organization;
import models.Posting;
import models.PostingComment;
import models.Project;
import models.PullRequest;
import models.ReviewComment;
import models.User;
import models.enumeration.ResourceType;
import models.resource.Resource;
import play.Logger;
import play.api.mvc.Call;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import playRepository.Commit;
import utils.TemplateHelper$DiffRenderer$;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class RouteUtil {
    public static final TemplateHelper$DiffRenderer$ diffRenderer = new TemplateHelper$DiffRenderer$();

    public static String getUrl(ResourceType resourceType, String resourceId) {
        return RouteUtil.getUrl(resourceType, Long.valueOf(resourceId));
    }

    public static String getUrl(ResourceType resourceType, Long longId) {
        try {
            switch (resourceType) {
                case ISSUE_POST: {
                    return RouteUtil.getUrl((Issue)Issue.finder.byId((Object)longId));
                }
                case ISSUE_COMMENT: {
                    return RouteUtil.getUrl((IssueComment)IssueComment.find.byId((Object)longId));
                }
                case NONISSUE_COMMENT: {
                    return RouteUtil.getUrl((PostingComment)PostingComment.find.byId((Object)longId));
                }
                case BOARD_POST: {
                    return RouteUtil.getUrl((Posting)Posting.finder.byId((Object)longId));
                }
                case COMMIT_COMMENT: {
                    return RouteUtil.getUrl((CommitComment)CommitComment.find.byId((Object)longId));
                }
                case PULL_REQUEST: {
                    return RouteUtil.getUrl((PullRequest)PullRequest.finder.byId((Object)longId));
                }
                case REVIEW_COMMENT: {
                    return RouteUtil.getUrl((ReviewComment)ReviewComment.find.byId((Object)longId));
                }
                case COMMENT_THREAD: {
                    return RouteUtil.getUrl((CommentThread)CommentThread.find.byId((Object)longId));
                }
                case USER_AVATAR: {
                    return RouteUtil.getUrl((User)User.find.byId((Object)longId));
                }
                case PROJECT: {
                    return RouteUtil.getUrl((Project)Project.find.byId((Object)longId));
                }
            }
            throw new IllegalArgumentException(Resource.getInvalidResourceTypeMessage(resourceType));
        }
        catch (Exception e) {
            Logger.error((String)"Failed to get a url to the resource", (Throwable)e);
            return null;
        }
    }

    public static String getUrl(User user) {
        if (user == null) {
            return null;
        }
        user.refresh();
        User user2 = user;
        String string = null;
        string = user2.getLoginId();
        return routes.UserApp.userInfo(string, routes.UserApp.userInfo$default$2(), routes.UserApp.userInfo$default$3()).url();
    }

    public static String getUrl(Organization org) {
        if (org == null) {
            return null;
        }
        org.refresh();
        Organization organization2 = org;
        String string = null;
        string = organization2.getName();
        return routes.OrganizationApp.organization(string).url();
    }

    public static String getUrl(Project project2) {
        if (project2 == null) {
            return null;
        }
        project2.refresh();
        Project project3 = project2;
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        return routes.ProjectApp.project(string2, string).url();
    }

    public static String getUrl(Issue issue2) {
        if (issue2 == null) {
            return null;
        }
        issue2.refresh();
        Object object = issue2;
        Object object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        Object object3 = object2 = ((Project)object).getOwner();
        object = issue2;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getName();
        return routes.IssueApp.issue((String)object3, (String)object2, issue2.getNumber()).url();
    }

    public static String getUrl(Posting post2) {
        if (post2 == null) {
            return null;
        }
        post2.refresh();
        Object object = post2;
        Object object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        Object object3 = object2 = ((Project)object).getOwner();
        object = post2;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getName();
        return routes.BoardApp.post((String)object3, (String)object2, post2.getNumber()).url();
    }

    public static String getUrl(IssueComment comment) {
        if (comment == null) {
            return null;
        }
        IssueComment issueComment = comment;
        Object object = null;
        object = issueComment.getIssue();
        StringBuilder stringBuilder = new StringBuilder().append(RouteUtil.getUrl((Issue)object)).append("#comment-");
        issueComment = comment;
        object = null;
        object = issueComment.getId();
        return stringBuilder.append(object).toString();
    }

    public static String getUrl(PostingComment comment) {
        if (comment == null) {
            return null;
        }
        PostingComment postingComment = comment;
        Object object = null;
        object = postingComment.getPosting();
        StringBuilder stringBuilder = new StringBuilder().append(RouteUtil.getUrl((Posting)object)).append("#comment-");
        postingComment = comment;
        object = null;
        object = postingComment.getId();
        return stringBuilder.append(object).toString();
    }

    public static String getUrl(PullRequest pullRequest2) {
        if (pullRequest2 == null) {
            return null;
        }
        Model model = pullRequest2;
        Object object = null;
        object = model.getToProject();
        Project toProject = object;
        model = toProject;
        object = null;
        Object object2 = object = model.getOwner();
        model = toProject;
        object = null;
        Object object3 = object = model.getName();
        model = pullRequest2;
        object = null;
        object = model.getNumber();
        return routes.PullRequestApp.pullRequest((String)object2, (String)object3, (Long)object).url();
    }

    public static String getUrl(CommitComment comment) {
        if (comment == null) {
            return null;
        }
        Object object = comment;
        Object object2 = null;
        object = object2 = ((CodeComment)object).getProject();
        object2 = null;
        Object object3 = object2 = ((Project)object).getOwner();
        object = comment;
        object2 = null;
        object = object2 = ((CodeComment)object).getProject();
        object2 = null;
        object2 = ((Project)object).getName();
        Call toView = routes.CodeHistoryApp.show((String)object3, (String)object2, comment.commitId);
        object = comment;
        object2 = null;
        object2 = ((CodeComment)object).getId();
        return toView + "#comment-" + object2;
    }

    public static String getUrl(Comment comment) {
        if (comment == null) {
            return null;
        }
        if (comment instanceof IssueComment) {
            return RouteUtil.getUrl((IssueComment)comment);
        }
        if (comment instanceof PostingComment) {
            return RouteUtil.getUrl((PostingComment)comment);
        }
        throw new IllegalArgumentException();
    }

    public static String getUrl(ReviewComment comment) {
        if (comment == null) {
            return null;
        }
        ReviewComment reviewComment = comment;
        Object object = null;
        object = reviewComment.getThread();
        CommentThread thread = object;
        reviewComment = comment;
        object = null;
        object = reviewComment.getId();
        return diffRenderer.urlToContainer(thread) + "#comment-" + object;
    }

    public static String getUrl(CommentThread thread) {
        if (thread == null) {
            return "";
        }
        CommentThread commentThread = thread;
        Long l = null;
        l = commentThread.getId();
        return diffRenderer.urlToContainer(thread) + "#thread-" + l;
    }

    public static String getUrl(Commit commit, Project project2) {
        if (commit == null) {
            return null;
        }
        Project project3 = project2;
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        return routes.CodeHistoryApp.show(string2, string, commit.getId()).url();
    }
}

