/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import play.Configuration;
import play.api.Play;
import play.core.Router;
import play.core.enhancers.PropertiesEnhancer;
import play.data.validation.Constraints;
import play.libs.F;
import play.libs.Scala;
import scala.Tuple3;
import scala.collection.Seq;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ReservedWordsValidator
extends Constraints.Validator<String> {
    public static final String MESSAGE = "validation.reservedWord";
    public static final Set<String> RESERVED_WORDS = new HashSet<String>();

    public F.Tuple<String, Object[]> getErrorMessageKey() {
        return F.Tuple((Object)MESSAGE, (Object)new Object[0]);
    }

    public boolean isValid(String string) {
        return !ReservedWordsValidator.isReserved(string);
    }

    public static boolean isReserved(String string) {
        for (String word : RESERVED_WORDS) {
            if (!StringUtils.equalsIgnoreCase((String)string, (String)word)) continue;
            return true;
        }
        return false;
    }

    static {
        List list2 = Scala.asJava((Seq)((Router.Routes)Play.current().routes().get()).documentation());
        Configuration config = Configuration.root();
        String context = config.getString("application.context", "/");
        String regex = String.format("^%s%s(%s)/?", context, context.endsWith("/") ? "" : "/", "[a-zA-Z0-9\uac00-\ud7a3-]+([_.][a-zA-Z0-9\uac00-\ud7a3-]+)*");
        Pattern pattern = Pattern.compile(regex);
        for (Tuple3 tuple : list2) {
            Matcher matcher = pattern.matcher((CharSequence)tuple._2());
            if (!matcher.find()) continue;
            RESERVED_WORDS.add(matcher.group(1));
        }
        RESERVED_WORDS.add("new");
        RESERVED_WORDS.add("projects");
        RESERVED_WORDS.add("orgs");
        RESERVED_WORDS.add("organizations");
    }
}

