/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;
import utils.Config;
import utils.FastHttpDateFormat;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PlayServletResponse
implements HttpServletResponse {
    private final PipedInputStream inputStream;
    private Http.Response response;
    private String characterEncoding;
    private int status = 0;
    private PrintWriter pw;
    private ChunkedOutputStream outputStream;
    private final Object statusLock;
    private boolean committed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitAndGetStatus() throws InterruptedException {
        Object statusLock;
        Object object = statusLock = this.getStatusLock();
        synchronized (object) {
            statusLock.wait();
            return this.getStatus();
        }
    }

    public Object getStatusLock() {
        return this.statusLock;
    }

    public PlayServletResponse(Http.Response response) throws IOException {
        this.response = response;
        this.statusLock = new Object();
        this.inputStream = new PipedInputStream();
        this.outputStream = new ChunkedOutputStream(new PipedOutputStream(this.inputStream));
        this.pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)((Object)this.outputStream), Config.getCharset())), false);
    }

    public void flushBuffer() throws IOException {
        this.getWriter().flush();
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding != null) {
            return this.characterEncoding;
        }
        return PlayServletResponse.getCharsetFromContentType(this.getContentType());
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    public PipedInputStream getInputStream() {
        return this.inputStream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.pw;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void resetBuffer() {
        try {
            this.getWriter().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setBufferSize(int arg0) {
        throw new UnsupportedOperationException();
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentLength(int length) {
        this.response.setHeader("Content-Length", Integer.toString(length));
    }

    public void setContentLengthLong(long length) {
        this.response.setHeader("Content-Length", Long.toString(length));
    }

    public void setContentType(String type) {
        this.response.setContentType(type);
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException();
    }

    public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, FastHttpDateFormat.formatDate(date, null));
    }

    public void addHeader(String name, String value) {
        String head = (String)this.response.getHeaders().get(name);
        String newValue = head == null || head.trim().isEmpty() ? value : head + "," + value;
        this.response.setHeader(name, newValue);
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, value + "");
    }

    public boolean containsHeader(String name) {
        return this.response.getHeaders().containsKey(name);
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String arg0) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String encodeUrl(String arg0) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String headerName) {
        for (String h : this.response.getHeaders().keySet()) {
            if (!headerName.toLowerCase().equals(h.toLowerCase())) continue;
            return (String)this.response.getHeaders().get(h);
        }
        return null;
    }

    public Collection<String> getHeaderNames() {
        return this.response.getHeaders().keySet();
    }

    public Collection<String> getHeaders(String name) {
        return Arrays.asList(((String)this.response.getHeaders().get(name)).split(","));
    }

    public int getStatus() {
        return this.status;
    }

    public void sendError(int statusCode) throws IOException {
        this.setStatus(statusCode);
    }

    public void sendError(int statusCode, String msg) throws IOException {
        this.setStatus(statusCode);
        if (msg != null) {
            this.setContentType("text/plain");
            this.resetBuffer();
            this.getWriter().write(msg);
            Logger.error((String)msg);
        } else {
            this.response.getHeaders().remove("Content-Type");
            this.resetBuffer();
        }
    }

    public void sendRedirect(String location) throws IOException {
        this.response.setHeader("Location", location);
        this.setStatus(302);
    }

    public void setDateHeader(String name, long date) {
        this.response.setHeader(name, FastHttpDateFormat.formatDate(date, null));
    }

    public void setHeader(String name, String value) {
        if (name == null || name.length() == 0 || value == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setHeader(name, Integer.toString(value));
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Deprecated
    public void setStatus(int status, String msg) {
        throw new UnsupportedOperationException();
    }

    private static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public String getVirtualServerName() {
        throw new UnsupportedOperationException();
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    class ChunkedOutputStream
    extends ServletOutputStream {
        private byte[] buffer = new byte[0x100000];
        private int offset = 0;
        private OutputStream target;

        public ChunkedOutputStream(OutputStream target) {
            this.target = target;
        }

        public void write(int b) throws IOException {
            if (this.offset >= this.buffer.length - 1) {
                this.flush();
            }
            this.buffer[this.offset++] = (byte)b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b) throws IOException {
            Object object = PlayServletResponse.this.statusLock;
            synchronized (object) {
                PlayServletResponse.this.statusLock.notifyAll();
                PlayServletResponse.this.committed = true;
            }
            this.target.write(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Object object = PlayServletResponse.this.statusLock;
            synchronized (object) {
                PlayServletResponse.this.statusLock.notifyAll();
            }
            byte[] b = Arrays.copyOf(this.buffer, this.offset);
            this.target.write(b);
            this.offset = 0;
        }

        public void close() throws IOException {
            this.offset = 0;
            this.target.close();
            super.close();
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException();
        }

        public boolean isReady() {
            throw new UnsupportedOperationException();
        }
    }
}

