/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.HashMap;
import java.util.Map;
import models.User;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Sha1Hash;
import org.joda.time.DateTime;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PasswordReset {
    public static final Map<String, String> resetHashMap = new HashMap<String, String>();
    public static final Map<String, Long> resetHashTimetable = new HashMap<String, Long>();
    public static final int HASH_EXPIRE_TIME_MILLISEC = 3600000;

    public static String generateResetHash(String loginId) {
        return new Sha1Hash((Object)loginId, (Object)new SecureRandomNumberGenerator().nextBytes(), 1).toHex();
    }

    public static void addHashToResetTable(String userId, String hashString) {
        resetHashMap.put(userId, hashString);
        resetHashTimetable.put(hashString, new DateTime().getMillis());
    }

    public static boolean isValidResetHash(String hashString) {
        if (!resetHashMap.containsValue(hashString)) {
            return false;
        }
        return !PasswordReset.isExpired(hashString);
    }

    private static boolean isExpired(String hashString) {
        return resetHashTimetable.get(hashString) + 3600000L < new DateTime().getMillis();
    }

    private static void removeResetHash(String hashString) {
        String key = PasswordReset.getKeyByValue(resetHashMap, hashString);
        resetHashMap.remove(key);
        resetHashTimetable.remove(hashString);
    }

    private static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean resetPassword(String hashString, String newPassword) {
        if (!PasswordReset.isValidResetHash(hashString)) {
            return false;
        }
        String loginId = PasswordReset.getKeyByValue(resetHashMap, hashString);
        User.resetPassword(loginId, newPassword);
        PasswordReset.removeResetHash(hashString);
        return true;
    }
}

