/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.UserApp;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import models.Issue;
import models.Project;
import models.enumeration.Operation;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import utils.AccessControl;
import utils.AutoLinkRenderer;
import utils.CacheStore;
import utils.Config;
import utils.ZipUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Markdown {
    private static final String XSS_JS_FILE = "public/javascripts/lib/xss.js";
    private static final String MARKED_JS_FILE = "public/javascripts/lib/marked.js";
    private static final String HIGHLIGHT_JS_FILE = "public/javascripts/lib/highlight/highlight.pack.js";
    private static ScriptEngine engine = Markdown.buildEngine();
    private static PolicyFactory sanitizerPolicy = Sanitizers.FORMATTING.and(Sanitizers.IMAGES).and(Sanitizers.STYLES).and(Sanitizers.TABLES).and(Sanitizers.BLOCKS).and(new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"http", "https", "mailto", "file", "zpl"}).allowElements(new String[]{"video", "source", "a", "input", "pre", "br", "hr", "iframe", "ol"}).allowAttributes(new String[]{"href", "name", "target"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"src", "type", "target"}).onElements(new String[]{"source"}).allowAttributes(new String[]{"data-setup", "controls", "preload", "type", "autoplay", "responsive", "height", "width", "fluid", "liveui", "src"}).onElements(new String[]{"video"}).allowAttributes(new String[]{"type", "disabled", "checked"}).onElements(new String[]{"input"}).allowAttributes(new String[]{"start"}).onElements(new String[]{"ol"}).allowAttributes(new String[]{"width", "height", "src", "frameborder", "allow", "allowfullscreen"}).onElements(new String[]{"iframe"}).allowAttributes(new String[]{"class", "id", "style", "width", "height"}).globally().toFactory());

    private static ScriptEngine buildEngine() {
        ScriptEngineManager manager = new ScriptEngineManager(null);
        InputStream is = null;
        Reader reader = null;
        ScriptEngine _engine = manager.getEngineByName("JavaScript");
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(XSS_JS_FILE);
            reader = new InputStreamReader(is, Config.getCharset());
            _engine.eval(reader);
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(MARKED_JS_FILE);
            reader = new InputStreamReader(is, Config.getCharset());
            _engine.eval(reader);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return _engine;
    }

    private static String removeJavascriptInHref(String source) {
        Document doc = Jsoup.parse((String)source);
        Elements elements = doc.getElementsByAttribute("href");
        for (Element el : elements) {
            String href = el.attr("href").replaceAll("[^\\w:]", "").toLowerCase();
            if (!href.startsWith("javascript:")) continue;
            el.attr("href", "#");
        }
        return doc.body().html();
    }

    private static String checkReferrer(String source) {
        Boolean noReferrer = Configuration.root().getBoolean("application.noreferrer", Boolean.valueOf(false));
        if (noReferrer.booleanValue()) {
            String hostname = Config.getHostname();
            Document doc = Jsoup.parse((String)source);
            Elements elements = doc.getElementsByAttribute("href");
            for (Element el : elements) {
                String href = el.attr("href");
                try {
                    URI uri = new URI(href);
                    if (uri.getHost() == null || uri.getHost().startsWith(hostname)) continue;
                    el.attr("rel", el.attr("rel") + " noreferrer");
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return doc.body().html();
        }
        return source;
    }

    private static String transformIssueLink(String source) {
        String hostname = Config.getHostname();
        Document doc = Jsoup.parse((String)source);
        Elements elements = doc.getElementsByAttribute("href");
        for (Element el : elements) {
            String href = el.attr("href");
            String linkText = el.text();
            try {
                URI uri = new URI(href);
                if (uri.getHost() == null || !uri.getHost().startsWith(hostname) || !StringUtils.equals((String)linkText, (String)href)) continue;
                el.attr("rel", el.attr("rel") + " noreferrer");
                if (!Markdown.extractIssueLink(el, uri)) continue;
                break;
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        }
        return doc.body().html();
    }

    private static boolean extractIssueLink(Element el, URI uri) {
        Pattern pattern = Pattern.compile("/issue/\\d+");
        Matcher matcher = pattern.matcher(uri.getPath());
        if (matcher.find()) {
            String linkText = el.text();
            String[] segments = uri.getPath().split("/issue/");
            try {
                if (segments.length > 1) {
                    String[] s = segments[0].split("/");
                    String owner = s[s.length - 2];
                    String projectName = s[s.length - 1];
                    long number = Long.parseLong(segments[1]);
                    Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
                    Issue issue2 = Issue.findByNumber(project2, number);
                    if (!AccessControl.isAllowed(UserApp.currentUser(), issue2.asResource(), Operation.READ)) {
                        return true;
                    }
                    Issue issue3 = issue2;
                    String string = null;
                    string = issue3.getTitle();
                    linkText = "#" + issue2.getNumber() + "." + string;
                    String fragment = uri.getFragment();
                    if (fragment != null) {
                        linkText = linkText + "#" + fragment;
                    }
                    el.addClass("issueLink");
                }
            }
            catch (RuntimeException re) {
                Logger.warn((String)("Issue link extraction fail: " + uri.getPath()));
            }
            el.text(linkText);
        }
        return false;
    }

    public static String sanitize(String source) {
        return sanitizerPolicy.sanitize(source);
    }

    private static String renderWithHighlight(String source, boolean breaks) {
        int sourceHashCode = source.hashCode();
        byte[] cached = (byte[])CacheStore.renderedMarkdown.getIfPresent((Object)sourceHashCode);
        if (cached != null) {
            return ZipUtil.decompress(cached);
        }
        try {
            Object options = engine.eval("new Object({     gfm: true,     tables: true,     breaks: true,     headerIds: true,     pedantic: false,     sanitize: false,     smartLists: true }) ");
            String rendered = Markdown.renderByMarked(source, options);
            rendered = Markdown.removeJavascriptInHref(rendered);
            rendered = Markdown.checkReferrer(rendered);
            rendered = Markdown.transformIssueLink(rendered);
            String sanitized = Markdown.sanitize(rendered);
            CacheStore.renderedMarkdown.put((Object)sourceHashCode, (Object)ZipUtil.compress(sanitized));
            return sanitized;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String renderByMarked(final @Nonnull String source, final Object options) throws InterruptedException {
        if (source.isEmpty()) {
            return source;
        }
        final String[] rendered = new String[1];
        Thread marked = new Thread(){

            @Override
            public void run() {
                try {
                    rendered[0] = (String)((Invocable)((Object)engine)).invokeFunction("marked", source, options);
                }
                catch (Exception e) {
                    Logger.error((String)("[Markdown] Failed to render: " + source), (Throwable)e);
                }
            }
        };
        marked.start();
        marked.join(5000L);
        if (rendered[0] == null) {
            marked.stop();
            return "<pre>" + StringEscapeUtils.escapeHtml((String)source) + "</pre>";
        }
        return rendered[0];
    }

    public static String render(@Nonnull String source) {
        int sourceHashCode = source.hashCode();
        byte[] cached = (byte[])CacheStore.renderedMarkdown.getIfPresent((Object)sourceHashCode);
        if (cached != null) {
            return ZipUtil.decompress(cached);
        }
        try {
            Object options = engine.eval("new Object({gfm: true, tables: true, breaks: true, pedantic: false, sanitize: false, smartLists: true});");
            String sanitized = Markdown.sanitize(Markdown.renderByMarked(source, options));
            CacheStore.renderedMarkdown.put((Object)sourceHashCode, (Object)ZipUtil.compress(sanitized));
            return sanitized;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String render(@Nonnull String source, Project project2, boolean breaks) {
        AutoLinkRenderer autoLinkRenderer = new AutoLinkRenderer(Markdown.renderWithHighlight(source, breaks), project2);
        return autoLinkRenderer.render(null);
    }

    public static String render(@Nonnull String source, Project project2, boolean breaks, String lang) {
        AutoLinkRenderer autoLinkRenderer = new AutoLinkRenderer(Markdown.renderWithHighlight(source, breaks), project2);
        return autoLinkRenderer.render(lang);
    }

    public static String render(@Nonnull String source, Project project2) {
        return Markdown.render(source, project2, true);
    }

    public static String render(@Nonnull String source, Project project2, String lang) {
        return Markdown.render(source, project2, true, lang);
    }

    public static String renderFileInCodeBrowser(@Nonnull String source, Project project2) {
        String imageLinkFilter = Markdown.replaceImageLinkPath(project2, source);
        AutoLinkRenderer autoLinkRenderer = new AutoLinkRenderer(Markdown.renderWithHighlight(imageLinkFilter, true), project2);
        return autoLinkRenderer.render(null);
    }

    public static String renderFileInReadme(@Nonnull String source, Project project2) {
        String relativeLinksToCodeBrowserPath = Markdown.replaceContentsLinkToCodeBrowerPath(project2, source);
        AutoLinkRenderer autoLinkRenderer = new AutoLinkRenderer(Markdown.renderWithHighlight(relativeLinksToCodeBrowserPath, true), project2);
        return autoLinkRenderer.render(null);
    }

    private static String replaceImageLinkPath(Project project2, String text) {
        String root = Configuration.root().getString("application.context", "");
        if (StringUtils.isNotEmpty((String)root)) {
            root = "/" + root;
        }
        String imageLink = "!\\[(?<text>[^]]*)]\\(/?(?!https:|http:|ftp:|file:)[.][/](?<link>.*)\\)";
        Project project3 = project2;
        String string = null;
        string = project3.getOwner();
        StringBuilder stringBuilder = new StringBuilder().append("![$1](/").append(root).append(string).append("/");
        project3 = project2;
        string = null;
        string = project3.getName();
        return text.replaceAll("!\\[(?<text>[^]]*)]\\(/?(?!https:|http:|ftp:|file:)[.][/](?<link>.*)\\)", stringBuilder.append(string).append("/files/").append(project2.defaultBranch().replaceAll("refs/heads/", "")).append("/$2)").toString());
    }

    private static String replaceContentsLinkToCodeBrowerPath(Project project2, String text) {
        String root = Configuration.root().getString("application.context", "");
        if (StringUtils.isNotEmpty((String)root)) {
            root = "/" + root;
        }
        String imageLink = "!\\[(?<text>[^]]*)]\\(/?(?!https:|http:|ftp:|file:)[.][/](?<link>.*)\\)";
        String normalLocalLink = "(?<space>[^!])\\[(?<text>[^]]*)]\\(/?(?!https:|http:|ftp:|file:)[.][/](?<link>.*)\\)";
        Project project3 = project2;
        String string = null;
        string = project3.getOwner();
        StringBuilder stringBuilder = new StringBuilder().append("![$1](/").append(root).append(string).append("/");
        project3 = project2;
        string = null;
        string = project3.getName();
        String imageFilteredText = text.replaceAll("!\\[(?<text>[^]]*)]\\(/?(?!https:|http:|ftp:|file:)[.][/](?<link>.*)\\)", stringBuilder.append(string).append("/files/").append(project2.defaultBranch().replaceAll("refs/heads/", "")).append("/$2)").toString());
        project3 = project2;
        string = null;
        string = project3.getOwner();
        StringBuilder stringBuilder2 = new StringBuilder().append("$1[$2](/").append(root).append(string).append("/");
        project3 = project2;
        string = null;
        string = project3.getName();
        return imageFilteredText.replaceAll("(?<space>[^!])\\[(?<text>[^]]*)]\\(/?(?!https:|http:|ftp:|file:)[.][/](?<link>.*)\\)", stringBuilder2.append(string).append("/code/").append(project2.defaultBranch().replaceAll("refs/heads/", "")).append("/$3)").toString());
    }
}

