/*
 * Decompiled with CFR 0.152.
 */
package utils;

import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class LineEnding {
    public static final EndingType DEFAULT_ENDING_TYPE = EndingType.UNIX;

    public static String changeLineEnding(String contents, String to) {
        if (StringUtils.isNotEmpty((CharSequence)to) && "DOS".equalsIgnoreCase(to)) {
            return LineEnding.changeLineEnding(contents, EndingType.DOS);
        }
        return LineEnding.changeLineEnding(contents, EndingType.UNIX);
    }

    public static String changeLineEnding(String contents, EndingType to) {
        EndingType endingType = LineEnding.findLineEnding(contents);
        if (StringUtils.isEmpty((CharSequence)contents)) {
            return "";
        }
        if (endingType != EndingType.DOS && to == EndingType.DOS) {
            return contents.replaceAll("\n", "\n");
        }
        if (endingType != EndingType.UNIX && to == EndingType.UNIX) {
            return contents.replaceAll("\r\n", "\n");
        }
        return contents;
    }

    public static String addEOL(String contents) {
        EndingType endingType = LineEnding.findLineEnding(contents);
        if (endingType == EndingType.UNDEFINED) {
            endingType = DEFAULT_ENDING_TYPE;
        }
        if (contents != null) {
            EndingType endingType2 = endingType;
            String string = null;
            string = endingType2.getValue();
            if (!contents.endsWith(string)) {
                endingType2 = endingType;
                string = null;
                string = endingType2.getValue();
                return contents.concat(string);
            }
        }
        return contents;
    }

    public static EndingType findLineEnding(String contents) {
        if (StringUtils.isEmpty((CharSequence)contents)) {
            return EndingType.UNDEFINED;
        }
        if (contents.contains("\r\n")) {
            return EndingType.DOS;
        }
        return EndingType.UNIX;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static enum EndingType {
        DOS("\r\n"),
        UNIX("\n"),
        UNDEFINED("");

        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String value;

        private EndingType(String lineEnding) {
            String string2 = lineEnding;
            EndingType endingType = this;
            endingType.setValue(string2);
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getValue() {
            return this.value;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setValue(String string) {
            this.value = string;
        }
    }
}

