/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Hashtable;
import javax.annotation.Nonnull;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import models.User;
import models.support.LdapUser;
import org.apache.commons.lang3.StringUtils;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class LdapService {
    public static final boolean useLdap = Play.application().configuration().getBoolean("application.use.ldap.login.supoort", Boolean.valueOf(false));
    private static final String HOST = Play.application().configuration().getString("ldap.host", "127.0.0.1");
    private static final String PORT = Play.application().configuration().getString("ldap.port", "389");
    private static final String BASE_DN = Play.application().configuration().getString("ldap.baseDN", "");
    private static final String DN_POSTFIX = Play.application().configuration().getString("ldap.distinguishedNamePostfix", "");
    private static final String PROTOCOL = Play.application().configuration().getString("protocol", "ldap");
    private static final String LOGIN_PROPERTY = Play.application().configuration().getString("ldap.loginProperty", "sAMAccountName");
    private static final String DISPLAY_NAME_PROPERTY = Play.application().configuration().getString("ldap.displayNameProperty", "displayName");
    private static final String USER_NAME_PROPERTY = Play.application().configuration().getString("ldap.userNameProperty", "CN");
    public static final boolean USE_EMAIL_BASE_LOGIN = Play.application().configuration().getBoolean("ldap.options.useEmailBaseLogin", Boolean.valueOf(false));
    public static final boolean FALLBACK_TO_LOCAL_LOGIN = Play.application().configuration().getBoolean("ldap.options.fallbackToLocalLogin", Boolean.valueOf(false));
    private static final String EMAIL_PROPERTY = Play.application().configuration().getString("ldap.emailProperty", "mail");
    private static final String ENGLISH_NAME_PROPERTY = Play.application().configuration().getString("ldap.options.englishNameAttributeName", "");
    private static final int TIMEOUT = 5000;

    public LdapUser authenticate(String username, String password) throws NamingException {
        String guessedUserIdentity = this.guessedUser(username);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("com.sun.jndi.ldap.connect.timeout", "5000");
        env.put("java.naming.provider.url", PROTOCOL + "://" + HOST + ":" + PORT);
        env.put("java.naming.security.authentication", "simple");
        Logger.info((String)("getProperUsernameGuessing: " + this.getProperUsernameGuessing(guessedUserIdentity)));
        env.put("java.naming.security.principal", this.getProperUsernameGuessing(guessedUserIdentity));
        env.put("java.naming.security.credentials", password);
        InitialDirContext authContext = new InitialDirContext(env);
        SearchResult searchResult = this.findUser(authContext, guessedUserIdentity, this.searchFilter(guessedUserIdentity));
        if (searchResult != null) {
            return this.getLdapUser(searchResult);
        }
        return null;
    }

    private String guessedUser(String username) {
        if (!USE_EMAIL_BASE_LOGIN) {
            return username;
        }
        String guessedUserIdentity = username;
        User user = User.findByLoginId(username);
        if (!user.isAnonymous()) {
            User user2 = user;
            String string = null;
            guessedUserIdentity = string = user2.getEmail();
        }
        return guessedUserIdentity;
    }

    private LdapUser getLdapUser(SearchResult searchResult) throws NamingException {
        Attributes attr = searchResult.getAttributes();
        LdapUser ldapUser = new LdapUser(attr.get(DISPLAY_NAME_PROPERTY), attr.get(EMAIL_PROPERTY), attr.get(LOGIN_PROPERTY), attr.get("department"));
        if (StringUtils.isNotBlank((CharSequence)ENGLISH_NAME_PROPERTY)) {
            ldapUser.setEnglishName(attr.get(ENGLISH_NAME_PROPERTY));
        }
        return ldapUser;
    }

    private String searchFilter(@Nonnull String username) {
        if (username.contains("@")) {
            return EMAIL_PROPERTY;
        }
        return LOGIN_PROPERTY;
    }

    private String getProperUsernameGuessing(@Nonnull String username) {
        if (username.contains("@")) {
            return username;
        }
        return USER_NAME_PROPERTY + "=" + username + "," + DN_POSTFIX;
    }

    private SearchResult findUser(DirContext ctx, String username, String filter) throws NamingException {
        String searchFilter = "(" + filter + "=" + username + ")";
        Logger.info((String)("filter: " + searchFilter));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(BASE_DN, searchFilter, searchControls);
        SearchResult searchResult = null;
        if (results.hasMoreElements()) {
            searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                System.err.println("Matched multiple users for the username: " + username);
                return null;
            }
        }
        return searchResult;
    }
}

