/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import play.api.http.MediaRange;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class HttpUtil {
    public static String getFirstValueFromQuery(Map<String, String[]> query, String key) {
        if (query == null) {
            return "";
        }
        String[] values = query.get(key);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return "";
    }

    public static String encodeContentDisposition(String filename) throws UnsupportedEncodingException {
        filename = filename.replaceAll("[:\\x5c\\/{?]", "_");
        filename = URLEncoder.encode(filename, "UTF-8").replaceAll("\\+", "%20");
        filename = "filename*=UTF-8''" + filename;
        return filename;
    }

    public static String getPreferType(Http.Request request, String ... types) {
        for (MediaRange range : request.acceptedTypes()) {
            for (String type : types) {
                if (!range.accepts(type)) continue;
                return type;
            }
        }
        return "text/html";
    }

    public static Boolean isJSONPreferred(Http.Request request) {
        String preferredType = HttpUtil.getPreferType(request, "text/html", "application/json");
        return preferredType != null ? preferredType.equals("application/json") : false;
    }

    public static String addQueryString(String url, String ... encodedPairs) throws URISyntaxException {
        URI aURI = new URI(url);
        String query = aURI.getQuery() != null ? aURI.getQuery() : "";
        query = query + (query.length() > 0 ? "&" : "") + StringUtils.join((Object[])encodedPairs, (String)"&");
        return new URI(aURI.getScheme(), aURI.getAuthority(), aURI.getPath(), query, aURI.getFragment()).toString();
    }

    public static String removeQueryString(String url, String ... keys) throws URISyntaxException, UnsupportedEncodingException {
        URI aURI = new URI(url);
        if (aURI.getQuery() == null) {
            return url;
        }
        ArrayList<String> pairStrings = new ArrayList<String>();
        HashSet<String> keySet = new HashSet<String>(Arrays.asList(keys));
        for (String pairString : aURI.getQuery().split("&")) {
            String[] pair = pairString.split("=");
            if (pair.length == 0 || keySet.contains(URLDecoder.decode(pair[0], "UTF-8"))) continue;
            pairStrings.add(pairString);
        }
        return new URI(aURI.getScheme(), aURI.getAuthority(), aURI.getPath(), StringUtils.join(pairStrings, (String)"&"), aURI.getFragment()).toString();
    }

    public static Boolean isRequestedWithXHR(Http.Request request) {
        String requestedWith = request.getHeader("X-Requested-With");
        return requestedWith != null && requestedWith.toLowerCase().equals("xmlhttprequest");
    }

    public static Boolean isPJAXRequest(Http.Request request) {
        return Boolean.parseBoolean(request.getHeader("X-PJAX"));
    }

    public static String decodePathSegment(String pathSegment) throws UnsupportedEncodingException {
        if (pathSegment != null) {
            String preTransformed = pathSegment.replaceAll("\\+", "*");
            String encoded = URLDecoder.decode(preTransformed, "UTF-8");
            return encoded.replaceAll("\\*", "+");
        }
        return null;
    }

    public static String decodeUrlString(String str) {
        String targetStr = str;
        try {
            targetStr = URLDecoder.decode(str, "UTF8");
            return targetStr;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        finally {
            return targetStr;
        }
    }

    public static String encodeUrlString(String str) {
        String targetStr = str;
        try {
            targetStr = URLEncoder.encode(str, "UTF8").replaceAll("\\+", "%20");
            return targetStr;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        finally {
            return targetStr;
        }
    }

    public static String getEncodeEachPathName(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        if (!path.contains("/")) {
            return HttpUtil.encodeUrlString(path);
        }
        String[] paths = path.split("/");
        CharSequence[] encodedPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            encodedPaths[i] = HttpUtil.encodeUrlString(paths[i]);
        }
        return String.join((CharSequence)"/", encodedPaths);
    }
}

