/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.UserApp;
import models.Organization;
import models.Project;
import models.User;
import play.core.enhancers.PropertiesEnhancer;
import play.twirl.api.Html;
import utils.MenuType;
import views.html.error.badrequest;
import views.html.error.badrequest_default;
import views.html.error.forbidden;
import views.html.error.forbidden_default;
import views.html.error.forbidden_organization;
import views.html.error.notfound;
import views.html.error.notfound_default;
import views.html.error.requestTextEntityTooLarge;
import views.html.index.index;
import views.html.user.login;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public enum ErrorViews {
    Forbidden{

        @Override
        public Html render(String messageKey) {
            return forbidden_default.render(messageKey);
        }

        @Override
        public Html render(String messageKey, Project project2) {
            return forbidden.render(messageKey, project2);
        }

        @Override
        public Html render(String messageKey, String returnUrl) {
            if (UserApp.currentUser() == User.anonymous) {
                return login.render("error.fobidden", null, returnUrl);
            }
            return forbidden_default.render(messageKey);
        }

        @Override
        public Html render(String messageKey, Organization organization2) {
            return forbidden_organization.render(messageKey, organization2);
        }

        @Override
        @Deprecated
        public Html render(String messageKey, Project project2, String type) {
            return null;
        }

        @Override
        public Html render(String messageKey, Project project2, MenuType menuType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Html render() {
            return this.render("error.forbidden");
        }
    }
    ,
    NotFound{

        @Override
        public Html render(String messageKey) {
            return notfound_default.render(messageKey);
        }

        @Override
        public Html render(String messageKey, Project project2) {
            return this.render(messageKey, project2, MenuType.PROJECT_HOME);
        }

        @Override
        public Html render(String messageKey, Organization organization2) {
            return notfound_default.render(messageKey);
        }

        @Override
        public Html render(String messageKey, Project project2, String type) {
            return notfound.render(messageKey, project2, type);
        }

        @Override
        public Html render(String messageKey, Project project2, MenuType menuType) {
            return notfound_default.render(messageKey);
        }

        @Override
        public Html render() {
            return this.render("error.notfound");
        }
    }
    ,
    RequestTextEntityTooLarge{

        @Override
        public Html render() {
            return requestTextEntityTooLarge.render();
        }

        @Override
        public Html render(String messageKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Html render(String messageKey, Project project2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Html render(String messageKey, Organization organization2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Html render(String messageKey, Project project2, String target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Html render(String messageKey, Project project2, MenuType menuType) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    BadRequest{

        @Override
        public Html render(String messageKey) {
            return badrequest_default.render(messageKey);
        }

        @Override
        public Html render(String messageKey, Project project2) {
            return badrequest.render(messageKey, project2, MenuType.PROJECT_HOME);
        }

        @Override
        public Html render(String messageKey, Organization organization2) {
            return badrequest_default.render(messageKey);
        }

        @Override
        @Deprecated
        public Html render(String messageKey, Project project2, String type) {
            return null;
        }

        @Override
        public Html render(String messageKey, Project project2, MenuType menuType) {
            return badrequest.render(messageKey, project2, menuType);
        }

        @Override
        public Html render() {
            return this.render("error.badrequest");
        }
    };


    public abstract Html render();

    public abstract Html render(String var1);

    public abstract Html render(String var1, Project var2);

    public abstract Html render(String var1, Organization var2);

    public abstract Html render(String var1, Project var2, String var3);

    public abstract Html render(String var1, Project var2, MenuType var3);

    public Html render(String messageKey, String returnUrl) {
        return index.render(UserApp.currentUser());
    }
}

