/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.commons.lang3.StringEscapeUtils;
import play.core.enhancers.PropertiesEnhancer;
import utils.diff_match_patch;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DiffUtil {
    public static final int EQUAL_TEXT_ELLIPSIS_SIZE = 100;
    public static final int EQUAL_TEXT_BASE_SIZE = 50;
    public static final int DIFF_EDITCOST = 8;

    public static String getDiffText(String oldValue, String newValue) {
        String oldVal = Optional.ofNullable(oldValue).orElse("");
        String newVal = Optional.ofNullable(newValue).orElse("");
        diff_match_patch dmp = new diff_match_patch();
        dmp.Diff_EditCost = (short)8;
        StringBuilder sb = new StringBuilder();
        LinkedList<diff_match_patch.Diff> diffs = dmp.diff_main(oldVal, newVal);
        dmp.diff_cleanupEfficiency(diffs);
        Iterator iterator = diffs.iterator();
        while (iterator.hasNext()) {
            diff_match_patch.Diff diff2;
            diff_match_patch.Diff diff3 = diff2 = (diff_match_patch.Diff)iterator.next();
            Object object = null;
            object = diff3.getOperation();
            switch (1.$SwitchMap$utils$diff_match_patch$Operation[((Enum)object).ordinal()]) {
                case 1: {
                    String deleteStyle = "<span style='background-color: #fda9a6;padding: 2px 0;'>";
                    sb.append(DiffUtil.addDiffStyle(diff2, deleteStyle));
                    break;
                }
                case 2: {
                    diff3 = diff2;
                    object = null;
                    object = diff3.getText();
                    int textLength = ((String)object).length();
                    if (textLength > 100) {
                        sb.append(DiffUtil.addHeadOfDiff(diff2));
                        sb.append(DiffUtil.addEllipsis());
                        sb.append(DiffUtil.addTailOfDiff(diff2));
                        break;
                    }
                    sb.append(DiffUtil.addAllDiff(diff2));
                    break;
                }
                case 3: {
                    String insertStyle = "<span style='background-color: #abdd52;padding: 2px 0;'>";
                    sb.append(DiffUtil.addDiffStyle(diff2, insertStyle));
                    break;
                }
            }
        }
        return sb.toString().replaceAll("\n", "&nbsp<br/>\n");
    }

    public static String getDiffPlainText(String oldValue, String newValue) {
        String oldVal = Optional.ofNullable(oldValue).orElse("");
        String newVal = Optional.ofNullable(newValue).orElse("");
        diff_match_patch dmp = new diff_match_patch();
        dmp.Diff_EditCost = (short)8;
        StringBuilder sb = new StringBuilder();
        LinkedList<diff_match_patch.Diff> diffs = dmp.diff_main(oldVal, newVal);
        dmp.diff_cleanupEfficiency(diffs);
        Iterator iterator = diffs.iterator();
        while (iterator.hasNext()) {
            diff_match_patch.Diff diff2;
            diff_match_patch.Diff diff3 = diff2 = (diff_match_patch.Diff)iterator.next();
            Object object = null;
            object = diff3.getOperation();
            switch (1.$SwitchMap$utils$diff_match_patch$Operation[((Enum)object).ordinal()]) {
                case 1: {
                    String deleteText = "--- ";
                    sb.append(DiffUtil.addDiffText(diff2, deleteText));
                    break;
                }
                case 2: {
                    diff3 = diff2;
                    object = null;
                    object = diff3.getText();
                    int textLength = ((String)object).length();
                    if (textLength > 100) {
                        sb.append(DiffUtil.addHeadOfDiff(diff2)).append(DiffUtil.addEllipsisText()).append(DiffUtil.addTailOfDiff(diff2));
                    } else {
                        sb.append(DiffUtil.addAllDiff(diff2));
                    }
                    sb.append("\n");
                    break;
                }
                case 3: {
                    String insertText = "+++ ";
                    sb.append(DiffUtil.addDiffText(diff2, insertText));
                    break;
                }
            }
        }
        return sb.toString();
    }

    private static String addHeadOfDiff(diff_match_patch.Diff diff2) {
        diff_match_patch.Diff diff3 = diff2;
        String string = null;
        string = diff3.getText();
        return StringEscapeUtils.escapeHtml4((String)string.substring(0, 50));
    }

    private static String addTailOfDiff(diff_match_patch.Diff diff2) {
        diff_match_patch.Diff diff3 = diff2;
        String string = null;
        String string2 = string = diff3.getText();
        diff3 = diff2;
        string = null;
        string = diff3.getText();
        return StringEscapeUtils.escapeHtml4((String)string2.substring(string.length() - 50));
    }

    private static String addAllDiff(diff_match_patch.Diff diff2) {
        diff_match_patch.Diff diff3 = diff2;
        String string = null;
        string = diff3.getText();
        return StringEscapeUtils.escapeHtml4((String)string);
    }

    private static String addEllipsis() {
        return "<span style='color: #bdbdbd;font-size: 16px;font-family: serif;'>...\n......\n......\n...</span>";
    }

    private static String addDiffStyle(diff_match_patch.Diff diff2, String style) {
        diff_match_patch.Diff diff3 = diff2;
        String string = null;
        string = diff3.getText();
        return style + StringEscapeUtils.escapeHtml4((String)string) + "</span>";
    }

    private static String addDiffText(diff_match_patch.Diff diff2, String text) {
        diff_match_patch.Diff diff3 = diff2;
        String string = null;
        string = diff3.getText();
        return text + StringEscapeUtils.escapeHtml4((String)string) + "\n";
    }

    private static String addEllipsisText() {
        return "......\n......\n...\n";
    }
}

