/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import models.SiteAdmin;
import org.apache.commons.lang3.ObjectUtils;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.mvc.Http;
import utils.Diagnostic;
import utils.SimpleDiagnostic;
import yona.BuildInfo;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Config {
    public static final String DEFAULT_SCHEME = "http";
    private static final String YONA_DATA = "yona.data";
    public static boolean isConnectableToGravatarServer = true;

    public static void onStart() {
        Diagnostic.register(new SimpleDiagnostic(){

            @Override
            public String checkOne() {
                Configuration config = Configuration.root();
                if (config.getInt("application.port") != null && config.getString("application.hostname") == null) {
                    return "application.port may be ignored because application.hostname is not configured.";
                }
                return null;
            }
        });
        isConnectableToGravatarServer = Config.isConnectableToGravatar();
    }

    public static String getSiteName() {
        return (String)ObjectUtils.defaultIfNull((Object)Configuration.root().getString("application.siteName"), (Object)"Yona");
    }

    public static String getContextRoot() {
        return Configuration.root().getString("application.context", "/");
    }

    public static String getHostport(String defaultValue) {
        String hostname = Configuration.root().getString("application.hostname");
        if (hostname != null && !hostname.isEmpty()) {
            Integer port = Configuration.root().getInt("application.port");
            if (port != null && !port.equals(80)) {
                return hostname + ":" + port.toString();
            }
            return hostname;
        }
        return defaultValue;
    }

    private static InetAddress getDefaultAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
        while (n.hasMoreElements()) {
            Enumeration<InetAddress> a = n.nextElement().getInetAddresses();
            while (a.hasMoreElements()) {
                InetAddress address = a.nextElement();
                if (address.isAnyLocalAddress() || !(address instanceof Inet4Address)) continue;
                return address;
            }
        }
        return InetAddress.getLocalHost();
    }

    public static String getHostname() {
        Configuration config = Configuration.root();
        String hostname = Configuration.root().getString("application.hostname");
        if (hostname != null && !hostname.isEmpty()) {
            return hostname;
        }
        try {
            return Config.getDefaultAddress().getHostName();
        }
        catch (Exception e) {
            Logger.warn((String)"Failed to get the hostname", (Throwable)e);
            return "localhost";
        }
    }

    public static String getHostport() {
        Http.Context context = (Http.Context)Http.Context.current.get();
        if (context != null) {
            return Config.getHostport(context.request().host());
        }
        try {
            return Config.getDefaultAddress().getHostAddress();
        }
        catch (Exception e) {
            Logger.warn((String)"Failed to get the host address", (Throwable)e);
            return "localhost";
        }
    }

    public static String getScheme(String defaultValue) {
        Configuration config = Configuration.root();
        String scheme = config.getString("application.scheme");
        if (scheme == null || scheme.isEmpty()) {
            return defaultValue;
        }
        return scheme;
    }

    public static String getScheme() {
        Http.Context context = (Http.Context)Http.Context.current.get();
        if (context != null) {
            try {
                return Config.getScheme(Config.getSchemeFromRequestURI(context.request()));
            }
            catch (URISyntaxException e) {
                Logger.warn((String)"Failed to get the scheme part from the request-uri", (Throwable)e);
                return Config.getScheme(DEFAULT_SCHEME);
            }
        }
        return Config.getScheme(DEFAULT_SCHEME);
    }

    private static String getSchemeFromRequestURI(Http.Request request) throws URISyntaxException {
        String scheme = new URI(request.uri()).getScheme();
        if (scheme == null) {
            return DEFAULT_SCHEME;
        }
        return scheme;
    }

    public static String getSystemEmailAddress() {
        String email = Config.getEmailFromSmtp();
        if (email != null) {
            return email;
        }
        Model model = new SiteAdmin();
        Object object = null;
        object = model.getAdmin();
        Object admin = object;
        if (admin != null) {
            model = admin;
            object = null;
            object = model.getEmail();
            if (object != null) {
                model = admin;
                object = null;
                object = model.getEmail();
                return object;
            }
        }
        return "yona@yona.io";
    }

    public static String getEmailFromSmtp() {
        return Config.getEmail("smtp");
    }

    public static URI createFullURI(URI uri) throws URISyntaxException {
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        scheme = scheme != null ? scheme : Config.getScheme();
        authority = authority != null ? authority : Config.getHostport();
        return new URI(scheme, authority, uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public static URI createFullURI(String uri) throws URISyntaxException {
        return Config.createFullURI(new URI(uri));
    }

    public static String semverize(String ver) {
        ver = ver.replaceFirst("^v", "");
        ver = ver.replaceAll("\\.([^\\d]+)", "-$1");
        ver = ver.replaceFirst("^(\\d+\\.\\d+)($|-)", "$1.0$2");
        return ver;
    }

    public static String getCurrentVersion() {
        return BuildInfo.version();
    }

    public static String getEmailFromImap() {
        return Configuration.root().getString("imap.address", Config.getEmail("imap"));
    }

    private static String getEmail(String prefix) {
        Configuration config = Configuration.root();
        String user = config.getString(prefix + ".user");
        if (user == null) {
            return null;
        }
        if (user.contains("@")) {
            return user;
        }
        return user + "@" + config.getString(prefix + ".domain", Config.getHostname());
    }

    public static Charset getCharset() {
        return Charset.forName("UTF-8");
    }

    public static String getYonaDataDir() {
        return System.getProperty(YONA_DATA);
    }

    public static String getYonaDataDir(String defaultValue) {
        return System.getProperty(YONA_DATA, defaultValue);
    }

    public static boolean displayPrivateRepositories() {
        return Configuration.root().getBoolean("application.displayPrivateRepositories", Boolean.FALSE);
    }

    private static boolean isConnectableToGravatar() {
        try {
            return InetAddress.getByName("ko.gravatar.com").isReachable(100) && InetAddress.getByName("www.gravatar.com").isReachable(100);
        }
        catch (IOException e) {
            Logger.warn((String)"Gravatar server is unreachable. Gravatar service will not work.");
            return false;
        }
    }
}

