/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import models.Project;
import models.User;
import play.core.enhancers.PropertiesEnhancer;
import utils.HttpUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CacheStore {
    public static Map<String, Long> projectMap = new ConcurrentHashMap<String, Long>();
    public static final int MAXIMUM_CACHED_MARKDOWN_ENTRY = 10000;
    public static final int MAXIMUM_CACHED_YONA_USER_ENTRY = 2000;
    public static Cache<Integer, byte[]> renderedMarkdown = CacheBuilder.newBuilder().maximumSize(10000L).build();
    public static Cache<Long, User> yonaUsers = CacheBuilder.newBuilder().maximumSize(2000L).build();

    public static String getProjectCacheKey(String owner, String projectName) {
        return HttpUtil.decodeUrlString(owner) + ":" + HttpUtil.decodeUrlString(projectName);
    }

    public static void refreshProjectMap() {
        for (Map.Entry<String, Long> entry : projectMap.entrySet()) {
            String[] keys = entry.getKey().split(":");
            Project project2 = (Project)Project.find.where().ieq("owner", keys[0]).ieq("name", keys[1]).findUnique();
            if (project2 != null) continue;
            projectMap.remove(entry.getKey());
        }
    }
}

