/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.UserApp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import models.User;
import org.apache.commons.lang3.StringEscapeUtils;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Http;
import play.mvc.Result;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AccessLogger {
    private static String orHyphen(String value) {
        if (value == null || value.isEmpty()) {
            return "-";
        }
        return value;
    }

    private static String quotedOrHyphen(String value) {
        if (value == null) {
            return "-";
        }
        return "\"" + StringEscapeUtils.escapeJava((String)value) + "\"";
    }

    public static void log(final Http.Request request, F.Promise<Result> promise, final Long startTimeMillis) {
        User user = UserApp.currentUser();
        String string = null;
        final String username = string = user.getLoginId();
        promise.onRedeem((F.Callback)new F.Callback<Result>(){

            public void invoke(Result result2) throws Throwable {
                AccessLogger.log((Http.RequestHeader)request, username, result2.toScala().header().status(), startTimeMillis);
            }
        });
    }

    public static void log(Http.RequestHeader request, String username, int status) {
        AccessLogger.log(request, username, status, null);
    }

    private static void log(Http.RequestHeader request, String username, int status, Long startTimeMillis) {
        if (request == null) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.ENGLISH);
        String time = startTimeMillis != null ? System.currentTimeMillis() - startTimeMillis + "ms" : "-";
        String uri = request.uri();
        String entry = String.format("%s - %s [%s] \"%s %s %s\" %d - %s %s %s", request.remoteAddress(), AccessLogger.orHyphen(username), format.format(new Date()), request.method(), request.uri(), request.version(), status, AccessLogger.quotedOrHyphen(request.getHeader("Referer")), AccessLogger.quotedOrHyphen(request.getHeader("User-Agent")), time);
        Logger.of((String)("access." + uri)).info(entry);
    }
}

