/*
 * Decompiled with CFR 0.152.
 */
package playRepository.hooks;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import models.Project;
import models.PullRequest;
import models.PushedBranch;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.hooks.ReceiveCommandUtil;
import utils.JodaDateUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class UpdateRecentlyPushedBranch
implements PostReceiveHook {
    private Project project;

    public UpdateRecentlyPushedBranch(Project project2) {
        this.project = project2;
    }

    public void onPostReceive(ReceivePack receivePack, Collection<ReceiveCommand> commands) {
        this.removeOldPushedBranches();
        this.saveRecentlyPushedBranch(ReceiveCommandUtil.getPushedBranches(commands));
        this.deletePushedBranch(ReceiveCommandUtil.getDeletedBranches(commands));
    }

    private void removeOldPushedBranches() {
        List<PushedBranch> list2 = this.project.getOldPushedBranches();
        for (PushedBranch pushedBranch : list2) {
            pushedBranch.delete();
        }
    }

    private void saveRecentlyPushedBranch(Set<String> pushedBranches) {
        for (String branch : pushedBranches) {
            PushedBranch pushedBranch = (PushedBranch)((Object)PushedBranch.find.where().eq("project", (Object)this.project).eq("name", (Object)branch).findUnique());
            if (pushedBranch != null) {
                Date date = JodaDateUtil.now();
                PushedBranch pushedBranch2 = pushedBranch;
                pushedBranch2.setPushedDate(date);
                pushedBranch.update();
            }
            if (!this.isNotExistsPushedBranch(branch, pushedBranch) || !this.isNotTag(branch)) continue;
            pushedBranch = new PushedBranch(JodaDateUtil.now(), branch, this.project);
            pushedBranch.save();
        }
    }

    private boolean isNotTag(String branch) {
        return !branch.contains("refs/tags/");
    }

    private boolean isNotExistsPushedBranch(String branch, PushedBranch pushedBranch) {
        return pushedBranch == null && PullRequest.findByFromProjectAndBranch(this.project, branch).isEmpty();
    }

    private void deletePushedBranch(Set<String> deletedBranches) {
        for (String branch : deletedBranches) {
            PushedBranch pushedBranch = (PushedBranch)((Object)PushedBranch.find.where().eq("project", (Object)this.project).eq("name", (Object)branch).findUnique());
            if (pushedBranch == null) continue;
            pushedBranch.delete();
        }
    }
}

