/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.UserApp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import models.Project;
import models.User;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PostReceiveHookChain;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHookChain;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.UploadPack;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;
import playRepository.GitRepository;
import playRepository.PlayRepository;
import playRepository.SVNRepository;
import playRepository.hooks.IssueReferredFromCommitEvent;
import playRepository.hooks.NotifyPushedCommits;
import playRepository.hooks.PullRequestCheck;
import playRepository.hooks.RejectPushToReservedRefs;
import playRepository.hooks.UpdateLastPushedDate;
import playRepository.hooks.UpdateRecentlyPushedBranch;
import utils.PlayServletContext;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class RepositoryService {
    public static final String VCS_SUBVERSION = "Subversion";
    public static final String VCS_GIT = "GIT";

    public static Map<String, String> vcsTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(VCS_GIT, "project.new.vcsType.git");
        map.put(VCS_SUBVERSION, "project.new.vcsType.subversion");
        return map;
    }

    public static void deleteRepository(Project project2) throws Exception {
        RepositoryService.getRepository(project2).delete();
    }

    public static void createRepository(Project project2) throws Exception {
        RepositoryService.deleteRepository(project2);
        RepositoryService.getRepository(project2).create();
    }

    public static List<ObjectNode> getMetaDataFromAncestorDirectories(PlayRepository repository, String branch, String path) throws SVNException, GitAPIException, IOException {
        ArrayList<ObjectNode> recursiveData = new ArrayList<ObjectNode>();
        String partialPath = "";
        String[] pathArray = path.split("/");
        int pathLength = path.equals("") ? 0 : pathArray.length;
        ObjectNode metaData = repository.getMetaDataFromPath(branch, "");
        if (metaData == null) {
            return null;
        }
        metaData.put("path", "");
        recursiveData.add(metaData);
        for (int i = 0; i < pathLength; ++i) {
            String string = partialPath = partialPath.equals("") ? pathArray[i] : partialPath + "/" + pathArray[i];
            if (repository.isIntermediateFolder(partialPath)) continue;
            metaData = repository.getMetaDataFromPath(branch, partialPath);
            if (metaData == null) {
                return null;
            }
            metaData.put("path", partialPath);
            recursiveData.add(metaData);
        }
        return recursiveData;
    }

    public static byte[] getFileAsRaw(String userName, String projectName, String revision, String path) throws UnsupportedOperationException, IOException, ServletException, SVNException {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        return RepositoryService.getRepository(project2, true).getRawFile(revision, path);
    }

    public static PlayRepository getRepository(Project project2, boolean alternatesMergeRepo) throws IOException, ServletException, UnsupportedOperationException {
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        String string = null;
        string = project3.getVcs();
        switch (string) {
            case "GIT": {
                project3 = project2;
                string = null;
                String string2 = string = project3.getOwner();
                project3 = project2;
                string = null;
                string = project3.getName();
                return new GitRepository(string2, string, alternatesMergeRepo);
            }
            case "Subversion": {
                project3 = project2;
                string = null;
                String string3 = string = project3.getOwner();
                project3 = project2;
                string = null;
                string = project3.getName();
                return new SVNRepository(string3, string);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static PlayRepository getRepository(Project project2) throws IOException, ServletException, UnsupportedOperationException {
        return RepositoryService.getRepository(project2, true);
    }

    public static PlayRepository getRepository(String userName, String projectName) throws IOException, ServletException, UnsupportedOperationException {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        return RepositoryService.getRepository(project2);
    }

    public static DAVServlet createDavServlet(final String userName) throws ServletException {
        DAVServlet servlet = new DAVServlet();
        servlet.init(new ServletConfig(){
            private ServletContext servletContext = new PlayServletContext();

            public String getInitParameter(String name) {
                if (name.equals("SVNParentPath")) {
                    return new File(SVNRepository.getRootDirectory(), userName + "/").getAbsolutePath();
                }
                return Configuration.root().getString("application." + name);
            }

            public Enumeration<String> getInitParameterNames() {
                throw new UnsupportedOperationException();
            }

            public ServletContext getServletContext() {
                return this.servletContext;
            }

            public String getServletName() {
                throw new UnsupportedOperationException();
            }
        });
        return servlet;
    }

    public static byte[] gitAdvertise(Project project2, String service2, Http.Response response) throws IOException {
        response.setContentType("application/x-" + service2 + "-advertisement");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PacketLineOut packetLineOut = new PacketLineOut((OutputStream)byteArrayOutputStream);
        packetLineOut.writeString("# service=" + service2 + "\n");
        packetLineOut.end();
        RefAdvertiser.PacketLineOutRefAdvertiser packetLineOutRefAdvertiser = new RefAdvertiser.PacketLineOutRefAdvertiser(packetLineOut);
        if (service2.equals("git-upload-pack")) {
            Repository repository = GitRepository.buildGitRepository(project2);
            UploadPack uploadPack = new UploadPack(repository);
            uploadPack.setBiDirectionalPipe(false);
            uploadPack.sendAdvertisedRefs((RefAdvertiser)packetLineOutRefAdvertiser);
        } else if (service2.equals("git-receive-pack")) {
            Repository repository = GitRepository.buildGitRepository(project2, false);
            ReceivePack receivePack = new ReceivePack(repository);
            receivePack.sendAdvertisedRefs((RefAdvertiser)packetLineOutRefAdvertiser);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static PipedInputStream gitRpc(Project project2, String service2, Http.Request request, Http.Response response) {
        response.setContentType("application/x-" + service2 + "-result");
        Http.RawBuffer raw = request.body().asRaw();
        byte[] buf = raw.asBytes();
        InputStream requestStream = null;
        try {
            requestStream = buf != null ? new ByteArrayInputStream(buf) : new FileInputStream(raw.asFile());
            PipedInputStream responseStream = new PipedInputStream();
            switch (service2) {
                case "git-upload-pack": {
                    Repository repository = GitRepository.buildGitRepository(project2);
                    RepositoryService.uploadPack(requestStream, repository, new PipedOutputStream(responseStream));
                    break;
                }
                case "git-receive-pack": {
                    Repository repository = GitRepository.buildGitRepository(project2, false);
                    PreReceiveHook preReceiveHook = RepositoryService.createPreReceiveHook();
                    PostReceiveHook postReceiveHook = RepositoryService.createPostReceiveHook(UserApp.currentUser(), project2, request);
                    RepositoryService.receivePack(requestStream, repository, new PipedOutputStream(responseStream), preReceiveHook, postReceiveHook);
                    break;
                }
                default: {
                    requestStream.close();
                }
            }
            return responseStream;
        }
        catch (IOException e) {
            if (requestStream != null) {
                try {
                    requestStream.close();
                }
                catch (IOException e1) {
                    Logger.error((String)"failed to close request stream", (Throwable)e1);
                }
            }
            throw new RuntimeException(e);
        }
    }

    private static PreReceiveHook createPreReceiveHook() {
        ArrayList<RejectPushToReservedRefs> hooks = new ArrayList<RejectPushToReservedRefs>();
        hooks.add(new RejectPushToReservedRefs());
        return PreReceiveHookChain.newChain(hooks);
    }

    private static PostReceiveHook createPostReceiveHook(User currentUser, Project project2, Http.Request request) {
        ArrayList<Object> hooks = new ArrayList<Object>();
        hooks.add(new UpdateLastPushedDate(project2));
        hooks.add(new UpdateRecentlyPushedBranch(project2));
        hooks.add(new IssueReferredFromCommitEvent(project2, currentUser));
        hooks.add(new PullRequestCheck(currentUser, request, project2));
        hooks.add(new NotifyPushedCommits(project2, currentUser));
        return PostReceiveHookChain.newChain(hooks);
    }

    private static void receivePack(final InputStream input, Repository repository, final OutputStream output, final PreReceiveHook preReceiveHook, final PostReceiveHook postReceiveHook) {
        final ReceivePack receivePack = new ReceivePack(repository);
        receivePack.setBiDirectionalPipe(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    receivePack.setPreReceiveHook(preReceiveHook);
                    receivePack.setPostReceiveHook(postReceiveHook);
                    receivePack.receive(input, output, null);
                }
                catch (IOException e) {
                    Logger.error((String)"receivePack failed", (Throwable)e);
                }
                RepositoryService.closeStreams("receivePack", input, output);
            }
        }.start();
    }

    private static void uploadPack(final InputStream input, Repository repository, final OutputStream output) {
        final UploadPack uploadPack = new UploadPack(repository);
        uploadPack.setBiDirectionalPipe(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    uploadPack.upload(input, output, null);
                }
                catch (IOException e) {
                    Logger.error((String)"uploadPack failed", (Throwable)e);
                }
                RepositoryService.closeStreams("uploadPack", input, output);
            }
        }.start();
    }

    private static void closeStreams(String serviceName, InputStream input, OutputStream output) {
        try {
            input.close();
        }
        catch (IOException e) {
            Logger.error((String)(serviceName + ": Failed to close input stream"), (Throwable)e);
        }
        try {
            output.close();
        }
        catch (IOException e) {
            Logger.error((String)(serviceName + ": Failed to close output stream"), (Throwable)e);
        }
    }
}

