/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.List;
import models.resource.Resource;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.tmatesoft.svn.core.SVNException;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Results;
import playRepository.Commit;
import playRepository.FileDiff;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public interface PlayRepository {
    public static final long MAX_FILE_SIZE_CAN_BE_VIEWED = Configuration.root().getInt("application.codeBrowser.viewer.maxFileSize", Integer.valueOf(0x100000)).intValue();

    public void create() throws IOException, SVNException;

    public boolean isIntermediateFolder(String var1);

    public ObjectNode getMetaDataFromPath(String var1) throws IOException, GitAPIException, SVNException;

    public byte[] getRawFile(String var1, String var2) throws IOException, SVNException;

    public void delete() throws Exception;

    public String getPatch(String var1) throws IOException, SVNException;

    public String getPatch(String var1, String var2) throws IOException, SVNException;

    public List<FileDiff> getDiff(String var1) throws IOException;

    public List<FileDiff> getDiff(String var1, String var2) throws IOException;

    public List<Commit> getHistory(int var1, int var2, String var3, String var4) throws IOException, GitAPIException, SVNException;

    public Commit getCommit(String var1) throws IOException, SVNException;

    public List<String> getRefNames();

    public ObjectNode getMetaDataFromPath(String var1, String var2) throws IOException, SVNException, GitAPIException;

    public Resource asResource();

    public boolean isFile(String var1) throws SVNException, IOException;

    public boolean isFile(String var1, String var2) throws SVNException, IOException;

    public boolean renameTo(String var1);

    public String getDefaultBranch() throws IOException;

    public void setDefaultBranch(String var1) throws IOException;

    public Commit getParentCommitOf(String var1);

    public boolean isEmpty();

    public boolean move(String var1, String var2, String var3, String var4);

    public File getDirectory();

    public void getArchive(Results.Chunks.Out<byte[]> var1, String var2);
}

