/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.UserApp;
import controllers.routes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.naming.LimitExceededException;
import models.Project;
import models.PullRequest;
import models.User;
import models.enumeration.ResourceType;
import models.resource.Resource;
import models.support.ModelLock;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.archive.ZipFormat;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.tmatesoft.svn.core.SVNException;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;
import play.mvc.Results;
import playRepository.Commit;
import playRepository.FileDiff;
import playRepository.GitBranch;
import playRepository.GitCommit;
import playRepository.PlayRepository;
import utils.ChunkedOutputStream;
import utils.Config;
import utils.FileUtil;
import utils.GravatarUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GitRepository
implements PlayRepository {
    private static final ModelLock<Project> PROJECT_LOCK = new ModelLock();
    public static final int DIFF_SIZE_LIMIT = 0x177000;
    public static final int DIFF_LINE_LIMIT = 15000;
    public static final int DIFF_FILE_LIMIT = 2000;
    public static final int COMMIT_HISTORY_LIMIT = 1000000;
    public static final int BLAME_FILE_LIMIT = 10;
    private static String repoPrefix = "repo/git/";
    private static String repoForMergingPrefix = "repo/git-merging/";
    private final Repository repository;
    private final String ownerName;
    private final String projectName;

    public static String getRepoPrefix() {
        return repoPrefix;
    }

    public static void setRepoPrefix(String repoPrefix) {
        GitRepository.repoPrefix = repoPrefix;
    }

    public static String getRepoForMergingPrefix() {
        return repoForMergingPrefix;
    }

    public GitRepository(String ownerName, String projectName, boolean alternatesMergeRepo) {
        this.ownerName = ownerName;
        this.projectName = projectName;
        this.repository = GitRepository.buildGitRepository(ownerName, projectName, alternatesMergeRepo);
    }

    public GitRepository(String ownerName, String projectName) {
        this(ownerName, projectName, true);
    }

    public GitRepository(Project project2) throws IOException {
        Project project3 = project2;
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        this(string2, string, true);
    }

    public static Repository buildGitRepository(String ownerName, String projectName, boolean alternatesMergeRepo) {
        try {
            RepositoryBuilder repo = (RepositoryBuilder)new RepositoryBuilder().setGitDir(GitRepository.getGitDirectory(ownerName, projectName));
            if (alternatesMergeRepo) {
                repo.addAlternateObjectDirectory(GitRepository.getDirectoryForMergingObjects(ownerName, projectName));
            }
            return repo.build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Repository buildGitRepository(String ownerName, String projectName) {
        return GitRepository.buildGitRepository(ownerName, projectName, true);
    }

    public static Repository buildGitRepository(Project project2) {
        return GitRepository.buildGitRepository(project2, true);
    }

    public static Repository buildGitRepository(Project project2, boolean alternatesMergeRepo) {
        Project project3 = project2;
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        return GitRepository.buildGitRepository(string2, string, alternatesMergeRepo);
    }

    public static void cloneLocalRepository(Project originalProject, Project forkProject) throws Exception {
        try {
            GitRepository.cloneHardLinkedRepository(originalProject, forkProject);
        }
        catch (Exception e) {
            new GitRepository(forkProject).delete();
            Logger.warn((String)"Failed to clone a repository using hardlink. Fall back to straight copy", (Throwable)e);
            GitRepository.cloneRepository(GitRepository.getGitDirectoryURL(originalProject), forkProject);
        }
    }

    @Override
    public void create() throws IOException {
        this.repository.create(true);
    }

    @Override
    public ObjectNode getMetaDataFromPath(String path) throws IOException, GitAPIException, SVNException {
        return this.getMetaDataFromPath(null, path);
    }

    public String extendPath(String basePath, String path) {
        try {
            ObjectId objectId = this.repository.resolve("HEAD");
            RevWalk revWalk = new RevWalk(this.repository);
            RevTree revTree = revWalk.parseTree((AnyObjectId)objectId);
            while (true) {
                String fullPath;
                TreeWalk treeWalk;
                if ((treeWalk = TreeWalk.forPath((Repository)this.repository, (String)(fullPath = StringUtils.isEmpty((CharSequence)basePath) ? path : basePath + "/" + path), (RevTree)revTree)) == null || !treeWalk.isSubtree()) {
                    return path;
                }
                treeWalk.enterSubtree();
                treeWalk.next();
                if (!treeWalk.isSubtree()) {
                    return path;
                }
                String next = path + "/" + treeWalk.getNameString();
                if (treeWalk.next()) {
                    return path;
                }
                path = next;
            }
        }
        catch (IOException e) {
            return path;
        }
    }

    @Override
    public boolean isIntermediateFolder(String path) {
        try {
            ObjectId objectId = this.repository.resolve("HEAD");
            RevWalk revWalk = new RevWalk(this.repository);
            RevTree revTree = revWalk.parseTree((AnyObjectId)objectId);
            if (StringUtils.isEmpty((CharSequence)path)) {
                return false;
            }
            TreeWalk treeWalk = TreeWalk.forPath((Repository)this.repository, (String)path, (RevTree)revTree);
            if (treeWalk == null || !treeWalk.isSubtree()) {
                return false;
            }
            treeWalk.enterSubtree();
            treeWalk.next();
            if (!treeWalk.isSubtree()) {
                return false;
            }
            return !treeWalk.next();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isFile(String path, String revStr) throws IOException {
        ObjectId objectId = this.getObjectId(revStr);
        if (objectId == null) {
            return false;
        }
        RevWalk revWalk = new RevWalk(this.repository);
        RevTree revTree = revWalk.parseTree((AnyObjectId)objectId);
        TreeWalk treeWalk = new TreeWalk(this.repository);
        treeWalk.addTree((AnyObjectId)revTree);
        treeWalk.setRecursive(true);
        treeWalk.setFilter((TreeFilter)PathFilter.create((String)path));
        return treeWalk.next();
    }

    @Override
    public ObjectNode getMetaDataFromPath(String branch, String path) throws IOException, GitAPIException {
        RevCommit headCommit = this.getRevCommit(branch);
        if (headCommit == null) {
            Logger.debug((String)"GitRepository : init Project - No Head commit");
            return null;
        }
        RevWalk revWalk = new RevWalk(this.repository);
        RevTree revTree = revWalk.parseTree((AnyObjectId)headCommit);
        TreeWalk treeWalk = new TreeWalk(this.repository);
        treeWalk.addTree((AnyObjectId)revTree);
        if (path.isEmpty()) {
            return this.treeAsJson(path, treeWalk, (AnyObjectId)headCommit);
        }
        PathFilter pathFilter = PathFilter.create((String)path);
        treeWalk.setFilter((TreeFilter)pathFilter);
        while (treeWalk.next() && !pathFilter.isDone(treeWalk)) {
            if (!treeWalk.isSubtree()) continue;
            treeWalk.enterSubtree();
        }
        if (treeWalk.isSubtree()) {
            treeWalk.enterSubtree();
            return this.treeAsJson(path, treeWalk, (AnyObjectId)headCommit);
        }
        try {
            return this.fileAsJson(treeWalk, (AnyObjectId)headCommit);
        }
        catch (MissingObjectException e) {
            Logger.debug((String)("Unavailable access. " + branch + "/" + path + " does not exist."));
            return null;
        }
    }

    private ObjectNode fileAsJson(TreeWalk treeWalk, AnyObjectId untilCommitId) throws IOException, GitAPIException {
        Git git = new Git(this.repository);
        GitCommit commit = new GitCommit((RevCommit)git.log().add(untilCommitId).addPath(treeWalk.getPathString()).call().iterator().next());
        ObjectNode result2 = Json.newObject();
        long commitTime = commit.getCommitTime() * 1000L;
        User author = commit.getAuthor();
        result2.put("type", "file");
        result2.put("msg", commit.getShortMessage());
        result2.put("author", commit.getAuthorName());
        result2.put("avatar", this.getAvatar(author));
        User user = author;
        String string = null;
        string = user.getName();
        result2.put("userName", string);
        user = author;
        string = null;
        string = user.getLoginId();
        result2.put("userLoginId", string);
        result2.put("createdDate", commitTime);
        result2.put("commitMessage", commit.getShortMessage());
        result2.put("commiter", commit.getCommitterName());
        result2.put("commitDate", commitTime);
        result2.put("commitId", untilCommitId.getName());
        ObjectLoader file = this.repository.open((AnyObjectId)treeWalk.getObjectId(0));
        result2.put("size", file.getSize());
        boolean isBinary = RawText.isBinary((InputStream)file.openStream());
        result2.put("isBinary", isBinary);
        if (!isBinary && file.getSize() <= MAX_FILE_SIZE_CAN_BE_VIEWED) {
            byte[] bytes = file.getBytes();
            String str = new String(bytes, FileUtil.detectCharset(bytes));
            result2.put("data", str);
        }
        Metadata meta = new Metadata();
        meta.add("resourceName", treeWalk.getNameString());
        result2.put("mimeType", new Tika().detect((InputStream)file.openStream(), meta));
        return result2;
    }

    private String getAvatar(User user) {
        if (user.isAnonymous() || user.avatarUrl().equals(UserApp.DEFAULT_AVATAR_URL)) {
            User user2 = user;
            String string = null;
            string = user2.getEmail();
            return GravatarUtil.getAvatar(string, 34);
        }
        return user.avatarUrl();
    }

    private ObjectNode treeAsJson(String basePath, TreeWalk treeWalk, AnyObjectId untilCommitId) throws IOException, GitAPIException {
        ObjectNode result2 = Json.newObject();
        ObjectNode listData = Json.newObject();
        listData.putAll(new ObjectFinder(basePath, treeWalk, untilCommitId).find());
        result2.put("type", "folder");
        result2.put("data", (JsonNode)listData);
        return listData.size() == 0 ? null : result2;
    }

    @Override
    public byte[] getRawFile(String revision, String path) throws IOException {
        RevTree tree = new RevWalk(this.repository).parseTree((AnyObjectId)this.repository.resolve(revision));
        TreeWalk treeWalk = TreeWalk.forPath((Repository)this.repository, (String)path, (RevTree)tree);
        if (treeWalk == null || treeWalk.isSubtree()) {
            throw new FileNotFoundException();
        }
        return this.repository.open((AnyObjectId)treeWalk.getObjectId(0)).getBytes();
    }

    @Override
    public void delete() throws Exception {
        this.repository.close();
        WindowCacheConfig config = new WindowCacheConfig();
        config.install();
        FileUtil.rm_rf(this.repository.getDirectory());
    }

    @Override
    public String getPatch(String rev) throws IOException {
        RevCommit commit = this.getRevCommit(rev);
        if (commit == null) {
            return null;
        }
        RevCommit parent = null;
        if (commit.getParentCount() > 0) {
            parent = this.parseCommit((AnyObjectId)commit.getParent(0));
        }
        return this.getPatch(parent, commit);
    }

    @Override
    public String getPatch(String revA, String revB) throws IOException {
        RevCommit commitA = this.getRevCommit(revA);
        RevCommit commitB = this.getRevCommit(revB);
        if (commitA == null || commitB == null) {
            return null;
        }
        return this.getPatch(commitA, commitB);
    }

    private String getPatch(RevCommit commitA, RevCommit commitB) throws IOException {
        TreeWalk treeWalk = new TreeWalk(this.repository);
        this.addTree(treeWalk, commitA);
        this.addTree(treeWalk, commitB);
        treeWalk.setRecursive(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DiffFormatter diffFormatter = new DiffFormatter((OutputStream)out);
        diffFormatter.setRepository(this.repository);
        diffFormatter.format(DiffEntry.scan((TreeWalk)treeWalk));
        return out.toString("UTF-8");
    }

    private void addTree(TreeWalk treeWalk, RevCommit commit) throws IOException {
        if (commit == null) {
            treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
        } else {
            treeWalk.addTree((AnyObjectId)commit.getTree());
        }
    }

    @Override
    public List<FileDiff> getDiff(String rev) throws IOException {
        return GitRepository.getDiff(this.repository, rev);
    }

    public static List<FileDiff> getDiff(Repository repository, String rev) throws IOException {
        return GitRepository.getDiff(repository, repository.resolve(rev));
    }

    public List<FileDiff> getDiff(ObjectId commitId) throws IOException {
        return GitRepository.getDiff(this.repository, commitId);
    }

    public static List<FileDiff> getDiff(Repository repository, ObjectId commitId) throws IOException {
        if (commitId == null) {
            return null;
        }
        RevWalk revWalk = new RevWalk(repository);
        RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
        ObjectId commitIdA = null;
        if (commit.getParentCount() > 0) {
            commitIdA = commit.getParent(0).getId();
        }
        return GitRepository.getFileDiffs(repository, repository, commitIdA, commitId);
    }

    public List<FileDiff> getDiff(RevCommit commit) throws IOException {
        ObjectId commitIdA = null;
        if (commit.getParentCount() > 0) {
            commitIdA = commit.getParent(0).getId();
        }
        return GitRepository.getFileDiffs(this.repository, this.repository, commitIdA, commit.getId());
    }

    public static List<FileDiff> getDiff(Repository repository, RevCommit commit) throws IOException {
        ObjectId commitIdA = null;
        if (commit.getParentCount() > 0) {
            commitIdA = commit.getParent(0).getId();
        }
        return GitRepository.getFileDiffs(repository, repository, commitIdA, commit.getId());
    }

    @Override
    public List<Commit> getHistory(int pageNumber, int pageSize, String untilRevName, String path) throws IOException, GitAPIException {
        RevCommit start;
        LogCommand logCommand = new Git(this.repository).log();
        if (path != null) {
            logCommand.addPath(path);
        }
        if ((start = this.getRevCommit(untilRevName)) == null) {
            return null;
        }
        logCommand.add((AnyObjectId)start);
        Iterable iter = logCommand.setMaxCount(pageNumber * pageSize + pageSize).call();
        LinkedList<RevCommit> list2 = new LinkedList<RevCommit>();
        for (RevCommit commit : iter) {
            if (list2.size() >= pageSize) {
                list2.remove(0);
            }
            list2.add(commit);
        }
        ArrayList<Commit> result2 = new ArrayList<Commit>();
        for (RevCommit commit : list2) {
            result2.add(new GitCommit(commit));
        }
        return result2;
    }

    @Override
    public Commit getCommit(String rev) throws IOException {
        ObjectId commitId = this.repository.resolve(rev);
        if (commitId == null) {
            return null;
        }
        return new GitCommit(new RevWalk(this.repository).parseCommit((AnyObjectId)commitId));
    }

    private static boolean isWellKnownRef(String refName) {
        return refName.startsWith("refs/heads/") || refName.startsWith("refs/tags/") || refName.startsWith("refs/remotes/");
    }

    @Override
    public List<String> getRefNames() {
        ArrayList<String> branches2 = new ArrayList<String>();
        for (String refName : this.repository.getAllRefs().keySet()) {
            if (!GitRepository.isWellKnownRef(refName)) continue;
            branches2.add(refName);
        }
        return branches2;
    }

    public List<GitBranch> getBranches() throws IOException, GitAPIException {
        ArrayList<GitBranch> branches2 = new ArrayList<GitBranch>();
        for (Ref ref2 : this.repository.getAllRefs().values()) {
            if (!GitRepository.isWellKnownRef(ref2.getName())) continue;
            GitCommit commit = new GitCommit(new RevWalk(this.getRepository()).parseCommit((AnyObjectId)ref2.getObjectId()));
            GitBranch newBranch = new GitBranch(ref2.getName(), commit);
            this.setTheLatestPullRequest(newBranch);
            branches2.add(newBranch);
        }
        Collections.sort(branches2, new Comparator<GitBranch>(){

            @Override
            public int compare(GitBranch b1, GitBranch b2) {
                return b2.getHeadCommit().getCommitterDate().compareTo(b1.getHeadCommit().getCommitterDate());
            }
        });
        return branches2;
    }

    private void setTheLatestPullRequest(GitBranch gitBranch) {
        Project project2 = Project.findByOwnerAndProjectName(this.ownerName, this.projectName);
        gitBranch.setPullRequest(PullRequest.findTheLatestOneFrom(project2, gitBranch.getName()));
    }

    @Override
    public Resource asResource() {
        return new Resource(){

            @Override
            public String getId() {
                return null;
            }

            @Override
            public Project getProject() {
                return Project.findByOwnerAndProjectName(GitRepository.this.ownerName, GitRepository.this.projectName);
            }

            @Override
            public ResourceType getType() {
                return ResourceType.CODE;
            }
        };
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return this.isFile(path, "HEAD");
    }

    public static File getGitDirectory(Project project2) {
        Project project3 = project2;
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        return GitRepository.getGitDirectory(string2, string);
    }

    public static String getGitDirectoryURL(Project project2) throws IOException {
        return GitRepository.getGitDirectory(project2).getCanonicalPath();
    }

    public static File getGitDirectory(String ownerName, String projectName) {
        return new File(GitRepository.getRootDirectory(), ownerName + "/" + projectName + ".git");
    }

    private static File getRootDirectory() {
        return new File(Config.getYonaDataDir(), GitRepository.getRepoPrefix());
    }

    private static File getRootDirectoryForMerging() {
        return new File(Config.getYonaDataDir(), GitRepository.getRepoForMergingPrefix());
    }

    public static void cloneRepository(String gitUrl, Project forkingProject) throws GitAPIException {
        Git.cloneRepository().setURI(gitUrl).setDirectory(GitRepository.getGitDirectory(forkingProject)).setCloneAllBranches(true).setBare(true).call();
    }

    public static void cloneRepository(String gitUrl, Project forkingProject, String authId, String authPw) throws GitAPIException {
        ((CloneCommand)Git.cloneRepository().setURI(gitUrl).setDirectory(GitRepository.getGitDirectory(forkingProject)).setCloneAllBranches(true).setBare(true).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(authId, authPw))).call();
    }

    public static void checkout(Repository repository, String branchName) throws GitAPIException {
        new Git(repository).checkout().setName(branchName).setCreateBranch(false).call();
    }

    public static File getDirectoryForMerging(String owner, String projectName) {
        return new File(GitRepository.getRootDirectoryForMerging(), owner + "/" + projectName + ".git");
    }

    public static File getDirectoryForMergingObjects(String owner, String projectName) {
        return new File(GitRepository.getDirectoryForMerging(owner, projectName), ".git/objects");
    }

    public static List<RevCommit> diffRevCommits(Repository repository, ObjectId from, ObjectId to) throws IOException, GitAPIException {
        return IteratorUtils.toList(new Git(repository).log().addRange((AnyObjectId)from, (AnyObjectId)to).call().iterator());
    }

    public static List<GitCommit> diffCommits(Repository repository, ObjectId from, ObjectId to) throws IOException, GitAPIException {
        return GitRepository.wrapInGitCommits(GitRepository.diffRevCommits(repository, from, to));
    }

    public static List<GitCommit> wrapInGitCommits(List<RevCommit> revCommits) throws IOException, GitAPIException {
        ArrayList<GitCommit> commits = new ArrayList<GitCommit>();
        for (RevCommit revCommit : revCommits) {
            commits.add(new GitCommit(revCommit));
        }
        return commits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<User> getRelatedAuthors(Repository repository, String revA, String revB) throws IOException, GitAPIException, LimitExceededException {
        HashSet<User> authors = new HashSet<User>();
        RevWalk revWalk = null;
        try {
            revWalk = new RevWalk(repository);
            RevCommit commitA = revWalk.parseCommit((AnyObjectId)repository.resolve(revA));
            RevCommit commitB = revWalk.parseCommit((AnyObjectId)repository.resolve(revB));
            List<DiffEntry> diffs = GitRepository.getDiffEntries(repository, commitA, commitB);
            if (diffs.size() > 10) {
                String msg = String.format("Reject to get related authors from changes because of performance issue: The changes include %d files and it exceeds our limit of '%d' files.", diffs.size(), 10);
                throw new LimitExceededException(msg);
            }
            for (DiffEntry diff2 : diffs) {
                if (GitRepository.isTypeMatching(diff2.getChangeType(), DiffEntry.ChangeType.MODIFY, DiffEntry.ChangeType.DELETE)) {
                    authors.addAll(GitRepository.getAuthorsFromDiffEntry(repository, diff2, commitA));
                }
                if (!GitRepository.isTypeMatching(diff2.getChangeType(), DiffEntry.ChangeType.RENAME)) continue;
                authors.add(GitRepository.getAuthorFromFirstCommit(repository, diff2.getOldPath(), commitA));
            }
        }
        finally {
            if (revWalk != null) {
                revWalk.dispose();
            }
        }
        authors.remove(User.anonymous);
        return authors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DiffEntry> getDiffEntries(Repository repository, RevCommit commitA, RevCommit commitB) throws IOException {
        try (DiffFormatter diffFormatter = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);){
            diffFormatter.setRepository(repository);
            diffFormatter.setDetectRenames(true);
            List list2 = diffFormatter.scan((AnyObjectId)commitA, (AnyObjectId)commitB);
            return list2;
        }
    }

    private static boolean isTypeMatching(Object type, Object ... types) {
        return ArrayUtils.contains((Object[])types, (Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<User> getAuthorsFromDiffEntry(Repository repository, DiffEntry diff2, RevCommit start) throws GitAPIException, IOException {
        try (DiffFormatter diffFormatter = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);){
            diffFormatter.setRepository(repository);
            EditList edits = diffFormatter.toFileHeader(diff2).toEditList();
            BlameResult blameResult = new Git(repository).blame().setFilePath(diff2.getOldPath()).setFollowFileRenames(true).setStartCommit((AnyObjectId)start).call();
            Set<User> set = GitRepository.getAuthorsFromBlameResult(edits, blameResult);
            return set;
        }
    }

    private static Set<User> getAuthorsFromBlameResult(EditList edits, BlameResult blameResult) {
        HashSet<User> authors = new HashSet<User>();
        for (Edit edit2 : edits) {
            if (!GitRepository.isTypeMatching(edit2.getType(), Edit.Type.REPLACE, Edit.Type.DELETE)) continue;
            for (int i = edit2.getBeginA(); i < edit2.getEndA(); ++i) {
                authors.add(GitRepository.findAuthorByPersonIdent(blameResult.getSourceAuthor(i)));
            }
        }
        return authors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static User getAuthorFromFirstCommit(Repository repository, String path, RevCommit start) throws IOException {
        RevWalk revWalk = null;
        try {
            revWalk = new RevWalk(repository);
            revWalk.markStart(start);
            revWalk.setTreeFilter((TreeFilter)PathFilter.create((String)path));
            revWalk.sort(RevSort.REVERSE);
            RevCommit commit = revWalk.next();
            if (commit == null) {
                User user = User.anonymous;
                return user;
            }
            User user = GitRepository.findAuthorByPersonIdent(commit.getAuthorIdent());
            return user;
        }
        finally {
            if (revWalk != null) {
                revWalk.dispose();
            }
        }
    }

    private static User findAuthorByPersonIdent(PersonIdent personIdent) {
        if (personIdent == null) {
            return User.anonymous;
        }
        return User.findByEmail(personIdent.getEmailAddress());
    }

    public static void deleteBranch(Repository repository, String branchName) throws GitAPIException {
        new Git(repository).branchDelete().setBranchNames(new String[]{branchName}).setForce(true).call();
    }

    public static Repository buildMergingRepository(PullRequest pullRequest2) {
        PullRequest pullRequest3 = pullRequest2;
        Project project2 = null;
        project2 = pullRequest3.getToProject();
        return GitRepository.buildMergingRepository(project2);
    }

    public static Repository buildMergingRepository(Project project2) {
        Project project3 = project2;
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        File workingDirectory = GitRepository.getDirectoryForMerging(string2, string);
        try {
            File gitDir = new File(workingDirectory + "/.git");
            if (!gitDir.exists()) {
                return GitRepository.cloneRepository(project2, workingDirectory).getRepository();
            }
            return ((RepositoryBuilder)new RepositoryBuilder().setGitDir(gitDir)).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Git cloneRepository(Project project2, File workingDirectory) throws GitAPIException, IOException {
        return Git.cloneRepository().setURI(GitRepository.getGitDirectoryURL(project2)).setDirectory(workingDirectory).call();
    }

    public static boolean canDeleteFromBranch(PullRequest pullRequest2) {
        try (Repository fromRepo = null;){
            PullRequest pullRequest3 = pullRequest2;
            Object object = null;
            object = pullRequest3.getFromProject();
            fromRepo = GitRepository.buildGitRepository((Project)object);
            String currentBranch = fromRepo.getFullBranch();
            List refs = new Git(fromRepo).branchList().call();
            for (Ref branchRef : refs) {
                String branchName = branchRef.getName();
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getFromBranch();
                if (!branchName.equals(object) || branchName.equals(currentBranch)) continue;
                RevWalk revWalk = new RevWalk(fromRepo);
                RevCommit commit = revWalk.parseCommit((AnyObjectId)fromRepo.resolve(branchName));
                String commitName = commit.name();
                revWalk.close();
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getToProject();
                Repository toRepo = GitRepository.buildGitRepository((Project)object);
                ObjectId toBranch = toRepo.resolve(commitName);
                if (toBranch == null) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static String deleteFromBranch(PullRequest pullRequest2) {
        if (!GitRepository.canDeleteFromBranch(pullRequest2)) {
            return null;
        }
        RevWalk revWalk = null;
        Repository repo = null;
        try {
            PullRequest pullRequest3 = pullRequest2;
            Object object = null;
            object = pullRequest3.getFromProject();
            repo = GitRepository.buildGitRepository((Project)object);
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getFromBranch();
            ObjectId branch = repo.resolve((String)object);
            revWalk = new RevWalk(repo);
            RevCommit commit = revWalk.parseCommit((AnyObjectId)branch);
            String lastCommitId = commit.getName();
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getFromBranch();
            GitRepository.deleteBranch(repo, (String)object);
            String string = lastCommitId;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (revWalk != null) {
                revWalk.close();
            }
            if (repo != null) {
                repo.close();
            }
        }
    }

    public static void restoreBranch(PullRequest pullRequest2) {
        if (!GitRepository.canRestoreBranch(pullRequest2)) {
            return;
        }
        try (Repository repo = null;){
            PullRequest pullRequest3 = pullRequest2;
            Object object = null;
            object = pullRequest3.getFromProject();
            repo = GitRepository.buildGitRepository((Project)object);
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getFromBranch();
            CreateBranchCommand createBranchCommand = new Git(repo).branchCreate().setName(((String)object).replaceAll("refs/heads/", ""));
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getLastCommitId();
            createBranchCommand.setStartPoint((String)object).call();
        }
    }

    public static boolean canRestoreBranch(PullRequest pullRequest2) {
        try (Repository repo = null;){
            PullRequest pullRequest3 = pullRequest2;
            Object object = null;
            object = pullRequest3.getFromProject();
            repo = GitRepository.buildGitRepository((Project)object);
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getFromBranch();
            ObjectId resolve = repo.resolve((String)object);
            if (resolve == null) {
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getLastCommitId();
                if (object != null) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public static List<GitCommit> diffCommits(PullRequest pullRequest2) {
        Object object;
        PullRequest pullRequest3;
        ArrayList<GitCommit> commits;
        block11: {
            block10: {
                commits = new ArrayList<GitCommit>();
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getMergedCommitIdFrom();
                if (object == null) break block10;
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getMergedCommitIdTo();
                if (object != null) break block11;
            }
            return commits;
        }
        try {
            Repository repo;
            if (pullRequest2.isClosed()) {
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getToProject();
                repo = GitRepository.buildGitRepository((Project)object);
            } else {
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getFromProject();
                repo = GitRepository.buildGitRepository((Project)object);
            }
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getMergedCommitIdTo();
            ObjectId untilId = repo.resolve((String)object);
            if (untilId == null) {
                return commits;
            }
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getMergedCommitIdFrom();
            ObjectId sinceId = repo.resolve((String)object);
            if (sinceId == null) {
                return commits;
            }
            Iterable logIterator = new Git(repo).log().addRange((AnyObjectId)sinceId, (AnyObjectId)untilId).call();
            for (RevCommit commit : logIterator) {
                commits.add(new GitCommit(commit));
            }
            return commits;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPatch(Repository repository, String fromBranch, String toBranch) {
        TreeWalk treeWalk = new TreeWalk(repository);
        RevWalk walk = new RevWalk(repository);
        try {
            ObjectId from = repository.resolve(fromBranch);
            ObjectId to = repository.resolve(toBranch);
            RevTree fromTree = walk.parseTree((AnyObjectId)from);
            RevTree toTree = walk.parseTree((AnyObjectId)to);
            treeWalk.addTree((AnyObjectId)toTree);
            treeWalk.addTree((AnyObjectId)fromTree);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DiffFormatter diffFormatter = new DiffFormatter((OutputStream)out);
            diffFormatter.setRepository(repository);
            treeWalk.setRecursive(true);
            diffFormatter.format(DiffEntry.scan((TreeWalk)treeWalk));
            String string = out.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            walk.dispose();
        }
    }

    public static String getPatch(PullRequest pullRequest2) {
        Object object;
        PullRequest pullRequest3;
        block8: {
            block7: {
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getMergedCommitIdFrom();
                if (object == null) break block7;
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getMergedCommitIdTo();
                if (object != null) break block8;
            }
            return "";
        }
        try {
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getToProject();
            Repository repo = GitRepository.buildGitRepository((Project)object);
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getMergedCommitIdTo();
            ObjectId untilId = repo.resolve((String)object);
            if (untilId == null) {
                return "";
            }
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getMergedCommitIdFrom();
            ObjectId sinceId = repo.resolve((String)object);
            if (sinceId == null) {
                return "";
            }
            return GitRepository.getPatch(repo, untilId.getName(), sinceId.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<FileDiff> getDiff(Repository repository, String revA, String revB) throws IOException {
        return GitRepository.getDiff(repository, revA, repository, revB);
    }

    @Override
    public List<FileDiff> getDiff(String revA, String revB) throws IOException {
        return GitRepository.getDiff(this.repository, revA, revB);
    }

    public static List<FileDiff> getDiff(Repository repositoryA, String revA, Repository repositoryB, String revB) throws IOException {
        ObjectId commitA = repositoryA.resolve(revA);
        ObjectId commitB = repositoryB.resolve(revB);
        return GitRepository.getFileDiffs(repositoryA, repositoryB, commitA, commitB);
    }

    private static List<FileDiff> getFileDiffs(final Repository repositoryA, Repository repositoryB, ObjectId commitA, ObjectId commitB) throws IOException {
        EmptyTreeIterator treeParserB;
        EmptyTreeIterator treeParserA;
        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        class MultipleRepositoryObjectReader
        extends ObjectReader {
            Collection<ObjectReader> readers = new HashSet<ObjectReader>();

            public ObjectReader newReader() {
                return new MultipleRepositoryObjectReader(this.readers);
            }

            public MultipleRepositoryObjectReader(Collection<ObjectReader> readers) {
                this.readers = readers;
            }

            public MultipleRepositoryObjectReader() {
                this.readers = new HashSet<ObjectReader>();
            }

            public void addObjectReader(ObjectReader reader) {
                this.readers.add(reader);
            }

            public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
                HashSet<ObjectId> result2 = new HashSet<ObjectId>();
                for (ObjectReader reader : this.readers) {
                    result2.addAll(reader.resolve(id));
                }
                return result2;
            }

            public ObjectLoader open(AnyObjectId objectId, int typeHint) throws IOException {
                for (ObjectReader reader : this.readers) {
                    if (!reader.has(objectId, typeHint)) continue;
                    return reader.open(objectId, typeHint);
                }
                return null;
            }

            public Set<ObjectId> getShallowCommits() throws IOException {
                HashSet<ObjectId> union = new HashSet<ObjectId>();
                for (ObjectReader reader : this.readers) {
                    union.addAll(reader.getShallowCommits());
                }
                return union;
            }

            public void close() {
                Logger.warn((String)"MultipleRepositoryObjectReader#close - Not implemented method but called!");
            }
        }
        final MultipleRepositoryObjectReader reader = new MultipleRepositoryObjectReader();
        reader.addObjectReader(repositoryA.newObjectReader());
        reader.addObjectReader(repositoryB.newObjectReader());
        Repository fakeRepo = new Repository(new BaseRepositoryBuilder()){
            {
                super(x0);
            }

            public void create(boolean bare) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ObjectDatabase getObjectDatabase() {
                throw new UnsupportedOperationException();
            }

            public RefDatabase getRefDatabase() {
                throw new UnsupportedOperationException();
            }

            public StoredConfig getConfig() {
                return repositoryA.getConfig();
            }

            public AttributesNodeProvider createAttributesNodeProvider() {
                return new EmptyAttributesNodeProvider();
            }

            public void scanForRepoChanges() throws IOException {
                throw new UnsupportedOperationException();
            }

            public void notifyIndexChanged() {
                throw new UnsupportedOperationException();
            }

            public ReflogReader getReflogReader(String refName) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ObjectReader newObjectReader() {
                return reader;
            }

            @PropertiesEnhancer.GeneratedAccessor
            @PropertiesEnhancer.RewrittenAccessor
            class EmptyAttributesNodeProvider
            implements AttributesNodeProvider {
                private EmptyAttributesNode emptyAttributesNode = new EmptyAttributesNode();

                EmptyAttributesNodeProvider() {
                }

                public AttributesNode getInfoAttributesNode() throws IOException {
                    return this.emptyAttributesNode;
                }

                public AttributesNode getGlobalAttributesNode() throws IOException {
                    return this.emptyAttributesNode;
                }

                @PropertiesEnhancer.GeneratedAccessor
                @PropertiesEnhancer.RewrittenAccessor
                class EmptyAttributesNode
                extends AttributesNode {
                    public EmptyAttributesNode() {
                        super(Collections.emptyList());
                    }

                    public void parse(InputStream in) throws IOException {
                    }
                }
            }
        };
        DiffFormatter formatter = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
        formatter.setRepository(fakeRepo);
        formatter.setDetectRenames(true);
        RevTree treeA = null;
        RevTree treeB = null;
        if (commitA != null) {
            treeA = new RevWalk(repositoryA).parseTree((AnyObjectId)commitA);
            treeParserA = new CanonicalTreeParser();
            ((CanonicalTreeParser)treeParserA).reset((ObjectReader)reader, (AnyObjectId)treeA);
        } else {
            treeParserA = new EmptyTreeIterator();
        }
        if (commitB != null) {
            treeB = new RevWalk(repositoryB).parseTree((AnyObjectId)commitB);
            treeParserB = new CanonicalTreeParser();
            ((CanonicalTreeParser)treeParserB).reset((ObjectReader)reader, (AnyObjectId)treeB);
        } else {
            treeParserB = new EmptyTreeIterator();
        }
        ArrayList<FileDiff> result2 = new ArrayList<FileDiff>();
        int size = 0;
        int lines = 0;
        for (DiffEntry diff2 : formatter.scan((AbstractTreeIterator)treeParserA, (AbstractTreeIterator)treeParserB)) {
            FileDiff fileDiff = new FileDiff();
            String string = commitA != null ? commitA.getName() : null;
            Object object = fileDiff;
            ((FileDiff)object).setCommitA(string);
            string = commitB != null ? commitB.getName() : null;
            object = fileDiff;
            ((FileDiff)object).setCommitB(string);
            string = diff2.getChangeType();
            object = fileDiff;
            ((FileDiff)object).setChangeType((DiffEntry.ChangeType)string);
            string = diff2.getOldMode();
            object = fileDiff;
            ((FileDiff)object).setOldMode((FileMode)string);
            string = diff2.getNewMode();
            object = fileDiff;
            ((FileDiff)object).setNewMode((FileMode)string);
            String pathA = diff2.getPath(DiffEntry.Side.OLD);
            String pathB = diff2.getPath(DiffEntry.Side.NEW);
            byte[] rawA = null;
            if (treeA != null && Arrays.asList(DiffEntry.ChangeType.DELETE, DiffEntry.ChangeType.MODIFY, DiffEntry.ChangeType.RENAME, DiffEntry.ChangeType.COPY).contains(diff2.getChangeType())) {
                TreeWalk t1 = TreeWalk.forPath((Repository)repositoryA, (String)pathA, (RevTree)treeA);
                ObjectId blobA = t1.getObjectId(0);
                string = pathA;
                object = fileDiff;
                ((FileDiff)object).setPathA(string);
                try {
                    rawA = repositoryA.open((AnyObjectId)blobA).getBytes();
                    boolean bl = RawText.isBinary((byte[])rawA);
                    object = fileDiff;
                    ((FileDiff)object).setIsBinaryA(bl);
                    object = fileDiff;
                    bl = false;
                    bl = ((FileDiff)object).getIsBinaryA();
                    if (bl) {
                        string = null;
                        object = fileDiff;
                        ((FileDiff)object).setA((RawText)string);
                    } else {
                        String str = new String(rawA, FileUtil.detectCharset(rawA));
                        string = new RawText(str.getBytes());
                        object = fileDiff;
                        ((FileDiff)object).setA((RawText)string);
                    }
                }
                catch (LargeObjectException e) {
                    fileDiff.addError(FileDiff.Error.A_SIZE_EXCEEDED);
                }
            }
            byte[] rawB = null;
            if (treeB != null && Arrays.asList(DiffEntry.ChangeType.ADD, DiffEntry.ChangeType.MODIFY, DiffEntry.ChangeType.RENAME, DiffEntry.ChangeType.COPY).contains(diff2.getChangeType())) {
                TreeWalk t2 = TreeWalk.forPath((Repository)repositoryB, (String)pathB, (RevTree)treeB);
                ObjectId blobB = t2.getObjectId(0);
                string = pathB;
                object = fileDiff;
                ((FileDiff)object).setPathB(string);
                try {
                    rawB = repositoryB.open((AnyObjectId)blobB).getBytes();
                    boolean bl = RawText.isBinary((byte[])rawB);
                    object = fileDiff;
                    ((FileDiff)object).setIsBinaryB(bl);
                    object = fileDiff;
                    bl = false;
                    bl = ((FileDiff)object).getIsBinaryB();
                    if (bl) {
                        string = null;
                        object = fileDiff;
                        ((FileDiff)object).setB((RawText)string);
                    } else {
                        String str = new String(rawB, FileUtil.detectCharset(rawB));
                        string = new RawText(str.getBytes());
                        object = fileDiff;
                        ((FileDiff)object).setB((RawText)string);
                    }
                }
                catch (LargeObjectException e) {
                    fileDiff.addError(FileDiff.Error.B_SIZE_EXCEEDED);
                }
            }
            if (size > 0x177000 || lines > 15000) {
                fileDiff.addError(FileDiff.Error.OTHERS_SIZE_EXCEEDED);
                result2.add(fileDiff);
                continue;
            }
            object = fileDiff;
            string = null;
            string = ((FileDiff)object).getA();
            if (string != null) {
                object = fileDiff;
                string = null;
                string = ((FileDiff)object).getB();
                if (string != null) {
                    object = fileDiff;
                    boolean bl = false;
                    bl = ((FileDiff)object).getIsBinaryA();
                    if (!bl) {
                        object = fileDiff;
                        bl = false;
                        bl = ((FileDiff)object).getIsBinaryB();
                        if (!bl && Arrays.asList(DiffEntry.ChangeType.MODIFY, DiffEntry.ChangeType.RENAME).contains(diff2.getChangeType())) {
                            DiffAlgorithm diffAlgorithm = DiffAlgorithm.getAlgorithm((DiffAlgorithm.SupportedAlgorithm)((DiffAlgorithm.SupportedAlgorithm)repositoryB.getConfig().getEnum("diff", null, "algorithm", (Enum)DiffAlgorithm.SupportedAlgorithm.HISTOGRAM)));
                            object = fileDiff;
                            RawText rawText = null;
                            RawText rawText2 = rawText = ((FileDiff)object).getA();
                            object = fileDiff;
                            rawText = null;
                            rawText = ((FileDiff)object).getB();
                            rawText = diffAlgorithm.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)rawText2, (Sequence)rawText);
                            object = fileDiff;
                            ((FileDiff)object).setEditList((EditList)rawText);
                            object = fileDiff.getHunks();
                            int n = 0;
                            n = ((FileDiff.Hunks)object).getSize();
                            size += n;
                            object = fileDiff.getHunks();
                            n = 0;
                            n = ((FileDiff.Hunks)object).getLines();
                            lines += n;
                        }
                    }
                }
            }
            object = fileDiff;
            RawText rawText = null;
            rawText = ((FileDiff)object).getB();
            if (rawText != null) {
                object = fileDiff;
                boolean bl = false;
                bl = ((FileDiff)object).getIsBinaryB();
                if (!bl && diff2.getChangeType().equals((Object)DiffEntry.ChangeType.ADD)) {
                    object = fileDiff;
                    RawText rawText3 = null;
                    rawText3 = ((FileDiff)object).getB();
                    lines += rawText3.size();
                    size += rawB.length;
                }
            }
            object = fileDiff;
            RawText rawText4 = null;
            rawText4 = ((FileDiff)object).getA();
            if (rawText4 != null) {
                object = fileDiff;
                boolean bl = false;
                bl = ((FileDiff)object).getIsBinaryA();
                if (!bl && diff2.getChangeType().equals((Object)DiffEntry.ChangeType.DELETE)) {
                    object = fileDiff;
                    RawText rawText5 = null;
                    rawText5 = ((FileDiff)object).getA();
                    lines += rawText5.size();
                    size += rawA.length;
                }
            }
            if (result2.size() > 2000) break;
            result2.add(fileDiff);
        }
        return result2;
    }

    protected static void cloneHardLinkedRepository(Project originalProject, Project forkProject) throws IOException {
        Repository origin = GitRepository.buildGitRepository(originalProject);
        Repository forked = GitRepository.buildGitRepository(forkProject);
        forked.create();
        final Path originObjectsPath = Paths.get(new File(origin.getDirectory(), "objects").getAbsolutePath(), new String[0]);
        final Path forkedObjectsPath = Paths.get(new File(forked.getDirectory(), "objects").getAbsolutePath(), new String[0]);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
                Path newPath = forkedObjectsPath.resolve(originObjectsPath.relativize(file.toAbsolutePath()));
                if (file.equals(forkedObjectsPath.resolve("/info/alternates"))) {
                    Files.copy(file, newPath, new CopyOption[0]);
                } else {
                    FileUtils.mkdirs((File)newPath.getParent().toFile(), (boolean)true);
                    Files.createLink(newPath, file);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(originObjectsPath, (FileVisitor<? super Path>)visitor);
        for (Map.Entry entry : origin.getAllRefs().entrySet()) {
            RefUpdate updateRef = forked.updateRef((String)entry.getKey());
            Ref ref2 = (Ref)entry.getValue();
            if (ref2.isSymbolic()) {
                updateRef.link(ref2.getTarget().getName());
                continue;
            }
            updateRef.setNewObjectId((AnyObjectId)ref2.getObjectId());
            updateRef.update();
        }
    }

    public GitBranch getHeadBranch() {
        try {
            String headBranchName = this.getDefaultBranch();
            ObjectId branchObjectId = this.repository.resolve(headBranchName);
            RevWalk walk = new RevWalk(this.repository);
            RevCommit head = walk.parseCommit((AnyObjectId)branchObjectId);
            walk.dispose();
            return new GitBranch(headBranchName, new GitCommit(head));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.repository.close();
    }

    @Override
    public boolean renameTo(String projectName) {
        return this.move(this.ownerName, this.projectName, this.ownerName, projectName);
    }

    @Override
    public String getDefaultBranch() throws IOException {
        return this.repository.findRef("HEAD").getTarget().getName();
    }

    @Override
    public void setDefaultBranch(String target) throws IOException {
        RefUpdate.Result result2 = this.repository.updateRef("HEAD").link(target);
        switch (result2) {
            case NEW: 
            case FORCED: 
            case NO_CHANGE: {
                break;
            }
            default: {
                throw new IOException("Failed to update symbolic ref, got: " + result2);
            }
        }
    }

    @Override
    public Commit getParentCommitOf(String commitIdString) {
        try {
            ObjectId commitId = this.repository.resolve(commitIdString);
            RevWalk revWalk = new RevWalk(this.repository);
            RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
            if (commit.getParentCount() > 0) {
                ObjectId parentId = commit.getParent(0).getId();
                return new GitCommit(revWalk.parseCommit((AnyObjectId)parentId));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.getRefNames().isEmpty();
    }

    private ObjectId getObjectId(String revstr) throws IOException {
        if (revstr == null) {
            return this.repository.resolve("HEAD");
        }
        return this.repository.resolve(revstr);
    }

    private RevCommit getRevCommit(String revstr) throws IOException {
        ObjectId objectId = this.getObjectId(revstr);
        return this.parseCommit((AnyObjectId)objectId);
    }

    private RevCommit parseCommit(AnyObjectId objectId) throws IOException {
        if (objectId == null) {
            return null;
        }
        RevWalk revWalk = new RevWalk(this.repository);
        return revWalk.parseCommit(objectId);
    }

    @Override
    public boolean move(String srcProjectOwner, String srcProjectName, String desrProjectOwner, String destProjectName) {
        this.repository.close();
        WindowCacheConfig config = new WindowCacheConfig();
        config.install();
        File srcGitDirectory = GitRepository.getGitDirectory(srcProjectOwner, srcProjectName);
        File destGitDirectory = GitRepository.getGitDirectory(desrProjectOwner, destProjectName);
        File srcGitDirectoryForMerging = GitRepository.getDirectoryForMerging(srcProjectOwner, srcProjectName);
        File destGitDirectoryForMerging = GitRepository.getDirectoryForMerging(desrProjectOwner, destProjectName);
        srcGitDirectory.setWritable(true);
        srcGitDirectoryForMerging.setWritable(true);
        try {
            if (srcGitDirectory.exists()) {
                org.apache.commons.io.FileUtils.moveDirectory((File)srcGitDirectory, (File)destGitDirectory);
                Logger.debug((String)("[Transfer] Move from: " + srcGitDirectory.getAbsolutePath() + "to " + destGitDirectory));
            } else {
                Logger.warn((String)("[Transfer] Nothing to move from: " + srcGitDirectory.getAbsolutePath()));
            }
            if (srcGitDirectoryForMerging.exists()) {
                org.apache.commons.io.FileUtils.moveDirectory((File)srcGitDirectoryForMerging, (File)destGitDirectoryForMerging);
                Logger.debug((String)("[Transfer] Move from: " + srcGitDirectoryForMerging.getAbsolutePath() + "to " + destGitDirectoryForMerging));
            } else {
                Logger.warn((String)("[Transfer] Nothing to move from: " + srcGitDirectoryForMerging.getAbsolutePath()));
            }
            return true;
        }
        catch (IOException e) {
            Logger.error((String)"[Transfer] Move Failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public File getDirectory() {
        return this.repository.getDirectory();
    }

    public Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getArchive(Results.Chunks.Out<byte[]> out, String branchName) {
        Git git = new Git(this.getRepository());
        ArchiveCommand.registerFormat((String)"zip", (ArchiveCommand.Format)new ZipFormat());
        try {
            ChunkedOutputStream cos = new ChunkedOutputStream(out, 16384);
            git.archive().setTree(this.getRepository().resolve(branchName)).setFormat("zip").setOutputStream((OutputStream)cos).call();
        }
        catch (GitAPIException | AmbiguousObjectException | IncorrectObjectTypeException e) {
            Logger.error((String)e.getMessage());
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage());
        }
        finally {
            ArchiveCommand.unregisterFormat((String)"zip");
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static interface AfterCloneAndFetchOperation {
        public void invoke(CloneAndFetch var1) throws IOException, GitAPIException;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class CloneAndFetch {
        private Repository repository;
        private String destToBranchName;
        private String destFromBranchName;
        private String mergingBranchName;

        public Repository getRepository() {
            return this.repository;
        }

        public String getDestToBranchName() {
            return this.destToBranchName;
        }

        public String getDestFromBranchName() {
            return this.destFromBranchName;
        }

        public String getMergingBranchName() {
            return this.mergingBranchName;
        }

        private CloneAndFetch(Repository repository, String destToBranchName, String destFromBranchName, String mergingBranchName) {
            this.repository = repository;
            this.destToBranchName = destToBranchName;
            this.destFromBranchName = destFromBranchName;
            this.mergingBranchName = "refs/heads/" + mergingBranchName;
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static interface TreeWalkHandler {
        public void handle(TreeWalk var1);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public class ObjectFinder {
        private SortedMap<String, JsonNode> found = new TreeMap<String, JsonNode>();
        private Map<String, JsonNode> targets = new HashMap<String, JsonNode>();
        private String basePath;
        private Iterator<RevCommit> commitIterator;
        private AnyObjectId untilCommitId;

        public ObjectFinder(String basePath, TreeWalk treeWalk, AnyObjectId untilCommitId) throws IOException, GitAPIException {
            while (treeWalk.next()) {
                String path = treeWalk.getNameString();
                ObjectNode object = Json.newObject();
                object.put("type", treeWalk.isSubtree() ? "folder" : "file");
                this.targets.put(path, (JsonNode)object);
            }
            this.basePath = basePath;
            this.untilCommitId = untilCommitId;
            this.commitIterator = this.getCommitIterator(untilCommitId);
        }

        public SortedMap<String, JsonNode> find() throws IOException {
            RevCommit prev = null;
            RevCommit curr = null;
            for (int i = 0; i < 1000000 && !this.targets.isEmpty(); ++i) {
                block8: {
                    if (this.commitIterator.hasNext()) {
                        curr = this.commitIterator.next();
                    } else {
                        try {
                            this.commitIterator = this.getCommitIterator((AnyObjectId)curr.getId());
                            curr = this.commitIterator.next();
                            if (!curr.equals((AnyObjectId)prev)) break block8;
                            curr = this.commitIterator.next();
                        }
                        catch (Exception e) {
                            Logger.warn((String)"An exception occurred while traversing git history", (Throwable)e);
                            break;
                        }
                    }
                }
                this.found(curr, this.findObjects(curr));
                prev = curr;
            }
            for (String path : this.targets.keySet()) {
                Iterator iterator;
                Git git = new Git(GitRepository.this.repository);
                try {
                    String targetPath = new File(this.basePath, path).getPath();
                    iterator = git.log().add(this.untilCommitId).addPath(targetPath).setMaxCount(1).call().iterator();
                }
                catch (GitAPIException e) {
                    Logger.warn((String)"An exception occurred while traversing git history", (Throwable)e);
                    continue;
                }
                if (!iterator.hasNext()) continue;
                this.setLatestCommit(this.fixRevCommitNoParents((RevCommit)iterator.next()), path);
            }
            return this.found;
        }

        private Iterator<RevCommit> getCommitIterator(AnyObjectId untilCommitId) throws IOException, GitAPIException {
            Git git = new Git(GitRepository.this.repository);
            LogCommand logCommand = git.log().add(untilCommitId);
            if (StringUtils.isNotEmpty((CharSequence)this.basePath)) {
                logCommand.addPath(this.basePath);
            }
            final Iterator iterator = logCommand.call().iterator();
            return new Iterator<RevCommit>(){

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public RevCommit next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return ObjectFinder.this.fixRevCommitNoParents((RevCommit)iterator.next());
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }
            };
        }

        private Map<String, ObjectId> findObjects(RevCommit commit) throws IOException {
            final HashMap<String, ObjectId> objects = new HashMap<String, ObjectId>();
            TreeWalkHandler objectCollector = new TreeWalkHandler(){

                @Override
                public void handle(TreeWalk treeWalk) {
                    if (ObjectFinder.this.targets.containsKey(treeWalk.getNameString())) {
                        objects.put(treeWalk.getNameString(), treeWalk.getObjectId(0));
                    }
                }
            };
            TreeWalkHandler objectRemover = new TreeWalkHandler(){

                @Override
                public void handle(TreeWalk treeWalk) {
                    if (treeWalk.getObjectId(0).equals((AnyObjectId)objects.get(treeWalk.getNameString()))) {
                        objects.remove(treeWalk.getNameString());
                    }
                }
            };
            this.traverseTree(commit, objectCollector);
            for (RevCommit parent : commit.getParents()) {
                RevCommit fixedParent = this.fixRevCommitNoTree(parent);
                this.traverseTree(fixedParent, objectRemover);
            }
            return objects;
        }

        private void traverseTree(RevCommit commit, TreeWalkHandler handler) throws IOException {
            TreeWalk treeWalk;
            if (StringUtils.isEmpty((CharSequence)this.basePath)) {
                treeWalk = new TreeWalk(GitRepository.this.repository);
                treeWalk.addTree((AnyObjectId)commit.getTree());
            } else {
                treeWalk = TreeWalk.forPath((Repository)GitRepository.this.repository, (String)this.basePath, (RevTree)commit.getTree());
                if (treeWalk == null) {
                    return;
                }
                treeWalk.enterSubtree();
            }
            while (treeWalk.next()) {
                handler.handle(treeWalk);
            }
        }

        private RevCommit fixRevCommitNoParents(RevCommit commit) {
            if (commit.getParentCount() == 0) {
                return this.fixRevCommit(commit);
            }
            return commit;
        }

        private RevCommit fixRevCommitNoTree(RevCommit commit) {
            if (commit.getTree() == null) {
                return this.fixRevCommit(commit);
            }
            return commit;
        }

        private RevCommit fixRevCommit(RevCommit commit) {
            RevWalk revWalk = new RevWalk(GitRepository.this.repository);
            try {
                return revWalk.parseCommit((AnyObjectId)commit);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void found(RevCommit revCommit, Map<String, ObjectId> objects) {
            for (String path : objects.keySet()) {
                this.setLatestCommit(revCommit, path);
                this.targets.remove(path);
            }
        }

        private void setLatestCommit(RevCommit revCommit, String path) {
            GitCommit commit = new GitCommit(revCommit);
            ObjectNode data2 = (ObjectNode)this.targets.get(path);
            data2.put("msg", commit.getShortMessage());
            String emailAddress = commit.getAuthorEmail();
            User user = User.findByEmail(emailAddress);
            data2.put("avatar", GitRepository.this.getAvatar(user));
            User user2 = user;
            String string = null;
            string = user2.getName();
            data2.put("userName", string);
            user2 = user;
            string = null;
            string = user2.getLoginId();
            data2.put("userLoginId", string);
            data2.put("createdDate", (long)revCommit.getCommitTime() * 1000L);
            data2.put("author", commit.getAuthorName());
            data2.put("commitId", commit.getShortId());
            data2.put("commitUrl", routes.CodeHistoryApp.show(GitRepository.this.ownerName, GitRepository.this.projectName, commit.getShortId()).url());
            this.found.put(GitRepository.this.extendPath(this.basePath, path), (JsonNode)data2);
        }
    }
}

