/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.OverlappingFileLockException;
import java.text.MessageFormat;
import models.Project;
import models.User;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.BareRepository;
import utils.Config;
import utils.LineEnding;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class BareCommit {
    private PersonIdent personIdent;
    private Repository repository;
    private String commitMessage;
    private ObjectInserter objectInserter;
    private File file;
    private String refName;
    private ObjectId headObjectId;

    public BareCommit(Project project2, User user) {
        this.repository = BareRepository.getRepository(project2);
        User user2 = user;
        String string = null;
        String string2 = string = user2.getName();
        user2 = user;
        string = null;
        string = user2.getEmail();
        this.personIdent = new PersonIdent(string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId commitTextFile(String fileNameWithPath, String contents, String message) throws IOException {
        this.file = new File(fileNameWithPath);
        this.setCommitMessage(message);
        if (this.refName == null) {
            this.setRefName("HEAD");
        }
        ObjectId commitId = null;
        try {
            this.objectInserter = this.repository.newObjectInserter();
            contents = LineEnding.addEOL(LineEnding.changeLineEnding(contents, BareRepository.findFileLineEnding(this.repository, fileNameWithPath)));
            this.setHeadObjectId(this.refName);
            commitId = this.createCommitWithNewTree(this.createGitObjectWithText(contents));
            RefUpdate.Result result2 = this.refUpdate(commitId, this.refName);
        }
        catch (OverlappingFileLockException e) {
            Logger.error((String)("Overlapping File Lock Error: " + e.getMessage()));
        }
        finally {
            this.objectInserter.close();
            this.repository.close();
        }
        return commitId;
    }

    private boolean noHeadRef() {
        if (this.headObjectId == null) {
            return true;
        }
        return this.headObjectId.equals((AnyObjectId)ObjectId.zeroId());
    }

    private ObjectId createCommitWithNewTree(ObjectId targetTextFileObjectId) throws IOException {
        return this.objectInserter.insert(this.buildCommitWith(this.file.getName(), targetTextFileObjectId));
    }

    private CommitBuilder buildCommitWith(String fileName, ObjectId fileObjectId) throws IOException {
        CommitBuilder commit = new CommitBuilder();
        commit.setTreeId((AnyObjectId)this.createTreeWith(fileName, fileObjectId));
        if (!this.noHeadRef()) {
            commit.setParentId((AnyObjectId)this.headObjectId);
        }
        commit.setAuthor(this.getPersonIdent());
        commit.setCommitter(this.getPersonIdent());
        commit.setMessage(this.getCommitMessage());
        return commit;
    }

    private ObjectId createTreeWith(String fileName, ObjectId fileObjectId) throws IOException {
        if (this.noHeadRef()) {
            return this.objectInserter.insert(this.newTreeWith(fileName, fileObjectId));
        }
        return this.objectInserter.insert(this.rebuildExistingTreeWith(fileName, fileObjectId));
    }

    private TreeFormatter newTreeWith(String fileName, ObjectId fileObjectId) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.append(fileName, FileMode.REGULAR_FILE, (AnyObjectId)fileObjectId);
        return formatter;
    }

    private TreeFormatter rebuildExistingTreeWith(String fileName, ObjectId fileObjectId) throws IOException {
        TreeFormatter formatter = new TreeFormatter();
        CanonicalTreeParser treeParser = this.getCanonicalTreeParser(this.repository);
        boolean isInsertedInTree = false;
        while (!treeParser.eof()) {
            String entryName;
            String nameForComparison = entryName = new String(treeParser.getEntryPathBuffer(), 0, treeParser.getEntryPathLength(), Config.getCharset());
            if (treeParser.getEntryFileMode() == FileMode.TREE) {
                nameForComparison = entryName.concat("/");
            }
            if (nameForComparison.compareTo(fileName) == 0 && !isInsertedInTree) {
                formatter.append(fileName, FileMode.REGULAR_FILE, (AnyObjectId)fileObjectId);
                isInsertedInTree = true;
            } else if (nameForComparison.compareTo(fileName) > 0 && !isInsertedInTree) {
                formatter.append(fileName, FileMode.REGULAR_FILE, (AnyObjectId)fileObjectId);
                formatter.append(entryName.getBytes(Config.getCharset()), treeParser.getEntryFileMode(), (AnyObjectId)treeParser.getEntryObjectId());
                isInsertedInTree = true;
            } else {
                formatter.append(entryName.getBytes(Config.getCharset()), treeParser.getEntryFileMode(), (AnyObjectId)treeParser.getEntryObjectId());
            }
            treeParser = treeParser.next();
        }
        if (!isInsertedInTree) {
            formatter.append(fileName, FileMode.REGULAR_FILE, (AnyObjectId)fileObjectId);
        }
        return formatter;
    }

    private CanonicalTreeParser getCanonicalTreeParser(Repository repository) throws IOException {
        RevWalk revWalk = new RevWalk(repository);
        RevCommit commit = revWalk.parseCommit((AnyObjectId)this.headObjectId);
        return new CanonicalTreeParser(new byte[0], revWalk.getObjectReader(), (AnyObjectId)commit.getTree().getId());
    }

    private ObjectId createGitObjectWithText(String contents) throws IOException {
        byte[] bytes = contents.getBytes(Config.getCharset());
        return this.objectInserter.insert(3, bytes, 0, bytes.length);
    }

    private RefUpdate.Result refUpdate(ObjectId commitId, String refName) throws IOException {
        RefUpdate ru = this.repository.updateRef(refName);
        ru.setForceUpdate(false);
        ru.setRefLogIdent(this.getPersonIdent());
        ru.setNewObjectId((AnyObjectId)commitId);
        if (this.hasOldCommit(refName)) {
            ru.setExpectedOldObjectId((AnyObjectId)this.getCurrentMomentHeadObjectId());
        }
        ru.setRefLogMessage(this.getCommitMessage(), true);
        RefUpdate.Result result2 = ru.update();
        Logger.debug((String)("Online commit: HEAD[" + this.headObjectId + "]:" + result2 + " New:" + commitId));
        return result2;
    }

    private boolean hasOldCommit(String refName) throws IOException {
        return this.repository.findRef(refName).getObjectId() != null;
    }

    private PersonIdent getPersonIdent() {
        if (this.personIdent == null) {
            this.personIdent = new PersonIdent(this.repository);
        }
        return this.personIdent;
    }

    private String getCommitMessage() {
        if (this.commitMessage == null) {
            return "Update " + this.file.getName();
        }
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public void setHeadObjectId(String refName) throws IOException {
        this.headObjectId = this.repository.findRef(refName).getObjectId() == null ? ObjectId.zeroId() : this.repository.findRef(refName).getObjectId();
    }

    public ObjectId getCurrentMomentHeadObjectId() throws IOException {
        if (this.repository.findRef(this.refName).getObjectId() == null) {
            return ObjectId.zeroId();
        }
        return this.repository.findRef(this.refName).getObjectId();
    }

    public void setRefName(String refName) {
        this.refName = refName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectId commitTextFile(String branchName, String path, String text, String message) throws IOException {
        this.file = new File(this.repository.getDirectory(), path);
        FileUtils.writeStringToFile((File)this.file, (String)text, (String)"UTF-8");
        ObjectId commitId = null;
        Git git = new Git(this.repository);
        try (ObjectInserter inserter = git.getRepository().newObjectInserter();){
            this.headObjectId = git.getRepository().resolve(this.refName + "^{commit}");
            DirCache index2 = BareCommit.createTemporaryIndex(git, this.headObjectId, path, this.file);
            ObjectId indexTreeId = index2.writeTree(inserter);
            CommitBuilder commit = this.getCommitBuilder(message, indexTreeId);
            commitId = inserter.insert(commit);
            inserter.flush();
            RefUpdate ru = this.getRefUpdate(branchName, commitId, git);
            RefUpdate.Result rc = ru.forceUpdate();
            switch (rc) {
                case NEW: 
                case FORCED: 
                case FAST_FORWARD: {
                    return commitId;
                }
                case REJECTED: 
                case LOCK_FAILURE: {
                    throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                }
                default: {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", commitId.toString(), rc));
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private RefUpdate getRefUpdate(String branchName, ObjectId commitId, Git git) throws IOException {
        RevWalk revWalk = new RevWalk(git.getRepository());
        RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
        RefUpdate ru = git.getRepository().updateRef("refs/heads/" + branchName);
        if (this.headObjectId == null) {
            ru.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
        } else {
            ru.setExpectedOldObjectId((AnyObjectId)this.headObjectId);
        }
        ru.setNewObjectId((AnyObjectId)commitId);
        ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
        revWalk.close();
        return ru;
    }

    private CommitBuilder getCommitBuilder(String message, ObjectId indexTreeId) {
        CommitBuilder commit = new CommitBuilder();
        commit.setAuthor(this.getPersonIdent());
        commit.setCommitter(this.getPersonIdent());
        commit.setEncoding("UTF-8");
        commit.setMessage(message);
        if (this.headObjectId != null) {
            commit.setParentId((AnyObjectId)this.headObjectId);
        }
        commit.setTreeId((AnyObjectId)indexTreeId);
        return commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirCache createTemporaryIndex(Git git, ObjectId headId, String path, File file) {
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder dcBuilder = inCoreIndex.builder();
        try (ObjectInserter inserter = git.getRepository().newObjectInserter();){
            if (file != null) {
                DirCacheEntry dcEntry = new DirCacheEntry(path);
                dcEntry.setLength(file.length());
                dcEntry.setLastModified(file.lastModified());
                dcEntry.setFileMode(FileMode.REGULAR_FILE);
                try (FileInputStream inputStream = new FileInputStream(file);){
                    dcEntry.setObjectId((AnyObjectId)inserter.insert(3, file.length(), (InputStream)inputStream));
                }
                dcBuilder.add(dcEntry);
            }
            if (headId != null) {
                TreeWalk treeWalk = new TreeWalk(git.getRepository());
                int hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(git.getRepository()).parseTree((AnyObjectId)headId));
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    String walkPath = treeWalk.getPathString();
                    CanonicalTreeParser hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                    if (walkPath.equals(path)) continue;
                    DirCacheEntry dcEntry = new DirCacheEntry(walkPath);
                    dcEntry.setObjectId((AnyObjectId)hTree.getEntryObjectId());
                    dcEntry.setFileMode(hTree.getEntryFileMode());
                    dcBuilder.add(dcEntry);
                }
                treeWalk.close();
            }
            dcBuilder.finish();
        }
        if (file == null) {
            DirCacheEditor editor2 = inCoreIndex.editor();
            editor2.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(path));
            editor2.finish();
        }
        return inCoreIndex;
    }
}

