/*
 * Decompiled with CFR 0.152.
 */
package notification;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import models.User;
import models.enumeration.EventType;
import models.enumeration.ResourceType;
import models.resource.Resource;
import notification.INotificationEvent;
import play.api.i18n.Lang;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class MergedNotificationEvent
implements INotificationEvent {
    private final List<INotificationEvent> messageSources;
    private final INotificationEvent main;
    private Set<User> receivers;

    public MergedNotificationEvent(@Nonnull INotificationEvent main, @Nonnull List<INotificationEvent> messageSources) {
        this.main = main;
        this.messageSources = new LinkedList<INotificationEvent>(messageSources);
    }

    public MergedNotificationEvent(@Nonnull INotificationEvent main) {
        this(main, Arrays.asList(main));
    }

    @Override
    public User getSender() {
        return this.main.getSender();
    }

    @Override
    public Resource getResource() {
        return this.main.getResource();
    }

    @Override
    public String getMessage(Lang lang) {
        ArrayList<String> messages = new ArrayList<String>();
        for (INotificationEvent event : this.messageSources) {
            messages.add(event.getMessage(lang));
        }
        return Joiner.on((String)"\n\n---\n\n").join(messages);
    }

    @Override
    public String getPlainMessage(Lang lang) {
        ArrayList<String> messages = new ArrayList<String>();
        for (INotificationEvent event : this.messageSources) {
            messages.add(event.getPlainMessage(lang));
        }
        return Joiner.on((String)"\n\n---\n\n").join(messages);
    }

    @Override
    public String getUrlToView() {
        return this.main.getUrlToView();
    }

    @Override
    public Date getCreatedDate() {
        return this.main.getCreatedDate();
    }

    @Override
    public String getTitle() {
        return this.main.getTitle();
    }

    @Override
    public EventType getType() {
        return this.main.getType();
    }

    @Override
    public ResourceType getResourceType() {
        return this.main.getResourceType();
    }

    @Override
    public String getResourceId() {
        return this.main.getResourceId();
    }

    @Override
    public boolean resourceExists() {
        return this.main.resourceExists();
    }

    @Override
    public Set<User> findReceivers() {
        if (this.receivers != null) {
            return this.receivers;
        }
        return this.main.findReceivers();
    }

    @Override
    public void setReceivers(@Nonnull Set<User> receivers) {
        this.receivers = receivers;
    }

    public List<INotificationEvent> getMessageSources() {
        return this.messageSources;
    }
}

