/*
 * Decompiled with CFR 0.152.
 */
package models.support;

import controllers.Application;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class LdapUser {
    private Attribute displayName;
    private Attribute email;
    private Attribute userLoginId;
    private Attribute department;
    private Attribute englishName;

    public LdapUser(Attribute displayName, Attribute email, Attribute userLoginId, Attribute department) {
        this.displayName = displayName;
        this.email = email;
        this.userLoginId = userLoginId;
        this.department = department;
    }

    public String getDisplayName() {
        if (StringUtils.isNotBlank((CharSequence)this.getDepartment())) {
            return this.getString(this.displayName) + " [" + this.getDepartment() + "]";
        }
        return this.getString(this.displayName);
    }

    private String getString(Attribute attr) {
        try {
            if (attr == null || attr.get() == null) {
                return "";
            }
            return attr.get().toString();
        }
        catch (NamingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean isGuestUser() {
        if (StringUtils.isBlank((CharSequence)Application.GUEST_USER_LOGIN_ID_PREFIX)) {
            return false;
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String idPrefix : Application.GUEST_USER_LOGIN_ID_PREFIX.replaceAll(" ", "").split(",")) {
            String prefix = StringUtils.defaultString((String)idPrefix, (String)"").toLowerCase().trim();
            if (!StringUtils.isNotBlank((CharSequence)prefix)) continue;
            prefixes.add(prefix);
        }
        for (String prefix : prefixes) {
            if (!this.getUserLoginId().toLowerCase().startsWith(prefix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String getEmail() {
        return this.getString(this.email);
    }

    public String getUserLoginId() {
        return this.getString(this.userLoginId);
    }

    public String getDepartment() {
        return this.getString(this.department);
    }

    public void setEnglishName(Attribute englishName) {
        this.englishName = englishName;
    }

    public String getEnglishName() {
        return this.getString(this.englishName);
    }

    public String toString() {
        return "LdapUser{displayName=" + this.displayName + ", email=" + this.email + ", userLoginId=" + this.userLoginId + ", department=" + this.department + ", englishName=" + this.englishName + '}';
    }
}

