/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import models.Project;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;
import utils.TemplateHelper;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class TitleHead
extends Model
implements EntityBean {
    private static final long serialVersionUID = 5194690128303455482L;
    public static final Model.Finder<Long, TitleHead> finder = new Model.Finder(Long.class, TitleHead.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String headKeyword;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public int frequency;
    private static String _EBEAN_MARKER = "models.TitleHead";

    public static List<TitleHead> findByProject(Project project2, String query) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return finder.where().eq("project.id", (Object)l).ilike("headKeyword", "%" + query + "%").findList();
    }

    public static TitleHead findByHeadKeyword(Project project2, String headKeyword) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        List founds = finder.where().eq("project.id", (Object)l).eq("headKeyword", (Object)headKeyword).findList();
        if (founds.size() > 0) {
            return (TitleHead)((Object)founds.get(0));
        }
        return null;
    }

    public static void newHeadKeyword(Project project2, String headKeyword) {
        TitleHead found = TitleHead.findByHeadKeyword(project2, headKeyword);
        if (found != null) {
            TitleHead titleHead = found;
            int n = 0;
            n = titleHead.getFrequency();
            titleHead.setFrequency(++n);
            found.update();
        } else {
            TitleHead titleHeadKeyword = new TitleHead();
            Object object = project2;
            TitleHead titleHead = titleHeadKeyword;
            titleHead.setProject((Project)object);
            object = headKeyword;
            titleHead = titleHeadKeyword;
            titleHead.setHeadKeyword((String)object);
            int n = 1;
            titleHead = titleHeadKeyword;
            titleHead.setFrequency(n);
            titleHeadKeyword.save();
        }
    }

    public static void reduceHeadKeyword(Project project2, String headKeyword) {
        TitleHead found = TitleHead.findByHeadKeyword(project2, headKeyword);
        if (found != null) {
            TitleHead titleHead = found;
            int n = 0;
            n = titleHead.getFrequency();
            titleHead.setFrequency(--n);
            titleHead = found;
            n = 0;
            n = titleHead.getFrequency();
            if (n == 0) {
                found.delete();
            } else {
                found.update();
            }
        }
    }

    public static void saveTitleHeadKeyword(Project project2, String title) {
        String[] headKeywords;
        for (String headKeyword : headKeywords = TemplateHelper.extractHeaderWordsInBrackets(title)) {
            String trimmed = headKeyword.trim();
            if (!TitleHead.isSurroundedByBracket(trimmed)) continue;
            TitleHead.newHeadKeyword(project2, TitleHead.removeBracket(trimmed));
        }
    }

    private static String removeBracket(String trimmed) {
        return trimmed.substring(1, trimmed.length() - 1);
    }

    private static boolean isSurroundedByBracket(String trimmed) {
        return trimmed.indexOf("[") == 0 && trimmed.indexOf("]") == trimmed.length() - 1 && trimmed.length() > 2;
    }

    public static void deleteTitleHeadKeyword(Project project2, String title) {
        String[] headKeywords;
        for (String headKeyword : headKeywords = TemplateHelper.extractHeaderWordsInBrackets(title)) {
            String trimmed = headKeyword.trim();
            if (!TitleHead.isSurroundedByBracket(trimmed)) continue;
            TitleHead.reduceHeadKeyword(project2, TitleHead.removeBracket(trimmed));
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this._ebean_get_project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this._ebean_set_project(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getHeadKeyword() {
        return this._ebean_get_headKeyword();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setHeadKeyword(String string) {
        this._ebean_set_headKeyword(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public int getFrequency() {
        return this._ebean_get_frequency();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setFrequency(int n) {
        this._ebean_set_frequency(n);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected Project _ebean_get_project() {
        this._ebean_intercept.preGetter("project");
        return this.project;
    }

    protected void _ebean_set_project(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "project", (Object)this._ebean_get_project(), (Object)newValue);
        this.project = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_project() {
        return this.project;
    }

    protected void _ebean_setni_project(Project _newValue) {
        this.project = _newValue;
    }

    protected String _ebean_get_headKeyword() {
        this._ebean_intercept.preGetter("headKeyword");
        return this.headKeyword;
    }

    protected void _ebean_set_headKeyword(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "headKeyword", (Object)this._ebean_get_headKeyword(), (Object)newValue);
        this.headKeyword = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_headKeyword() {
        return this.headKeyword;
    }

    protected void _ebean_setni_headKeyword(String _newValue) {
        this.headKeyword = _newValue;
    }

    protected int _ebean_get_frequency() {
        this._ebean_intercept.preGetter("frequency");
        return this.frequency;
    }

    protected void _ebean_set_frequency(int newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "frequency", this._ebean_get_frequency(), newValue);
        this.frequency = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected int _ebean_getni_frequency() {
        return this.frequency;
    }

    protected void _ebean_setni_frequency(int _newValue) {
        this.frequency = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        TitleHead titleHead = new TitleHead();
        titleHead.id = this.id;
        titleHead.project = this.project;
        titleHead.headKeyword = this.headKeyword;
        titleHead.frequency = this.frequency;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        TitleHead p = (TitleHead)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.project;
            }
            case 3: {
                return p.headKeyword;
            }
            case 4: {
                return p.frequency;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        TitleHead p = (TitleHead)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_project();
            }
            case 3: {
                return p._ebean_get_headKeyword();
            }
            case 4: {
                return p._ebean_get_frequency();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        TitleHead p = (TitleHead)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.project = (Project)arg;
                return;
            }
            case 3: {
                p.headKeyword = (String)arg;
                return;
            }
            case 4: {
                p.frequency = (Integer)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        TitleHead p = (TitleHead)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 3: {
                p._ebean_set_headKeyword((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_frequency((Integer)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "project", "headKeyword", "frequency"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        TitleHead titleHead = this;
        synchronized (titleHead) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((TitleHead)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new TitleHead();
    }
}

