/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import models.Issue;
import models.IssueComment;
import models.Milestone;
import models.Posting;
import models.PostingComment;
import models.Project;
import models.ReviewComment;
import models.User;
import models.enumeration.SearchType;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SearchResult {
    private String keyword;
    private SearchType searchType;
    private int usersCount;
    private int projectsCount;
    private int issuesCount;
    private int postsCount;
    private int milestonesCount;
    private int issueCommentsCount;
    private int postCommentsCount;
    private int reviewsCount;
    private Page<User> users;
    private Page<Project> projects;
    private Page<Issue> issues;
    private Page<Posting> posts;
    private Page<Milestone> milestones;
    private Page<IssueComment> issueComments;
    private Page<PostingComment> postComments;
    private Page<ReviewComment> reviews;

    public List<String> makeSnippets(String contents, int threshold) {
        String lowerCaseContents = contents.toLowerCase();
        String lowerCaseKeyword = this.keyword.toLowerCase();
        LinkedList<BeginAndEnd> beginAndEnds = new LinkedList<BeginAndEnd>();
        List<Integer> indexes = this.findIndexes(lowerCaseContents, lowerCaseKeyword);
        for (int i = 0; i < indexes.size(); ++i) {
            int currentIndex = indexes.get(i);
            int beginIndex = this.beginIndex(currentIndex, threshold);
            int endIndex = this.endIndex(currentIndex + lowerCaseKeyword.length(), lowerCaseContents.length(), threshold);
            BeginAndEnd thisOne = new BeginAndEnd(beginIndex, endIndex);
            if (i == 0) {
                beginAndEnds.push(thisOne);
                continue;
            }
            BeginAndEnd latestOne = (BeginAndEnd)beginAndEnds.peek();
            if (latestOne.getEndIndex() >= thisOne.getBeginIndex()) {
                BeginAndEnd mergedOne = new BeginAndEnd(latestOne.getBeginIndex(), thisOne.getEndIndex());
                beginAndEnds.pop();
                beginAndEnds.push(mergedOne);
                continue;
            }
            beginAndEnds.push(thisOne);
        }
        Collections.reverse(beginAndEnds);
        ArrayList<String> snippets = new ArrayList<String>();
        for (BeginAndEnd bae : beginAndEnds) {
            snippets.add(contents.substring(bae.beginIndex, bae.endIndex));
        }
        return snippets;
    }

    private List<Integer> findIndexes(String contents, String keyword) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int index2 = contents.indexOf(keyword);
        while (index2 != -1) {
            indexes.add(index2);
            index2 = contents.indexOf(keyword, index2 + keyword.length());
        }
        return indexes;
    }

    private int beginIndex(int index2, int threshold) {
        return index2 < threshold ? 0 : index2 - threshold;
    }

    private int endIndex(int keywordEndIndex, int contentLength, int threshold) {
        int endIndex = keywordEndIndex + threshold;
        return endIndex < contentLength ? endIndex : contentLength;
    }

    public void updateSearchType() {
        if (this.searchType != SearchType.AUTO) {
            return;
        }
        if (this.getIssuesCount() > 0) {
            this.setSearchType(SearchType.ISSUE);
            return;
        }
        if (this.getUsersCount() > 0) {
            this.setSearchType(SearchType.USER);
            return;
        }
        if (this.getProjectsCount() > 0) {
            this.setSearchType(SearchType.PROJECT);
            return;
        }
        if (this.getPostsCount() > 0) {
            this.setSearchType(SearchType.POST);
            return;
        }
        if (this.getMilestonesCount() > 0) {
            this.setSearchType(SearchType.MILESTONE);
            return;
        }
        if (this.getIssueCommentsCount() > 0) {
            this.setSearchType(SearchType.ISSUE_COMMENT);
            return;
        }
        if (this.getPostCommentsCount() > 0) {
            this.setSearchType(SearchType.POST_COMMENT);
            return;
        }
        if (this.getReviewsCount() > 0) {
            this.setSearchType(SearchType.REVIEW);
            return;
        }
        this.setSearchType(SearchType.ISSUE);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public int getUsersCount() {
        return this.usersCount;
    }

    public void setUsersCount(int usersCount) {
        this.usersCount = usersCount;
    }

    public int getProjectsCount() {
        return this.projectsCount;
    }

    public void setProjectsCount(int projectsCount) {
        this.projectsCount = projectsCount;
    }

    public int getIssuesCount() {
        return this.issuesCount;
    }

    public void setIssuesCount(int issuesCount) {
        this.issuesCount = issuesCount;
    }

    public int getPostsCount() {
        return this.postsCount;
    }

    public void setPostsCount(int postsCount) {
        this.postsCount = postsCount;
    }

    public int getMilestonesCount() {
        return this.milestonesCount;
    }

    public void setMilestonesCount(int milestonesCount) {
        this.milestonesCount = milestonesCount;
    }

    public int getIssueCommentsCount() {
        return this.issueCommentsCount;
    }

    public void setIssueCommentsCount(int issueCommentsCount) {
        this.issueCommentsCount = issueCommentsCount;
    }

    public int getPostCommentsCount() {
        return this.postCommentsCount;
    }

    public void setPostCommentsCount(int postCommentsCount) {
        this.postCommentsCount = postCommentsCount;
    }

    public int getReviewsCount() {
        return this.reviewsCount;
    }

    public void setReviewsCount(int reviewsCount) {
        this.reviewsCount = reviewsCount;
    }

    public Page<User> getUsers() {
        return this.users;
    }

    public void setUsers(Page<User> users2) {
        this.users = users2;
    }

    public Page<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Page<Project> projects2) {
        this.projects = projects2;
    }

    public Page<Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(Page<Issue> issues2) {
        this.issues = issues2;
    }

    public Page<Posting> getPosts() {
        return this.posts;
    }

    public void setPosts(Page<Posting> posts2) {
        this.posts = posts2;
    }

    public Page<Milestone> getMilestones() {
        return this.milestones;
    }

    public void setMilestones(Page<Milestone> milestones2) {
        this.milestones = milestones2;
    }

    public Page<IssueComment> getIssueComments() {
        return this.issueComments;
    }

    public void setIssueComments(Page<IssueComment> issueComments) {
        this.issueComments = issueComments;
    }

    public Page<PostingComment> getPostComments() {
        return this.postComments;
    }

    public void setPostComments(Page<PostingComment> postComments) {
        this.postComments = postComments;
    }

    public Page<ReviewComment> getReviews() {
        return this.reviews;
    }

    public void setReviews(Page<ReviewComment> reviews) {
        this.reviews = reviews;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private class BeginAndEnd {
        int beginIndex;
        int endIndex;

        BeginAndEnd(int beginIndex, int endIndex) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String toString() {
            return "BeginAndEnd{beginIndex=" + this.beginIndex + ", endIndex=" + this.endIndex + '}';
        }
    }
}

