/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.Expr;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Junction;
import com.avaje.ebean.Page;
import controllers.Application;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import models.Issue;
import models.IssueComment;
import models.Milestone;
import models.Organization;
import models.OrganizationUser;
import models.PageParam;
import models.Posting;
import models.PostingComment;
import models.Project;
import models.ReviewComment;
import models.User;
import models.enumeration.Operation;
import models.enumeration.ProjectScope;
import models.enumeration.UserState;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import utils.AccessControl;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Search {
    private static final String DEFAULT_PATH_TO_PROJECT = "project";
    private static final String DEFAULT_PATH_TO_AUTHOR = "authorId";
    private static JunctionOperation<Issue> containsKeywordInIssue = new JunctionOperation<Issue>(){

        @Override
        public void withJunction(String keyword, Junction<Issue> junction) {
            Search.containsKeywordIn(keyword, junction, new String[]{"title", "body"});
        }
    };
    private static JunctionOperation<Posting> containsKeywordInPosting = new JunctionOperation<Posting>(){

        @Override
        public void withJunction(String keyword, Junction<Posting> junction) {
            Search.containsKeywordIn(keyword, junction, new String[]{"title", "body"});
        }
    };
    private static JunctionOperation<Milestone> containsKeywordInMilestone = new JunctionOperation<Milestone>(){

        @Override
        public void withJunction(String keyword, Junction<Milestone> junction) {
            Search.containsKeywordIn(keyword, junction, new String[]{"title", "contents"});
        }
    };
    private static JunctionOperation<IssueComment> containsKeywordInIssueComment = new JunctionOperation<IssueComment>(){

        @Override
        public void withJunction(String keyword, Junction<IssueComment> junction) {
            Search.containsKeywordIn(keyword, junction, new String[]{"contents"});
        }
    };
    private static JunctionOperation<PostingComment> containsKeywordInPostComment = new JunctionOperation<PostingComment>(){

        @Override
        public void withJunction(String keyword, Junction<PostingComment> junction) {
            Search.containsKeywordIn(keyword, junction, new String[]{"contents"});
        }
    };
    private static JunctionOperation<ReviewComment> containsKeywordInReviewComment = new JunctionOperation<ReviewComment>(){

        @Override
        public void withJunction(String keyword, Junction<ReviewComment> junction) {
            Search.containsKeywordIn(keyword, junction, new String[]{"contents"});
        }
    };

    public static Page<Issue> findIssues(String keyword, User user, PageParam pageParam) {
        return Search.issuesEL(keyword, user).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countIssues(String keyword, User user) {
        return Search.issuesEL(keyword, user).findRowCount();
    }

    private static ExpressionList<Issue> issuesEL(String keyword, User user) {
        ExpressionList el = Issue.finder.where();
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, junction, DEFAULT_PATH_TO_PROJECT, containsKeywordInIssue);
        Search.equalsUserTemplate(keyword, user, junction, DEFAULT_PATH_TO_AUTHOR, containsKeywordInIssue);
        Search.equalsUserTemplate(keyword, user, junction, "assignee.user.id", containsKeywordInIssue);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<Issue> findIssues(String keyword, User user, Project project2, PageParam pageParam) {
        return Search.issuesEL(keyword, user, project2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countIssues(String keyword, User user, Project project2) {
        ExpressionList<Issue> el = Search.issuesEL(keyword, user, project2);
        return el.findRowCount();
    }

    private static ExpressionList<Issue> issuesEL(String keyword, User user, Project project2) {
        ExpressionList el = Issue.finder.where().eq(DEFAULT_PATH_TO_PROJECT, (Object)project2);
        if (!AccessControl.isAllowed(user, project2.asResource(), Operation.READ)) {
            Junction junction = el.disjunction();
            User user2 = user;
            Long l = null;
            l = user2.getId();
            junction.add(Expr.eq((String)DEFAULT_PATH_TO_AUTHOR, (Object)l));
            user2 = user;
            l = null;
            l = user2.getId();
            junction.add(Expr.eq((String)"assignee.user.id", (Object)l));
            junction.endJunction();
        }
        Search.containsKeywordIn(keyword, el.conjunction(), new String[]{"title", "body"});
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<Issue> findIssues(String keyword, User user, Organization organization2, PageParam pageParam) {
        return Search.issuesEL(keyword, user, organization2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countIssues(String keyword, User user, Organization organization2) {
        ExpressionList<Issue> el = Search.issuesEL(keyword, user, organization2);
        return el.findRowCount();
    }

    private static ExpressionList<Issue> issuesEL(String keyword, User user, Organization organization2) {
        ExpressionList el = Issue.finder.where().eq("project.organization", (Object)organization2);
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, organization2, junction, DEFAULT_PATH_TO_PROJECT, containsKeywordInIssue);
        Search.equalsUserTemplate(keyword, user, junction, DEFAULT_PATH_TO_AUTHOR, containsKeywordInIssue);
        Search.equalsUserTemplate(keyword, user, junction, "assignee.user.id", containsKeywordInIssue);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<Posting> findPosts(String keyword, User user, PageParam pageParam) {
        return Search.postsEL(keyword, user).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countPosts(String keyword, User user) {
        return Search.postsEL(keyword, user).findRowCount();
    }

    private static ExpressionList<Posting> postsEL(String keyword, User user) {
        ExpressionList el = Posting.finder.where();
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, junction, DEFAULT_PATH_TO_PROJECT, containsKeywordInPosting);
        Search.equalsUserTemplate(keyword, user, junction, DEFAULT_PATH_TO_AUTHOR, containsKeywordInPosting);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<Posting> findPosts(String keyword, User user, Project project2, PageParam pageParam) {
        return Search.postsEL(keyword, user, project2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countPosts(String keyword, User user, Project project2) {
        return Search.postsEL(keyword, user, project2).findRowCount();
    }

    private static ExpressionList<Posting> postsEL(String keyword, User user, Project project2) {
        ExpressionList el = Posting.finder.where().eq(DEFAULT_PATH_TO_PROJECT, (Object)project2);
        if (!AccessControl.isAllowed(user, project2.asResource(), Operation.READ)) {
            User user2 = user;
            Long l = null;
            l = user2.getId();
            el.eq(DEFAULT_PATH_TO_AUTHOR, (Object)l);
        }
        Search.containsKeywordIn(keyword, el.conjunction(), new String[]{"title", "body"});
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<Posting> findPosts(String keyword, User user, Organization organization2, PageParam pageParam) {
        return Search.postsEL(keyword, user, organization2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countPosts(String keyword, User user, Organization organization2) {
        ExpressionList<Posting> el = Search.postsEL(keyword, user, organization2);
        return el.findRowCount();
    }

    private static ExpressionList<Posting> postsEL(String keyword, User user, Organization organization2) {
        ExpressionList el = Posting.finder.where().eq("project.organization", (Object)organization2);
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, organization2, junction, DEFAULT_PATH_TO_PROJECT, containsKeywordInPosting);
        Search.equalsUserTemplate(keyword, user, junction, DEFAULT_PATH_TO_AUTHOR, containsKeywordInPosting);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<User> findUsers(String keyword, PageParam pageParam) {
        return Search.usersEL(keyword).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countUsers(String keyword) {
        return Search.usersEL(keyword).findRowCount();
    }

    private static ExpressionList<User> usersEL(String keyword) {
        ExpressionList el = User.find.where().eq("state", (Object)UserState.ACTIVE);
        el.disjunction().add(Expr.icontains((String)"name", (String)keyword)).add(Expr.icontains((String)"loginId", (String)keyword)).endJunction().orderBy().asc("name");
        return el;
    }

    public static Page<User> findUsers(String keyword, Project project2, PageParam pageParam) {
        return Search.usersEL(keyword, project2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countUsers(String keyword, Project project2) {
        ExpressionList<User> el = Search.usersEL(keyword, project2);
        return el.findRowCount();
    }

    private static ExpressionList<User> usersEL(String keyword, Project project2) {
        ExpressionList el = User.find.where().eq("state", (Object)UserState.ACTIVE).eq("projectUser.project", (Object)project2);
        el.disjunction().add(Expr.icontains((String)"name", (String)keyword)).add(Expr.icontains((String)"loginId", (String)keyword)).endJunction().orderBy().asc("name");
        return el;
    }

    public static Page<User> findUsers(String keyword, Organization organization2, PageParam pageParam) {
        return Search.usersEL(keyword, organization2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countUsers(String keyword, Organization organization2) {
        return Search.usersEL(keyword, organization2).findRowCount();
    }

    private static ExpressionList<User> usersEL(String keyword, Organization organization2) {
        ExpressionList el = User.find.where().eq("state", (Object)UserState.ACTIVE).eq("groupUser.organization", (Object)organization2);
        el.disjunction().add(Expr.icontains((String)"name", (String)keyword)).add(Expr.icontains((String)"loginId", (String)keyword)).endJunction().orderBy().asc("name");
        return el;
    }

    public static Page<Project> findProjects(String keyword, User user, PageParam pageParam) {
        return Search.projectsEL(keyword, user).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countProjects(String keyword, User user) {
        return Search.projectsEL(keyword, user).findList().size();
    }

    public static Page<Project> findProjects(String keyword, User user, Organization organization2, PageParam pageParam) {
        return Search.projectsEL(keyword, user).eq("organization", (Object)organization2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countProjects(String keyword, User user, Organization organization2) {
        return Search.projectsEL(keyword, user).eq("organization", (Object)organization2).findList().size();
    }

    private static ExpressionList<Project> projectsEL(String keyword, User user) {
        ExpressionList el = Project.find.where();
        if (user.isAnonymous() && !Application.HIDE_PROJECT_LISTING) {
            el.eq("projectScope", (Object)ProjectScope.PUBLIC);
            el.disjunction().icontains("overview", keyword).icontains("name", keyword).endJunction();
        } else {
            Junction junction = el.conjunction();
            Junction pj = junction.disjunction();
            if (!Application.HIDE_PROJECT_LISTING) {
                pj.add(Expr.eq((String)"projectScope", (Object)((Object)ProjectScope.PUBLIC)));
            }
            User user2 = user;
            Object object = null;
            object = user2.getLoginId();
            List<Organization> orgs = Organization.findOrganizationsByUserLoginId((String)object);
            if (!orgs.isEmpty()) {
                pj.and(Expr.in((String)"organization", orgs), Expr.eq((String)"projectScope", (Object)((Object)ProjectScope.PROTECTED)));
            }
            user2 = user;
            object = null;
            object = user2.getId();
            pj.add(Expr.eq((String)"projectUser.user.id", (Object)object));
            pj.endJunction();
            junction.disjunction().icontains("overview", keyword).icontains("name", keyword).endJunction();
            junction.endJunction();
        }
        el.orderBy().asc("name");
        return el;
    }

    public static Page<Milestone> findMilestones(String keyword, User user, PageParam pageParam) {
        return Search.milestonesEL(keyword, user).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countMilestones(String keyword, User user) {
        return Search.milestonesEL(keyword, user).findRowCount();
    }

    private static ExpressionList<Milestone> milestonesEL(String keyword, User user) {
        ExpressionList el = Milestone.find.where();
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, junction, DEFAULT_PATH_TO_PROJECT, containsKeywordInMilestone);
        junction.endJunction();
        el.orderBy().desc("dueDate");
        return el;
    }

    public static Page<Milestone> findMilestones(String keyword, User user, Project project2, PageParam pageParam) {
        if (!AccessControl.isAllowed(user, project2.asResource(), Operation.READ)) {
            return Search.emptyPage();
        }
        return Search.milestonesEL(keyword, project2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countMilestones(String keyword, User user, Project project2) {
        if (!AccessControl.isAllowed(user, project2.asResource(), Operation.READ)) {
            return 0;
        }
        return Search.milestonesEL(keyword, project2).findRowCount();
    }

    private static ExpressionList<Milestone> milestonesEL(String keyword, Project project2) {
        ExpressionList el = Milestone.find.where().eq(DEFAULT_PATH_TO_PROJECT, (Object)project2);
        Junction junction = el.disjunction();
        Search.containsKeywordIn(keyword, junction, new String[]{"title", "contents"});
        junction.endJunction();
        el.orderBy().desc("dueDate");
        return el;
    }

    public static Page<Milestone> findMilestones(String keyword, User user, Organization organization2, PageParam pageParam) {
        return Search.milestonesEL(keyword, user, organization2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countMilestones(String keyword, User user, Organization organization2) {
        return Search.milestonesEL(keyword, user, organization2).findRowCount();
    }

    private static ExpressionList<Milestone> milestonesEL(String keyword, User user, Organization organization2) {
        ExpressionList el = Milestone.find.where().eq("project.organization", (Object)organization2);
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, organization2, junction, DEFAULT_PATH_TO_PROJECT, containsKeywordInMilestone);
        junction.endJunction();
        el.orderBy().desc("dueDate");
        return el;
    }

    public static Page<IssueComment> findIssueComments(String keyword, User user, PageParam pageParam) {
        return Search.issueCommentsEL(keyword, user).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countIssueComments(String keyword, User user) {
        return Search.issueCommentsEL(keyword, user).findRowCount();
    }

    private static ExpressionList<IssueComment> issueCommentsEL(String keyword, User user) {
        ExpressionList el = IssueComment.find.where();
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, junction, "issue.project", containsKeywordInIssueComment);
        Search.equalsUserTemplate(keyword, user, junction, DEFAULT_PATH_TO_AUTHOR, containsKeywordInIssueComment);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<IssueComment> findIssueComments(String keyword, User user, Project project2, PageParam pageParam) {
        return Search.issueCommentsEL(keyword, user, project2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countIssueComments(String keyword, User user, Project project2) {
        return Search.issueCommentsEL(keyword, user, project2).findRowCount();
    }

    private static ExpressionList<IssueComment> issueCommentsEL(String keyword, User user, Project project2) {
        ExpressionList el = IssueComment.find.where().eq("issue.project", (Object)project2);
        if (!AccessControl.isAllowed(user, project2.asResource(), Operation.READ)) {
            User user2 = user;
            Long l = null;
            l = user2.getId();
            el.eq(DEFAULT_PATH_TO_AUTHOR, (Object)l);
        }
        Search.containsKeywordIn(keyword, el.conjunction(), new String[]{"contents"});
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<IssueComment> findIssueComments(String keyword, User user, Organization organization2, PageParam pageParam) {
        return Search.issueCommentsEL(keyword, user, organization2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countIssueComments(String keyword, User user, Organization organization2) {
        return Search.issueCommentsEL(keyword, user, organization2).findRowCount();
    }

    private static ExpressionList<IssueComment> issueCommentsEL(String keyword, User user, Organization organization2) {
        ExpressionList el = IssueComment.find.where().eq("issue.project.organization", (Object)organization2);
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, organization2, junction, "issue.project", containsKeywordInIssueComment);
        Search.equalsUserTemplate(keyword, user, junction, DEFAULT_PATH_TO_AUTHOR, containsKeywordInIssueComment);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<PostingComment> findPostComments(String keyword, User user, PageParam pageParam) {
        return Search.postCommentsEL(keyword, user).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countPostComments(String keyword, User user) {
        return Search.postCommentsEL(keyword, user).findRowCount();
    }

    private static ExpressionList<PostingComment> postCommentsEL(String keyword, User user) {
        ExpressionList el = PostingComment.find.where();
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, junction, "posting.project", containsKeywordInPostComment);
        Search.equalsUserTemplate(keyword, user, junction, DEFAULT_PATH_TO_AUTHOR, containsKeywordInPostComment);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<PostingComment> findPostComments(String keyword, User user, Project project2, PageParam pageParam) {
        return Search.postCommentsEL(keyword, user, project2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countPostComments(String keyword, User user, Project project2) {
        return Search.postCommentsEL(keyword, user, project2).findRowCount();
    }

    private static ExpressionList<PostingComment> postCommentsEL(String keyword, User user, Project project2) {
        ExpressionList el = PostingComment.find.where().eq("posting.project", (Object)project2);
        if (!AccessControl.isAllowed(user, project2.asResource(), Operation.READ)) {
            User user2 = user;
            Long l = null;
            l = user2.getId();
            el.eq(DEFAULT_PATH_TO_AUTHOR, (Object)l);
        }
        Search.containsKeywordIn(keyword, el.conjunction(), new String[]{"contents"});
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<PostingComment> findPostComments(String keyword, User user, Organization organization2, PageParam pageParam) {
        return Search.postCommentsEL(keyword, user, organization2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countPostComments(String keyword, User user, Organization organization2) {
        return Search.postCommentsEL(keyword, user, organization2).findRowCount();
    }

    private static ExpressionList<PostingComment> postCommentsEL(String keyword, User user, Organization organization2) {
        ExpressionList el = PostingComment.find.where().eq("posting.project.organization", (Object)organization2);
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, organization2, junction, "posting.project", containsKeywordInPostComment);
        Search.equalsUserTemplate(keyword, user, junction, DEFAULT_PATH_TO_AUTHOR, containsKeywordInPostComment);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<ReviewComment> findReviews(String keyword, User user, PageParam pageParam) {
        return Search.reviewsEL(keyword, user).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countReviews(String keyword, User user) {
        return Search.reviewsEL(keyword, user).findRowCount();
    }

    private static ExpressionList<ReviewComment> reviewsEL(String keyword, User user) {
        ExpressionList el = ReviewComment.find.where();
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, junction, "thread.project", containsKeywordInReviewComment);
        Search.equalsUserTemplate(keyword, user, junction, "author.id", containsKeywordInReviewComment);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<ReviewComment> findReviews(String keyword, User user, Project project2, PageParam pageParam) {
        return Search.reviewsEL(keyword, user, project2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countReviews(String keyword, User user, Project project2) {
        return Search.reviewsEL(keyword, user, project2).findRowCount();
    }

    private static ExpressionList<ReviewComment> reviewsEL(String keyword, User user, Project project2) {
        ExpressionList el = ReviewComment.find.where().eq("thread.project", (Object)project2);
        if (!AccessControl.isAllowed(user, project2.asResource(), Operation.READ)) {
            User user2 = user;
            Long l = null;
            l = user2.getId();
            el.eq("author.id", (Object)l);
        }
        Search.containsKeywordIn(keyword, el.conjunction(), new String[]{"contents"});
        el.orderBy().desc("createdDate");
        return el;
    }

    public static Page<ReviewComment> findReviews(String keyword, User user, Organization organization2, PageParam pageParam) {
        return Search.reviewsEL(keyword, user, organization2).findPagingList(pageParam.getSize()).getPage(pageParam.getPage());
    }

    public static int countReviews(String keyword, User user, Organization organization2) {
        return Search.reviewsEL(keyword, user, organization2).findRowCount();
    }

    private static ExpressionList<ReviewComment> reviewsEL(String keyword, User user, Organization organization2) {
        ExpressionList el = ReviewComment.find.where().eq("thread.project.organization", (Object)organization2);
        Junction junction = el.disjunction();
        Search.inProjectsTemplate(keyword, user, organization2, junction, "thread.project", containsKeywordInReviewComment);
        Search.equalsUserTemplate(keyword, user, junction, "author.id", containsKeywordInReviewComment);
        junction.endJunction();
        el.orderBy().desc("createdDate");
        return el;
    }

    private static <T> void containsKeywordIn(String keyword, Junction<T> junction, String[] fields) {
        Junction byKeyword = junction.disjunction();
        for (String field : fields) {
            byKeyword.add(Expr.icontains((String)field, (String)keyword));
        }
        byKeyword.endJunction();
    }

    private static <T> void inProjectsTemplate(String keyword, User user, Organization organization2, Junction<T> junction, String pathToProject, JunctionOperation<T> junctionOperation) {
        if (pathToProject == null) {
            pathToProject = DEFAULT_PATH_TO_PROJECT;
        }
        Junction projectAndKeyword = junction.conjunction();
        if (user.isAnonymous()) {
            projectAndKeyword.eq(pathToProject + ".projectScope", (Object)ProjectScope.PUBLIC);
        } else {
            Model model = user;
            Long l = null;
            l = model.getId();
            ExpressionList pel = Project.find.where().eq("organization", (Object)organization2).disjunction().add(Expr.eq((String)"projectUser.user.id", (Object)l));
            model = organization2;
            l = null;
            Long l2 = l = model.getId();
            model = user;
            l = null;
            l = model.getId();
            if (OrganizationUser.exist(l2, l)) {
                pel.add(Expr.in((String)"projectScope", (Object[])new ProjectScope[]{ProjectScope.PUBLIC, ProjectScope.PROTECTED}));
            } else {
                pel.add(Expr.eq((String)"projectScope", (Object)((Object)ProjectScope.PUBLIC)));
            }
            pel.endJunction();
            List projects2 = pel.findList();
            projectAndKeyword.in(pathToProject, (Collection)projects2);
        }
        junctionOperation.withJunction(keyword, projectAndKeyword);
        projectAndKeyword.endJunction();
        junction.endJunction();
    }

    private static <T> void inProjectsTemplate(String keyword, User user, Junction<T> junction, String pathToProject, JunctionOperation<T> junctionOperation) {
        if (pathToProject == null) {
            pathToProject = DEFAULT_PATH_TO_PROJECT;
        }
        Junction projectAndKeyword = junction.conjunction();
        if (user.isAnonymous()) {
            projectAndKeyword.eq(pathToProject + ".projectScope", (Object)ProjectScope.PUBLIC);
        } else {
            User user2 = user;
            Object object = null;
            object = user2.getId();
            ExpressionList pel = Project.find.where().disjunction().add(Expr.eq((String)"projectScope", (Object)((Object)ProjectScope.PUBLIC))).add(Expr.eq((String)"projectUser.user.id", (Object)object));
            user2 = user;
            object = null;
            object = user2.getLoginId();
            List<Organization> orgs = Organization.findOrganizationsByUserLoginId((String)object);
            if (!orgs.isEmpty()) {
                pel.and(Expr.in((String)"organization", orgs), Expr.ne((String)"projectScope", (Object)((Object)ProjectScope.PRIVATE)));
            }
            pel.endJunction();
            List projects2 = pel.findList();
            projectAndKeyword.in(pathToProject, (Collection)projects2);
        }
        junctionOperation.withJunction(keyword, projectAndKeyword);
        projectAndKeyword.endJunction();
    }

    private static <T> void equalsUserTemplate(String keyword, User user, Junction<T> junction, String pathToUserId, JunctionOperation<T> junctionOperation) {
        if (!user.isAnonymous()) {
            if (pathToUserId == null) {
                pathToUserId = DEFAULT_PATH_TO_AUTHOR;
            }
            Junction userAndKeyword = junction.conjunction();
            User user2 = user;
            Long l = null;
            l = user2.getId();
            userAndKeyword.eq(pathToUserId, (Object)l);
            junctionOperation.withJunction(keyword, userAndKeyword);
            userAndKeyword.endJunction();
        }
    }

    private static <T> Page<T> emptyPage() {
        return new Page<T>(){

            public List<T> getList() {
                return new ArrayList();
            }

            public int getTotalRowCount() {
                return 0;
            }

            public int getTotalPageCount() {
                return 0;
            }

            public int getPageIndex() {
                return 0;
            }

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrev() {
                return false;
            }

            public Page<T> next() {
                return null;
            }

            public Page<T> prev() {
                return null;
            }

            public String getDisplayXtoYofZ(String s, String s2) {
                return null;
            }
        };
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    static interface JunctionOperation<T> {
        public void withJunction(String var1, Junction<T> var2);
    }
}

