/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import models.Project;
import models.Role;
import models.User;
import models.enumeration.RoleType;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ProjectUser
extends Model
implements EntityBean {
    private static final long serialVersionUID = 1L;
    private static Model.Finder<Long, ProjectUser> find = new Model.Finder(Long.class, ProjectUser.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public User user;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Role role;
    private static String _EBEAN_MARKER = "models.ProjectUser";

    public ProjectUser(Long userId, Long projectId, Long roleId) {
        Model model = (User)User.find.byId((Object)userId);
        ProjectUser projectUser = this;
        projectUser.setUser((User)model);
        model = (Project)Project.find.byId((Object)projectId);
        projectUser = this;
        projectUser.setProject((Project)model);
        model = Role.findById(roleId);
        projectUser = this;
        projectUser.setRole((Role)model);
    }

    public static void create(Long userId, Long projectId, Long roleId) {
        ProjectUser projectUser = new ProjectUser(userId, projectId, roleId);
        projectUser.save();
    }

    public static void delete(Long userId, Long projectId) {
        ProjectUser projectUser = ProjectUser.findByIds(userId, projectId);
        if (projectUser != null) {
            projectUser.delete();
        }
    }

    public static void assignRole(Long userId, Long projectId, Long roleId) {
        ProjectUser projectUser = ProjectUser.findByIds(userId, projectId);
        if (projectUser == null) {
            ProjectUser.create(userId, projectId, roleId);
        } else {
            ProjectUser projectUser2 = projectUser;
            Long l = null;
            l = projectUser2.getId();
            new ProjectUser(userId, projectId, roleId).update(l);
        }
    }

    public static void assignRole(Long userId, Long projectId, RoleType roleType) {
        ProjectUser.assignRole(userId, projectId, roleType.roleType());
    }

    public static ProjectUser findByIds(Long userId, Long projectId) {
        List projectUsers = find.where().eq("user.id", (Object)userId).eq("project.id", (Object)projectId).ne("role.id", (Object)RoleType.SITEMANAGER.roleType()).findList();
        if (projectUsers.size() > 0) {
            return (ProjectUser)((Object)projectUsers.get(0));
        }
        return null;
    }

    public static List<ProjectUser> findMemberListByProject(Long projectId) {
        return find.fetch("user").fetch("role", "name").where().eq("project.id", (Object)projectId).ne("role.id", (Object)RoleType.SITEMANAGER.roleType()).orderBy("user.name ASC").findList();
    }

    public static boolean checkOneMangerPerOneProject(Long userId, Long projectId) {
        int findRowCount = find.where().eq("role.id", (Object)RoleType.MANAGER.roleType()).eq("project.id", (Object)projectId).ne("user.id", (Object)userId).findRowCount();
        return findRowCount <= 0;
    }

    public static boolean isManager(Long userId, Long projectId) {
        int findRowCount = find.where().eq("user.id", (Object)userId).eq("role.id", (Object)RoleType.MANAGER.roleType()).eq("project.id", (Object)projectId).findRowCount();
        return findRowCount != 0;
    }

    public static boolean isMember(Long userId, Long projectId) {
        if (userId == null) {
            return false;
        }
        int findRowCount = find.where().eq("user.id", (Object)userId).eq("project.id", (Object)projectId).findRowCount();
        return findRowCount != 0;
    }

    public static Map<String, String> options(Long projectId) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        Iterator<User> iterator = User.findUsersByProject(projectId).iterator();
        while (iterator.hasNext()) {
            User user;
            User user2 = user = iterator.next();
            Object object = null;
            object = user2.getId();
            String string = ((Long)object).toString();
            user2 = user;
            object = null;
            object = user2.getLoginId();
            options.put(string, (String)object);
        }
        return options;
    }

    public static ProjectUser findById(Long id) {
        return (ProjectUser)((Object)find.byId((Object)id));
    }

    public static List<ProjectUser> findAll() {
        return find.all();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAllowedToNotice(User user, Project project2) {
        if (user.isAnonymous()) {
            return false;
        }
        if (user.isSiteManager()) {
            return true;
        }
        Model model = user;
        Long l = null;
        Long l2 = l = model.getId();
        model = project2;
        l = null;
        l = model.getId();
        if (ProjectUser.isMember(l2, l)) return true;
        model = user;
        l = null;
        Long l3 = l = model.getId();
        model = project2;
        l = null;
        l = model.getId();
        if (!ProjectUser.isManager(l3, l)) return false;
        return true;
    }

    public static String roleOf(String loginId, Project project2) {
        User user = User.findByLoginId(loginId);
        return ProjectUser.roleOf(user, project2);
    }

    public static String roleOf(User user, Project project2) {
        if (user == null) {
            return RoleType.ANONYMOUS.getLowerCasedName();
        }
        if (user.isSiteManager()) {
            return RoleType.SITEMANAGER.getLowerCasedName();
        }
        if (user.isAnonymous()) {
            return RoleType.ANONYMOUS.getLowerCasedName();
        }
        Model model = user;
        Object object = null;
        object = model.getId();
        Long l = object;
        model = project2;
        object = null;
        object = model.getId();
        Role role = Role.findRoleByIds(l, (Long)object);
        if (role == null) {
            return RoleType.GUEST.getLowerCasedName();
        }
        model = role;
        object = null;
        object = model.getName();
        return ((String)object).toLowerCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAllowedToSettings(String loginId, Project project2) {
        if (loginId == null) {
            return false;
        }
        User user = User.findByLoginId(loginId);
        if (user.isAnonymous()) {
            return false;
        }
        if (user.isSiteManager()) return true;
        Model model = user;
        Long l = null;
        Long l2 = l = model.getId();
        model = project2;
        l = null;
        l = model.getId();
        if (!ProjectUser.isManager(l2, l)) return false;
        return true;
    }

    public static boolean isGuest(Project project2, User user) {
        return ProjectUser.roleOf(user, project2).equals(RoleType.GUEST.getLowerCasedName());
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public User getUser() {
        return this._ebean_get_user();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUser(User user) {
        this._ebean_set_user(user);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this._ebean_get_project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this._ebean_set_project(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Role getRole() {
        return this._ebean_get_role();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setRole(Role role) {
        this._ebean_set_role(role);
    }

    public ProjectUser() {
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected User _ebean_get_user() {
        this._ebean_intercept.preGetter("user");
        return this.user;
    }

    protected void _ebean_set_user(User newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "user", (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected User _ebean_getni_user() {
        return this.user;
    }

    protected void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
    }

    protected Project _ebean_get_project() {
        this._ebean_intercept.preGetter("project");
        return this.project;
    }

    protected void _ebean_set_project(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "project", (Object)this._ebean_get_project(), (Object)newValue);
        this.project = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_project() {
        return this.project;
    }

    protected void _ebean_setni_project(Project _newValue) {
        this.project = _newValue;
    }

    protected Role _ebean_get_role() {
        this._ebean_intercept.preGetter("role");
        return this.role;
    }

    protected void _ebean_set_role(Role newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "role", (Object)this._ebean_get_role(), (Object)newValue);
        this.role = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Role _ebean_getni_role() {
        return this.role;
    }

    protected void _ebean_setni_role(Role _newValue) {
        this.role = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        ProjectUser projectUser = new ProjectUser();
        projectUser.id = this.id;
        projectUser.user = this.user;
        projectUser.project = this.project;
        projectUser.role = this.role;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        ProjectUser p = (ProjectUser)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.user;
            }
            case 3: {
                return p.project;
            }
            case 4: {
                return p.role;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        ProjectUser p = (ProjectUser)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_user();
            }
            case 3: {
                return p._ebean_get_project();
            }
            case 4: {
                return p._ebean_get_role();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        ProjectUser p = (ProjectUser)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.user = (User)arg;
                return;
            }
            case 3: {
                p.project = (Project)arg;
                return;
            }
            case 4: {
                p.role = (Role)((Object)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        ProjectUser p = (ProjectUser)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_user((User)arg);
                return;
            }
            case 3: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 4: {
                p._ebean_set_role((Role)((Object)arg));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "user", "project", "role"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        ProjectUser projectUser = this;
        synchronized (projectUser) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((ProjectUser)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new ProjectUser();
    }
}

