/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import models.Organization;
import models.Role;
import models.User;
import models.enumeration.RoleType;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OrganizationUser
extends Model
implements EntityBean {
    private static final long serialVersionUID = -1L;
    public static final Model.Finder<Long, OrganizationUser> find = new Model.Finder(Long.class, OrganizationUser.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public User user;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Organization organization;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Role role;
    private static String _EBEAN_MARKER = "models.OrganizationUser";

    public static List<OrganizationUser> findAdminsOf(Organization organization2) {
        return find.where().eq("organization", (Object)organization2).eq("role", (Object)Role.findByName("org_admin")).findList();
    }

    public static List<OrganizationUser> findByAdmin(Long userId) {
        return find.where().eq("role", (Object)Role.findByRoleType(RoleType.ORG_ADMIN)).eq("user.id", (Object)userId).findList();
    }

    public static boolean isAdmin(Organization organization2, User user) {
        return OrganizationUser.contains(organization2, user, RoleType.ORG_ADMIN);
    }

    public static boolean isAdmin(Long organizationId, Long userId) {
        return OrganizationUser.contains(organizationId, userId, RoleType.ORG_ADMIN);
    }

    public static boolean isGuest(Organization organization2, User user) {
        return OrganizationUser.roleTypeOf(user, organization2).equals(RoleType.GUEST.name());
    }

    public static boolean isMember(Organization organization2, User user) {
        return OrganizationUser.contains(organization2, user, RoleType.ORG_MEMBER);
    }

    public static boolean isMember(Long organizationId, Long userId) {
        return OrganizationUser.contains(organizationId, userId, RoleType.ORG_MEMBER);
    }

    public static String roleTypeOf(User user, Organization organization2) {
        if (user == null) {
            return RoleType.ANONYMOUS.name();
        }
        if (user.isSiteManager()) {
            return RoleType.SITEMANAGER.name();
        }
        if (user.isAnonymous()) {
            return RoleType.ANONYMOUS.name();
        }
        Model model = user;
        Object object = null;
        object = model.getId();
        Long l = object;
        model = organization2;
        object = null;
        object = model.getId();
        Role role = Role.findOrganizationRoleByIds(l, (Long)object);
        if (role == null) {
            return RoleType.GUEST.name();
        }
        model = role;
        object = null;
        object = model.getName();
        return object;
    }

    private static boolean contains(Organization organization2, User user, RoleType roleType) {
        if (organization2 == null) {
            return false;
        }
        if (user == null || user.isAnonymous()) {
            return false;
        }
        Model model = organization2;
        Long l = null;
        Long l2 = l = model.getId();
        model = user;
        l = null;
        l = model.getId();
        return OrganizationUser.contains(l2, l, roleType);
    }

    private static boolean contains(Long organizationId, Long userId, RoleType roleType) {
        Role role = Role.findByRoleType(roleType);
        Long l = null;
        l = role.getId();
        int rowCount = find.where().eq("organization.id", (Object)organizationId).eq("user.id", (Object)userId).eq("role.id", (Object)l).findRowCount();
        return rowCount > 0;
    }

    public static void assignRole(Long userId, Long organizationId, Long roleId) {
        OrganizationUser organizationUser = OrganizationUser.findByOrganizationIdAndUserId(organizationId, userId);
        if (organizationUser == null) {
            OrganizationUser.create(userId, organizationId, roleId);
        } else {
            Role role = Role.findById(roleId);
            if (role != null) {
                Role role2 = role;
                OrganizationUser organizationUser2 = organizationUser;
                organizationUser2.setRole(role2);
                organizationUser.update();
            }
        }
    }

    public static OrganizationUser findByOrganizationIdAndUserId(Long organizationId, Long userId) {
        return (OrganizationUser)((Object)find.where().eq("user.id", (Object)userId).eq("organization.id", (Object)organizationId).findUnique());
    }

    public static void create(Long userId, Long organizationId, Long roleId) {
        OrganizationUser organizationUser = new OrganizationUser();
        Model model = (User)User.find.byId((Object)userId);
        OrganizationUser organizationUser2 = organizationUser;
        organizationUser2.setUser((User)model);
        model = (Organization)Organization.find.byId((Object)organizationId);
        organizationUser2 = organizationUser;
        organizationUser2.setOrganization((Organization)model);
        model = Role.findById(roleId);
        organizationUser2 = organizationUser;
        organizationUser2.setRole((Role)model);
        organizationUser.save();
    }

    public static void delete(Long organizationId, Long userId) {
        OrganizationUser organizationUser = OrganizationUser.findByOrganizationIdAndUserId(organizationId, userId);
        if (organizationUser != null) {
            organizationUser.delete();
        }
    }

    public static boolean exist(Long organizationId, Long userId) {
        return OrganizationUser.findByOrganizationIdAndUserId(organizationId, userId) != null;
    }

    public static List<OrganizationUser> findByUser(User user, int size) {
        return find.where().eq("user", (Object)user).order().asc("organization.name").setMaxRows(size).findList();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public User getUser() {
        return this._ebean_get_user();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUser(User user) {
        this._ebean_set_user(user);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Organization getOrganization() {
        return this._ebean_get_organization();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOrganization(Organization organization2) {
        this._ebean_set_organization(organization2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Role getRole() {
        return this._ebean_get_role();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setRole(Role role) {
        this._ebean_set_role(role);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected User _ebean_get_user() {
        this._ebean_intercept.preGetter("user");
        return this.user;
    }

    protected void _ebean_set_user(User newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "user", (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected User _ebean_getni_user() {
        return this.user;
    }

    protected void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
    }

    protected Organization _ebean_get_organization() {
        this._ebean_intercept.preGetter("organization");
        return this.organization;
    }

    protected void _ebean_set_organization(Organization newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "organization", (Object)this._ebean_get_organization(), (Object)newValue);
        this.organization = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Organization _ebean_getni_organization() {
        return this.organization;
    }

    protected void _ebean_setni_organization(Organization _newValue) {
        this.organization = _newValue;
    }

    protected Role _ebean_get_role() {
        this._ebean_intercept.preGetter("role");
        return this.role;
    }

    protected void _ebean_set_role(Role newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "role", (Object)this._ebean_get_role(), (Object)newValue);
        this.role = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Role _ebean_getni_role() {
        return this.role;
    }

    protected void _ebean_setni_role(Role _newValue) {
        this.role = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        OrganizationUser organizationUser = new OrganizationUser();
        organizationUser.id = this.id;
        organizationUser.user = this.user;
        organizationUser.organization = this.organization;
        organizationUser.role = this.role;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        OrganizationUser p = (OrganizationUser)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.user;
            }
            case 3: {
                return p.organization;
            }
            case 4: {
                return p.role;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        OrganizationUser p = (OrganizationUser)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_user();
            }
            case 3: {
                return p._ebean_get_organization();
            }
            case 4: {
                return p._ebean_get_role();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        OrganizationUser p = (OrganizationUser)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.user = (User)arg;
                return;
            }
            case 3: {
                p.organization = (Organization)arg;
                return;
            }
            case 4: {
                p.role = (Role)((Object)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        OrganizationUser p = (OrganizationUser)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_user((User)arg);
                return;
            }
            case 3: {
                p._ebean_set_organization((Organization)arg);
                return;
            }
            case 4: {
                p._ebean_set_role((Role)((Object)arg));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "user", "organization", "role"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        OrganizationUser organizationUser = this;
        synchronized (organizationUser) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((OrganizationUser)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new OrganizationUser();
    }
}

