/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.RawSqlBuilder;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanSet;
import controllers.UserApp;
import controllers.routes;
import java.beans.PropertyChangeEvent;
import java.beans.Transient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.LimitExceededException;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.servlet.ServletException;
import models.AbstractPosting;
import models.Assignee;
import models.CodeCommentThread;
import models.CodeRange;
import models.Comment;
import models.CommentThread;
import models.CommitComment;
import models.Issue;
import models.IssueComment;
import models.IssueSharer;
import models.Milestone;
import models.NonRangedCodeCommentThread;
import models.NotificationMail;
import models.Organization;
import models.OrganizationUser;
import models.Posting;
import models.Project;
import models.ProjectUser;
import models.PullRequest;
import models.PullRequestCommit;
import models.ReviewComment;
import models.User;
import models.UserIdent;
import models.UserProjectNotification;
import models.Watch;
import models.Webhook;
import models.enumeration.EventType;
import models.enumeration.Operation;
import models.enumeration.PullRequestReviewAction;
import models.enumeration.RequestState;
import models.enumeration.ResourceType;
import models.enumeration.RoleType;
import models.enumeration.State;
import models.enumeration.UserState;
import models.enumeration.WebhookType;
import models.resource.GlobalResource;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import notification.INotificationEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.joda.time.DateTime;
import org.tmatesoft.svn.core.SVNException;
import play.Logger;
import play.api.i18n.Lang;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.i18n.Messages;
import play.libs.Akka;
import play.libs.F;
import playRepository.Commit;
import playRepository.DiffLine;
import playRepository.FileDiff;
import playRepository.GitCommit;
import playRepository.GitRepository;
import playRepository.Hunk;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import utils.AccessControl;
import utils.DiffUtil;
import utils.EventConstants;
import utils.RouteUtil;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class NotificationEvent
extends Model
implements INotificationEvent,
EntityBean {
    private static final long serialVersionUID = 1L;
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    public static final Model.Finder<Long, NotificationEvent> find = new Model.Finder(Long.class, NotificationEvent.class);
    @PropertiesEnhancer.GeneratedSetAccessor
    public String title;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long senderId;
    @ManyToMany(cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    public Set<User> receivers;
    @Temporal(value=TemporalType.TIMESTAMP)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date created;
    @Enumerated(value=EnumType.STRING)
    @PropertiesEnhancer.GeneratedSetAccessor
    public ResourceType resourceType;
    @PropertiesEnhancer.GeneratedSetAccessor
    public String resourceId;
    @Enumerated(value=EnumType.STRING)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public EventType eventType;
    @Lob
    @Basic(fetch=FetchType.EAGER)
    @PropertiesEnhancer.GeneratedSetAccessor
    public String oldValue;
    @Lob
    @Basic(fetch=FetchType.EAGER)
    @PropertiesEnhancer.GeneratedSetAccessor
    public String newValue;
    @OneToOne(mappedBy="notificationEvent", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public NotificationMail notificationMail;
    private static String _EBEAN_MARKER = "models.NotificationEvent";

    @Override
    public Set<User> findReceivers() {
        NotificationEvent notificationEvent = this;
        Long l = null;
        l = notificationEvent.getId();
        String sql = "select n4user.id from n4user where id in (select n4user_id from notification_event_n4user where notification_event_id = '" + l + "')";
        return User.find.setRawSql(RawSqlBuilder.parse((String)sql).create()).findSet();
    }

    @Override
    public void setReceivers(Set<User> receivers) {
        throw new UnsupportedOperationException();
    }

    public String getOldValue() {
        return this._ebean_get_oldValue();
    }

    public String getNewValue() {
        return this._ebean_get_newValue();
    }

    @Transient
    public String getMessage() {
        return this.getMessage(Lang.defaultLang());
    }

    @Override
    @Transient
    public String getMessage(Lang lang) {
        Model model = this;
        Object object = null;
        object = model.getEventType();
        switch (3.$SwitchMap$models$enumeration$EventType[((Enum)object).ordinal()]) {
            case 1: {
                if (this._ebean_get_newValue().equals(State.CLOSED.state())) {
                    return Messages.get((Lang)lang, (String)"notification.issue.closed", (Object[])new Object[0]);
                }
                return Messages.get((Lang)lang, (String)"notification.issue.reopened", (Object[])new Object[0]);
            }
            case 2: {
                if (this._ebean_get_newValue() == null) {
                    return Messages.get((Lang)lang, (String)"notification.issue.unassigned", (Object[])new Object[0]);
                }
                return Messages.get((Lang)lang, (String)"notification.issue.assigned", (Object[])new Object[]{this._ebean_get_newValue()});
            }
            case 3: {
                if (Milestone.findById(Long.parseLong(this._ebean_get_newValue())) == null) {
                    return Messages.get((Lang)lang, (String)"notification.milestone.changed", (Object[])new Object[]{Messages.get((Lang)Lang.defaultLang(), (String)"issue.noMilestone", (Object[])new Object[0])});
                }
                Object[] objectArray = new Object[1];
                model = Milestone.findById(Long.parseLong(this._ebean_get_newValue()));
                object = null;
                objectArray[0] = object = model.getTitle();
                return Messages.get((Lang)lang, (String)"notification.milestone.changed", (Object[])objectArray);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this._ebean_get_newValue();
            }
            case 9: {
                return this._ebean_get_newValue() + this._ebean_get_oldValue();
            }
            case 10: 
            case 11: {
                return DiffUtil.getDiffText(this._ebean_get_oldValue(), this._ebean_get_newValue());
            }
            case 12: {
                try {
                    ReviewComment reviewComment = (ReviewComment)ReviewComment.find.byId((Object)Long.valueOf(this._ebean_get_resourceId()));
                    if (reviewComment != null) {
                        return NotificationEvent.buildCommentedCodeMessage(reviewComment, lang);
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"Failed to generate a notification message for a review comment", (Throwable)e);
                }
                return this._ebean_get_newValue();
            }
            case 13: {
                if (State.OPEN.state().equals(this._ebean_get_newValue())) {
                    return Messages.get((Lang)lang, (String)"notification.pullrequest.reopened", (Object[])new Object[0]);
                }
                return Messages.get((Lang)lang, (String)("notification.pullrequest." + this._ebean_get_newValue()), (Object[])new Object[0]);
            }
            case 14: {
                return this._ebean_get_newValue();
            }
            case 15: {
                return Messages.get((Lang)lang, (String)("notification.type.pullrequest.merged." + this._ebean_get_newValue()), (Object[])new Object[0]) + "\n" + StringUtils.defaultString((String)this._ebean_get_oldValue(), (String)"");
            }
            case 16: {
                if (RequestState.REQUEST.name().equals(this._ebean_get_newValue())) {
                    return Messages.get((Lang)lang, (String)"notification.member.enroll.request", (Object[])new Object[0]);
                }
                if (RequestState.ACCEPT.name().equals(this._ebean_get_newValue())) {
                    return Messages.get((Lang)lang, (String)"notification.member.enroll.accept", (Object[])new Object[0]);
                }
                return Messages.get((Lang)lang, (String)"notification.member.enroll.cancel", (Object[])new Object[0]);
            }
            case 17: {
                if (RequestState.REQUEST.name().equals(this._ebean_get_newValue())) {
                    return Messages.get((Lang)lang, (String)"notification.organization.member.enroll.request", (Object[])new Object[0]);
                }
                if (RequestState.ACCEPT.name().equals(this._ebean_get_newValue())) {
                    return Messages.get((Lang)lang, (String)"notification.organization.member.enroll.accept", (Object[])new Object[0]);
                }
                return Messages.get((Lang)lang, (String)"notification.organization.member.enroll.cancel", (Object[])new Object[0]);
            }
            case 18: {
                if (PullRequestReviewAction.DONE.name().equals(this._ebean_get_newValue())) {
                    Object[] objectArray = new Object[1];
                    model = this;
                    object = null;
                    object = model.getSenderId();
                    model = (User)User.find.byId(object);
                    object = null;
                    objectArray[0] = object = model.getLoginId();
                    return Messages.get((Lang)lang, (String)"notification.pullrequest.reviewed", (Object[])objectArray);
                }
                Object[] objectArray = new Object[1];
                model = this;
                object = null;
                object = model.getSenderId();
                model = (User)User.find.byId(object);
                object = null;
                objectArray[0] = object = model.getLoginId();
                return Messages.get((Lang)lang, (String)"notification.pullrequest.unreviewed", (Object[])objectArray);
            }
            case 19: {
                if (this._ebean_get_newValue().equals(CommentThread.ThreadState.CLOSED.name())) {
                    return Messages.get((Lang)lang, (String)"notification.reviewthread.closed", (Object[])new Object[0]);
                }
                return Messages.get((Lang)lang, (String)"notification.reviewthread.reopened", (Object[])new Object[0]);
            }
            case 20: {
                return Messages.get((Lang)lang, (String)"notification.type.issue.moved", (Object[])new Object[]{this._ebean_get_oldValue(), this._ebean_get_newValue()});
            }
            case 21: {
                if (StringUtils.isNotBlank((CharSequence)this._ebean_get_newValue())) {
                    User user = User.findByLoginId(this._ebean_get_newValue());
                    return Messages.get((Lang)lang, (String)"notification.issue.sharer.added", (Object[])new Object[]{user.getDisplayName(user)});
                }
                if (StringUtils.isNotBlank((CharSequence)this._ebean_get_oldValue())) {
                    return Messages.get((Lang)lang, (String)"notification.issue.sharer.deleted", (Object[])new Object[0]);
                }
            }
            case 22: {
                if (StringUtils.isNotBlank((CharSequence)this._ebean_get_newValue())) {
                    User user = User.findByLoginId(this._ebean_get_newValue());
                    return Messages.get((Lang)lang, (String)"notification.issue.label.added", (Object[])new Object[]{user.getDisplayName(user)});
                }
                if (StringUtils.isNotBlank((CharSequence)this._ebean_get_oldValue())) {
                    return Messages.get((Lang)lang, (String)"notification.issue.label.deleted", (Object[])new Object[0]);
                }
            }
            case 23: {
                User user = User.findByLoginId(this._ebean_get_newValue());
                return Messages.get((Lang)lang, (String)"notification.resource.deleted", (Object[])new Object[]{user.getDisplayName(user)});
            }
        }
        Logger.warn((String)("Unknown event message: " + this));
        model = this;
        object = null;
        object = model.getEventType();
        Logger.warn((String)("Event Type: " + object));
        Logger.warn((String)"See: NotificationEvent.getMessage");
        model = this;
        object = null;
        object = model.getEventType();
        return ((EventType)((Object)object)).getDescr();
    }

    @Transient
    public String getPlainMessage() {
        return this.getPlainMessage(Lang.defaultLang());
    }

    @Override
    @Transient
    public String getPlainMessage(Lang lang) {
        NotificationEvent notificationEvent = this;
        EventType eventType = null;
        eventType = notificationEvent.getEventType();
        switch (eventType) {
            case ISSUE_BODY_CHANGED: 
            case POSTING_BODY_CHANGED: {
                return DiffUtil.getDiffPlainText(this._ebean_get_oldValue(), this._ebean_get_newValue());
            }
        }
        return this.getMessage(lang).replaceAll("\n\n<br />\n", "\n\n");
    }

    private static String buildCommentedCodeMessage(ReviewComment reviewComment, Lang lang) throws IOException {
        List<FileDiff> diffs;
        PlayRepository repo;
        List<DiffLine> list2;
        Object object;
        block18: {
            block17: {
                object = reviewComment;
                list2 = null;
                list2 = ((ReviewComment)object).getThread();
                if (list2 == null) break block17;
                object = reviewComment;
                list2 = null;
                list2 = ((ReviewComment)object).getThread();
                if (!((CommentThread)((Object)list2)).getFirstReviewComment().equals(reviewComment)) break block17;
                object = reviewComment;
                list2 = null;
                list2 = ((ReviewComment)object).getThread();
                if (list2 instanceof CodeCommentThread) break block18;
            }
            return reviewComment.getContents();
        }
        object = reviewComment;
        list2 = null;
        list2 = ((ReviewComment)object).getThread();
        CodeCommentThread thread = (CodeCommentThread)((Object)list2);
        try {
            object = thread;
            list2 = null;
            list2 = ((CommentThread)object).getProject();
            repo = RepositoryService.getRepository((Project)((Object)list2));
        }
        catch (Exception e) {
            Logger.error((String)"Failed to get the repository", (Throwable)e);
            return reviewComment.getContents();
        }
        object = thread;
        list2 = null;
        list2 = ((CodeCommentThread)object).getCodeRange();
        List<DiffLine> codeRange = list2;
        object = thread;
        list2 = null;
        list2 = ((CodeCommentThread)object).getPrevCommitId();
        if (list2 == null) {
            object = thread;
            list2 = null;
            list2 = ((CodeCommentThread)object).getCommitId();
            diffs = repo.getDiff((String)((Object)list2));
        } else {
            object = thread;
            list2 = null;
            list2 = ((CodeCommentThread)object).getPrevCommitId();
            List<DiffLine> list3 = list2;
            object = thread;
            list2 = null;
            list2 = ((CodeCommentThread)object).getCommitId();
            diffs = repo.getDiff((String)((Object)list3), (String)((Object)list2));
        }
        for (FileDiff diff2 : diffs) {
            if (!((CodeRange)((Object)codeRange)).isFor(diff2)) continue;
            StringBuilder message = new StringBuilder();
            Object[] objectArray = new Object[1];
            object = codeRange;
            list2 = null;
            list2 = ((CodeRange)object).getPath();
            objectArray[0] = list2;
            message.append(Messages.get((Lang)lang, (String)"notification.reviewthread.inTheFile", (Object[])objectArray));
            message.append("\n");
            object = codeRange;
            list2 = null;
            list2 = ((CodeRange)object).getEndLine();
            diff2.setInterestLine((Integer)((Object)list2));
            object = codeRange;
            list2 = null;
            list2 = ((CodeRange)object).getEndSide();
            diff2.setInterestSide((CodeRange.Side)((Object)list2));
            FileDiff.Hunks hunks = diff2.getHunks();
            if (hunks != null) {
                message.append("```diff\n");
                for (Hunk hunk : hunks) {
                    Object[] objectArray2 = new Object[4];
                    object = hunk;
                    int n = 0;
                    n = ((Hunk)object).getBeginA();
                    objectArray2[0] = n + 1;
                    object = hunk;
                    n = 0;
                    int n2 = n = ((Hunk)object).getEndA();
                    object = hunk;
                    n = 0;
                    n = ((Hunk)object).getBeginA();
                    objectArray2[1] = n2 - n;
                    object = hunk;
                    n = 0;
                    n = ((Hunk)object).getBeginB();
                    objectArray2[2] = n + 1;
                    object = hunk;
                    n = 0;
                    int n3 = n = ((Hunk)object).getEndB();
                    object = hunk;
                    n = 0;
                    n = ((Hunk)object).getBeginB();
                    objectArray2[3] = n3 - n;
                    message.append(String.format("> @@ -%d, %d +%d, %d @@\n", objectArray2));
                    object = hunk;
                    list2 = null;
                    list2 = ((Hunk)object).getLines();
                    for (DiffLine line : list2) {
                        message.append("> ");
                        switch (line.kind) {
                            case CONTEXT: {
                                message.append(" ");
                                break;
                            }
                            case ADD: {
                                message.append("+");
                                break;
                            }
                            case REMOVE: {
                                message.append("-");
                            }
                        }
                        message.append(line.content + "\n");
                        if (!((CodeRange)((Object)codeRange)).endsWith(line)) continue;
                        message.append("```\n");
                        message.append("\n" + reviewComment.getContents() + "\n\n");
                        message.append("```diff\n");
                    }
                }
                message.append("```\n");
            } else {
                message.append(reviewComment.getContents());
            }
            return message.toString();
        }
        return reviewComment.getContents();
    }

    @Override
    public User getSender() {
        NotificationEvent notificationEvent = this;
        Long l = null;
        l = notificationEvent.getSenderId();
        return (User)User.find.byId((Object)l);
    }

    @Override
    public Resource getResource() {
        return Resource.get(this._ebean_get_resourceType(), this._ebean_get_resourceId());
    }

    public Project getProject() {
        switch (this._ebean_get_resourceType()) {
            case ISSUE_ASSIGNEE: {
                Assignee assignee = (Assignee)((Object)Assignee.finder.byId((Object)Long.valueOf(this._ebean_get_resourceId())));
                Project project2 = null;
                project2 = assignee.getProject();
                return project2;
            }
            case PROJECT: {
                return (Project)Project.find.byId((Object)Long.valueOf(this._ebean_get_resourceId()));
            }
        }
        Resource resource = this.getResource();
        if (resource != null) {
            if (resource instanceof GlobalResource) {
                return null;
            }
            return resource.getProject();
        }
        return null;
    }

    public Organization getOrganization() {
        switch (this._ebean_get_resourceType()) {
            case ORGANIZATION: {
                return (Organization)Organization.find.byId((Object)Long.valueOf(this._ebean_get_resourceId()));
            }
        }
        return null;
    }

    @Override
    public boolean resourceExists() {
        return Resource.exists(this._ebean_get_resourceType(), this._ebean_get_resourceId());
    }

    public static void add(NotificationEvent event) {
        Model model = event;
        Object object = null;
        object = model.getNotificationMail();
        if (object == null) {
            object = new NotificationMail();
            model = event;
            model.setNotificationMail((NotificationMail)((Object)object));
            model = event;
            object = null;
            object = model.getNotificationMail();
            NotificationMail notificationMail2 = object;
            object = event;
            model = notificationMail2;
            model.setNotificationEvent((NotificationEvent)object);
        }
        Date draftDate = DateTime.now().minusMillis(EventConstants.DRAFT_TIME_IN_MILLIS).toDate();
        NotificationEvent lastEvent = (NotificationEvent)find.where().eq("resourceId", (Object)event.resourceId).eq("resourceType", (Object)event.resourceType).gt("created", (Object)draftDate).orderBy("id desc").setMaxRows(1).findUnique();
        if (lastEvent != null && NotificationEvent.isSameUserEventAsPrevious(event, lastEvent)) {
            object = lastEvent.getOldValue();
            model = event;
            model.setOldValue((String)object);
            lastEvent.delete();
            if (StringUtils.equals((CharSequence)event.oldValue, (CharSequence)event.newValue)) {
                return;
            }
        }
        NotificationEvent.filterReceivers(event);
        model = event;
        object = null;
        object = model.getReceivers();
        if (object.isEmpty()) {
            return;
        }
        event.save();
        event.saveManyToManyAssociations("receivers");
    }

    public static void addWithoutSkipEvent(NotificationEvent event) {
        Model model = event;
        Object object = null;
        object = model.getNotificationMail();
        if (object == null) {
            object = new NotificationMail();
            model = event;
            model.setNotificationMail((NotificationMail)((Object)object));
            model = event;
            object = null;
            object = model.getNotificationMail();
            NotificationMail notificationMail2 = object;
            object = event;
            model = notificationMail2;
            model.setNotificationEvent((NotificationEvent)object);
        }
        Date draftDate = DateTime.now().minusMillis(EventConstants.DRAFT_TIME_IN_MILLIS).toDate();
        NotificationEvent lastEvent = (NotificationEvent)find.where().eq("resourceId", (Object)event.resourceId).eq("resourceType", (Object)event.resourceType).gt("created", (Object)draftDate).orderBy("id desc").setMaxRows(1).findUnique();
        if (lastEvent != null && NotificationEvent.isSameUserEventAsPrevious(event, lastEvent) && NotificationEvent.isRevertingTheValue(event, lastEvent)) {
            lastEvent.delete();
            return;
        }
        if (NotificationEvent.isAddingSharerEvent(event)) {
            NotificationEvent.filterReceivers(event);
        }
        model = event;
        object = null;
        object = model.getReceivers();
        if (object.isEmpty()) {
            return;
        }
        event.save();
        event.saveManyToManyAssociations("receivers");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSameUserEventAsPrevious(NotificationEvent event, NotificationEvent lastEvent) {
        NotificationEvent notificationEvent = lastEvent;
        Object var3_3 = null;
        EventType eventType = notificationEvent.getEventType();
        notificationEvent = event;
        Object var3_5 = null;
        EventType eventType2 = notificationEvent.getEventType();
        if (eventType != eventType2) return false;
        notificationEvent = event;
        Object var3_7 = null;
        Long l = notificationEvent.getSenderId();
        notificationEvent = lastEvent;
        Object var3_9 = null;
        Long l2 = notificationEvent.getSenderId();
        if (!l.equals(l2)) return false;
        return true;
    }

    private static boolean isRevertingTheValue(NotificationEvent event, NotificationEvent lastEvent) {
        return StringUtils.equals((CharSequence)event.oldValue, (CharSequence)lastEvent.newValue) && StringUtils.equals((CharSequence)event.newValue, (CharSequence)lastEvent.oldValue);
    }

    private static boolean isAddingSharerEvent(NotificationEvent event) {
        NotificationEvent notificationEvent = event;
        EventType eventType = null;
        eventType = notificationEvent.getEventType();
        return eventType.equals((Object)EventType.ISSUE_SHARER_CHANGED) && StringUtils.isBlank((CharSequence)event.oldValue) && StringUtils.isNotBlank((CharSequence)event.newValue);
    }

    private static void filterReceivers(final NotificationEvent event) {
        final Project project2 = event.getProject();
        if (project2 == null) {
            return;
        }
        final Resource resource = project2.asResource();
        NotificationEvent notificationEvent = event;
        Set<User> set = null;
        set = notificationEvent.getReceivers();
        CollectionUtils.filter(set, (Predicate)new Predicate(){

            public boolean evaluate(Object obj) {
                User receiver = (User)obj;
                Model model = receiver;
                Object object = null;
                object = model.getLoginId();
                if (object == null) {
                    return false;
                }
                if (!AccessControl.isAllowed(receiver, event.getResource(), Operation.READ)) {
                    return false;
                }
                if (!Watch.isWatching(receiver, resource)) {
                    return true;
                }
                model = event;
                object = null;
                object = model.getEventType();
                return UserProjectNotification.isEnabledNotiType(receiver, project2, (EventType)((Object)object));
            }
        });
    }

    public static void deleteBy(Resource resource) {
        for (NotificationEvent event : find.where().where().eq("resourceType", (Object)resource.getType()).eq("resourceId", (Object)resource.getId()).findList()) {
            event.delete();
        }
    }

    public static NotificationEvent afterNewPullRequest(User sender, PullRequest pullRequest2) {
        NotificationEvent notiEvent = NotificationEvent.createFrom(sender, pullRequest2);
        Object object = NotificationEvent.formatNewTitle(pullRequest2);
        Model model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getReceiversWithRelatedAuthors(sender, pullRequest2);
        object = EventType.NEW_PULL_REQUEST;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = null;
        model = notiEvent;
        model.setOldValue((String)object);
        model = pullRequest2;
        object = null;
        object = model.getBody();
        model = notiEvent;
        model.setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        return notiEvent;
    }

    @Override
    public String getUrlToView() {
        Model model = this;
        Object object = null;
        object = model.getEventType();
        switch (object) {
            case MEMBER_ENROLL_REQUEST: {
                if (this.getProject() == null) {
                    return null;
                }
                model = this.getProject();
                object = null;
                Object object2 = object = model.getOwner();
                model = this.getProject();
                object = null;
                object = model.getName();
                return routes.ProjectApp.members((String)object2, (String)object).url();
            }
            case MEMBER_ENROLL_ACCEPT: {
                if (this.getProject() == null) {
                    return null;
                }
                model = this.getProject();
                object = null;
                Object object3 = object = model.getOwner();
                model = this.getProject();
                object = null;
                object = model.getName();
                return routes.ProjectApp.project((String)object3, (String)object).url();
            }
            case ORGANIZATION_MEMBER_ENROLL_REQUEST: {
                Organization organization2 = this.getOrganization();
                if (organization2 == null) {
                    return null;
                }
                model = organization2;
                object = null;
                object = model.getName();
                return routes.OrganizationApp.members((String)object).url();
            }
            case ORGANIZATION_MEMBER_ENROLL_ACCEPT: {
                Organization organization3 = this.getOrganization();
                if (organization3 == null) {
                    return null;
                }
                model = organization3;
                object = null;
                object = model.getName();
                return routes.OrganizationApp.organization((String)object).url();
            }
            case NEW_COMMIT: {
                if (this.getProject() == null) {
                    return null;
                }
                model = this.getProject();
                object = null;
                Object object4 = object = model.getOwner();
                model = this.getProject();
                object = null;
                object = model.getName();
                return routes.CodeHistoryApp.historyUntilHead((String)object4, (String)object).url();
            }
        }
        return RouteUtil.getUrl(this._ebean_get_resourceType(), this._ebean_get_resourceId());
    }

    @Override
    public Date getCreatedDate() {
        NotificationEvent notificationEvent = this;
        Date date = null;
        date = notificationEvent.getCreated();
        return date;
    }

    @Override
    public String getTitle() {
        return this._ebean_get_title();
    }

    @Override
    public EventType getType() {
        NotificationEvent notificationEvent = this;
        EventType eventType = null;
        eventType = notificationEvent.getEventType();
        return eventType;
    }

    @Override
    public ResourceType getResourceType() {
        return this._ebean_get_resourceType();
    }

    @Override
    public String getResourceId() {
        return this._ebean_get_resourceId();
    }

    private static void webhookRequest(EventType eventTypes, PullRequest pullRequest2) {
        List<Webhook> list2;
        Object object;
        Object object2;
        if (eventTypes == EventType.PULL_REQUEST_MERGED) {
            object2 = pullRequest2;
            object = null;
            object2 = object = ((PullRequest)object2).getToProject();
            object = null;
            object = ((Project)object2).getId();
            list2 = Webhook.findByProject((Long)object);
        } else {
            object2 = pullRequest2;
            object = null;
            object = ((PullRequest)object2).getToProjectId();
            list2 = Webhook.findByProject((Long)object);
        }
        List<Webhook> webhookList = list2;
        for (Webhook webhook : webhookList) {
            object2 = webhook;
            object = null;
            object = ((Webhook)object2).getWebhookType();
            if (object == WebhookType.JSON) continue;
            webhook.sendRequestToPayloadUrl(eventTypes, UserApp.currentUser(), pullRequest2);
        }
    }

    private static void webhookRequest(EventType eventTypes, PullRequest pullRequest2, PullRequestReviewAction reviewAction) {
        Model model = pullRequest2;
        Object object = null;
        object = model.getToProject();
        model = object;
        object = null;
        object = model.getId();
        List<Webhook> webhookList = Webhook.findByProject((Long)object);
        for (Webhook webhook : webhookList) {
            model = webhook;
            object = null;
            object = model.getWebhookType();
            if (object == WebhookType.JSON) continue;
            webhook.sendRequestToPayloadUrl(eventTypes, UserApp.currentUser(), pullRequest2, reviewAction);
        }
    }

    private static void webhookRequest(EventType eventTypes, Issue issue2) {
        Model model = issue2;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getId();
        List<Webhook> webhookList = Webhook.findByProject((Long)object);
        for (Webhook webhook : webhookList) {
            model = webhook;
            object = null;
            object = model.getWebhookType();
            if (object == WebhookType.JSON) continue;
            webhook.sendRequestToPayloadUrl(eventTypes, UserApp.currentUser(), issue2);
        }
    }

    private static void webhookRequest(EventType eventTypes, Issue issue2, Project previous) {
        Model model = issue2;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getId();
        List<Webhook> webhookList = Webhook.findByProject((Long)object);
        for (Webhook webhook : webhookList) {
            model = webhook;
            object = null;
            object = model.getWebhookType();
            if (object == WebhookType.JSON) continue;
            webhook.sendRequestToPayloadUrl(eventTypes, UserApp.currentUser(), issue2, previous);
        }
    }

    private static void webhookRequest(EventType eventTypes, Posting post2) {
        Model model = post2;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getId();
        List<Webhook> webhookList = Webhook.findByProject((Long)object);
        for (Webhook webhook : webhookList) {
            model = webhook;
            object = null;
            object = model.getWebhookType();
            if (object == WebhookType.JSON) continue;
            webhook.sendRequestToPayloadUrl(eventTypes, UserApp.currentUser(), post2);
        }
    }

    private static void webhookRequest(EventType eventTypes, Comment comment) {
        Model model = comment;
        Object object = null;
        object = model.getProjectId();
        List<Webhook> webhookList = Webhook.findByProject(object);
        for (Webhook webhook : webhookList) {
            model = webhook;
            object = null;
            object = model.getWebhookType();
            if (object == WebhookType.JSON) continue;
            webhook.sendRequestToPayloadUrl(eventTypes, UserApp.currentUser(), comment);
        }
    }

    private static void webhookRequest(EventType eventTypes, PullRequest pullRequest2, ReviewComment reviewComment) {
        Model model = pullRequest2;
        Object object = null;
        object = model.getToProject();
        model = object;
        object = null;
        object = model.getId();
        List<Webhook> webhookList = Webhook.findByProject((Long)object);
        for (Webhook webhook : webhookList) {
            model = webhook;
            object = null;
            object = model.getWebhookType();
            if (object == WebhookType.JSON) continue;
            webhook.sendRequestToPayloadUrl(eventTypes, UserApp.currentUser(), pullRequest2, reviewComment);
        }
    }

    private static void webhookRequest(Project project2, List<RevCommit> commits, List<String> refNames, User sender, String title) {
        Model model = project2;
        Object object = null;
        object = model.getId();
        List<Webhook> webhookList = Webhook.findByProject(object);
        for (Webhook webhook : webhookList) {
            model = webhook;
            object = null;
            object = model.getWebhookType();
            if (object == WebhookType.JSON) {
                webhook.sendRequestToPayloadUrl(commits, refNames, sender);
                continue;
            }
            model = webhook;
            object = null;
            object = model.getGitPush();
            if (!((Boolean)object).booleanValue()) continue;
            webhook.sendRequestToPayloadUrl(commits, refNames, sender, title);
        }
    }

    public static NotificationEvent afterPullRequestUpdated(User sender, PullRequest pullRequest2, State oldState, State newState) {
        NotificationEvent notiEvent = NotificationEvent.createFrom(sender, pullRequest2);
        Object object = NotificationEvent.formatReplyTitle(pullRequest2);
        NotificationEvent notificationEvent = notiEvent;
        notificationEvent.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getReceivers(sender, pullRequest2);
        object = EventType.PULL_REQUEST_STATE_CHANGED;
        notificationEvent = notiEvent;
        notificationEvent.setEventType((EventType)((Object)object));
        object = oldState.state();
        notificationEvent = notiEvent;
        notificationEvent.setOldValue((String)object);
        object = newState.state();
        notificationEvent = notiEvent;
        notificationEvent.setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        if (newState == State.MERGED) {
            NotificationEvent.webhookRequest(EventType.PULL_REQUEST_MERGED, pullRequest2);
        }
        return notiEvent;
    }

    public static NotificationEvent afterPullRequestCommitChanged(User sender, PullRequest pullRequest2) {
        NotificationEvent notiEvent = NotificationEvent.createFrom(sender, pullRequest2);
        Object object = NotificationEvent.formatReplyTitle(pullRequest2);
        NotificationEvent notificationEvent = notiEvent;
        notificationEvent.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getReceivers(sender, pullRequest2);
        object = EventType.PULL_REQUEST_COMMIT_CHANGED;
        notificationEvent = notiEvent;
        notificationEvent.setEventType((EventType)((Object)object));
        object = null;
        notificationEvent = notiEvent;
        notificationEvent.setOldValue((String)object);
        object = NotificationEvent.newPullRequestCommitChangedMessage(pullRequest2);
        notificationEvent = notiEvent;
        notificationEvent.setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        NotificationEvent.webhookRequest(EventType.PULL_REQUEST_COMMIT_CHANGED, pullRequest2);
        return notiEvent;
    }

    private static String newPullRequestCommitChangedMessage(PullRequest pullRequest2) {
        List commits = PullRequestCommit.find.where().eq("pullRequest", (Object)pullRequest2).orderBy().desc("authorDate").findList();
        StringBuilder builder = new StringBuilder();
        builder.append("### ");
        builder.append(Messages.get((String)"notification.pullrequest.current.commits", (Object[])new Object[0]));
        builder.append("\n");
        Iterator iterator = commits.iterator();
        while (iterator.hasNext()) {
            PullRequestCommit commit;
            PullRequestCommit pullRequestCommit = commit = (PullRequestCommit)iterator.next();
            PullRequestCommit.State state = null;
            state = pullRequestCommit.getState();
            if (state != PullRequestCommit.State.CURRENT) continue;
            builder.append(commit.getCommitShortId());
            builder.append(" ");
            builder.append(commit.getCommitShortMessage());
            builder.append("\n");
        }
        return builder.toString();
    }

    public static NotificationEvent afterMerge(User sender, PullRequest pullRequest2, State state) {
        NotificationEvent notiEvent = NotificationEvent.createFrom(sender, pullRequest2);
        Object object = NotificationEvent.formatReplyTitle(pullRequest2);
        NotificationEvent notificationEvent = notiEvent;
        notificationEvent.setTitle((String)object);
        notiEvent.receivers = state == State.MERGED ? NotificationEvent.getReceiversWithRelatedAuthors(sender, pullRequest2) : NotificationEvent.getReceivers(sender, pullRequest2);
        object = EventType.PULL_REQUEST_MERGED;
        notificationEvent = notiEvent;
        notificationEvent.setEventType((EventType)((Object)object));
        object = state.state();
        notificationEvent = notiEvent;
        notificationEvent.setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        return notiEvent;
    }

    public static void afterNewComment(User sender, PullRequest pullRequest2, ReviewComment newComment2, String urlToView) {
        NotificationEvent.add(NotificationEvent.forNewComment(sender, pullRequest2, newComment2));
    }

    public static NotificationEvent forNewComment(User sender, PullRequest pullRequest2, ReviewComment newComment2) {
        NotificationEvent.webhookRequest(EventType.NEW_REVIEW_COMMENT, pullRequest2, newComment2);
        NotificationEvent notiEvent = NotificationEvent.createFrom(sender, newComment2);
        Object object = NotificationEvent.formatReplyTitle(pullRequest2);
        Object object2 = notiEvent;
        ((NotificationEvent)object2).setTitle((String)object);
        Set<User> receivers = NotificationEvent.getMentionedUsers(newComment2.getContents());
        receivers.addAll(NotificationEvent.getReceivers(sender, pullRequest2));
        object2 = newComment2;
        object = null;
        object2 = object = ((ReviewComment)object2).getAuthor();
        object = null;
        object = ((UserIdent)object2).getLoginId();
        receivers.remove(User.findByLoginId((String)object));
        notiEvent.receivers = receivers;
        object = EventType.NEW_REVIEW_COMMENT;
        object2 = notiEvent;
        ((NotificationEvent)object2).setEventType((EventType)((Object)object));
        object = null;
        object2 = notiEvent;
        ((NotificationEvent)object2).setOldValue((String)object);
        object = newComment2.getContents();
        object2 = notiEvent;
        ((NotificationEvent)object2).setNewValue((String)object);
        return notiEvent;
    }

    public static NotificationEvent afterNewPullRequest(PullRequest pullRequest2) {
        NotificationEvent.webhookRequest(EventType.NEW_PULL_REQUEST, pullRequest2);
        return NotificationEvent.afterNewPullRequest(UserApp.currentUser(), pullRequest2);
    }

    public static NotificationEvent afterPullRequestUpdated(PullRequest pullRequest2, State oldState, State newState) {
        return NotificationEvent.afterPullRequestUpdated(UserApp.currentUser(), pullRequest2, oldState, newState);
    }

    public static void afterNewComment(Comment comment) {
        NotificationEvent.webhookRequest(EventType.NEW_COMMENT, comment);
        NotificationEvent.add(NotificationEvent.forNewComment(comment, UserApp.currentUser()));
    }

    public static NotificationEvent forComment(Comment comment, User author, EventType eventType) {
        AbstractPosting post2 = comment.getParent();
        NotificationEvent notiEvent = NotificationEvent.createFrom(author, comment);
        Object object = NotificationEvent.formatReplyTitle(post2);
        Model model = notiEvent;
        model.setTitle((String)object);
        object = eventType;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        notiEvent.receivers = NotificationEvent.getMandatoryReceivers(comment, eventType);
        model = comment;
        object = null;
        object = model.getPreviousContents();
        model = notiEvent;
        model.setOldValue((String)object);
        model = comment;
        object = null;
        object = model.getContents();
        model = notiEvent;
        model.setNewValue((String)object);
        object = comment.asResource().getType();
        model = notiEvent;
        model.setResourceType((ResourceType)((Object)object));
        object = comment.asResource().getId();
        model = notiEvent;
        model.setResourceId((String)object);
        return notiEvent;
    }

    public static NotificationEvent forUpdatedComment(Comment comment, User author) {
        return NotificationEvent.forComment(comment, author, EventType.COMMENT_UPDATED);
    }

    public static NotificationEvent forNewComment(Comment comment, User author) {
        return NotificationEvent.forComment(comment, author, EventType.NEW_COMMENT);
    }

    public static void afterNewCommentWithState(Comment comment, State state) {
        AbstractPosting post2 = comment.getParent();
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(comment);
        Object object = NotificationEvent.formatReplyTitle(post2);
        Model model = notiEvent;
        model.setTitle((String)object);
        Set<User> receivers = NotificationEvent.getReceivers(post2);
        model = comment;
        object = null;
        object = model.getContents();
        receivers.addAll(NotificationEvent.getMentionedUsers(object));
        receivers.remove(UserApp.currentUser());
        notiEvent.receivers = receivers;
        object = EventType.NEW_COMMENT;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = null;
        model = notiEvent;
        model.setOldValue((String)object);
        model = comment;
        object = null;
        object = model.getContents();
        object = object + "\n" + state.state();
        model = notiEvent;
        model.setNewValue((String)object);
        object = comment.asResource().getType();
        model = notiEvent;
        model.setResourceType((ResourceType)((Object)object));
        object = comment.asResource().getId();
        model = notiEvent;
        model.setResourceId((String)object);
        NotificationEvent.add(notiEvent);
    }

    public static NotificationEvent afterStateChanged(State oldState, Issue issue2) {
        NotificationEvent.webhookRequest(EventType.ISSUE_STATE_CHANGED, issue2);
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(issue2);
        Object object = NotificationEvent.formatReplyTitle(issue2);
        Model model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getMandatoryReceivers(issue2, EventType.ISSUE_STATE_CHANGED);
        object = EventType.ISSUE_STATE_CHANGED;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = oldState != null ? oldState.state() : null;
        model = notiEvent;
        model.setOldValue((String)object);
        model = issue2;
        object = null;
        object = model.getState();
        object = ((State)((Object)object)).state();
        model = notiEvent;
        model.setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        return notiEvent;
    }

    public static NotificationEvent afterStateChanged(CommentThread.ThreadState oldState, CommentThread thread) throws IOException, SVNException, ServletException {
        Set<User> receivers;
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(thread);
        Object object = EventType.REVIEW_THREAD_STATE_CHANGED;
        Model model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = oldState.name() != null ? oldState.name() : null;
        model = notiEvent;
        model.setOldValue((String)object);
        model = thread;
        object = null;
        object = model.getState();
        object = ((Enum)object).name();
        model = notiEvent;
        model.setNewValue((String)object);
        if (thread.isOnPullRequest()) {
            model = thread;
            object = null;
            Object pullRequest2 = object = model.getPullRequest();
            object = NotificationEvent.formatReplyTitle((PullRequest)pullRequest2);
            model = notiEvent;
            model.setTitle((String)object);
            receivers = ((PullRequest)pullRequest2).getWatchers();
        } else {
            Object commitId;
            if (thread instanceof CodeCommentThread) {
                model = (CodeCommentThread)thread;
                object = null;
                commitId = object = model.getCommitId();
            } else {
                model = (NonRangedCodeCommentThread)thread;
                object = null;
                commitId = object = model.getCommitId();
            }
            model = thread;
            object = null;
            Object project2 = object = model.getProject();
            Commit commit = RepositoryService.getRepository((Project)project2).getCommit((String)commitId);
            object = NotificationEvent.formatReplyTitle((Project)project2, commit);
            model = notiEvent;
            model.setTitle((String)object);
            receivers = commit.getWatchers((Project)project2);
        }
        receivers.remove(UserApp.currentUser());
        notiEvent.receivers = receivers;
        NotificationEvent.add(notiEvent);
        return notiEvent;
    }

    public static NotificationEvent afterAssigneeChanged(User oldAssignee, Issue issue2) {
        Object object;
        Model model;
        NotificationEvent.webhookRequest(EventType.ISSUE_ASSIGNEE_CHANGED, issue2);
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(issue2);
        Set<User> receivers = NotificationEvent.getReceiversWhenAssigneeChanged(oldAssignee, issue2);
        if (oldAssignee != null) {
            model = oldAssignee;
            object = null;
            object = model.getLoginId();
            model = notiEvent;
            model.setOldValue((String)object);
        }
        model = issue2;
        object = null;
        object = model.getAssignee();
        if (object != null) {
            model = issue2;
            object = null;
            object = model.getAssignee();
            model = object;
            object = null;
            object = model.getUser();
            model = object;
            object = null;
            object = model.getId();
            model = (User)User.find.byId(object);
            object = null;
            object = model.getLoginId();
            model = notiEvent;
            model.setNewValue((String)object);
        }
        object = NotificationEvent.formatReplyTitle(issue2);
        model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = receivers;
        object = EventType.ISSUE_ASSIGNEE_CHANGED;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        NotificationEvent.add(notiEvent);
        return notiEvent;
    }

    private static Set<User> getReceiversWhenAssigneeChanged(User oldAssignee, Issue issue2) {
        Set<User> receivers = NotificationEvent.getMandatoryReceivers(issue2, EventType.ISSUE_ASSIGNEE_CHANGED);
        if (oldAssignee != null && !oldAssignee.isAnonymous()) {
            User user = oldAssignee;
            String string = null;
            String string2 = string = user.getLoginId();
            user = UserApp.currentUser();
            string = null;
            string = user.getLoginId();
            if (!string2.equals(string)) {
                receivers.add(oldAssignee);
            }
        }
        return receivers;
    }

    public static NotificationEvent afterNewIssue(Issue issue2) {
        NotificationEvent notiEvent = NotificationEvent.forNewIssue(issue2, UserApp.currentUser());
        NotificationEvent.add(notiEvent);
        NotificationEvent.webhookRequest(EventType.NEW_ISSUE, issue2);
        return notiEvent;
    }

    public static NotificationEvent forNewIssue(Issue issue2, User author) {
        NotificationEvent notiEvent = NotificationEvent.createFrom(author, issue2);
        Object object = NotificationEvent.formatNewTitle(issue2);
        Model model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getReceivers(issue2, author);
        object = EventType.NEW_ISSUE;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = null;
        model = notiEvent;
        model.setOldValue((String)object);
        model = issue2;
        object = null;
        object = model.getBody();
        model = notiEvent;
        model.setNewValue((String)object);
        return notiEvent;
    }

    public static NotificationEvent afterResourceDeleted(AbstractPosting item, User reuqestedUser) {
        Model model = item;
        Object object = null;
        object = model.getProject();
        NotificationEvent notiEvent = NotificationEvent.createFrom(reuqestedUser, (ResourceConvertible)object);
        object = NotificationEvent.formatNewTitle(item);
        model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getReceivers(item, reuqestedUser);
        object = EventType.RESOURCE_DELETED;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        model = item;
        object = null;
        object = model.getBody();
        model = notiEvent;
        model.setOldValue((String)object);
        model = reuqestedUser;
        object = null;
        object = model.getLoginId();
        model = notiEvent;
        model.setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        if (item instanceof Issue) {
            NotificationEvent.webhookRequest(EventType.RESOURCE_DELETED, (Issue)item);
        }
        return notiEvent;
    }

    public static NotificationEvent afterIssueBodyChanged(String oldBody, Issue issue2) {
        NotificationEvent.webhookRequest(EventType.ISSUE_BODY_CHANGED, issue2);
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(issue2);
        Object object = NotificationEvent.formatReplyTitle(issue2);
        Model model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getReceiversForIssueBodyChanged(oldBody, issue2);
        object = EventType.ISSUE_BODY_CHANGED;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = oldBody;
        model = notiEvent;
        model.setOldValue((String)object);
        model = issue2;
        object = null;
        object = model.getBody();
        model = notiEvent;
        model.setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        return notiEvent;
    }

    public static NotificationEvent afterIssueMoved(Project previous, Issue issue2, Supplier<Set<User>> getReceivers) {
        String string;
        NotificationEvent.webhookRequest(EventType.ISSUE_MOVED, issue2, previous);
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(issue2);
        Object object = NotificationEvent.formatReplyTitle(issue2);
        Object object2 = notiEvent;
        ((NotificationEvent)object2).setTitle((String)object);
        notiEvent.receivers = getReceivers.get();
        object = EventType.ISSUE_MOVED;
        object2 = notiEvent;
        ((NotificationEvent)object2).setEventType((EventType)((Object)object));
        if (previous != null) {
            object2 = previous;
            object = null;
            object = ((Project)object2).getOwner();
            StringBuilder stringBuilder = new StringBuilder().append((String)object).append("/");
            object2 = previous;
            object = null;
            object = ((Project)object2).getName();
            string = stringBuilder.append((String)object).toString();
        } else {
            string = null;
        }
        object = string;
        object2 = notiEvent;
        ((NotificationEvent)object2).setOldValue((String)object);
        object2 = issue2;
        object = null;
        object = ((AbstractPosting)object2).getProject();
        object2 = object;
        object = null;
        object = ((Project)object2).getOwner();
        StringBuilder stringBuilder = new StringBuilder().append((String)object).append("/");
        object2 = issue2;
        object = null;
        object = ((AbstractPosting)object2).getProject();
        object2 = object;
        object = null;
        object = ((Project)object2).getName();
        object = stringBuilder.append((String)object).toString();
        object2 = notiEvent;
        ((NotificationEvent)object2).setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        return notiEvent;
    }

    public static NotificationEvent afterIssueSharerChanged(Issue issue2, String sharerLoginId, String action) {
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(issue2);
        Object object = NotificationEvent.formatReplyTitle(issue2);
        NotificationEvent notificationEvent = notiEvent;
        notificationEvent.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.findSharer(sharerLoginId);
        object = EventType.ISSUE_SHARER_CHANGED;
        notificationEvent = notiEvent;
        notificationEvent.setEventType((EventType)((Object)object));
        if ("add".equalsIgnoreCase(action)) {
            object = "";
            notificationEvent = notiEvent;
            notificationEvent.setOldValue((String)object);
            object = sharerLoginId;
            notificationEvent = notiEvent;
            notificationEvent.setNewValue((String)object);
        } else if ("delete".equalsIgnoreCase(action)) {
            object = sharerLoginId;
            notificationEvent = notiEvent;
            notificationEvent.setOldValue((String)object);
            object = "";
            notificationEvent = notiEvent;
            notificationEvent.setNewValue((String)object);
        }
        NotificationEvent.addWithoutSkipEvent(notiEvent);
        return notiEvent;
    }

    private static Set<User> findSharer(String sharerLoginId) {
        HashSet<User> receivers = new HashSet<User>();
        receivers.add(User.findByLoginId(sharerLoginId));
        return receivers;
    }

    public static NotificationEvent afterIssueLabelChanged(String addedLabels, String deletedLabels, Issue issue2) {
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(issue2);
        Object object = NotificationEvent.formatReplyTitle(issue2);
        NotificationEvent notificationEvent = notiEvent;
        notificationEvent.setTitle((String)object);
        notiEvent.receivers = null;
        object = EventType.ISSUE_LABEL_CHANGED;
        notificationEvent = notiEvent;
        notificationEvent.setEventType((EventType)((Object)object));
        object = deletedLabels;
        notificationEvent = notiEvent;
        notificationEvent.setOldValue((String)object);
        object = addedLabels;
        notificationEvent = notiEvent;
        notificationEvent.setNewValue((String)object);
        NotificationEvent.addWithoutSkipEvent(notiEvent);
        return notiEvent;
    }

    public static NotificationEvent afterMilestoneChanged(Long oldMilestoneId, Issue issue2) {
        Model model = issue2;
        Object object = null;
        object = model.getMilestone();
        if (object != null) {
            model = issue2;
            object = null;
            object = model.getMilestone();
            object.refresh();
        }
        NotificationEvent.webhookRequest(EventType.ISSUE_MILESTONE_CHANGED, issue2);
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(issue2);
        Set<User> receivers = NotificationEvent.getMandatoryReceivers(issue2, EventType.ISSUE_MILESTONE_CHANGED);
        object = NotificationEvent.formatReplyTitle(issue2);
        model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = receivers;
        object = EventType.ISSUE_MILESTONE_CHANGED;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = oldMilestoneId.toString();
        model = notiEvent;
        model.setOldValue((String)object);
        object = issue2.milestoneId().toString();
        model = notiEvent;
        model.setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        return notiEvent;
    }

    private static Set<User> getMandatoryReceivers(Issue issue2, EventType eventType) {
        Set<User> receivers = Watch.findWatchers(issue2.asResource());
        receivers.add(issue2.getAuthor());
        Object object = issue2;
        Object object2 = null;
        object2 = ((Issue)object).getSharers();
        for (IssueSharer issueSharer : object2) {
            object = issueSharer;
            object2 = null;
            object2 = ((IssueSharer)((Object)object)).getLoginId();
            receivers.add(User.findByLoginId(object2));
        }
        object = issue2;
        object2 = null;
        object2 = ((Issue)object).getAssignee();
        if (object2 != null) {
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getAssignee();
            object = object2;
            object2 = null;
            object2 = ((Assignee)((Object)object)).getUser();
            receivers.add((User)object2);
        }
        object = issue2;
        object2 = null;
        object2 = ((AbstractPosting)object).getProject();
        object = object2;
        object2 = null;
        object2 = ((Project)object).getId();
        receivers.addAll(UserProjectNotification.findEventWatchersByEventType(object2, eventType));
        receivers.removeAll(Watch.findUnwatchers(issue2.asResource()));
        object = issue2;
        object2 = null;
        object2 = ((AbstractPosting)object).getProject();
        object = object2;
        object2 = null;
        object2 = ((Project)object).getId();
        receivers.removeAll(UserProjectNotification.findEventUnwatchersByEventType(object2, eventType));
        object = issue2;
        object2 = null;
        object2 = ((AbstractPosting)object).getAuthorId();
        receivers.remove(NotificationEvent.findCurrentUserToBeExcluded(object2));
        return receivers;
    }

    private static User findCurrentUserToBeExcluded(Long authorId) {
        User currentUser;
        try {
            currentUser = UserApp.currentUser();
        }
        catch (RuntimeException re) {
            currentUser = User.anonymous;
        }
        if (currentUser.isAnonymous()) {
            return (User)User.find.byId((Object)authorId);
        }
        return currentUser;
    }

    private static Set<User> getMandatoryReceivers(Posting posting, EventType eventType) {
        Set<User> receivers = Watch.findWatchers(posting.asResource());
        receivers.add(posting.getAuthor());
        receivers.addAll(Watch.findWatchers(posting.asResource()));
        Object object = posting;
        Object object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getId();
        receivers.addAll(UserProjectNotification.findEventWatchersByEventType((Long)object2, eventType));
        receivers.removeAll(Watch.findUnwatchers(posting.asResource()));
        object = posting;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getId();
        receivers.removeAll(UserProjectNotification.findEventUnwatchersByEventType((Long)object2, eventType));
        object = posting;
        object2 = null;
        object2 = ((AbstractPosting)object).getAuthorId();
        receivers.remove(NotificationEvent.findCurrentUserToBeExcluded((Long)object2));
        return receivers;
    }

    public static Set<User> getMandatoryReceivers(Comment comment, EventType eventType) {
        Object object;
        Model model;
        AbstractPosting parent = comment.getParent();
        Set<User> receivers = Watch.findWatchers(parent.asResource());
        receivers.add(parent.getAuthor());
        NotificationEvent.includeAssigneeIfExist(comment, receivers);
        Comment parentComment = comment.getParentComment();
        if (parentComment != null) {
            model = comment.getParent();
            object = null;
            object = model.getAuthorId();
            receivers.remove(User.find.byId(object));
            model = comment.getParentComment();
            object = null;
            object = model.getAuthorId();
            receivers.add((User)User.find.byId(object));
            model = parentComment;
            object = null;
            object = model.getAuthorId();
            Long l = object;
            model = comment;
            object = null;
            object = model.getAuthorId();
            if (l.equals(object)) {
                for (Comment comment2 : comment.getSiblingComments()) {
                    model = comment2;
                    object = null;
                    object = model.getAuthorId();
                    receivers.add((User)User.find.byId(object));
                }
            }
        }
        model = comment;
        object = null;
        object = model.getProjectId();
        receivers.addAll(UserProjectNotification.findEventWatchersByEventType((Long)object, eventType));
        receivers.removeAll(Watch.findUnwatchers(parent.asResource()));
        model = comment;
        object = null;
        object = model.getProjectId();
        receivers.removeAll(UserProjectNotification.findEventUnwatchersByEventType((Long)object, eventType));
        receivers.removeAll(NotificationEvent.filterInactiveUsers(receivers));
        model = comment;
        object = null;
        object = model.getAuthorId();
        receivers.remove(NotificationEvent.findCurrentUserToBeExcluded((Long)object));
        model = comment;
        object = null;
        object = model.getContents();
        receivers.addAll(NotificationEvent.getMentionedUsers((String)object));
        return receivers;
    }

    private static Set<User> filterInactiveUsers(Set<User> receivers) {
        HashSet<User> inactiveUsers = new HashSet<User>();
        Iterator<User> iterator = receivers.iterator();
        while (iterator.hasNext()) {
            User user;
            User user2 = user = iterator.next();
            UserState userState = null;
            userState = user2.getState();
            if (userState == UserState.ACTIVE) continue;
            inactiveUsers.add(user);
        }
        return inactiveUsers;
    }

    private static Set<User> getProjectCommitReceivers(Project project2, EventType eventType, User sender) {
        Set<User> receivers = NotificationEvent.findMembersOnlyFromWatchers(project2);
        receivers.removeAll(Watch.findUnwatchers(project2.asResource()));
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        receivers.removeAll(UserProjectNotification.findEventUnwatchersByEventType(l, eventType));
        receivers.remove(sender);
        return receivers;
    }

    private static Set<User> findMembersOnlyFromWatchers(Project project2) {
        HashSet<User> receivers = new HashSet<User>();
        Set<User> projectMembers = NotificationEvent.extractMembers(project2);
        for (User watcher : Watch.findWatchers(project2.asResource())) {
            if (!projectMembers.contains(watcher)) continue;
            receivers.add(watcher);
        }
        return receivers;
    }

    private static Set<User> extractMembers(Project project2) {
        HashSet<User> projectMembers = new HashSet<User>();
        Iterator<ProjectUser> iterator = project2.members().iterator();
        while (iterator.hasNext()) {
            ProjectUser projectUser;
            ProjectUser projectUser2 = projectUser = iterator.next();
            User user = null;
            user = projectUser2.getUser();
            projectMembers.add(user);
        }
        return projectMembers;
    }

    private static Set<User> getReceiversForIssueBodyChanged(String oldBody, Issue issue2) {
        Set<User> receivers = NotificationEvent.getMandatoryReceivers(issue2, EventType.ISSUE_BODY_CHANGED);
        Issue issue3 = issue2;
        Object object = null;
        object = issue3.getBody();
        receivers.addAll(NotificationEvent.getNewMentionedUsers(oldBody, (String)object));
        issue3 = issue2;
        object = null;
        object = issue3.getAuthorId();
        receivers.remove(NotificationEvent.findCurrentUserToBeExcluded((Long)object));
        return receivers;
    }

    public static void afterNewPost(Posting post2) {
        NotificationEvent.add(NotificationEvent.forNewPosting(post2, UserApp.currentUser()));
        NotificationEvent.webhookRequest(EventType.NEW_POSTING, post2);
    }

    public static void afterUpdatePosting(String oldValue, Posting post2) {
        NotificationEvent.add(NotificationEvent.forUpdatePosting(oldValue, post2, UserApp.currentUser()));
    }

    public static NotificationEvent forNewPosting(Posting post2, User author) {
        NotificationEvent notiEvent = NotificationEvent.createFrom(author, post2);
        Object object = NotificationEvent.formatNewTitle(post2);
        Model model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getReceivers(post2);
        object = EventType.NEW_POSTING;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = null;
        model = notiEvent;
        model.setOldValue((String)object);
        model = post2;
        object = null;
        object = model.getBody();
        model = notiEvent;
        model.setNewValue((String)object);
        return notiEvent;
    }

    public static NotificationEvent forUpdatePosting(String oldValue, Posting post2, User author) {
        NotificationEvent notiEvent = NotificationEvent.createFrom(author, post2);
        Object object = NotificationEvent.formatNewTitle(post2);
        Model model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getMandatoryReceivers(post2, EventType.POSTING_BODY_CHANGED);
        object = EventType.POSTING_BODY_CHANGED;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = oldValue;
        model = notiEvent;
        model.setOldValue((String)object);
        model = post2;
        object = null;
        object = model.getBody();
        model = notiEvent;
        model.setNewValue((String)object);
        return notiEvent;
    }

    public static void afterNewCommitComment(Project project2, ReviewComment comment, String commitId) throws IOException, SVNException, ServletException {
        NotificationEvent.add(NotificationEvent.forNewCommitComment(project2, comment, commitId, UserApp.currentUser()));
    }

    public static NotificationEvent forNewCommitComment(Project project2, ReviewComment comment, String commitId, User author) throws IOException, SVNException, ServletException {
        Commit commit = RepositoryService.getRepository(project2).getCommit(commitId);
        Set<User> watchers2 = commit.getWatchers(project2);
        watchers2.addAll(NotificationEvent.getMentionedUsers(comment.getContents()));
        watchers2.remove(author);
        NotificationEvent notiEvent = NotificationEvent.createFrom(author, comment);
        Object object = NotificationEvent.formatReplyTitle(project2, commit);
        NotificationEvent notificationEvent = notiEvent;
        notificationEvent.setTitle((String)object);
        notiEvent.receivers = watchers2;
        object = EventType.NEW_REVIEW_COMMENT;
        notificationEvent = notiEvent;
        notificationEvent.setEventType((EventType)((Object)object));
        object = null;
        notificationEvent = notiEvent;
        notificationEvent.setOldValue((String)object);
        object = comment.getContents();
        notificationEvent = notiEvent;
        notificationEvent.setNewValue((String)object);
        return notiEvent;
    }

    public static void afterNewSVNCommitComment(Project project2, CommitComment codeComment) throws IOException, SVNException, ServletException {
        NotificationEvent.add(NotificationEvent.forNewSVNCommitComment(project2, codeComment, UserApp.currentUser()));
    }

    private static NotificationEvent forNewSVNCommitComment(Project project2, CommitComment codeComment, User author) throws IOException, SVNException, ServletException {
        Commit commit = RepositoryService.getRepository(project2).getCommit(codeComment.commitId);
        Set<User> watchers2 = commit.getWatchers(project2);
        Model model = codeComment;
        Object object = null;
        object = model.getContents();
        watchers2.addAll(NotificationEvent.getMentionedUsers(object));
        watchers2.remove(author);
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(codeComment);
        object = NotificationEvent.formatReplyTitle(project2, commit);
        model = notiEvent;
        model.setTitle((String)object);
        notiEvent.receivers = watchers2;
        object = EventType.NEW_COMMENT;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = null;
        model = notiEvent;
        model.setOldValue((String)object);
        model = codeComment;
        object = null;
        object = model.getContents();
        model = notiEvent;
        model.setNewValue((String)object);
        return notiEvent;
    }

    public static void afterMemberRequest(Project project2, User user, RequestState state) {
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(project2);
        Object object = EventType.MEMBER_ENROLL_REQUEST;
        NotificationEvent notificationEvent = notiEvent;
        notificationEvent.setEventType((EventType)((Object)object));
        notiEvent.receivers = NotificationEvent.getReceivers(project2);
        object = state.name();
        notificationEvent = notiEvent;
        notificationEvent.setNewValue((String)object);
        if (state == RequestState.ACCEPT || state == RequestState.REJECT) {
            notificationEvent = notiEvent;
            object = null;
            object = notificationEvent.getReceivers();
            object.remove(UserApp.currentUser());
            notificationEvent = notiEvent;
            object = null;
            object = notificationEvent.getReceivers();
            object.add(user);
        }
        switch (state) {
            case REQUEST: {
                object = NotificationEvent.formatMemberRequestTitle(project2, user);
                notificationEvent = notiEvent;
                notificationEvent.setTitle((String)object);
                object = RequestState.CANCEL.name();
                notificationEvent = notiEvent;
                notificationEvent.setOldValue((String)object);
                break;
            }
            case CANCEL: {
                object = NotificationEvent.formatMemberRequestCancelTitle(project2, user);
                notificationEvent = notiEvent;
                notificationEvent.setTitle((String)object);
                object = RequestState.REQUEST.name();
                notificationEvent = notiEvent;
                notificationEvent.setOldValue((String)object);
                break;
            }
            case ACCEPT: {
                object = NotificationEvent.formatMemberAcceptTitle(project2, user);
                notificationEvent = notiEvent;
                notificationEvent.setTitle((String)object);
                object = EventType.MEMBER_ENROLL_ACCEPT;
                notificationEvent = notiEvent;
                notificationEvent.setEventType((EventType)((Object)object));
                object = RequestState.REQUEST.name();
                notificationEvent = notiEvent;
                notificationEvent.setOldValue((String)object);
            }
        }
        object = project2.asResource().getType();
        notificationEvent = notiEvent;
        notificationEvent.setResourceType((ResourceType)((Object)object));
        object = project2.asResource().getId();
        notificationEvent = notiEvent;
        notificationEvent.setResourceId((String)object);
        NotificationEvent.add(notiEvent);
    }

    public static void afterOrganizationMemberRequest(Organization organization2, User user, RequestState state) {
        NotificationEvent notiEvent = NotificationEvent.createFromCurrentUser(organization2);
        Object object = EventType.ORGANIZATION_MEMBER_ENROLL_REQUEST;
        NotificationEvent notificationEvent = notiEvent;
        notificationEvent.setEventType((EventType)((Object)object));
        notiEvent.receivers = NotificationEvent.getReceivers(organization2);
        object = state.name();
        notificationEvent = notiEvent;
        notificationEvent.setNewValue((String)object);
        if (state == RequestState.ACCEPT || state == RequestState.REJECT) {
            notificationEvent = notiEvent;
            object = null;
            object = notificationEvent.getReceivers();
            object.remove(UserApp.currentUser());
            notificationEvent = notiEvent;
            object = null;
            object = notificationEvent.getReceivers();
            object.add(user);
        }
        switch (state) {
            case REQUEST: {
                object = NotificationEvent.formatMemberRequestTitle(organization2, user);
                notificationEvent = notiEvent;
                notificationEvent.setTitle((String)object);
                object = RequestState.CANCEL.name();
                notificationEvent = notiEvent;
                notificationEvent.setOldValue((String)object);
                break;
            }
            case CANCEL: {
                object = NotificationEvent.formatMemberRequestCancelTitle(organization2, user);
                notificationEvent = notiEvent;
                notificationEvent.setTitle((String)object);
                object = RequestState.REQUEST.name();
                notificationEvent = notiEvent;
                notificationEvent.setOldValue((String)object);
                break;
            }
            case ACCEPT: {
                object = NotificationEvent.formatMemberAcceptTitle(organization2, user);
                notificationEvent = notiEvent;
                notificationEvent.setTitle((String)object);
                object = EventType.ORGANIZATION_MEMBER_ENROLL_ACCEPT;
                notificationEvent = notiEvent;
                notificationEvent.setEventType((EventType)((Object)object));
                object = RequestState.REQUEST.name();
                notificationEvent = notiEvent;
                notificationEvent.setOldValue((String)object);
            }
        }
        object = organization2.asResource().getType();
        notificationEvent = notiEvent;
        notificationEvent.setResourceType((ResourceType)((Object)object));
        object = organization2.asResource().getId();
        notificationEvent = notiEvent;
        notificationEvent.setResourceId((String)object);
        NotificationEvent.add(notiEvent);
    }

    public static void afterNewCommits(List<RevCommit> commits, List<String> refNames, Project project2, User sender, String title) {
        NotificationEvent notiEvent = NotificationEvent.createFrom(sender, project2);
        Object object = title;
        NotificationEvent notificationEvent = notiEvent;
        notificationEvent.setTitle((String)object);
        notiEvent.receivers = NotificationEvent.getProjectCommitReceivers(project2, EventType.NEW_COMMIT, sender);
        object = EventType.NEW_COMMIT;
        notificationEvent = notiEvent;
        notificationEvent.setEventType((EventType)((Object)object));
        object = null;
        notificationEvent = notiEvent;
        notificationEvent.setOldValue((String)object);
        object = NotificationEvent.newCommitsMessage(commits, refNames, project2);
        notificationEvent = notiEvent;
        notificationEvent.setNewValue((String)object);
        object = project2.asResource().getType();
        notificationEvent = notiEvent;
        notificationEvent.setResourceType((ResourceType)((Object)object));
        object = project2.asResource().getId();
        notificationEvent = notiEvent;
        notificationEvent.setResourceId((String)object);
        NotificationEvent.add(notiEvent);
        NotificationEvent.webhookRequest(project2, commits, refNames, sender, title);
    }

    public static NotificationEvent afterReviewed(PullRequest pullRequest2, PullRequestReviewAction reviewAction) {
        NotificationEvent.webhookRequest(EventType.PULL_REQUEST_REVIEW_STATE_CHANGED, pullRequest2, reviewAction);
        String title = NotificationEvent.formatReplyTitle(pullRequest2);
        Resource resource = pullRequest2.asResource();
        Set<User> receivers = pullRequest2.getWatchers();
        Model model = pullRequest2;
        Object object = null;
        object = model.getContributor();
        receivers.add((User)object);
        User reviewer = UserApp.currentUser();
        receivers.remove(reviewer);
        NotificationEvent notiEvent = new NotificationEvent();
        object = new Date();
        model = notiEvent;
        model.setCreated((Date)object);
        object = title;
        model = notiEvent;
        model.setTitle((String)object);
        model = reviewer;
        object = null;
        object = model.getId();
        model = notiEvent;
        model.setSenderId((Long)object);
        notiEvent.receivers = receivers;
        object = resource.getId();
        model = notiEvent;
        model.setResourceId((String)object);
        object = resource.getType();
        model = notiEvent;
        model.setResourceType((ResourceType)((Object)object));
        object = EventType.PULL_REQUEST_REVIEW_STATE_CHANGED;
        model = notiEvent;
        model.setEventType((EventType)((Object)object));
        object = reviewAction.getOppositAction().name();
        model = notiEvent;
        model.setOldValue((String)object);
        object = reviewAction.name();
        model = notiEvent;
        model.setNewValue((String)object);
        NotificationEvent.add(notiEvent);
        return notiEvent;
    }

    private static String newCommitsMessage(List<RevCommit> commits, List<String> refNames, Project project2) {
        StringBuilder result2 = new StringBuilder();
        if (commits.size() > 0) {
            result2.append("### " + Messages.get((String)"notification.pushed.newcommits", (Object[])new Object[0]) + "\n");
            result2.append("```\n");
            for (RevCommit commit : commits) {
                GitCommit gitCommit = new GitCommit(commit);
                result2.append(gitCommit.getShortId());
                result2.append(" ");
                result2.append(gitCommit.getShortMessage());
                result2.append("\n");
            }
            result2.append("```\n\n");
        }
        if (refNames.size() > 0) {
            result2.append("### " + Messages.get((String)"notification.pushed.branches", (Object[])new Object[0]) + "\n");
            for (String refName : refNames) {
                try {
                    Project project3 = project2;
                    String string = null;
                    String string2 = string = project3.getOwner();
                    project3 = project2;
                    string = null;
                    string = project3.getName();
                    result2.append("[" + refName + "](" + routes.CodeHistoryApp.history(string2, string, URLEncoder.encode(refName, "UTF-8"), "") + ")");
                }
                catch (UnsupportedEncodingException e) {
                    result2.append(refName);
                }
                result2.append("\n");
            }
        }
        return result2.toString();
    }

    private static NotificationEvent createFrom(User sender, ResourceConvertible rc) {
        NotificationEvent notiEvent = new NotificationEvent();
        Model model = sender;
        Object object = null;
        object = model.getId();
        model = notiEvent;
        model.setSenderId((Long)object);
        object = new Date();
        model = notiEvent;
        model.setCreated((Date)object);
        Resource resource = rc.asResource();
        object = resource.getId();
        model = notiEvent;
        model.setResourceId((String)object);
        object = resource.getType();
        model = notiEvent;
        model.setResourceType((ResourceType)((Object)object));
        return notiEvent;
    }

    private static NotificationEvent createFromCurrentUser(ResourceConvertible rc) {
        return NotificationEvent.createFrom(UserApp.currentUser(), rc);
    }

    private static Set<User> getReceivers(AbstractPosting abstractPosting) {
        return NotificationEvent.getReceivers(abstractPosting, UserApp.currentUser());
    }

    private static Set<User> getReceivers(AbstractPosting abstractPosting, User except) {
        Set<User> receivers = abstractPosting.getWatchers();
        AbstractPosting abstractPosting2 = abstractPosting;
        String string = null;
        string = abstractPosting2.getBody();
        receivers.addAll(NotificationEvent.getMentionedUsers(string));
        receivers.remove(except);
        return receivers;
    }

    private static void includeAssigneeIfExist(Comment comment, Set<User> receivers) {
        if (comment instanceof IssueComment) {
            Model model = (Issue)comment.getParent();
            Model model2 = null;
            model2 = model.getAssignee();
            Assignee assignee = model2;
            if (assignee != null) {
                model = assignee;
                model2 = null;
                model2 = model.getUser();
                receivers.add((User)model2);
            }
        }
    }

    private static String getPrefixedNumber(AbstractPosting posting) {
        if (posting instanceof Issue) {
            return "#" + posting.getNumber();
        }
        return posting.getNumber().toString();
    }

    private static String formatReplyTitle(AbstractPosting posting) {
        Object[] objectArray = new Object[3];
        Model model = posting;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        objectArray[0] = object = model.getName();
        model = posting;
        object = null;
        objectArray[1] = object = model.getTitle();
        objectArray[2] = NotificationEvent.getPrefixedNumber(posting);
        return String.format("Re: [%s] %s (%s)", objectArray);
    }

    private static String formatNewTitle(AbstractPosting posting) {
        Object[] objectArray = new Object[3];
        Model model = posting;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        objectArray[0] = object = model.getName();
        model = posting;
        object = null;
        objectArray[1] = object = model.getTitle();
        objectArray[2] = NotificationEvent.getPrefixedNumber(posting);
        return String.format("[%s] %s (%s)", objectArray);
    }

    private static String formatReplyTitle(Project project2, Commit commit) {
        Object[] objectArray = new Object[3];
        Project project3 = project2;
        String string = null;
        string = project3.getName();
        objectArray[0] = string;
        objectArray[1] = commit.getShortMessage();
        objectArray[2] = commit.getShortId();
        return String.format("Re: [%s] %s (%s)", objectArray);
    }

    private static Set<User> getReceivers(User sender, PullRequest pullRequest2) {
        Set<User> watchers2 = NotificationEvent.getDefaultReceivers(pullRequest2);
        watchers2.remove(sender);
        return watchers2;
    }

    private static Set<User> getDefaultReceivers(PullRequest pullRequest2) {
        Set<User> watchers2 = pullRequest2.getWatchers();
        PullRequest pullRequest3 = pullRequest2;
        String string = null;
        string = pullRequest3.getBody();
        watchers2.addAll(NotificationEvent.getMentionedUsers(string));
        return watchers2;
    }

    private static Set<User> getReceiversWithRelatedAuthors(User sender, PullRequest pullRequest2) {
        Set<User> receivers = NotificationEvent.getDefaultReceivers(pullRequest2);
        String failureMessage = "Failed to get authors related to the pullrequest " + pullRequest2;
        try {
            PullRequest pullRequest3 = pullRequest2;
            Object object = null;
            object = pullRequest3.getMergedCommitIdFrom();
            if (object != null) {
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getMergedCommitIdTo();
                if (object != null) {
                    pullRequest3 = pullRequest2;
                    object = null;
                    object = pullRequest3.getToProject();
                    GitRepository gitRepository = new GitRepository((Project)object);
                    pullRequest3 = pullRequest2;
                    object = null;
                    Object object2 = object = pullRequest3.getMergedCommitIdFrom();
                    pullRequest3 = pullRequest2;
                    object = null;
                    object = pullRequest3.getMergedCommitIdTo();
                    receivers.addAll(GitRepository.getRelatedAuthors(gitRepository.getRepository(), (String)object2, (String)object));
                }
            }
        }
        catch (LimitExceededException e) {
            Model model = pullRequest2;
            Model model2 = null;
            model2 = model.getToProject();
            for (ProjectUser member : model2.members()) {
                model = member;
                model2 = null;
                model2 = model.getUser();
                receivers.add((User)model2);
            }
            Logger.info((String)(failureMessage + ": Get all project members instead"), (Throwable)e);
        }
        catch (GitAPIException e) {
            Logger.warn((String)failureMessage, (Throwable)e);
        }
        catch (IOException e) {
            Logger.warn((String)failureMessage, (Throwable)e);
        }
        receivers.remove(sender);
        return receivers;
    }

    private static String formatNewTitle(PullRequest pullRequest2) {
        Object[] objectArray = new Object[3];
        Model model = pullRequest2;
        Object object = null;
        object = model.getToProject();
        model = object;
        object = null;
        objectArray[0] = object = model.getName();
        model = pullRequest2;
        object = null;
        objectArray[1] = object = model.getTitle();
        model = pullRequest2;
        object = null;
        objectArray[2] = object = model.getNumber();
        return String.format("[%s] %s (#%d)", objectArray);
    }

    private static String formatReplyTitle(PullRequest pullRequest2) {
        Object[] objectArray = new Object[3];
        Model model = pullRequest2;
        Object object = null;
        object = model.getToProject();
        model = object;
        object = null;
        objectArray[0] = object = model.getName();
        model = pullRequest2;
        object = null;
        objectArray[1] = object = model.getTitle();
        model = pullRequest2;
        object = null;
        objectArray[2] = object = model.getNumber();
        return String.format("Re: [%s] %s (#%s)", objectArray);
    }

    private static Set<User> getReceivers(Project project2) {
        HashSet<User> receivers = new HashSet<User>();
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        List<User> managers = User.findUsersByProject(l, RoleType.MANAGER);
        for (User manager : managers) {
            if (!Watch.isWatching(manager, project2.asResource())) continue;
            receivers.add(manager);
        }
        return receivers;
    }

    private static Set<User> getReceivers(Organization organization2) {
        HashSet<User> receivers = new HashSet<User>();
        Organization organization3 = organization2;
        Long l = null;
        l = organization3.getId();
        List<User> managers = User.findUsersByOrganization(l, RoleType.ORG_ADMIN);
        receivers.addAll(managers);
        return receivers;
    }

    private static String formatMemberRequestTitle(Project project2, User user) {
        Object[] objectArray = new Object[2];
        Model model = project2;
        String string = null;
        string = model.getName();
        objectArray[0] = string;
        model = user;
        string = null;
        string = model.getLoginId();
        objectArray[1] = string;
        return Messages.get((String)"notification.member.request.title", (Object[])objectArray);
    }

    private static String formatMemberRequestCancelTitle(Project project2, User user) {
        Object[] objectArray = new Object[2];
        Model model = project2;
        String string = null;
        string = model.getName();
        objectArray[0] = string;
        model = user;
        string = null;
        string = model.getLoginId();
        objectArray[1] = string;
        return Messages.get((String)"notification.member.request.cancel.title", (Object[])objectArray);
    }

    private static String formatMemberRequestCancelTitle(Organization organization2, User user) {
        Object[] objectArray = new Object[2];
        Model model = organization2;
        String string = null;
        string = model.getName();
        objectArray[0] = string;
        model = user;
        string = null;
        string = model.getLoginId();
        objectArray[1] = string;
        return Messages.get((String)"notification.member.request.cancel.title", (Object[])objectArray);
    }

    private static String formatMemberRequestTitle(Organization organization2, User user) {
        Object[] objectArray = new Object[2];
        Model model = organization2;
        String string = null;
        string = model.getName();
        objectArray[0] = string;
        model = user;
        string = null;
        string = model.getLoginId();
        objectArray[1] = string;
        return Messages.get((String)"notification.organization.member.request.title", (Object[])objectArray);
    }

    private static String formatMemberAcceptTitle(Project project2, User user) {
        Object[] objectArray = new Object[2];
        Model model = project2;
        String string = null;
        string = model.getName();
        objectArray[0] = string;
        model = user;
        string = null;
        string = model.getLoginId();
        objectArray[1] = string;
        return Messages.get((String)"notification.member.request.accept.title", (Object[])objectArray);
    }

    private static String formatMemberAcceptTitle(Organization organization2, User user) {
        Object[] objectArray = new Object[2];
        Model model = organization2;
        String string = null;
        string = model.getName();
        objectArray[0] = string;
        model = user;
        string = null;
        string = model.getLoginId();
        objectArray[1] = string;
        return Messages.get((String)"notification.member.request.accept.title", (Object[])objectArray);
    }

    public static Set<User> getMentionedUsers(String body) {
        Matcher matcher = Pattern.compile("@[a-zA-Z0-9-/]+([_.][a-zA-Z0-9-/]+)*").matcher(body);
        HashSet<User> users2 = new HashSet<User>();
        while (matcher.find()) {
            String mentionWord = matcher.group().substring(1);
            users2.addAll(NotificationEvent.findOrganizationMembers(mentionWord));
            users2.addAll(NotificationEvent.findProjectMembers(mentionWord));
            users2.add(User.findByLoginId(mentionWord));
        }
        users2.remove(User.anonymous);
        return users2;
    }

    public static Set<User> getNewMentionedUsers(String oldBody, String newBody) {
        Set<User> oldBodyMentionedUsers = NotificationEvent.getMentionedUsers(oldBody);
        Set<User> newBodyMentionedUsers = NotificationEvent.getMentionedUsers(newBody);
        newBodyMentionedUsers.removeAll(oldBodyMentionedUsers);
        return newBodyMentionedUsers;
    }

    private static Set<User> findOrganizationMembers(String mentionWord) {
        HashSet<User> users2 = new HashSet<User>();
        Organization org = Organization.findByName(mentionWord);
        if (org != null) {
            Model model = org;
            Object object = null;
            object = model.getUsers();
            Iterator<OrganizationUser> iterator = object.iterator();
            while (iterator.hasNext()) {
                OrganizationUser orgUser = iterator.next();
                model = orgUser;
                object = null;
                object = model.getUser();
                users2.add((User)object);
            }
        }
        return users2;
    }

    private static Set<User> findProjectMembers(String mentionWord) {
        HashSet<User> users2 = new HashSet<User>();
        if (mentionWord.contains("/")) {
            String projectName = mentionWord.substring(mentionWord.lastIndexOf("/") + 1);
            String loginId = mentionWord.substring(0, mentionWord.lastIndexOf("/"));
            Project mentionedProject = Project.findByOwnerAndProjectName(loginId, projectName);
            if (mentionedProject == null) {
                return users2;
            }
            Iterator<ProjectUser> iterator = mentionedProject.members().iterator();
            while (iterator.hasNext()) {
                ProjectUser projectUser;
                ProjectUser projectUser2 = projectUser = iterator.next();
                User user = null;
                user = projectUser2.getUser();
                users2.add(user);
            }
        }
        return users2;
    }

    public static void scheduleDeleteOldNotifications() {
        if (EventConstants.KEEP_TIME_IN_DAYS > 0) {
            Akka.system().scheduler().schedule(Duration.create((long)1L, (TimeUnit)TimeUnit.MINUTES), Duration.create((long)1L, (TimeUnit)TimeUnit.DAYS), new Runnable(){

                @Override
                public void run() {
                    Date threshold = DateTime.now().minusDays(EventConstants.KEEP_TIME_IN_DAYS).toDate();
                    List olds = find.where().lt("created", (Object)threshold).findList();
                    for (NotificationEvent old : olds) {
                        old.delete();
                    }
                }
            }, (ExecutionContext)Akka.system().dispatcher());
        }
    }

    public static void onStart() {
        NotificationEvent.scheduleDeleteOldNotifications();
    }

    public static List<NotificationEvent> findByReceiver(User user, int from, int size) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        String sql = "select t1.id, t1.title, t1.sender_id, t1.created, t1.resource_type, t1.resource_id, t1.event_type, t1.old_value, t1.new_value from n4user t0 left outer join notification_event_n4user t1z_ on t1z_.n4user_id = t0.id left outer join notification_event t1 on t1.id = t1z_.notification_event_id left outer join notification_mail t2 on t2.notification_event_id = t1.id where t0.id = " + l + " and t1.id IS NOT NULL order by t1.created DESC";
        return find.setRawSql(RawSqlBuilder.parse((String)sql).create()).setFirstRow(from).setMaxRows(size).findList();
    }

    public static int getNotificationsCount(User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        String sql = "select t1.id from n4user t0 left outer join notification_event_n4user t1z_ on t1z_.n4user_id = t0.id left outer join notification_event t1 on t1.id = t1z_.notification_event_id left outer join notification_mail t2 on t2.notification_event_id = t1.id where t0.id = " + l + " and t1.id IS NOT NULL ";
        return find.setRawSql(RawSqlBuilder.parse((String)sql).create()).findList().size();
    }

    public static void afterCommentUpdated(Comment comment) {
        NotificationEvent.webhookRequest(EventType.COMMENT_UPDATED, comment);
        NotificationEvent.add(NotificationEvent.forUpdatedComment(comment, UserApp.currentUser()));
    }

    public String toString() {
        NotificationEvent notificationEvent = this;
        Object object = null;
        object = notificationEvent.getId();
        StringBuilder stringBuilder = new StringBuilder().append("NotificationEvent{id=").append(object).append(", title='").append(this.title).append('\'').append(", senderId=");
        notificationEvent = this;
        object = null;
        object = notificationEvent.getSenderId();
        StringBuilder stringBuilder2 = stringBuilder.append(object).append(", receivers=");
        notificationEvent = this;
        object = null;
        object = notificationEvent.getReceivers();
        StringBuilder stringBuilder3 = stringBuilder2.append(object).append(", created=");
        notificationEvent = this;
        object = null;
        object = notificationEvent.getCreated();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", resourceType=").append((Object)this.resourceType).append(", resourceId='").append(this.resourceId).append('\'').append(", eventType=");
        notificationEvent = this;
        object = null;
        object = notificationEvent.getEventType();
        StringBuilder stringBuilder5 = stringBuilder4.append(object).append(", oldValue='").append(this.oldValue).append('\'').append(", newValue='").append(this.newValue).append('\'').append(", notificationMail=");
        notificationEvent = this;
        object = null;
        object = notificationEvent.getNotificationMail();
        return stringBuilder5.append(object).append('}').toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setTitle(String string) {
        this._ebean_set_title(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getSenderId() {
        return this._ebean_get_senderId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSenderId(Long l) {
        this._ebean_set_senderId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<User> getReceivers() {
        return this._ebean_get_receivers();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreated() {
        return this._ebean_get_created();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreated(Date date) {
        this._ebean_set_created(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setResourceType(ResourceType resourceType) {
        this._ebean_set_resourceType(resourceType);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setResourceId(String string) {
        this._ebean_set_resourceId(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public EventType getEventType() {
        return this._ebean_get_eventType();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEventType(EventType eventType) {
        this._ebean_set_eventType(eventType);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOldValue(String string) {
        this._ebean_set_oldValue(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNewValue(String string) {
        this._ebean_set_newValue(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public NotificationMail getNotificationMail() {
        return this._ebean_get_notificationMail();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNotificationMail(NotificationMail notificationMail2) {
        this._ebean_set_notificationMail(notificationMail2);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_title() {
        this._ebean_intercept.preGetter("title");
        return this.title;
    }

    protected void _ebean_set_title(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "title", (Object)this._ebean_get_title(), (Object)newValue);
        this.title = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_title() {
        return this.title;
    }

    protected void _ebean_setni_title(String _newValue) {
        this.title = _newValue;
    }

    protected Long _ebean_get_senderId() {
        this._ebean_intercept.preGetter("senderId");
        return this.senderId;
    }

    protected void _ebean_set_senderId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "senderId", (Object)this._ebean_get_senderId(), (Object)newValue);
        this.senderId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_senderId() {
        return this.senderId;
    }

    protected void _ebean_setni_senderId(Long _newValue) {
        this.senderId = _newValue;
    }

    protected Set _ebean_get_receivers() {
        this._ebean_intercept.preGetter("receivers");
        if (this.receivers == null) {
            this.receivers = new BeanSet();
            ((BeanCollection)this.receivers).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.receivers;
    }

    protected void _ebean_set_receivers(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "receivers", (Object)this._ebean_get_receivers(), (Object)newValue);
        this.receivers = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_receivers() {
        return this.receivers;
    }

    protected void _ebean_setni_receivers(Set _newValue) {
        this.receivers = _newValue;
    }

    protected Date _ebean_get_created() {
        this._ebean_intercept.preGetter("created");
        return this.created;
    }

    protected void _ebean_set_created(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "created", (Object)this._ebean_get_created(), (Object)newValue);
        this.created = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_created() {
        return this.created;
    }

    protected void _ebean_setni_created(Date _newValue) {
        this.created = _newValue;
    }

    protected ResourceType _ebean_get_resourceType() {
        this._ebean_intercept.preGetter("resourceType");
        return this.resourceType;
    }

    protected void _ebean_set_resourceType(ResourceType newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "resourceType", (Object)this._ebean_get_resourceType(), (Object)newValue);
        this.resourceType = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected ResourceType _ebean_getni_resourceType() {
        return this.resourceType;
    }

    protected void _ebean_setni_resourceType(ResourceType _newValue) {
        this.resourceType = _newValue;
    }

    protected String _ebean_get_resourceId() {
        this._ebean_intercept.preGetter("resourceId");
        return this.resourceId;
    }

    protected void _ebean_set_resourceId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "resourceId", (Object)this._ebean_get_resourceId(), (Object)newValue);
        this.resourceId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_resourceId() {
        return this.resourceId;
    }

    protected void _ebean_setni_resourceId(String _newValue) {
        this.resourceId = _newValue;
    }

    protected EventType _ebean_get_eventType() {
        this._ebean_intercept.preGetter("eventType");
        return this.eventType;
    }

    protected void _ebean_set_eventType(EventType newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "eventType", (Object)this._ebean_get_eventType(), (Object)newValue);
        this.eventType = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected EventType _ebean_getni_eventType() {
        return this.eventType;
    }

    protected void _ebean_setni_eventType(EventType _newValue) {
        this.eventType = _newValue;
    }

    protected String _ebean_get_oldValue() {
        this._ebean_intercept.preGetter("oldValue");
        return this.oldValue;
    }

    protected void _ebean_set_oldValue(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "oldValue", (Object)this._ebean_get_oldValue(), (Object)newValue);
        this.oldValue = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_oldValue() {
        return this.oldValue;
    }

    protected void _ebean_setni_oldValue(String _newValue) {
        this.oldValue = _newValue;
    }

    protected String _ebean_get_newValue() {
        this._ebean_intercept.preGetter("newValue");
        return this.newValue;
    }

    protected void _ebean_set_newValue(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "newValue", (Object)this._ebean_get_newValue(), (Object)newValue);
        this.newValue = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_newValue() {
        return this.newValue;
    }

    protected void _ebean_setni_newValue(String _newValue) {
        this.newValue = _newValue;
    }

    protected NotificationMail _ebean_get_notificationMail() {
        this._ebean_intercept.preGetter("notificationMail");
        return this.notificationMail;
    }

    protected void _ebean_set_notificationMail(NotificationMail newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "notificationMail", (Object)this._ebean_get_notificationMail(), (Object)newValue);
        this.notificationMail = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected NotificationMail _ebean_getni_notificationMail() {
        return this.notificationMail;
    }

    protected void _ebean_setni_notificationMail(NotificationMail _newValue) {
        this.notificationMail = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        NotificationEvent notificationEvent = new NotificationEvent();
        notificationEvent.id = this.id;
        notificationEvent.title = this.title;
        notificationEvent.senderId = this.senderId;
        notificationEvent.receivers = this.receivers;
        notificationEvent.created = this.created;
        notificationEvent.resourceType = this.resourceType;
        notificationEvent.resourceId = this.resourceId;
        notificationEvent.eventType = this.eventType;
        notificationEvent.oldValue = this.oldValue;
        notificationEvent.newValue = this.newValue;
        notificationEvent.notificationMail = this.notificationMail;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        NotificationEvent p = (NotificationEvent)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.title;
            }
            case 3: {
                return p.senderId;
            }
            case 4: {
                return p.receivers;
            }
            case 5: {
                return p.created;
            }
            case 6: {
                return p.resourceType;
            }
            case 7: {
                return p.resourceId;
            }
            case 8: {
                return p.eventType;
            }
            case 9: {
                return p.oldValue;
            }
            case 10: {
                return p.newValue;
            }
            case 11: {
                return p.notificationMail;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        NotificationEvent p = (NotificationEvent)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_title();
            }
            case 3: {
                return p._ebean_get_senderId();
            }
            case 4: {
                return p._ebean_get_receivers();
            }
            case 5: {
                return p._ebean_get_created();
            }
            case 6: {
                return p._ebean_get_resourceType();
            }
            case 7: {
                return p._ebean_get_resourceId();
            }
            case 8: {
                return p._ebean_get_eventType();
            }
            case 9: {
                return p._ebean_get_oldValue();
            }
            case 10: {
                return p._ebean_get_newValue();
            }
            case 11: {
                return p._ebean_get_notificationMail();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        NotificationEvent p = (NotificationEvent)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.title = (String)arg;
                return;
            }
            case 3: {
                p.senderId = (Long)arg;
                return;
            }
            case 4: {
                p.receivers = (Set)arg;
                return;
            }
            case 5: {
                p.created = (Date)arg;
                return;
            }
            case 6: {
                p.resourceType = (ResourceType)((Object)arg);
                return;
            }
            case 7: {
                p.resourceId = (String)arg;
                return;
            }
            case 8: {
                p.eventType = (EventType)((Object)arg);
                return;
            }
            case 9: {
                p.oldValue = (String)arg;
                return;
            }
            case 10: {
                p.newValue = (String)arg;
                return;
            }
            case 11: {
                p.notificationMail = (NotificationMail)((Object)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        NotificationEvent p = (NotificationEvent)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_title((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_senderId((Long)arg);
                return;
            }
            case 4: {
                p._ebean_set_receivers((Set)arg);
                return;
            }
            case 5: {
                p._ebean_set_created((Date)arg);
                return;
            }
            case 6: {
                p._ebean_set_resourceType((ResourceType)((Object)arg));
                return;
            }
            case 7: {
                p._ebean_set_resourceId((String)arg);
                return;
            }
            case 8: {
                p._ebean_set_eventType((EventType)((Object)arg));
                return;
            }
            case 9: {
                p._ebean_set_oldValue((String)arg);
                return;
            }
            case 10: {
                p._ebean_set_newValue((String)arg);
                return;
            }
            case 11: {
                p._ebean_set_notificationMail((NotificationMail)((Object)arg));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "title", "senderId", "receivers", "created", "resourceType", "resourceId", "eventType", "oldValue", "newValue", "notificationMail"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        NotificationEvent notificationEvent = this;
        synchronized (notificationEvent) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((NotificationEvent)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new NotificationEvent();
    }
}

