/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanSet;
import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import models.Issue;
import models.Project;
import models.enumeration.Direction;
import models.enumeration.Matching;
import models.enumeration.ResourceType;
import models.enumeration.State;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import models.support.FinderTemplate;
import models.support.OrderParams;
import models.support.SearchParams;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.shiro.util.CollectionUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.data.format.Formats;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.i18n.Messages;
import play.libs.F;
import utils.JodaDateUtil;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"project_id", "title"})})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Milestone
extends Model
implements ResourceConvertible,
EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, Milestone> find = new Model.Finder(Long.class, Milestone.class);
    public static final String DEFAULT_SORTER = "dueDate";
    public static final Long NULL_MILESTONE_ID = -1L;
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Constraints.Required
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String title;
    @Formats.DateTime(pattern="yyyy-MM-dd")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date dueDate;
    @Lob
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String contents;
    @Constraints.Required
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public State state;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    @OneToMany(mappedBy="milestone")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<Issue> issues;
    private static String _EBEAN_MARKER = "models.Milestone";

    public void delete() {
        Model model = this;
        Set<Issue> set = null;
        set = model.getIssues();
        for (Issue issue2 : set) {
            set = null;
            model = issue2;
            model.setMilestone((Milestone)((Object)set));
            issue2.update();
        }
        super.delete();
    }

    public static void create(Milestone milestone2) {
        milestone2.save();
    }

    public int getNumClosedIssues() {
        return Issue.finder.where().eq("milestone", (Object)this).eq("state", (Object)State.CLOSED).findRowCount();
    }

    public int getNumOpenIssues() {
        return Issue.finder.where().eq("milestone", (Object)this).eq("state", (Object)State.OPEN).findRowCount();
    }

    public List<Issue> sortedByNumberOfIssue() {
        Milestone milestone2 = this;
        Set<Issue> set = null;
        set = milestone2.getIssues();
        ArrayList<Issue> sortedIssues = new ArrayList<Issue>(set);
        Collections.sort(sortedIssues, new Comparator<Issue>(){

            @Override
            public int compare(Issue a, Issue b) {
                return b.getNumber().compareTo(a.getNumber());
            }
        });
        return sortedIssues;
    }

    public List<Issue> sortedByNumberOfOpenIssue() {
        ArrayList<Issue> openedIssues = new ArrayList<Issue>();
        for (Issue issue2 : this.sortedByNumberOfIssue()) {
            if (!issue2.isOpen()) continue;
            openedIssues.add(issue2);
        }
        return openedIssues;
    }

    public List<Issue> sortedByNumberOfClosedIssue() {
        ArrayList<Issue> closedIssues = new ArrayList<Issue>();
        for (Issue issue2 : this.sortedByNumberOfIssue()) {
            if (!issue2.isClosed()) continue;
            closedIssues.add(issue2);
        }
        return closedIssues;
    }

    public int getNumTotalIssues() {
        Milestone milestone2 = this;
        Set<Issue> set = null;
        set = milestone2.getIssues();
        return set.size();
    }

    public int getCompletionRate() {
        return (int)((double)this.getNumClosedIssues() / (double)this.getNumTotalIssues() * 100.0);
    }

    public static Milestone findById(Long id) {
        return (Milestone)find.byId((Object)id);
    }

    public static List<Milestone> findByProjectId(Long projectId) {
        return Milestone.findMilestones(projectId, State.ALL);
    }

    public static List<Milestone> findClosedMilestones(Long projectId) {
        return Milestone.findMilestones(projectId, State.CLOSED);
    }

    public static List<Milestone> findOpenMilestones(Long projectId) {
        return Milestone.findMilestones(projectId, State.OPEN);
    }

    public static Milestone findMilestoneByTitle(@Nonnull Project project2, String title) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        List milestones2 = find.where().eq("project.id", (Object)l).eq("title", (Object)title).findList();
        if (CollectionUtils.isEmpty((Collection)milestones2)) {
            return null;
        }
        return (Milestone)milestones2.get(0);
    }

    public String getDueDateString() {
        Milestone milestone2 = this;
        Date date = null;
        date = milestone2.getDueDate();
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        milestone2 = this;
        date = null;
        date = milestone2.getDueDate();
        return sdf.format(date);
    }

    public static List<Milestone> findMilestones(Long projectId, State state) {
        return Milestone.findMilestones(projectId, state, DEFAULT_SORTER, Direction.ASC);
    }

    public static List<Milestone> findMilestones(Long projectId, State state, String sort, final Direction direction) {
        OrderParams orderParams = new OrderParams();
        if (!"completionRate".equals(sort)) {
            orderParams.add(sort, direction);
        }
        SearchParams searchParams = new SearchParams().add("project.id", projectId, Matching.EQUALS);
        if (state != null && state != State.ALL) {
            searchParams.add("state", (Object)state, Matching.EQUALS);
        }
        List<Milestone> milestones2 = FinderTemplate.findBy(orderParams, searchParams, find);
        if ("completionRate".equals(sort)) {
            Collections.sort(milestones2, new Comparator<Milestone>(){

                @Override
                public int compare(Milestone o1, Milestone o2) {
                    int o1CompletionRate = o1.getCompletionRate();
                    int o2CompletionRate = o2.getCompletionRate();
                    if (direction == Direction.ASC) {
                        return o1CompletionRate < o2CompletionRate ? -1 : (o1CompletionRate == o2CompletionRate ? 0 : 1);
                    }
                    return o1CompletionRate < o2CompletionRate ? 1 : (o1CompletionRate == o2CompletionRate ? 0 : -1);
                }
            });
        }
        return milestones2;
    }

    public void updateWith(Milestone newMilestone2) {
        Milestone milestone2 = newMilestone2;
        Object object = null;
        object = milestone2.getContents();
        milestone2 = this;
        milestone2.setContents((String)object);
        milestone2 = newMilestone2;
        object = null;
        object = milestone2.getTitle();
        milestone2 = this;
        milestone2.setTitle((String)object);
        milestone2 = newMilestone2;
        object = null;
        object = milestone2.getDueDate();
        milestone2 = this;
        milestone2.setDueDate((Date)object);
        milestone2 = newMilestone2;
        object = null;
        object = milestone2.getState();
        milestone2 = this;
        milestone2.setState((State)((Object)object));
        this.save();
    }

    public static Map<String, String> options(Long projectId) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        Iterator<Milestone> iterator = Milestone.findMilestones(projectId, State.ALL, "title", Direction.ASC).iterator();
        while (iterator.hasNext()) {
            Milestone milestone2;
            Milestone milestone3 = milestone2 = iterator.next();
            Object object = null;
            object = milestone3.getId();
            String string = ((Long)object).toString();
            milestone3 = milestone2;
            object = null;
            object = milestone3.getTitle();
            options.put(string, (String)object);
        }
        return options;
    }

    public static boolean isUniqueProjectIdAndTitle(Long projectId, String title) {
        int count = find.where().eq("project.id", (Object)projectId).eq("title", (Object)title).findRowCount();
        return count == 0;
    }

    public String until() {
        Milestone milestone2 = this;
        Date date = null;
        date = milestone2.getDueDate();
        if (date == null) {
            return null;
        }
        Date now = JodaDateUtil.now();
        milestone2 = this;
        date = null;
        date = milestone2.getDueDate();
        if (DateUtils.isSameDay((Date)now, (Date)date)) {
            return Messages.get((String)"common.time.today", (Object[])new Object[0]);
        }
        if (this.isOverDueDate().booleanValue()) {
            Object[] objectArray = new Object[1];
            milestone2 = this;
            date = null;
            date = milestone2.getDueDate();
            objectArray[0] = JodaDateUtil.localDaysBetween(date, now);
            return Messages.get((String)"common.time.overday", (Object[])objectArray);
        }
        Object[] objectArray = new Object[1];
        milestone2 = this;
        date = null;
        date = milestone2.getDueDate();
        objectArray[0] = JodaDateUtil.localDaysBetween(now, date);
        return Messages.get((String)"common.time.leftday", (Object[])objectArray);
    }

    public Boolean isOverDueDate() {
        Milestone milestone2 = this;
        Date date = null;
        date = milestone2.getDueDate();
        return JodaDateUtil.ago(date).getMillis() > 0L;
    }

    @Override
    public Resource asResource() {
        return new Resource(){

            @Override
            public String getId() {
                Milestone milestone2 = Milestone.this;
                Long l = null;
                l = milestone2.getId();
                return l.toString();
            }

            @Override
            public Project getProject() {
                Milestone milestone2 = Milestone.this;
                Project project2 = null;
                project2 = milestone2.getProject();
                return project2;
            }

            @Override
            public ResourceType getType() {
                return ResourceType.MILESTONE;
            }
        };
    }

    public void open() {
        State state = State.OPEN;
        Milestone milestone2 = this;
        milestone2.setState(state);
        this.update();
    }

    public void close() {
        State state = State.CLOSED;
        Milestone milestone2 = this;
        milestone2.setState(state);
        this.update();
    }

    public boolean isNullMilestone() {
        Milestone milestone2 = this;
        Long l = null;
        l = milestone2.getId();
        return l.equals(NULL_MILESTONE_ID);
    }

    public static int countOpened(Project project2) {
        return find.where().eq("project", (Object)project2).eq("state", (Object)State.OPEN).findRowCount();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getTitle() {
        return this._ebean_get_title();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setTitle(String string) {
        this._ebean_set_title(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getDueDate() {
        return this._ebean_get_dueDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDueDate(Date date) {
        this._ebean_set_dueDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getContents() {
        return this._ebean_get_contents();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setContents(String string) {
        this._ebean_set_contents(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public State getState() {
        return this._ebean_get_state();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setState(State state) {
        this._ebean_set_state(state);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this._ebean_get_project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this._ebean_set_project(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<Issue> getIssues() {
        return this._ebean_get_issues();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIssues(Set<Issue> set) {
        this._ebean_set_issues(set);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_title() {
        this._ebean_intercept.preGetter("title");
        return this.title;
    }

    protected void _ebean_set_title(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "title", (Object)this._ebean_get_title(), (Object)newValue);
        this.title = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_title() {
        return this.title;
    }

    protected void _ebean_setni_title(String _newValue) {
        this.title = _newValue;
    }

    protected Date _ebean_get_dueDate() {
        this._ebean_intercept.preGetter(DEFAULT_SORTER);
        return this.dueDate;
    }

    protected void _ebean_set_dueDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, DEFAULT_SORTER, (Object)this._ebean_get_dueDate(), (Object)newValue);
        this.dueDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_dueDate() {
        return this.dueDate;
    }

    protected void _ebean_setni_dueDate(Date _newValue) {
        this.dueDate = _newValue;
    }

    protected String _ebean_get_contents() {
        this._ebean_intercept.preGetter("contents");
        return this.contents;
    }

    protected void _ebean_set_contents(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "contents", (Object)this._ebean_get_contents(), (Object)newValue);
        this.contents = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_contents() {
        return this.contents;
    }

    protected void _ebean_setni_contents(String _newValue) {
        this.contents = _newValue;
    }

    protected State _ebean_get_state() {
        this._ebean_intercept.preGetter("state");
        return this.state;
    }

    protected void _ebean_set_state(State newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "state", (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected State _ebean_getni_state() {
        return this.state;
    }

    protected void _ebean_setni_state(State _newValue) {
        this.state = _newValue;
    }

    protected Project _ebean_get_project() {
        this._ebean_intercept.preGetter("project");
        return this.project;
    }

    protected void _ebean_set_project(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "project", (Object)this._ebean_get_project(), (Object)newValue);
        this.project = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_project() {
        return this.project;
    }

    protected void _ebean_setni_project(Project _newValue) {
        this.project = _newValue;
    }

    protected Set _ebean_get_issues() {
        this._ebean_intercept.preGetter("issues");
        if (this.issues == null) {
            this.issues = new BeanSet();
        }
        return this.issues;
    }

    protected void _ebean_set_issues(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "issues", (Object)this._ebean_get_issues(), (Object)newValue);
        this.issues = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_issues() {
        return this.issues;
    }

    protected void _ebean_setni_issues(Set _newValue) {
        this.issues = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        Milestone milestone2 = new Milestone();
        milestone2.id = this.id;
        milestone2.title = this.title;
        milestone2.dueDate = this.dueDate;
        milestone2.contents = this.contents;
        milestone2.state = this.state;
        milestone2.project = this.project;
        milestone2.issues = this.issues;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        Milestone p = (Milestone)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.title;
            }
            case 3: {
                return p.dueDate;
            }
            case 4: {
                return p.contents;
            }
            case 5: {
                return p.state;
            }
            case 6: {
                return p.project;
            }
            case 7: {
                return p.issues;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Milestone p = (Milestone)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_title();
            }
            case 3: {
                return p._ebean_get_dueDate();
            }
            case 4: {
                return p._ebean_get_contents();
            }
            case 5: {
                return p._ebean_get_state();
            }
            case 6: {
                return p._ebean_get_project();
            }
            case 7: {
                return p._ebean_get_issues();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        Milestone p = (Milestone)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.title = (String)arg;
                return;
            }
            case 3: {
                p.dueDate = (Date)arg;
                return;
            }
            case 4: {
                p.contents = (String)arg;
                return;
            }
            case 5: {
                p.state = (State)((Object)arg);
                return;
            }
            case 6: {
                p.project = (Project)arg;
                return;
            }
            case 7: {
                p.issues = (Set)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Milestone p = (Milestone)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_title((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_dueDate((Date)arg);
                return;
            }
            case 4: {
                p._ebean_set_contents((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_state((State)((Object)arg));
                return;
            }
            case 6: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 7: {
                p._ebean_set_issues((Set)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "title", DEFAULT_SORTER, "contents", "state", "project", "issues"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        Milestone milestone2 = this;
        synchronized (milestone2) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Milestone)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new Milestone();
    }
}

