/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanSet;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.validation.constraints.Size;
import models.Issue;
import models.IssueLabelCategory;
import models.Posting;
import models.Project;
import models.enumeration.ResourceType;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import org.apache.commons.collections.CollectionUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IssueLabel
extends Model
implements ResourceConvertible,
EntityBean {
    private static final long serialVersionUID = -35487506476718498L;
    public static final Model.Finder<Long, IssueLabel> finder = new Model.Finder(Long.class, IssueLabel.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Constraints.Required
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public IssueLabelCategory category;
    @Constraints.Required(message="label.error.color.empty")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String color;
    @Constraints.Required(message="label.error.labelName.empty")
    @Size(max=255, message="label.error.labelName.tooLongSize")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String name;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    @ManyToMany(mappedBy="labels", fetch=FetchType.EAGER)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<Issue> issues;
    @ManyToMany(mappedBy="labels", fetch=FetchType.EAGER)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<Posting> postings;
    private static String _EBEAN_MARKER = "models.IssueLabel";

    public static List<IssueLabel> findByProject(Project project2) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return finder.where().eq("project.id", (Object)l).orderBy().asc("category.name").orderBy().asc("name").findList();
    }

    public static void copyIssueLabels(Project fromProject, Project toProject) {
        List<IssueLabel> fromLabels = IssueLabel.findByProject(fromProject);
        if (CollectionUtils.isEmpty(fromLabels)) {
            return;
        }
        List<IssueLabel> list2 = new ArrayList<IssueLabel>();
        Project project2 = toProject;
        project2.setIssueLabels(list2);
        for (IssueLabel fromLabel : fromLabels) {
            IssueLabel copiedLabel = IssueLabel.copyIssueLabel(toProject, fromLabel);
            if (copiedLabel.exists()) continue;
            project2 = toProject;
            list2 = null;
            list2 = project2.getIssueLabels();
            list2.add(copiedLabel);
        }
        toProject.update();
    }

    public static IssueLabel copyIssueLabel(@Nonnull Project toProject, @Nonnull IssueLabel fromLabel) {
        IssueLabel label = new IssueLabel();
        IssueLabel issueLabel = fromLabel;
        Object object = null;
        object = issueLabel.getName();
        issueLabel = label;
        issueLabel.setName((String)object);
        issueLabel = fromLabel;
        object = null;
        object = issueLabel.getColor();
        issueLabel = label;
        issueLabel.setColor((String)object);
        object = IssueLabel.copyIssueLabelCategory(toProject, fromLabel);
        issueLabel = label;
        issueLabel.setCategory((IssueLabelCategory)object);
        object = toProject;
        issueLabel = label;
        issueLabel.setProject((Project)object);
        return label;
    }

    private static IssueLabelCategory copyIssueLabelCategory(@Nonnull Project toProject, @Nonnull IssueLabel fromLabel) {
        IssueLabelCategory category2 = new IssueLabelCategory();
        Object object = fromLabel;
        Object object2 = null;
        object = object2 = ((IssueLabel)object).getCategory();
        object2 = null;
        object2 = ((IssueLabelCategory)object).getName();
        object = category2;
        ((IssueLabelCategory)object).setName((String)object2);
        object2 = toProject;
        object = category2;
        ((IssueLabelCategory)object).setProject((Project)object2);
        object = fromLabel;
        object2 = null;
        object = object2 = ((IssueLabel)object).getCategory();
        boolean bl = false;
        bl = ((IssueLabelCategory)object).getIsExclusive();
        object = category2;
        ((IssueLabelCategory)object).setIsExclusive(bl);
        if (category2.exists()) {
            category2 = IssueLabelCategory.findBy(category2);
        } else {
            category2.save();
        }
        return category2;
    }

    public String toString() {
        Model model = this;
        Object object = null;
        object = model.getCategory();
        model = object;
        object = null;
        object = model.getName();
        StringBuilder stringBuilder = new StringBuilder().append((String)object).append(" - ");
        model = this;
        object = null;
        object = model.getName();
        return stringBuilder.append((String)object).toString();
    }

    @Transient
    public boolean exists() {
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getId();
        ExpressionList expressionList = finder.where().eq("project.id", object);
        model = this;
        object = null;
        object = model.getCategory();
        ExpressionList expressionList2 = expressionList.eq("category", object);
        model = this;
        object = null;
        object = model.getName();
        return expressionList2.eq("name", object).findRowCount() > 0;
    }

    @Transient
    public IssueLabel findExistLabel() {
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getId();
        ExpressionList expressionList = finder.where().eq("project.id", object);
        model = this;
        object = null;
        object = model.getCategory();
        ExpressionList expressionList2 = expressionList.eq("category", object);
        model = this;
        object = null;
        object = model.getName();
        List list2 = expressionList2.eq("name", object).findList();
        if (list2 != null && list2.size() > 0) {
            return (IssueLabel)list2.get(0);
        }
        return null;
    }

    @Transient
    public static IssueLabel findByName(String labelName, String categoryName, Project project2) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        List list2 = finder.where().eq("project.id", (Object)l).eq("category.name", (Object)categoryName).eq("name", (Object)labelName).findList();
        if (list2 != null && list2.size() > 0) {
            return (IssueLabel)list2.get(0);
        }
        return null;
    }

    public void delete() {
        IssueLabel issueLabel = this;
        Set<Issue> set = null;
        set = issueLabel.getIssues();
        for (Issue issue2 : set) {
            issue2.labels.remove(this);
            issue2.save();
        }
        super.delete();
    }

    @Override
    public Resource asResource() {
        return new Resource(){

            @Override
            public String getId() {
                IssueLabel issueLabel = IssueLabel.this;
                Long l = null;
                l = issueLabel.getId();
                return l.toString();
            }

            @Override
            public Project getProject() {
                IssueLabel issueLabel = IssueLabel.this;
                Project project2 = null;
                project2 = issueLabel.getProject();
                return project2;
            }

            @Override
            public ResourceType getType() {
                return ResourceType.ISSUE_LABEL;
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        IssueLabel that = (IssueLabel)object;
        IssueLabel issueLabel = this;
        Object object2 = null;
        object2 = issueLabel.getColor();
        String string = object2;
        issueLabel = that;
        object2 = null;
        object2 = issueLabel.getColor();
        if (!string.equals(object2)) {
            return false;
        }
        issueLabel = this;
        object2 = null;
        Object object3 = object2 = issueLabel.getId();
        issueLabel = that;
        object2 = null;
        object2 = issueLabel.getId();
        if (!((Long)object3).equals(object2)) {
            return false;
        }
        issueLabel = this;
        object2 = null;
        Object object4 = object2 = issueLabel.getName();
        issueLabel = that;
        object2 = null;
        object2 = issueLabel.getName();
        return ((String)object4).equals(object2);
    }

    public int hashCode() {
        int n;
        int result2 = super.hashCode();
        IssueLabel issueLabel = this;
        Object object = null;
        object = issueLabel.getId();
        if (object != null) {
            issueLabel = this;
            object = null;
            object = issueLabel.getId();
            n = ((Long)object).hashCode();
        } else {
            n = 0;
        }
        result2 = 31 * result2 + n;
        issueLabel = this;
        object = null;
        object = issueLabel.getColor();
        result2 = 31 * result2 + ((String)object).hashCode();
        issueLabel = this;
        object = null;
        object = issueLabel.getName();
        result2 = 31 * result2 + ((String)object).hashCode();
        return result2;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public IssueLabelCategory getCategory() {
        return this._ebean_get_category();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCategory(IssueLabelCategory issueLabelCategory) {
        this._ebean_set_category(issueLabelCategory);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getColor() {
        return this._ebean_get_color();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setColor(String string) {
        this._ebean_set_color(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getName() {
        return this._ebean_get_name();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setName(String string) {
        this._ebean_set_name(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this._ebean_get_project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this._ebean_set_project(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<Issue> getIssues() {
        return this._ebean_get_issues();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIssues(Set<Issue> set) {
        this._ebean_set_issues(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<Posting> getPostings() {
        return this._ebean_get_postings();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPostings(Set<Posting> set) {
        this._ebean_set_postings(set);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected IssueLabelCategory _ebean_get_category() {
        this._ebean_intercept.preGetter("category");
        return this.category;
    }

    protected void _ebean_set_category(IssueLabelCategory newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "category", (Object)this._ebean_get_category(), (Object)newValue);
        this.category = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected IssueLabelCategory _ebean_getni_category() {
        return this.category;
    }

    protected void _ebean_setni_category(IssueLabelCategory _newValue) {
        this.category = _newValue;
    }

    protected String _ebean_get_color() {
        this._ebean_intercept.preGetter("color");
        return this.color;
    }

    protected void _ebean_set_color(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "color", (Object)this._ebean_get_color(), (Object)newValue);
        this.color = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_color() {
        return this.color;
    }

    protected void _ebean_setni_color(String _newValue) {
        this.color = _newValue;
    }

    protected String _ebean_get_name() {
        this._ebean_intercept.preGetter("name");
        return this.name;
    }

    protected void _ebean_set_name(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "name", (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_name() {
        return this.name;
    }

    protected void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
    }

    protected Project _ebean_get_project() {
        this._ebean_intercept.preGetter("project");
        return this.project;
    }

    protected void _ebean_set_project(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "project", (Object)this._ebean_get_project(), (Object)newValue);
        this.project = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_project() {
        return this.project;
    }

    protected void _ebean_setni_project(Project _newValue) {
        this.project = _newValue;
    }

    protected Set _ebean_get_issues() {
        this._ebean_intercept.preGetter("issues");
        if (this.issues == null) {
            this.issues = new BeanSet();
            ((BeanCollection)this.issues).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.issues;
    }

    protected void _ebean_set_issues(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "issues", (Object)this._ebean_get_issues(), (Object)newValue);
        this.issues = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_issues() {
        return this.issues;
    }

    protected void _ebean_setni_issues(Set _newValue) {
        this.issues = _newValue;
    }

    protected Set _ebean_get_postings() {
        this._ebean_intercept.preGetter("postings");
        if (this.postings == null) {
            this.postings = new BeanSet();
            ((BeanCollection)this.postings).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.postings;
    }

    protected void _ebean_set_postings(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "postings", (Object)this._ebean_get_postings(), (Object)newValue);
        this.postings = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_postings() {
        return this.postings;
    }

    protected void _ebean_setni_postings(Set _newValue) {
        this.postings = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        IssueLabel issueLabel = new IssueLabel();
        issueLabel.id = this.id;
        issueLabel.category = this.category;
        issueLabel.color = this.color;
        issueLabel.name = this.name;
        issueLabel.project = this.project;
        issueLabel.issues = this.issues;
        issueLabel.postings = this.postings;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        IssueLabel p = (IssueLabel)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.category;
            }
            case 3: {
                return p.color;
            }
            case 4: {
                return p.name;
            }
            case 5: {
                return p.project;
            }
            case 6: {
                return p.issues;
            }
            case 7: {
                return p.postings;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        IssueLabel p = (IssueLabel)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_category();
            }
            case 3: {
                return p._ebean_get_color();
            }
            case 4: {
                return p._ebean_get_name();
            }
            case 5: {
                return p._ebean_get_project();
            }
            case 6: {
                return p._ebean_get_issues();
            }
            case 7: {
                return p._ebean_get_postings();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        IssueLabel p = (IssueLabel)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.category = (IssueLabelCategory)arg;
                return;
            }
            case 3: {
                p.color = (String)arg;
                return;
            }
            case 4: {
                p.name = (String)arg;
                return;
            }
            case 5: {
                p.project = (Project)arg;
                return;
            }
            case 6: {
                p.issues = (Set)arg;
                return;
            }
            case 7: {
                p.postings = (Set)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        IssueLabel p = (IssueLabel)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_category((IssueLabelCategory)arg);
                return;
            }
            case 3: {
                p._ebean_set_color((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_name((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 6: {
                p._ebean_set_issues((Set)arg);
                return;
            }
            case 7: {
                p._ebean_set_postings((Set)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "category", "color", "name", "project", "issues", "postings"};
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new IssueLabel();
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class IssueLabelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IssueLabelException(String s) {
            super(s);
        }
    }
}

