/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.Expr;
import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Page;
import com.avaje.ebean.RawSqlBuilder;
import com.avaje.ebean.annotation.Formula;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanList;
import com.avaje.ebean.common.BeanSet;
import controllers.routes;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import models.AbstractPosting;
import models.Assignee;
import models.Comment;
import models.IssueComment;
import models.IssueEvent;
import models.IssueLabel;
import models.IssueLabelCategory;
import models.IssueSharer;
import models.LabelOwner;
import models.Mention;
import models.Milestone;
import models.Organization;
import models.Posting;
import models.Project;
import models.TimelineItem;
import models.User;
import models.enumeration.ResourceType;
import models.enumeration.State;
import models.resource.Resource;
import models.support.SearchCondition;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.shiro.util.CollectionUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.data.format.Formats;
import play.db.ebean.Model;
import play.i18n.Messages;
import play.libs.F;
import utils.JodaDateUtil;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"project_id", "number"})})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Issue
extends AbstractPosting
implements LabelOwner,
EntityBean {
    private static final long serialVersionUID = -2409072006294045262L;
    public static final Model.Finder<Long, Issue> finder = new Model.Finder(Long.class, Issue.class);
    public static final String DEFAULT_SORTER = "createdDate";
    public static final String TO_BE_ASSIGNED = "";
    public static final Pattern ISSUE_PATTERN = Pattern.compile("#\\d+");
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public State state;
    @Formats.DateTime(pattern="yyyy-MM-dd")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date dueDate;
    public static final List<State> availableStates = Collections.unmodifiableList(CollectionUtils.asList((Object[])new State[]{State.OPEN, State.CLOSED}));
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Milestone milestone;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.REMOVE})
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<IssueLabel> labels;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Assignee assignee;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="issue")
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<IssueComment> comments;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="issue")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<IssueEvent> events;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="issue")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<IssueSharer> sharers;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="issue_voter", joinColumns={@JoinColumn(name="issue_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<User> voters;
    @Transient
    @Formula(select="case when due_date is null then cast('0001-01-01 00:00:00' as datetime) else due_date end")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date dueDateDesc;
    @Transient
    @Formula(select="case when due_date is null then cast('9999-12-31 23:59:59' as datetime) else due_date end")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date dueDateAsc;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String targetProjectId;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String parentIssueId;
    @OneToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Issue parent;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Integer weight;
    private static String _EBEAN_MARKER = "models.Issue";

    public Issue(Project project2, User author, String title, String body) {
        super(project2, author, title, body);
        Object object = State.OPEN;
        Issue issue2 = this;
        issue2.setState((State)((Object)object));
        object = new LinkedHashSet();
        issue2 = this;
        issue2.setSharers((Set<IssueSharer>)object);
        object = new HashSet();
        issue2 = this;
        issue2.setVoters((Set<User>)object);
        object = 0;
        issue2 = this;
        issue2.setWeight((Integer)object);
        object = State.OPEN;
        issue2 = this;
        issue2.setState((State)((Object)object));
    }

    public Issue() {
        Object object = State.OPEN;
        Issue issue2 = this;
        issue2.setState((State)((Object)object));
        object = new LinkedHashSet();
        issue2 = this;
        issue2.setSharers((Set<IssueSharer>)object);
        object = new HashSet();
        issue2 = this;
        issue2.setVoters((Set<User>)object);
        object = 0;
        issue2 = this;
        issue2.setWeight((Integer)object);
    }

    @Override
    public int computeNumOfComments() {
        return this._ebean_get_comments().size();
    }

    @Override
    protected Long increaseNumber() {
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getId();
        return Project.increaseLastIssueNumber((Long)object);
    }

    @Override
    protected void fixLastNumber() {
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getId();
        Project.fixLastIssueNumber((Long)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String assigneeName() {
        String string;
        Model model = this;
        Object var2_2 = null;
        Assignee assignee = model.getAssignee();
        if (assignee == null) return null;
        model = this;
        Object var2_4 = null;
        Assignee assignee2 = model.getAssignee();
        model = assignee2;
        Object var2_6 = null;
        User user = model.getUser();
        if (user == null) return null;
        model = this;
        Object var2_8 = null;
        Assignee assignee3 = model.getAssignee();
        model = assignee3;
        Object var2_10 = null;
        User user2 = model.getUser();
        model = user2;
        Object var2_12 = null;
        String string2 = string = model.getName();
        return string2;
    }

    public Long milestoneId() {
        Model model = this;
        Object object = null;
        object = model.getMilestone();
        if (object == null) {
            return Milestone.NULL_MILESTONE_ID;
        }
        model = this;
        object = null;
        object = model.getMilestone();
        model = object;
        object = null;
        object = model.getId();
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasAssignee() {
        Model model = this;
        Object var2_2 = null;
        Assignee assignee = model.getAssignee();
        if (assignee == null) return false;
        model = this;
        Object var2_4 = null;
        Assignee assignee2 = model.getAssignee();
        model = assignee2;
        Object var2_6 = null;
        User user = model.getUser();
        if (user == null) return false;
        return true;
    }

    private void updateAssignee() {
        Model model = this;
        Object object = null;
        object = model.getAssignee();
        if (object != null) {
            model = this;
            object = null;
            object = model.getAssignee();
            model = object;
            object = null;
            object = model.getId();
            if (object == null) {
                model = this;
                object = null;
                object = model.getAssignee();
                model = object;
                object = null;
                object = model.getUser();
                model = object;
                object = null;
                object = model.getId();
                if (object != null) {
                    model = this;
                    object = null;
                    object = model.getAssignee();
                    model = object;
                    object = null;
                    object = model.getUser();
                    model = object;
                    object = null;
                    Object object2 = object = model.getId();
                    model = this;
                    object = null;
                    object = model.getProject();
                    model = object;
                    object = null;
                    object = model.getId();
                    object = Assignee.add((Long)object2, (Long)object);
                    model = this;
                    model.setAssignee((Assignee)((Object)object));
                }
            }
        }
    }

    @Override
    @Transient
    public void update() {
        this.updateAssignee();
        super.update();
    }

    @Override
    public void checkLabels() throws IssueLabel.IssueLabelException {
        HashSet<IssueLabelCategory> notAllowedCategories = new HashSet<IssueLabelCategory>();
        for (IssueLabel label : this._ebean_get_labels()) {
            Model model = label;
            IssueLabelCategory issueLabelCategory = null;
            issueLabelCategory = model.getCategory();
            if (notAllowedCategories.contains(issueLabelCategory)) {
                throw new IssueLabel.IssueLabelException("This category does not allow an issue to have two or more labels of the category");
            }
            model = label;
            issueLabelCategory = null;
            issueLabelCategory = model.getCategory();
            model = issueLabelCategory;
            boolean bl = false;
            bl = model.getIsExclusive();
            if (!bl) continue;
            model = label;
            IssueLabelCategory issueLabelCategory2 = null;
            issueLabelCategory2 = model.getCategory();
            notAllowedCategories.add(issueLabelCategory2);
        }
    }

    @Override
    public void updateProperties() {
        HashSet<String> updateProps = new HashSet<String>();
        Issue issue2 = this;
        Model model = null;
        model = issue2.getMilestone();
        if (model == null) {
            updateProps.add("milestone");
        }
        issue2 = this;
        model = null;
        model = issue2.getAssignee();
        if (model == null) {
            updateProps.add("assignee");
        }
        if (!updateProps.isEmpty()) {
            Ebean.update((Object)this, updateProps);
        }
    }

    @Override
    @Transient
    public void save() {
        this.updateAssignee();
        super.save();
    }

    public static int countAllAssignedBy(User user) {
        String template = "SELECT issue.id FROM issue \nINNER JOIN assignee ON issue.assignee_id = assignee.id \nWHERE assignee.user_id = %d";
        Object[] objectArray = new Object[1];
        User user2 = user;
        Long l = null;
        l = user2.getId();
        objectArray[0] = l;
        String sql = String.format(template, objectArray);
        Set set = finder.setRawSql(RawSqlBuilder.parse((String)sql).create()).findSet();
        return set.size();
    }

    public static int countVoterOf(User user) {
        String template = "SELECT issue.id FROM issue INNER JOIN issue_voter ON issue.id = issue_voter.issue_id WHERE issue_voter.user_id = %d";
        Object[] objectArray = new Object[1];
        User user2 = user;
        Long l = null;
        l = user2.getId();
        objectArray[0] = l;
        String sql = String.format(template, objectArray);
        Set set = finder.setRawSql(RawSqlBuilder.parse((String)sql).create()).findSet();
        return set.size();
    }

    public static int countAllCreatedBy(User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        return finder.where().eq("author_id", (Object)l).findRowCount();
    }

    public static int countIssues(Long projectId, State state) {
        if (state == State.ALL) {
            return finder.where().eq("project.id", (Object)projectId).isNull("parent.id").findRowCount();
        }
        return finder.where().eq("project.id", (Object)projectId).isNull("parent.id").eq("state", (Object)state).findRowCount();
    }

    public static int countIssuesBy(Long projectId, SearchCondition cond) {
        return cond.asExpressionList((Project)Project.find.byId((Object)projectId)).findRowCount();
    }

    public static int countIssuesBy(SearchCondition cond) {
        return cond.asExpressionList().findRowCount();
    }

    public static int countIssuesBy(Long projectId, Map<String, String> paramMap) {
        Form paramForm = new Form(SearchCondition.class);
        SearchCondition cond = (SearchCondition)paramForm.bind(paramMap, new String[0]).get();
        return Issue.countIssuesBy(projectId, cond);
    }

    public static int countIssuesBy(Organization organization2, SearchCondition cond) {
        return cond.asExpressionList(organization2).findRowCount();
    }

    public static byte[] excelFrom(List<Issue> issueList2) throws WriteException, IOException {
        WritableCellFormat headerCellFormat = Issue.getHeaderCellFormat();
        WritableCellFormat bodyCellFormat = Issue.getBodyCellFormat();
        WritableCellFormat dateCellFormat = Issue.getDateCellFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)bos);
        WritableSheet sheet = workbook.createSheet(String.valueOf(JodaDateUtil.today().getTime()), 0);
        String[] titles = new String[]{"No", Messages.get((String)"issue.state", (Object[])new Object[0]), Messages.get((String)"title", (Object[])new Object[0]), Messages.get((String)"issue.assignee", (Object[])new Object[0]), Messages.get((String)"issue.content", (Object[])new Object[0]), Messages.get((String)"issue.label", (Object[])new Object[0]), Messages.get((String)"issue.createdDate", (Object[])new Object[0]), Messages.get((String)"issue.dueDate", (Object[])new Object[0]), Messages.get((String)"milestone", (Object[])new Object[0]), "URL", Messages.get((String)"common.comment", (Object[])new Object[0]), Messages.get((String)"common.comment.author", (Object[])new Object[0]), Messages.get((String)"common.comment.created", (Object[])new Object[0])};
        for (int i = 0; i < titles.length; ++i) {
            sheet.addCell((WritableCell)new Label(i, 0, titles[i], (CellFormat)headerCellFormat));
            sheet.setColumnView(i, 20);
        }
        int lineNumber = 0;
        for (int idx = 1; idx < issueList2.size() + 1; ++idx) {
            Object object;
            Issue issue2 = issueList2.get(idx - 1);
            List<IssueComment> comments = issue2.comments;
            ++lineNumber;
            int columnPos = 0;
            Object object2 = issue2;
            Object object3 = null;
            object3 = ((Issue)object2).getMilestone();
            if (object3 != null) {
                object2 = issue2;
                object3 = null;
                object2 = object3 = ((Issue)object2).getMilestone();
                object3 = null;
                object = object3 = ((Milestone)object2).getTitle();
            } else {
                object = TO_BE_ASSIGNED;
            }
            String milestoneName = object;
            sheet.addCell((WritableCell)new Label(columnPos++, lineNumber, issue2.getNumber().toString(), (CellFormat)bodyCellFormat));
            int n = columnPos++;
            object2 = issue2;
            object3 = null;
            object3 = ((Issue)object2).getState();
            sheet.addCell((WritableCell)new Label(n, lineNumber, ((Enum)object3).toString(), (CellFormat)bodyCellFormat));
            int n2 = columnPos++;
            object2 = issue2;
            object3 = null;
            object3 = ((AbstractPosting)object2).getTitle();
            sheet.addCell((WritableCell)new Label(n2, lineNumber, (String)object3, (CellFormat)bodyCellFormat));
            int n3 = columnPos++;
            object2 = issue2;
            object3 = null;
            object3 = ((Issue)object2).getAssignee();
            sheet.addCell((WritableCell)new Label(n3, lineNumber, Issue.getAssigneeName((Assignee)((Object)object3)), (CellFormat)bodyCellFormat));
            int n4 = columnPos++;
            object2 = issue2;
            object3 = null;
            object3 = ((AbstractPosting)object2).getBody();
            sheet.addCell((WritableCell)new Label(n4, lineNumber, (String)object3, (CellFormat)bodyCellFormat));
            sheet.addCell((WritableCell)new Label(columnPos++, lineNumber, Issue.getIssueLabels(issue2), (CellFormat)bodyCellFormat));
            int n5 = columnPos++;
            object2 = issue2;
            object3 = null;
            object3 = ((AbstractPosting)object2).getCreatedDate();
            sheet.addCell((WritableCell)new DateTime(n5, lineNumber, (Date)object3, (CellFormat)dateCellFormat));
            int n6 = columnPos++;
            object2 = issue2;
            object3 = null;
            object3 = ((Issue)object2).getDueDate();
            sheet.addCell((WritableCell)new Label(n6, lineNumber, JodaDateUtil.geYMDDate((Date)object3), (CellFormat)bodyCellFormat));
            sheet.addCell((WritableCell)new Label(columnPos++, lineNumber, milestoneName, (CellFormat)bodyCellFormat));
            int n7 = columnPos++;
            object2 = issue2;
            object3 = null;
            object2 = object3 = ((AbstractPosting)object2).getProject();
            object3 = null;
            Object object4 = object3 = ((Project)object2).getOwner();
            object2 = issue2;
            object3 = null;
            object2 = object3 = ((AbstractPosting)object2).getProject();
            object3 = null;
            object3 = ((Project)object2).getName();
            sheet.addCell((WritableCell)new Label(n7, lineNumber, routes.IssueApp.issue((String)object4, (String)object3, issue2.number).toString(), (CellFormat)bodyCellFormat));
            if (comments.size() <= 0) continue;
            for (int j = 0; j < comments.size(); ++j) {
                object2 = comments.get(j);
                object3 = null;
                object3 = ((Comment)object2).getContents();
                sheet.addCell((WritableCell)new Label(columnPos, lineNumber + j, (String)object3, (CellFormat)bodyCellFormat));
                object2 = comments.get(j);
                object3 = null;
                object3 = ((Comment)object2).getAuthorName();
                sheet.addCell((WritableCell)new Label(columnPos + 1, lineNumber + j, (String)object3, (CellFormat)bodyCellFormat));
                object2 = comments.get(j);
                object3 = null;
                object3 = ((Comment)object2).getCreatedDate();
                sheet.addCell((WritableCell)new DateTime(columnPos + 2, lineNumber + j, (Date)object3, (CellFormat)dateCellFormat));
            }
            lineNumber = lineNumber + comments.size() - 1;
        }
        workbook.write();
        try {
            workbook.close();
        }
        catch (IOException | WriteException e) {
            e.printStackTrace();
        }
        return bos.toByteArray();
    }

    private static String getIssueLabels(Issue issue2) {
        StringBuilder labels2 = new StringBuilder();
        Iterator<IssueLabel> iterator = issue2.getLabels().iterator();
        while (iterator.hasNext()) {
            IssueLabel issueLabel;
            IssueLabel issueLabel2 = issueLabel = iterator.next();
            String string = null;
            string = issueLabel2.getName();
            labels2.append(string + ", ");
        }
        return labels2.toString().replaceAll(", $", TO_BE_ASSIGNED);
    }

    private static WritableCellFormat getDateCellFormat() throws WriteException {
        WritableFont baseFont = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
        DateFormat valueFormatDate = new DateFormat("yyyy-MM-dd HH:mm");
        WritableCellFormat cellFormat = new WritableCellFormat((DisplayFormat)valueFormatDate);
        cellFormat.setFont((FontRecord)baseFont);
        cellFormat.setShrinkToFit(true);
        cellFormat.setAlignment(Alignment.CENTRE);
        cellFormat.setVerticalAlignment(VerticalAlignment.TOP);
        return cellFormat;
    }

    private static WritableCellFormat getBodyCellFormat() throws WriteException {
        WritableFont baseFont = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
        return Issue.getBodyCellFormat(baseFont);
    }

    private static WritableCellFormat getBodyCellFormat(WritableFont baseFont) throws WriteException {
        WritableCellFormat cellFormat = new WritableCellFormat(baseFont);
        cellFormat.setBorder(Border.NONE, BorderLineStyle.THIN);
        cellFormat.setVerticalAlignment(VerticalAlignment.TOP);
        return cellFormat;
    }

    private static WritableCellFormat getHeaderCellFormat() throws WriteException {
        WritableFont headerFont = new WritableFont(WritableFont.ARIAL, 14, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
        WritableCellFormat headerCell = new WritableCellFormat(headerFont);
        headerCell.setBorder(Border.ALL, BorderLineStyle.THIN);
        headerCell.setAlignment(Alignment.CENTRE);
        return headerCell;
    }

    private static String getAssigneeName(Assignee assignee) {
        Object object;
        if (assignee != null) {
            Model model = assignee;
            Object object2 = null;
            object2 = model.getUser();
            model = object2;
            object2 = null;
            object = object2 = model.getName();
        } else {
            object = TO_BE_ASSIGNED;
        }
        return object;
    }

    public boolean isOpen() {
        Issue issue2 = this;
        State state = null;
        state = issue2.getState();
        return state == State.OPEN;
    }

    public boolean isClosed() {
        Issue issue2 = this;
        State state = null;
        state = issue2.getState();
        return state == State.CLOSED;
    }

    @Override
    public Resource asResource() {
        return this.asResource(ResourceType.ISSUE_POST);
    }

    public Resource fieldAsResource(final ResourceType resourceType) {
        return new Resource(){

            @Override
            public String getId() {
                Issue issue2 = Issue.this;
                Long l = null;
                l = issue2.getId();
                return l.toString();
            }

            @Override
            public Project getProject() {
                Issue issue2 = Issue.this;
                Project project2 = null;
                project2 = issue2.getProject();
                return project2;
            }

            @Override
            public ResourceType getType() {
                return resourceType;
            }

            @Override
            public Resource getContainer() {
                return Issue.this.asResource();
            }
        };
    }

    public Resource stateAsResource() {
        return this.fieldAsResource(ResourceType.ISSUE_STATE);
    }

    public Resource milestoneAsResource() {
        return this.fieldAsResource(ResourceType.ISSUE_MILESTONE);
    }

    public Resource assigneeAsResource() {
        return this.fieldAsResource(ResourceType.ISSUE_ASSIGNEE);
    }

    public static List<Issue> findRecentlyCreated(Project project2, int size) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return finder.where().eq("project.id", (Object)l).order().desc(DEFAULT_SORTER).findPagingList(size).getPage(0).getList();
    }

    @Override
    @Transient
    public List<? extends Comment> getComments() {
        Collections.sort(this.comments, Comment.comparator());
        return this.comments;
    }

    public static Issue findByNumber(Project project2, Long number) {
        return AbstractPosting.findByNumber(finder, project2, number);
    }

    public static List<Issue> findByMilestone(Milestone milestone2) {
        Milestone milestone3 = milestone2;
        Long l = null;
        l = milestone3.getId();
        return finder.where().eq("milestone.id", (Object)l).findList();
    }

    public static List<Issue> findClosedIssuesByMilestone(Milestone milestone2) {
        Milestone milestone3 = milestone2;
        Long l = null;
        l = milestone3.getId();
        return finder.where().eq("milestone.id", (Object)l).eq("state", (Object)State.CLOSED).findList();
    }

    public static List<Issue> findOpenIssuesByMilestone(Milestone milestone2) {
        Milestone milestone3 = milestone2;
        Long l = null;
        l = milestone3.getId();
        return finder.where().eq("milestone.id", (Object)l).eq("state", (Object)State.OPEN).findList();
    }

    @Override
    @Transient
    public Set<User> getWatchers() {
        return this.getWatchers(true);
    }

    @Override
    @Transient
    public Set<User> getWatchers(boolean allowedWatchersOnly) {
        HashSet<User> baseWatchers = new HashSet<User>();
        Object object = this;
        Object object2 = null;
        object2 = ((Issue)object).getAssignee();
        if (object2 != null) {
            object = this;
            object2 = null;
            object2 = ((Issue)object).getAssignee();
            object = object2;
            object2 = null;
            object2 = ((Assignee)((Object)object)).getUser();
            baseWatchers.add((User)object2);
        }
        object = this;
        object2 = null;
        object2 = ((Issue)object).getVoters();
        baseWatchers.addAll((Collection<User>)object2);
        return super.getWatchers(baseWatchers, allowedWatchersOnly);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean assignedUserEquals(Assignee otherAssignee) {
        Model model;
        Model model2;
        block7: {
            block6: {
                block5: {
                    block4: {
                        model2 = this;
                        model = null;
                        model = model2.getAssignee();
                        if (model == null) break block4;
                        model2 = this;
                        model = null;
                        model2 = model = model2.getAssignee();
                        model = null;
                        model = model2.getUser();
                        if (model == null) break block4;
                        model2 = this;
                        model = null;
                        model2 = model = model2.getAssignee();
                        model = null;
                        model = model2.getUser();
                        if (!model.isAnonymous()) break block5;
                    }
                    if (otherAssignee == null) return true;
                    model2 = otherAssignee;
                    model = null;
                    model = model2.getUser();
                    if (model == null) return true;
                    model2 = otherAssignee;
                    model = null;
                    model = model2.getUser();
                    if (!model.isAnonymous()) return false;
                    return true;
                }
                if (otherAssignee == null) break block6;
                model2 = otherAssignee;
                model = null;
                model = model2.getUser();
                if (model == null) break block6;
                model2 = otherAssignee;
                model = null;
                model = model2.getUser();
                if (!model.isAnonymous()) break block7;
            }
            model2 = this;
            model = null;
            model2 = model = model2.getAssignee();
            model = null;
            model = model2.getUser();
            return model.isAnonymous();
        }
        model2 = this;
        model = null;
        model = model2.getAssignee();
        if (model.equals((Object)otherAssignee)) return true;
        model2 = this;
        model = null;
        model2 = model = model2.getAssignee();
        model = null;
        Model model3 = model = model2.getUser();
        model2 = otherAssignee;
        model = null;
        model = model2.getUser();
        if (!model3.equals(model)) return false;
        return true;
    }

    public static List<Issue> findRecentlyIssuesByDaysAgo(User user, int days) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        Expression expression = Expr.eq((String)"assignee.user.id", (Object)l);
        user2 = user;
        l = null;
        l = user2.getId();
        return finder.where().or(expression, Expr.eq((String)"authorId", (Object)l)).ge("updatedDate", (Object)JodaDateUtil.before(days)).order("updatedDate desc, state asc").findList();
    }

    public static List<Issue> findByProject(Project project2, String filter) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        ExpressionList el = finder.where().eq("project.id", (Object)l);
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            el.icontains("title", filter);
        }
        return el.order().desc(DEFAULT_SORTER).findList();
    }

    public static List<Issue> findByProject(Project project2, String filter, int limit) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        ExpressionList el = finder.where().eq("project.id", (Object)l);
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            el.icontains("title", filter);
        }
        return el.setMaxRows(limit).order().desc(DEFAULT_SORTER).findList();
    }

    public static List<Issue> findParentIssueByProject(Project project2, String filter, int limit) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        ExpressionList el = finder.where().eq("project.id", (Object)l).isNull("parent");
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            el.icontains("title", filter);
        }
        return el.setMaxRows(limit).order().desc(DEFAULT_SORTER).findList();
    }

    public static Page<Issue> findIssuesByState(int size, int pageNum, State state) {
        return finder.where().eq("state", (Object)state).order().desc(DEFAULT_SORTER).findPagingList(size).getPage(pageNum);
    }

    public State previousState() {
        Issue issue2 = this;
        State state = null;
        state = issue2.getState();
        int currentState = availableStates.indexOf((Object)state);
        if (this.isLastState(currentState)) {
            return availableStates.get(0);
        }
        return availableStates.get(currentState + 1);
    }

    private boolean isLastState(int currentState) {
        return currentState + 1 == availableStates.size();
    }

    public State nextState() {
        Issue issue2 = this;
        State state = null;
        state = issue2.getState();
        int currentState = availableStates.indexOf((Object)state);
        if (this.isFirstState(currentState)) {
            return availableStates.get(availableStates.size() - 1);
        }
        return availableStates.get(currentState - 1);
    }

    private boolean isFirstState(int currentState) {
        return currentState == 0;
    }

    public State toNextState() {
        Object object = this.nextState();
        Issue issue2 = this;
        issue2.setState((State)((Object)object));
        object = JodaDateUtil.now();
        issue2 = this;
        issue2.setUpdatedDate((Date)object);
        super.update();
        issue2 = this;
        object = null;
        object = issue2.getState();
        return object;
    }

    public Set<IssueLabel> getLabels() {
        return this._ebean_get_labels();
    }

    public Set<Long> getLabelIds() {
        HashSet<Long> labelIds = new HashSet<Long>();
        Iterator iterator = this._ebean_get_labels().iterator();
        while (iterator.hasNext()) {
            IssueLabel label;
            IssueLabel issueLabel = label = (IssueLabel)iterator.next();
            Long l = null;
            l = issueLabel.getId();
            labelIds.add(l);
        }
        return labelIds;
    }

    public List<TimelineItem> getTimeline() {
        ArrayList<TimelineItem> timelineItems = new ArrayList<TimelineItem>();
        timelineItems.addAll(this._ebean_get_comments());
        Issue issue2 = this;
        List<IssueEvent> list2 = null;
        list2 = issue2.getEvents();
        timelineItems.addAll(list2);
        Collections.sort(timelineItems, TimelineItem.ASC);
        return timelineItems;
    }

    public boolean canBeDeleted() {
        if (this._ebean_get_comments() == null || this._ebean_get_comments().isEmpty()) {
            return true;
        }
        for (IssueComment comment : this._ebean_get_comments()) {
            Model model = comment;
            String string = null;
            String string2 = string = model.getAuthorLoginId();
            model = this;
            string = null;
            string = model.getAuthorLoginId();
            if (string2.equals(string)) continue;
            return false;
        }
        return true;
    }

    public void addVoter(User user) {
        Issue issue2 = this;
        Set<User> set = null;
        set = issue2.getVoters();
        if (set.add(user)) {
            this.update();
        }
    }

    public void removeVoter(User user) {
        Issue issue2 = this;
        Set<User> set = null;
        set = issue2.getVoters();
        if (set.remove(user)) {
            this.update();
        }
    }

    public boolean isVotedBy(User user) {
        Issue issue2 = this;
        Set<User> set = null;
        set = issue2.getVoters();
        return set.contains(user);
    }

    public String getDueDateString() {
        Issue issue2 = this;
        Date date = null;
        date = issue2.getDueDate();
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        issue2 = this;
        date = null;
        date = issue2.getDueDate();
        return sdf.format(date);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Boolean isOverDueDate() {
        boolean bl;
        if (this.isOpen()) {
            Issue issue2 = this;
            Date date = null;
            date = issue2.getDueDate();
            if (JodaDateUtil.ago(date).getMillis() > 0L) {
                bl = true;
                return bl;
            }
        }
        bl = false;
        return bl;
    }

    public String until() {
        Issue issue2 = this;
        Date date = null;
        date = issue2.getDueDate();
        if (date == null) {
            return null;
        }
        Date now = JodaDateUtil.now();
        issue2 = this;
        date = null;
        date = issue2.getDueDate();
        if (DateUtils.isSameDay((Date)now, (Date)date)) {
            return Messages.get((String)"common.time.today", (Object[])new Object[0]);
        }
        if (this.isOverDueDate().booleanValue()) {
            Object[] objectArray = new Object[1];
            issue2 = this;
            date = null;
            date = issue2.getDueDate();
            objectArray[0] = JodaDateUtil.localDaysBetween(date, now);
            return Messages.get((String)"common.time.default.day", (Object[])objectArray);
        }
        Object[] objectArray = new Object[1];
        issue2 = this;
        date = null;
        date = issue2.getDueDate();
        objectArray[0] = JodaDateUtil.localDaysBetween(now, date);
        return Messages.get((String)"common.time.default.day", (Object[])objectArray);
    }

    public static int countOpenIssuesByLabel(Project project2, IssueLabel label) {
        return finder.where().eq("project", (Object)project2).eq("labels", (Object)label).eq("state", (Object)State.OPEN).findRowCount();
    }

    public static int countOpenIssuesByAssignee(Project project2, Assignee assignee) {
        return finder.where().eq("project", (Object)project2).eq("assignee", (Object)assignee).eq("state", (Object)State.OPEN).findRowCount();
    }

    public static int countOpenIssuesByMilestone(Project project2, Milestone milestone2) {
        return finder.where().eq("project", (Object)project2).eq("milestone", (Object)milestone2).eq("state", (Object)State.OPEN).findRowCount();
    }

    public static List<Issue> findByParentIssueId(Long parentIssueId) {
        return finder.where().eq("parent.id", (Object)parentIssueId).findList();
    }

    public boolean hasChildIssue() {
        Issue issue2 = this;
        Long l = null;
        l = issue2.getId();
        return finder.where().eq("parent.id", (Object)l).setMaxRows(1).findRowCount() > 0;
    }

    public boolean hasParentIssue() {
        Issue issue2 = this;
        Issue issue3 = null;
        issue3 = issue2.getParent();
        return issue3 != null && finder.where().isNotNull("parent.id").findRowCount() > 0;
    }

    public static List<Issue> findByParentIssueIdAndState(Long parentIssueId, State state) {
        return finder.where().eq("parent.id", (Object)parentIssueId).eq("state", (Object)state).findList();
    }

    public static int countByParentIssueIdAndState(Long parentIssueId, State state) {
        return finder.where().eq("parent.id", (Object)parentIssueId).eq("state", (Object)state).findRowCount();
    }

    public static int countOpenIssuesByUser(User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        return finder.where().eq("assignee.user.id", (Object)l).eq("state", (Object)State.OPEN).findRowCount();
    }

    public IssueSharer findSharerByUserId(Long id) {
        Object object = this;
        Object object2 = null;
        object2 = ((Issue)object).getSharers();
        Iterator<IssueSharer> iterator = object2.iterator();
        while (iterator.hasNext()) {
            IssueSharer sharer = iterator.next();
            object = sharer;
            object2 = null;
            object = object2 = ((IssueSharer)((Object)object)).getUser();
            object2 = null;
            object2 = ((User)object).getId();
            if (!((Long)object2).equals(id)) continue;
            return sharer;
        }
        return null;
    }

    public IssueComment findCommentByCommentId(Long id) {
        Iterator iterator = this._ebean_get_comments().iterator();
        while (iterator.hasNext()) {
            IssueComment comment;
            IssueComment issueComment = comment = (IssueComment)iterator.next();
            Long l = null;
            l = issueComment.getId();
            if (!l.equals(id)) continue;
            return comment;
        }
        return null;
    }

    public List<IssueSharer> getSortedSharer() {
        Issue issue2 = this;
        Set<IssueSharer> set = null;
        set = issue2.getSharers();
        return new ArrayList<IssueSharer>(set);
    }

    public static int getCountOfMentionedOpenIssues(Long userId) {
        return finder.where().in("id", Mention.getMentioningIssueIds(userId)).eq("state", (Object)State.OPEN).findRowCount();
    }

    public static Issue from(Posting posting) {
        Issue issue2 = new Issue();
        AbstractPosting abstractPosting = posting;
        Object object = null;
        object = abstractPosting.getTitle();
        abstractPosting = issue2;
        abstractPosting.setTitle((String)object);
        abstractPosting = posting;
        object = null;
        object = abstractPosting.getBody();
        abstractPosting = issue2;
        abstractPosting.setBody((String)object);
        abstractPosting = posting;
        object = null;
        object = abstractPosting.getHistory();
        abstractPosting = issue2;
        abstractPosting.setHistory((String)object);
        abstractPosting = posting;
        object = null;
        object = abstractPosting.getCreatedDate();
        abstractPosting = issue2;
        abstractPosting.setCreatedDate((Date)object);
        abstractPosting = posting;
        object = null;
        object = abstractPosting.getUpdatedDate();
        abstractPosting = issue2;
        abstractPosting.setUpdatedDate((Date)object);
        abstractPosting = posting;
        object = null;
        object = abstractPosting.getAuthorId();
        abstractPosting = issue2;
        abstractPosting.setAuthorId((Long)object);
        abstractPosting = posting;
        object = null;
        object = abstractPosting.getAuthorLoginId();
        abstractPosting = issue2;
        abstractPosting.setAuthorLoginId((String)object);
        abstractPosting = posting;
        object = null;
        object = abstractPosting.getAuthorName();
        abstractPosting = issue2;
        abstractPosting.setAuthorName((String)object);
        abstractPosting = posting;
        object = null;
        object = abstractPosting.getProject();
        abstractPosting = issue2;
        abstractPosting.setProject((Project)object);
        return issue2;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public State getState() {
        return this._ebean_get_state();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setState(State state) {
        this._ebean_set_state(state);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getDueDate() {
        return this._ebean_get_dueDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDueDate(Date date) {
        this._ebean_set_dueDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Milestone getMilestone() {
        return this._ebean_get_milestone();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setMilestone(Milestone milestone2) {
        this._ebean_set_milestone(milestone2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLabels(Set<IssueLabel> set) {
        this._ebean_set_labels(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Assignee getAssignee() {
        return this._ebean_get_assignee();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAssignee(Assignee assignee) {
        this._ebean_set_assignee(assignee);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setComments(List<IssueComment> list2) {
        this._ebean_set_comments(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<IssueEvent> getEvents() {
        return this._ebean_get_events();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEvents(List<IssueEvent> list2) {
        this._ebean_set_events(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<IssueSharer> getSharers() {
        return this._ebean_get_sharers();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSharers(Set<IssueSharer> set) {
        this._ebean_set_sharers(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<User> getVoters() {
        return this._ebean_get_voters();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setVoters(Set<User> set) {
        this._ebean_set_voters(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getDueDateDesc() {
        return this.dueDateDesc;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDueDateDesc(Date date) {
        this.dueDateDesc = date;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getDueDateAsc() {
        return this.dueDateAsc;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDueDateAsc(Date date) {
        this.dueDateAsc = date;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getTargetProjectId() {
        return this.targetProjectId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setTargetProjectId(String string) {
        this.targetProjectId = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getParentIssueId() {
        return this.parentIssueId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setParentIssueId(String string) {
        this.parentIssueId = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Issue getParent() {
        return this._ebean_get_parent();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setParent(Issue issue2) {
        this._ebean_set_parent(issue2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Integer getWeight() {
        return this._ebean_get_weight();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setWeight(Integer n) {
        this._ebean_set_weight(n);
    }

    @Override
    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected State _ebean_get_state() {
        this._ebean_intercept.preGetter("state");
        return this.state;
    }

    protected void _ebean_set_state(State newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "state", (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected State _ebean_getni_state() {
        return this.state;
    }

    protected void _ebean_setni_state(State _newValue) {
        this.state = _newValue;
    }

    protected Date _ebean_get_dueDate() {
        this._ebean_intercept.preGetter("dueDate");
        return this.dueDate;
    }

    protected void _ebean_set_dueDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "dueDate", (Object)this._ebean_get_dueDate(), (Object)newValue);
        this.dueDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_dueDate() {
        return this.dueDate;
    }

    protected void _ebean_setni_dueDate(Date _newValue) {
        this.dueDate = _newValue;
    }

    protected Milestone _ebean_get_milestone() {
        this._ebean_intercept.preGetter("milestone");
        return this.milestone;
    }

    protected void _ebean_set_milestone(Milestone newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "milestone", (Object)this._ebean_get_milestone(), (Object)newValue);
        this.milestone = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Milestone _ebean_getni_milestone() {
        return this.milestone;
    }

    protected void _ebean_setni_milestone(Milestone _newValue) {
        this.milestone = _newValue;
    }

    protected Set _ebean_get_labels() {
        this._ebean_intercept.preGetter("labels");
        if (this.labels == null) {
            this.labels = new BeanSet();
            ((BeanCollection)this.labels).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.labels;
    }

    protected void _ebean_set_labels(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "labels", (Object)this._ebean_get_labels(), (Object)newValue);
        this.labels = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_labels() {
        return this.labels;
    }

    protected void _ebean_setni_labels(Set _newValue) {
        this.labels = _newValue;
    }

    protected Assignee _ebean_get_assignee() {
        this._ebean_intercept.preGetter("assignee");
        return this.assignee;
    }

    protected void _ebean_set_assignee(Assignee newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "assignee", (Object)this._ebean_get_assignee(), (Object)newValue);
        this.assignee = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Assignee _ebean_getni_assignee() {
        return this.assignee;
    }

    protected void _ebean_setni_assignee(Assignee _newValue) {
        this.assignee = _newValue;
    }

    protected List _ebean_get_comments() {
        this._ebean_intercept.preGetter("comments");
        if (this.comments == null) {
            this.comments = new BeanList();
        }
        return this.comments;
    }

    protected void _ebean_set_comments(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "comments", (Object)this._ebean_get_comments(), (Object)newValue);
        this.comments = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_comments() {
        return this.comments;
    }

    protected void _ebean_setni_comments(List _newValue) {
        this.comments = _newValue;
    }

    protected List _ebean_get_events() {
        this._ebean_intercept.preGetter("events");
        if (this.events == null) {
            this.events = new BeanList();
        }
        return this.events;
    }

    protected void _ebean_set_events(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "events", (Object)this._ebean_get_events(), (Object)newValue);
        this.events = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_events() {
        return this.events;
    }

    protected void _ebean_setni_events(List _newValue) {
        this.events = _newValue;
    }

    protected Set _ebean_get_sharers() {
        this._ebean_intercept.preGetter("sharers");
        if (this.sharers == null) {
            this.sharers = new BeanSet();
        }
        return this.sharers;
    }

    protected void _ebean_set_sharers(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "sharers", (Object)this._ebean_get_sharers(), (Object)newValue);
        this.sharers = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_sharers() {
        return this.sharers;
    }

    protected void _ebean_setni_sharers(Set _newValue) {
        this.sharers = _newValue;
    }

    protected Set _ebean_get_voters() {
        this._ebean_intercept.preGetter("voters");
        if (this.voters == null) {
            this.voters = new BeanSet();
            ((BeanCollection)this.voters).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.voters;
    }

    protected void _ebean_set_voters(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "voters", (Object)this._ebean_get_voters(), (Object)newValue);
        this.voters = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_voters() {
        return this.voters;
    }

    protected void _ebean_setni_voters(Set _newValue) {
        this.voters = _newValue;
    }

    protected Date _ebean_get_dueDateDesc() {
        return this.dueDateDesc;
    }

    protected void _ebean_set_dueDateDesc(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "dueDateDesc", (Object)this._ebean_get_dueDateDesc(), (Object)newValue);
        this.dueDateDesc = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_dueDateDesc() {
        return this.dueDateDesc;
    }

    protected void _ebean_setni_dueDateDesc(Date _newValue) {
        this.dueDateDesc = _newValue;
    }

    protected Date _ebean_get_dueDateAsc() {
        return this.dueDateAsc;
    }

    protected void _ebean_set_dueDateAsc(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "dueDateAsc", (Object)this._ebean_get_dueDateAsc(), (Object)newValue);
        this.dueDateAsc = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_dueDateAsc() {
        return this.dueDateAsc;
    }

    protected void _ebean_setni_dueDateAsc(Date _newValue) {
        this.dueDateAsc = _newValue;
    }

    protected String _ebean_get_targetProjectId() {
        return this.targetProjectId;
    }

    protected void _ebean_set_targetProjectId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "targetProjectId", (Object)this._ebean_get_targetProjectId(), (Object)newValue);
        this.targetProjectId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_targetProjectId() {
        return this.targetProjectId;
    }

    protected void _ebean_setni_targetProjectId(String _newValue) {
        this.targetProjectId = _newValue;
    }

    protected String _ebean_get_parentIssueId() {
        return this.parentIssueId;
    }

    protected void _ebean_set_parentIssueId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "parentIssueId", (Object)this._ebean_get_parentIssueId(), (Object)newValue);
        this.parentIssueId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_parentIssueId() {
        return this.parentIssueId;
    }

    protected void _ebean_setni_parentIssueId(String _newValue) {
        this.parentIssueId = _newValue;
    }

    protected Issue _ebean_get_parent() {
        this._ebean_intercept.preGetter("parent");
        return this.parent;
    }

    protected void _ebean_set_parent(Issue newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "parent", (Object)this._ebean_get_parent(), (Object)newValue);
        this.parent = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Issue _ebean_getni_parent() {
        return this.parent;
    }

    protected void _ebean_setni_parent(Issue _newValue) {
        this.parent = _newValue;
    }

    protected Integer _ebean_get_weight() {
        this._ebean_intercept.preGetter("weight");
        return this.weight;
    }

    protected void _ebean_set_weight(Integer newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "weight", (Object)this._ebean_get_weight(), (Object)newValue);
        this.weight = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Integer _ebean_getni_weight() {
        return this.weight;
    }

    protected void _ebean_setni_weight(Integer _newValue) {
        this.weight = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object _ebean_createCopy() {
        void p;
        Issue issue2 = new Issue();
        issue2._ebean_setni_id(this._ebean_getni_id());
        issue2._ebean_setni_title(this._ebean_getni_title());
        issue2._ebean_setni_body(this._ebean_getni_body());
        issue2._ebean_setni_history(this._ebean_getni_history());
        issue2._ebean_setni_createdDate(this._ebean_getni_createdDate());
        issue2._ebean_setni_updatedDate(this._ebean_getni_updatedDate());
        issue2._ebean_setni_authorId(this._ebean_getni_authorId());
        issue2._ebean_setni_authorLoginId(this._ebean_getni_authorLoginId());
        issue2._ebean_setni_authorName(this._ebean_getni_authorName());
        issue2._ebean_setni_updatedByAuthorId(this._ebean_getni_updatedByAuthorId());
        issue2._ebean_setni_project(this._ebean_getni_project());
        issue2._ebean_setni_number(this._ebean_getni_number());
        issue2._ebean_setni_numOfComments(this._ebean_getni_numOfComments());
        issue2.state = this.state;
        issue2.dueDate = this.dueDate;
        issue2.milestone = this.milestone;
        issue2.labels = this.labels;
        issue2.assignee = this.assignee;
        issue2.comments = this.comments;
        issue2.events = this.events;
        issue2.sharers = this.sharers;
        issue2.voters = this.voters;
        issue2.parent = this.parent;
        issue2.weight = this.weight;
        return p;
    }

    @Override
    public Object _ebean_getField(int index2, Object o) {
        Issue p = (Issue)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p._ebean_getni_id();
            }
            case 2: {
                return p._ebean_getni_title();
            }
            case 3: {
                return p._ebean_getni_body();
            }
            case 4: {
                return p._ebean_getni_history();
            }
            case 5: {
                return p._ebean_getni_createdDate();
            }
            case 6: {
                return p._ebean_getni_updatedDate();
            }
            case 7: {
                return p._ebean_getni_authorId();
            }
            case 8: {
                return p._ebean_getni_authorLoginId();
            }
            case 9: {
                return p._ebean_getni_authorName();
            }
            case 10: {
                return p._ebean_getni_updatedByAuthorId();
            }
            case 11: {
                return p._ebean_getni_author();
            }
            case 12: {
                return p._ebean_getni_project();
            }
            case 13: {
                return p._ebean_getni_number();
            }
            case 14: {
                return p._ebean_getni_numOfComments();
            }
            case 15: {
                return p.state;
            }
            case 16: {
                return p.dueDate;
            }
            case 17: {
                return p.milestone;
            }
            case 18: {
                return p.labels;
            }
            case 19: {
                return p.assignee;
            }
            case 20: {
                return p.comments;
            }
            case 21: {
                return p.events;
            }
            case 22: {
                return p.sharers;
            }
            case 23: {
                return p.voters;
            }
            case 24: {
                return p.dueDateDesc;
            }
            case 25: {
                return p.dueDateAsc;
            }
            case 26: {
                return p.targetProjectId;
            }
            case 27: {
                return p.parentIssueId;
            }
            case 28: {
                return p.parent;
            }
            case 29: {
                return p.weight;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Issue p = (Issue)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_title();
            }
            case 3: {
                return p._ebean_get_body();
            }
            case 4: {
                return p._ebean_get_history();
            }
            case 5: {
                return p._ebean_get_createdDate();
            }
            case 6: {
                return p._ebean_get_updatedDate();
            }
            case 7: {
                return p._ebean_get_authorId();
            }
            case 8: {
                return p._ebean_get_authorLoginId();
            }
            case 9: {
                return p._ebean_get_authorName();
            }
            case 10: {
                return p._ebean_get_updatedByAuthorId();
            }
            case 11: {
                return p._ebean_get_author();
            }
            case 12: {
                return p._ebean_get_project();
            }
            case 13: {
                return p._ebean_get_number();
            }
            case 14: {
                return p._ebean_get_numOfComments();
            }
            case 15: {
                return p._ebean_get_state();
            }
            case 16: {
                return p._ebean_get_dueDate();
            }
            case 17: {
                return p._ebean_get_milestone();
            }
            case 18: {
                return p._ebean_get_labels();
            }
            case 19: {
                return p._ebean_get_assignee();
            }
            case 20: {
                return p._ebean_get_comments();
            }
            case 21: {
                return p._ebean_get_events();
            }
            case 22: {
                return p._ebean_get_sharers();
            }
            case 23: {
                return p._ebean_get_voters();
            }
            case 24: {
                return p._ebean_get_dueDateDesc();
            }
            case 25: {
                return p._ebean_get_dueDateAsc();
            }
            case 26: {
                return p._ebean_get_targetProjectId();
            }
            case 27: {
                return p._ebean_get_parentIssueId();
            }
            case 28: {
                return p._ebean_get_parent();
            }
            case 29: {
                return p._ebean_get_weight();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setField(int index2, Object o, Object arg) {
        Issue p = (Issue)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_setni_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_setni_title((String)arg);
                return;
            }
            case 3: {
                p._ebean_setni_body((String)arg);
                return;
            }
            case 4: {
                p._ebean_setni_history((String)arg);
                return;
            }
            case 5: {
                p._ebean_setni_createdDate((Date)arg);
                return;
            }
            case 6: {
                p._ebean_setni_updatedDate((Date)arg);
                return;
            }
            case 7: {
                p._ebean_setni_authorId((Long)arg);
                return;
            }
            case 8: {
                p._ebean_setni_authorLoginId((String)arg);
                return;
            }
            case 9: {
                p._ebean_setni_authorName((String)arg);
                return;
            }
            case 10: {
                p._ebean_setni_updatedByAuthorId((Long)arg);
                return;
            }
            case 11: {
                p._ebean_setni_author((User)arg);
                return;
            }
            case 12: {
                p._ebean_setni_project((Project)arg);
                return;
            }
            case 13: {
                p._ebean_setni_number((Long)arg);
                return;
            }
            case 14: {
                p._ebean_setni_numOfComments((Integer)arg);
                return;
            }
            case 15: {
                p.state = (State)((Object)arg);
                return;
            }
            case 16: {
                p.dueDate = (Date)arg;
                return;
            }
            case 17: {
                p.milestone = (Milestone)arg;
                return;
            }
            case 18: {
                p.labels = (Set)arg;
                return;
            }
            case 19: {
                p.assignee = (Assignee)((Object)arg);
                return;
            }
            case 20: {
                p.comments = (List)arg;
                return;
            }
            case 21: {
                p.events = (List)arg;
                return;
            }
            case 22: {
                p.sharers = (Set)arg;
                return;
            }
            case 23: {
                p.voters = (Set)arg;
                return;
            }
            case 24: {
                p.dueDateDesc = (Date)arg;
                return;
            }
            case 25: {
                p.dueDateAsc = (Date)arg;
                return;
            }
            case 26: {
                p.targetProjectId = (String)arg;
                return;
            }
            case 27: {
                p.parentIssueId = (String)arg;
                return;
            }
            case 28: {
                p.parent = (Issue)arg;
                return;
            }
            case 29: {
                p.weight = (Integer)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Issue p = (Issue)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_title((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_body((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_history((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 6: {
                p._ebean_set_updatedDate((Date)arg);
                return;
            }
            case 7: {
                p._ebean_set_authorId((Long)arg);
                return;
            }
            case 8: {
                p._ebean_set_authorLoginId((String)arg);
                return;
            }
            case 9: {
                p._ebean_set_authorName((String)arg);
                return;
            }
            case 10: {
                p._ebean_set_updatedByAuthorId((Long)arg);
                return;
            }
            case 11: {
                p._ebean_set_author((User)arg);
                return;
            }
            case 12: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 13: {
                p._ebean_set_number((Long)arg);
                return;
            }
            case 14: {
                p._ebean_set_numOfComments((Integer)arg);
                return;
            }
            case 15: {
                p._ebean_set_state((State)((Object)arg));
                return;
            }
            case 16: {
                p._ebean_set_dueDate((Date)arg);
                return;
            }
            case 17: {
                p._ebean_set_milestone((Milestone)arg);
                return;
            }
            case 18: {
                p._ebean_set_labels((Set)arg);
                return;
            }
            case 19: {
                p._ebean_set_assignee((Assignee)((Object)arg));
                return;
            }
            case 20: {
                p._ebean_set_comments((List)arg);
                return;
            }
            case 21: {
                p._ebean_set_events((List)arg);
                return;
            }
            case 22: {
                p._ebean_set_sharers((Set)arg);
                return;
            }
            case 23: {
                p._ebean_set_voters((Set)arg);
                return;
            }
            case 24: {
                p._ebean_set_dueDateDesc((Date)arg);
                return;
            }
            case 25: {
                p._ebean_set_dueDateAsc((Date)arg);
                return;
            }
            case 26: {
                p._ebean_set_targetProjectId((String)arg);
                return;
            }
            case 27: {
                p._ebean_set_parentIssueId((String)arg);
                return;
            }
            case 28: {
                p._ebean_set_parent((Issue)arg);
                return;
            }
            case 29: {
                p._ebean_set_weight((Integer)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "title", "body", "history", DEFAULT_SORTER, "updatedDate", "authorId", "authorLoginId", "authorName", "updatedByAuthorId", "author", "project", "number", "numOfComments", "state", "dueDate", "milestone", "labels", "assignee", "comments", "events", "sharers", "voters", "dueDateDesc", "dueDateAsc", "targetProjectId", "parentIssueId", "parent", "weight"};
    }

    @Override
    public void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public Object _ebean_newInstance() {
        return new Issue();
    }
}

