/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanList;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import models.CodeCommentThread;
import models.CodeRange;
import models.Project;
import models.PullRequest;
import models.ReviewComment;
import models.UserIdent;
import models.enumeration.ResourceType;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import models.support.ReviewSearchCondition;
import play.core.enhancers.PropertiesEnhancer;
import play.data.format.Formats;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CommentThread
extends Model
implements ResourceConvertible,
EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, CommentThread> find = new Model.Finder(Long.class, CommentThread.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="author_id")), @AttributeOverride(name="loginId", column=@Column(name="author_login_id")), @AttributeOverride(name="name", column=@Column(name="author_name"))})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public UserIdent author;
    @OneToMany(mappedBy="thread", cascade={CascadeType.REMOVE})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<ReviewComment> reviewComments;
    @Enumerated(value=EnumType.STRING)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public ThreadState state;
    @Constraints.Required
    @Formats.DateTime(pattern="YYYY/MM/DD/hh/mm/ss")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date createdDate;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public PullRequest pullRequest;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    private static String _EBEAN_MARKER = "models.CommentThread";

    public CommentThread() {
        ArrayList<ReviewComment> arrayList = new ArrayList<ReviewComment>();
        CommentThread commentThread = this;
        commentThread.setReviewComments(arrayList);
    }

    public boolean isOnPullRequest() {
        CommentThread commentThread = this;
        PullRequest pullRequest2 = null;
        pullRequest2 = commentThread.getPullRequest();
        return pullRequest2 != null;
    }

    public static List<CommentThread> findByCommitId(String commitId) {
        return find.where().eq("commitId", (Object)commitId).order().desc("createdDate").findList();
    }

    public static <T extends CommentThread> List<T> findByCommitId(Model.Finder<Long, T> find, Project project2, String commitId) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return find.where().eq("commitId", (Object)commitId).eq("project.id", (Object)l).order().desc("createdDate").findList();
    }

    public static List<CommentThread> findByCommitIdAndState(String commitId, ThreadState state) {
        return find.where().eq("commitId", (Object)commitId).eq("state", (Object)state).order().desc("createdDate").findList();
    }

    public String toString() {
        CommentThread commentThread = this;
        Object object = null;
        object = commentThread.getId();
        StringBuilder stringBuilder = new StringBuilder().append("CommentThread{id=").append(object).append(", author=");
        commentThread = this;
        object = null;
        object = commentThread.getAuthor();
        StringBuilder stringBuilder2 = stringBuilder.append(object).append(", reviewComments=");
        commentThread = this;
        object = null;
        object = commentThread.getReviewComments();
        StringBuilder stringBuilder3 = stringBuilder2.append(object).append(", state=");
        commentThread = this;
        object = null;
        object = commentThread.getState();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", createdDate=");
        commentThread = this;
        object = null;
        object = commentThread.getCreatedDate();
        StringBuilder stringBuilder5 = stringBuilder4.append(object).append(", project=");
        commentThread = this;
        object = null;
        object = commentThread.getProject();
        return stringBuilder5.append(object).append('}').toString();
    }

    @Override
    public Resource asResource() {
        return new Resource(){

            @Override
            public String getId() {
                CommentThread commentThread = CommentThread.this;
                Long l = null;
                l = commentThread.getId();
                return String.valueOf(l);
            }

            @Override
            public Project getProject() {
                CommentThread commentThread = CommentThread.this;
                Project project2 = null;
                project2 = commentThread.getProject();
                return project2;
            }

            @Override
            public ResourceType getType() {
                return ResourceType.COMMENT_THREAD;
            }

            @Override
            public Long getAuthorId() {
                Object object = CommentThread.this;
                Object object2 = null;
                object = object2 = ((CommentThread)object).getAuthor();
                object2 = null;
                object2 = ((UserIdent)object).getId();
                return object2;
            }
        };
    }

    public void removeComment(ReviewComment reviewComment) {
        Model model = this;
        List<ReviewComment> list2 = null;
        list2 = model.getReviewComments();
        list2.remove(reviewComment);
        list2 = null;
        model = reviewComment;
        model.setThread((CommentThread)((Object)list2));
    }

    public void addComment(ReviewComment reviewComment) {
        Model model = this;
        Object object = null;
        object = model.getReviewComments();
        object.add((ReviewComment)reviewComment);
        object = this;
        model = reviewComment;
        model.setThread((CommentThread)object);
    }

    public ReviewComment getFirstReviewComment() {
        CommentThread commentThread = this;
        Long l = null;
        l = commentThread.getId();
        List<ReviewComment> list2 = ReviewComment.findByThread(l);
        if (!list2.isEmpty()) {
            return list2.get(0);
        }
        throw new IllegalStateException("This thread has no ReviewComment.");
    }

    public static int countReviewsBy(Long projectId, @Nullable ReviewSearchCondition cond) {
        if (cond == null) {
            cond = new ReviewSearchCondition();
        }
        return cond.asExpressionList((Project)Project.find.byId((Object)projectId)).findRowCount();
    }

    public static int count(PullRequest pullRequest2, String commitId, String path) {
        int count = 0;
        for (CommentThread thread : CommentThread.findByCommitId(commitId)) {
            Object object;
            Object object2;
            if (pullRequest2 != null) {
                object2 = thread;
                object = null;
                object = ((CommentThread)object2).getPullRequest();
                if (object != pullRequest2) continue;
            }
            if (path != null && thread instanceof CodeCommentThread) {
                object2 = (CodeCommentThread)thread;
                object = null;
                object2 = object = ((CodeCommentThread)object2).getCodeRange();
                object = null;
                object = ((CodeRange)object2).getPath();
                if (!((String)object).equals(path)) continue;
            }
            ++count;
        }
        return count;
    }

    public static int countOnCommit(Project project2, String commitId, String path) {
        int count = 0;
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getId();
        List threads = find.where().eq("commitId", (Object)commitId).eq("project.id", object2).eq("pullRequest.id", null).order().desc("createdDate").findList();
        for (CommentThread thread : threads) {
            if (path != null && thread instanceof CodeCommentThread) {
                object = (CodeCommentThread)thread;
                object2 = null;
                object = object2 = ((CodeCommentThread)object).getCodeRange();
                object2 = null;
                object2 = ((CodeRange)object).getPath();
                if (!((String)object2).equals(path)) continue;
            }
            ++count;
        }
        return count;
    }

    public String getChildCommentsSizeToString() {
        CommentThread commentThread = this;
        List<ReviewComment> list2 = null;
        list2 = commentThread.getReviewComments();
        if (list2.size() > 1) {
            commentThread = this;
            list2 = null;
            list2 = commentThread.getReviewComments();
            return String.valueOf(list2.size() - 1);
        }
        return "";
    }

    public boolean hasChildComments() {
        CommentThread commentThread = this;
        List<ReviewComment> list2 = null;
        list2 = commentThread.getReviewComments();
        return list2.size() > 1;
    }

    public static void deleteByPullRequest(PullRequest pullRequest2) {
        for (CommentThread commentThread : find.where().eq("pullRequest", (Object)pullRequest2).findList()) {
            commentThread.delete();
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public UserIdent getAuthor() {
        return this._ebean_get_author();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAuthor(UserIdent userIdent) {
        this._ebean_set_author(userIdent);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<ReviewComment> getReviewComments() {
        return this._ebean_get_reviewComments();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setReviewComments(List<ReviewComment> list2) {
        this._ebean_set_reviewComments(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public ThreadState getState() {
        return this._ebean_get_state();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setState(ThreadState threadState) {
        this._ebean_set_state(threadState);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreatedDate() {
        return this._ebean_get_createdDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreatedDate(Date date) {
        this._ebean_set_createdDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public PullRequest getPullRequest() {
        return this._ebean_get_pullRequest();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPullRequest(PullRequest pullRequest2) {
        this._ebean_set_pullRequest(pullRequest2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this._ebean_get_project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this._ebean_set_project(project2);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected UserIdent _ebean_get_author() {
        this._ebean_intercept.preGetter("author");
        return this.author;
    }

    protected void _ebean_set_author(UserIdent newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "author", (Object)this._ebean_get_author(), (Object)newValue);
        this.author = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected UserIdent _ebean_getni_author() {
        return this.author;
    }

    protected void _ebean_setni_author(UserIdent _newValue) {
        this.author = _newValue;
    }

    protected List _ebean_get_reviewComments() {
        this._ebean_intercept.preGetter("reviewComments");
        if (this.reviewComments == null) {
            this.reviewComments = new BeanList();
        }
        return this.reviewComments;
    }

    protected void _ebean_set_reviewComments(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "reviewComments", (Object)this._ebean_get_reviewComments(), (Object)newValue);
        this.reviewComments = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_reviewComments() {
        return this.reviewComments;
    }

    protected void _ebean_setni_reviewComments(List _newValue) {
        this.reviewComments = _newValue;
    }

    protected ThreadState _ebean_get_state() {
        this._ebean_intercept.preGetter("state");
        return this.state;
    }

    protected void _ebean_set_state(ThreadState newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "state", (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected ThreadState _ebean_getni_state() {
        return this.state;
    }

    protected void _ebean_setni_state(ThreadState _newValue) {
        this.state = _newValue;
    }

    protected Date _ebean_get_createdDate() {
        this._ebean_intercept.preGetter("createdDate");
        return this.createdDate;
    }

    protected void _ebean_set_createdDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "createdDate", (Object)this._ebean_get_createdDate(), (Object)newValue);
        this.createdDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_createdDate() {
        return this.createdDate;
    }

    protected void _ebean_setni_createdDate(Date _newValue) {
        this.createdDate = _newValue;
    }

    protected PullRequest _ebean_get_pullRequest() {
        this._ebean_intercept.preGetter("pullRequest");
        return this.pullRequest;
    }

    protected void _ebean_set_pullRequest(PullRequest newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "pullRequest", (Object)this._ebean_get_pullRequest(), (Object)newValue);
        this.pullRequest = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected PullRequest _ebean_getni_pullRequest() {
        return this.pullRequest;
    }

    protected void _ebean_setni_pullRequest(PullRequest _newValue) {
        this.pullRequest = _newValue;
    }

    protected Project _ebean_get_project() {
        this._ebean_intercept.preGetter("project");
        return this.project;
    }

    protected void _ebean_set_project(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "project", (Object)this._ebean_get_project(), (Object)newValue);
        this.project = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_project() {
        return this.project;
    }

    protected void _ebean_setni_project(Project _newValue) {
        this.project = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        CommentThread commentThread = new CommentThread();
        commentThread.id = this.id;
        commentThread.author = this.author;
        commentThread.reviewComments = this.reviewComments;
        commentThread.state = this.state;
        commentThread.createdDate = this.createdDate;
        commentThread.pullRequest = this.pullRequest;
        commentThread.project = this.project;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        CommentThread p = (CommentThread)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.author;
            }
            case 3: {
                return p.reviewComments;
            }
            case 4: {
                return p.state;
            }
            case 5: {
                return p.createdDate;
            }
            case 6: {
                return p.pullRequest;
            }
            case 7: {
                return p.project;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        CommentThread p = (CommentThread)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_author();
            }
            case 3: {
                return p._ebean_get_reviewComments();
            }
            case 4: {
                return p._ebean_get_state();
            }
            case 5: {
                return p._ebean_get_createdDate();
            }
            case 6: {
                return p._ebean_get_pullRequest();
            }
            case 7: {
                return p._ebean_get_project();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        CommentThread p = (CommentThread)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.author = (UserIdent)arg;
                return;
            }
            case 3: {
                p.reviewComments = (List)arg;
                return;
            }
            case 4: {
                p.state = (ThreadState)((Object)arg);
                return;
            }
            case 5: {
                p.createdDate = (Date)arg;
                return;
            }
            case 6: {
                p.pullRequest = (PullRequest)arg;
                return;
            }
            case 7: {
                p.project = (Project)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        CommentThread p = (CommentThread)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_author((UserIdent)arg);
                return;
            }
            case 3: {
                p._ebean_set_reviewComments((List)arg);
                return;
            }
            case 4: {
                p._ebean_set_state((ThreadState)((Object)arg));
                return;
            }
            case 5: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 6: {
                p._ebean_set_pullRequest((PullRequest)arg);
                return;
            }
            case 7: {
                p._ebean_set_project((Project)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "author", "reviewComments", "state", "createdDate", "pullRequest", "project"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        CommentThread commentThread = this;
        synchronized (commentThread) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CommentThread)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
        this._ebean_intercept.setEmbeddedLoaded((Object)this.author);
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return this._ebean_intercept.isEmbeddedNewOrDirty((Object)this.author);
    }

    public Object _ebean_newInstance() {
        return new CommentThread();
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static enum ThreadState {
        OPEN,
        CLOSED;

    }
}

