/*
 * Decompiled with CFR 0.152.
 */
package mailbox;

import akka.actor.Cancellable;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import mailbox.EmailHandler;
import models.Property;
import models.User;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Akka;
import play.libs.F;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import utils.Diagnostic;
import utils.SimpleDiagnostic;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
@NotThreadSafe
public class MailboxService {
    private IMAPStore store;
    private static IMAPFolder folder;
    private Thread idleThread;
    private Cancellable pollingSchedule;
    private boolean isStopping = false;
    private static final String IMAP_USE_KEY = "imap.use";
    private static final boolean IMAP_USE_DEFAULT = true;
    private static final String IMAP_FOLDER_KEY = "imap.folder";
    private static final String IMAP_FOLDER_DEFAULT = "inbox";
    private static final String IMAP_HOST_KEY = "imap.host";
    private static final String IMAP_PASSWORD_KEY = "imap.password";
    private static final String IMAP_SSL_KEY = "imap.ssl";
    private static final String IMAP_USER_KEY = "imap.user";

    private static Set<String> getMissingKeys(Configuration config, String ... keys) {
        HashSet<String> requiredKeys = new HashSet<String>(Arrays.asList(keys));
        requiredKeys.removeAll(config.keys());
        return requiredKeys;
    }

    private IMAPStore connect() throws MessagingException {
        Configuration config = Configuration.root();
        Set<String> missingKeys = MailboxService.getMissingKeys(config, IMAP_HOST_KEY, IMAP_USER_KEY, IMAP_PASSWORD_KEY);
        if (missingKeys.size() > 0) {
            throw new IllegalStateException("Cannot connect to the IMAP server because these are not configured: " + missingKeys);
        }
        Properties props = new Properties();
        String s = config.getBoolean(IMAP_SSL_KEY, Boolean.valueOf(false)) != false ? "s" : "";
        props.setProperty("mail.store.protocol", "imap" + s);
        Session session = Session.getDefaultInstance((Properties)props, null);
        this.store = (IMAPStore)session.getStore();
        this.store.connect(config.getString(IMAP_HOST_KEY), config.getString(IMAP_USER_KEY), config.getString(IMAP_PASSWORD_KEY));
        return this.store;
    }

    public void stop() {
        if (folder == null && this.store == null && this.pollingSchedule == null) {
            return;
        }
        this.isStopping = true;
        try {
            folder.close(true);
            this.store.close();
            if (this.pollingSchedule != null && !this.pollingSchedule.isCancelled()) {
                this.pollingSchedule.cancel();
            }
        }
        catch (MessagingException e) {
            Logger.error((String)"Error occurred while stop the email receiver", (Throwable)e);
        }
    }

    public void start() {
        if (Configuration.root().getString(IMAP_HOST_KEY) == null) {
            Logger.info((String)"Mailbox Service doesn't start because IMAP server is not configured.");
            return;
        }
        Configuration config = Configuration.root();
        if (!config.getBoolean(IMAP_USE_KEY, Boolean.valueOf(true)).booleanValue()) {
            return;
        }
        List users2 = User.find.where().ilike("email", config.getString(IMAP_USER_KEY) + "+%").findList();
        if (users2.size() == 1) {
            Logger.warn((String)("There is a user whose email is danger: " + users2));
        }
        if (users2.size() > 1) {
            Logger.warn((String)("There are some users whose email is danger: " + users2));
        }
        try {
            this.store = this.connect();
            folder = (IMAPFolder)this.store.getFolder(config.getString(IMAP_FOLDER_KEY, IMAP_FOLDER_DEFAULT));
            folder.open(1);
        }
        catch (Exception e) {
            Logger.error((String)"Failed to open IMAP folder", (Throwable)e);
            return;
        }
        this.handleNewMessagesAndStartListener();
        Diagnostic.register(new SimpleDiagnostic(){

            @Override
            public String checkOne() {
                if (MailboxService.this.idleThread == null) {
                    return "The Email Receiver is not initialized";
                }
                if (!MailboxService.this.idleThread.isAlive()) {
                    return "The Email Receiver is not running";
                }
                return null;
            }
        });
    }

    private void handleNewMessagesAndStartListener() {
        F.Promise promise = F.Promise.promise((F.Function0)new F.Function0<Void>(){

            public Void apply() {
                try {
                    EmailHandler.handleNewMessages(folder);
                }
                catch (MessagingException e) {
                    Logger.error((String)"Failed to handle new messages");
                }
                try {
                    MailboxService.this.startEmailListener();
                }
                catch (Exception e) {
                    MailboxService.this.startEmailPolling();
                }
                return null;
            }
        });
    }

    private IMAPFolder reopenFolder() throws MessagingException {
        if (this.store == null || !this.store.isConnected()) {
            this.store = this.connect();
        }
        IMAPFolder folder = (IMAPFolder)this.store.getFolder(Configuration.root().getString(IMAP_FOLDER_KEY, IMAP_FOLDER_DEFAULT));
        folder.open(1);
        return folder;
    }

    private void startEmailPolling() {
        Runnable polling = new Runnable(){

            @Override
            public void run() {
                try {
                    if (folder == null || !folder.isOpen()) {
                        folder = MailboxService.this.reopenFolder();
                    }
                    EmailHandler.handleNewMessages(folder);
                }
                catch (MessagingException e) {
                    Logger.error((String)"Failed to poll emails", (Throwable)e);
                    return;
                }
                try {
                    folder.close(true);
                }
                catch (MessagingException e) {
                    Logger.error((String)"Failed to close the IMAP folder", (Throwable)e);
                }
            }
        };
        this.pollingSchedule = Akka.system().scheduler().schedule(Duration.create((long)0L, (TimeUnit)TimeUnit.MINUTES), Duration.create((long)Configuration.root().getMilliseconds("application.mailbox.polling.interval", Long.valueOf(300000L)), (TimeUnit)TimeUnit.MILLISECONDS), polling, (ExecutionContext)Akka.system().dispatcher());
    }

    private void startEmailListener() throws MessagingException, UnsupportedOperationException {
        if (!((IMAPStore)folder.getStore()).hasCapability("IDLE")) {
            throw new UnsupportedOperationException("The imap server does not support IDLE command");
        }
        MessageCountListener messageCountListener = new MessageCountListener(){

            public void messagesAdded(@Nonnull MessageCountEvent e) {
                try {
                    EmailHandler.handleMessages(folder, e.getMessages());
                }
                catch (Exception e1) {
                    Logger.error((String)"Unexpected error occurs while handling messages", (Throwable)e1);
                }
            }

            public void messagesRemoved(MessageCountEvent e) {
            }
        };
        folder.addMessageCountListener(messageCountListener);
        this.idleThread = new Thread(){

            @Override
            public void run() {
                Logger.info((String)"Start the Email Receiving Thread");
                while (!MailboxService.this.isStopping) {
                    try {
                        folder.idle();
                    }
                    catch (FolderClosedException e) {
                        if (MailboxService.this.isStopping) break;
                        Logger.info((String)"Reopen the imap folder");
                        try {
                            folder = MailboxService.this.reopenFolder();
                        }
                        catch (MessagingException e1) {
                            Logger.warn((String)"Failed to reopen the imap folder; abort", (Throwable)e1);
                            break;
                        }
                    }
                    catch (Exception e) {
                        Logger.warn((String)"Failed to run IDLE command; abort", (Throwable)e);
                        break;
                    }
                }
                Logger.info((String)"Stop the Email Receiving Thread");
            }
        };
        this.idleThread.start();
    }

    static synchronized void updateLastSeenUID(IMAPMessage msg) throws MessagingException {
        long uid = folder.getUID((Message)msg);
        try {
            long lastSeenUID = Property.getLong(Property.Name.MAILBOX_LAST_SEEN_UID);
            if (uid <= lastSeenUID) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Property.set(Property.Name.MAILBOX_LAST_SEEN_UID, uid);
    }
}

