/*
 * Decompiled with CFR 0.152.
 */
package mailbox;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPMessage;
import info.schleichardt.play2.mailplugin.Mailer;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import mailbox.CreationViaEmail;
import mailbox.EmailAddressWithDetail;
import mailbox.IMAPMessageUtil;
import mailbox.MailboxService;
import mailbox.exceptions.IllegalDetailException;
import mailbox.exceptions.MailHandlerException;
import models.OriginalEmail;
import models.Project;
import models.Property;
import models.User;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import models.resource.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.joda.time.DateTime;
import play.Logger;
import play.api.i18n.Lang;
import play.core.enhancers.PropertiesEnhancer;
import play.i18n.Messages;
import utils.AccessControl;
import utils.Config;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
class EmailHandler {
    static void handleNewMessages(IMAPFolder folder) throws MessagingException {
        Long lastUIDValidity = Property.getLong(Property.Name.MAILBOX_LAST_UID_VALIDITY);
        Long lastSeenUID = Property.getLong(Property.Name.MAILBOX_LAST_SEEN_UID);
        long uidValidity = folder.getUIDValidity();
        if (lastUIDValidity != null && lastUIDValidity.equals(uidValidity) && lastSeenUID != null) {
            EmailHandler.handleMessages(folder, folder.getMessagesByUID(lastSeenUID + 1L, folder.getUIDNext()));
        }
        Property.set(Property.Name.MAILBOX_LAST_UID_VALIDITY, uidValidity);
    }

    static void handleMessages(IMAPFolder folder, Message[] messages) {
        EmailHandler.handleMessages(folder, Arrays.asList(messages));
    }

    private EmailHandler() {
    }

    private static List<String> parseMessageIds(String headerValue) {
        ArrayList<String> result2 = new ArrayList<String>();
        String cfws = "[^<]*(?:\\([^\\(]*\\))?[^<]*";
        Pattern pattern = Pattern.compile(cfws + "(<[^>]*>)" + cfws);
        Matcher matcher = pattern.matcher(headerValue);
        while (matcher.find()) {
            result2.add(matcher.group(1));
        }
        return result2;
    }

    private static void handleMessages(final IMAPFolder folder, List<Message> messages) {
        Collections.sort(messages, new Comparator<Message>(){

            @Override
            public int compare(Message m1, Message m2) {
                try {
                    return Long.compare(folder.getUID(m1), folder.getUID(m2));
                }
                catch (MessagingException e) {
                    Logger.warn((String)("Failed to compare uids of " + m1 + " and " + m2 + " while sorting messages by the uid; There is some remote chance of loss of mail requests."));
                    return 0;
                }
            }
        });
        for (Message msg : messages) {
            EmailHandler.handleMessage((IMAPMessage)msg);
        }
    }

    private static void handleMessage(@Nonnull IMAPMessage msg) {
        InternetAddress[] senderAddresses;
        Exception exception = null;
        long startTime = System.currentTimeMillis();
        try {
            if (EmailHandler.isAutoReplied(msg)) {
                return;
            }
        }
        catch (MessagingException e) {
            Logger.warn((String)("Failed to determine whether the email is auto-replied or not: " + msg), (Throwable)e);
        }
        try {
            OriginalEmail sameMessage = (OriginalEmail)((Object)OriginalEmail.finder.where().eq("messageId", (Object)msg.getMessageID()).findUnique());
            if (sameMessage != null) {
                if (sameMessage.getHandledDate().before(new DateTime().minusHours(1).toDate())) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = msg;
                    OriginalEmail originalEmail = sameMessage;
                    String string = null;
                    string = originalEmail.getMessageId();
                    objectArray[1] = string;
                    objectArray[2] = sameMessage.getHandledDate();
                    String warn = String.format("This email '%s' is ignored because an email with the same id '%s' was already handled at '%s'", objectArray);
                    Logger.warn((String)warn);
                }
                return;
            }
        }
        catch (MessagingException e) {
            Logger.warn((String)("Failed to determine whether the email is duplicated or not: " + msg), (Throwable)e);
        }
        try {
            senderAddresses = (InternetAddress[])msg.getFrom();
        }
        catch (Exception e) {
            Logger.error((String)"Failed to get senders from an email", (Throwable)e);
            return;
        }
        if (senderAddresses == null || senderAddresses.length == 0) {
            Logger.warn((String)("This email has no sender: " + msg));
            return;
        }
        for (InternetAddress senderAddress : senderAddresses) {
            ArrayList<String> errors = new ArrayList<String>();
            User author = User.findByEmail(senderAddress.getAddress());
            if (author.isAnonymous()) continue;
            try {
                EmailHandler.createResources(msg, author, errors);
            }
            catch (MailHandlerException e) {
                exception = e;
                errors.add(e.getMessage());
            }
            catch (Exception e) {
                String shortDescription;
                exception = e;
                try {
                    shortDescription = IMAPMessageUtil.asString(msg);
                }
                catch (MessagingException e1) {
                    shortDescription = msg.toString();
                }
                Logger.warn((String)("Failed to process an email: " + shortDescription), (Throwable)e);
                errors.add("Unexpected error occurs");
            }
            if (errors.size() > 0) {
                String username = senderAddress.getPersonal();
                String emailAddress = senderAddress.getAddress();
                String helpMessage = EmailHandler.getHelpMessage(Lang.apply((String)author.getPreferredLanguage()), username, errors);
                EmailHandler.reply(msg, username, emailAddress, helpMessage);
            }
            try {
                EmailHandler.log(msg, startTime, exception);
            }
            catch (MessagingException e) {
                Logger.warn((String)"Failed to log mail request", (Throwable)e);
            }
            try {
                MailboxService.updateLastSeenUID(msg);
            }
            catch (MessagingException e) {
                Logger.warn((String)"Failed to update the lastSeenUID", (Throwable)e);
            }
        }
    }

    private static boolean isAutoReplied(IMAPMessage message) throws MessagingException {
        return new MailHeader(message, "Auto-Submitted").containsIgnoreCase("auto-replied") || new MailHeader(message, "X-Naver-Absent").containsIgnoreCase("yes");
    }

    private static void createResources(IMAPMessage msg, User sender, List<String> errors) throws MessagingException, IOException, MailHandlerException, NoSuchAlgorithmException {
        Set<Resource> threads = EmailHandler.getThreads(msg);
        for (Project project2 : EmailHandler.getProjects(msg, sender, errors)) {
            boolean hasCommented = false;
            for (Resource thread : threads) {
                Project project3 = thread.getProject();
                Long l = null;
                Long l2 = l = project3.getId();
                project3 = project2;
                l = null;
                l = project3.getId();
                if (!l2.equals(l)) continue;
                switch (thread.getType()) {
                    case COMMENT_THREAD: {
                        CreationViaEmail.saveReviewComment(msg, thread);
                        break;
                    }
                    case ISSUE_POST: 
                    case BOARD_POST: {
                        CreationViaEmail.saveComment(msg, thread);
                    }
                }
                hasCommented = true;
            }
            if (hasCommented) continue;
            CreationViaEmail.saveIssue(msg, project2);
        }
    }

    private static Set<Project> getProjects(IMAPMessage msg, User sender, List<String> errors) throws MessagingException {
        HashSet<Project> projects2 = new HashSet<Project>();
        for (EmailAddressWithDetail address : EmailHandler.getMailAddressesToYobi(msg.getAllRecipients())) {
            Project project2;
            String detail = address.getDetail();
            if (StringUtils.isEmpty((CharSequence)detail)) continue;
            Lang lang = Lang.apply((String)sender.getPreferredLanguage());
            if (StringUtils.equalsIgnoreCase((CharSequence)detail, (CharSequence)"help")) {
                EmailHandler.reply(msg, sender, EmailHandler.getHelpMessage(lang, sender));
                continue;
            }
            try {
                project2 = EmailHandler.getProjectFromDetail(detail);
            }
            catch (IllegalDetailException e) {
                errors.add(Messages.get((Lang)lang, (String)"viaEmail.error.email", (Object[])new Object[]{address.toString()}));
                continue;
            }
            if (project2 == null || !AccessControl.isAllowed(sender, project2.asResource(), Operation.READ)) {
                errors.add(Messages.get((Lang)lang, (String)"viaEmail.error.forbidden.or.notfound", (Object[])new Object[]{address.toString()}));
                continue;
            }
            projects2.add(project2);
        }
        return projects2;
    }

    private static Set<Resource> getThreads(IMAPMessage msg) throws MessagingException {
        HashSet<String> messageIds = new HashSet<String>();
        String inReplyTo = msg.getInReplyTo();
        if (inReplyTo != null) {
            messageIds.addAll(EmailHandler.parseMessageIds(inReplyTo));
        }
        for (String references : ArrayUtils.nullToEmpty((String[])msg.getHeader("References"))) {
            if (references == null) continue;
            messageIds.addAll(EmailHandler.parseMessageIds(references));
        }
        HashSet<Resource> threads = new HashSet<Resource>();
        for (String messageId : messageIds) {
            block6: for (Resource resource : EmailHandler.findResourcesByMessageId(messageId)) {
                switch (resource.getType()) {
                    case COMMENT_THREAD: 
                    case ISSUE_POST: 
                    case BOARD_POST: {
                        threads.add(resource);
                        continue block6;
                    }
                    case REVIEW_COMMENT: {
                        threads.add(resource.getContainer());
                        continue block6;
                    }
                }
                Logger.info((String)("Cannot comment a resource of unknown type: " + resource));
            }
        }
        for (EmailAddressWithDetail address : EmailHandler.getMailAddressesToYobi(msg.getAllRecipients())) {
            Resource thread = EmailHandler.getResourceFromDetail(address.getDetail());
            if (thread == null) continue;
            threads.add(thread);
        }
        return threads;
    }

    @Nullable
    private static Resource getResourceFromDetail(@Nullable String detail) {
        if (detail == null) {
            return null;
        }
        String[] segments = detail.split("/", 3);
        if (segments.length < 3) {
            return null;
        }
        return Resource.findByPath(segments[2]);
    }

    private static Project getProjectFromDetail(String detail) throws IllegalDetailException {
        String[] segments = detail.split("/");
        if (segments.length < 2) {
            throw new IllegalDetailException();
        }
        return Project.findByOwnerAndProjectName(segments[0], segments[1]);
    }

    private static String getHelpMessage(Lang lang, String username, List<String> errors) {
        String help2 = "";
        String paragraphSeparator = "\n\n";
        String sampleProject = "dlab/hive";
        EmailAddressWithDetail address = new EmailAddressWithDetail(Config.getEmailFromImap());
        address.setDetail("dlab/hive/issue");
        help2 = help2 + Messages.get((Lang)lang, (String)"viaEmail.help.hello", (Object[])new Object[]{username});
        if (errors != null && errors.size() > 0) {
            String messageKey;
            String error;
            help2 = help2 + paragraphSeparator;
            if (errors.size() > 1) {
                error = "\n* " + StringUtils.join(errors, (String)"\n* ");
                messageKey = "viaEmail.help.errorMultiLine";
            } else {
                error = errors.get(0);
                messageKey = "viaEmail.help.errorSingleLine";
            }
            help2 = help2 + Messages.get((Lang)lang, (String)messageKey, (Object[])new Object[]{Config.getSiteName(), error});
        }
        help2 = help2 + paragraphSeparator;
        help2 = help2 + Messages.get((Lang)lang, (String)"viaEmail.help.intro", (Object[])new Object[]{Config.getSiteName()});
        help2 = help2 + paragraphSeparator;
        help2 = help2 + Messages.get((Lang)lang, (String)"viaEmail.help.description", (Object[])new Object[]{sampleProject, address});
        help2 = help2 + paragraphSeparator;
        help2 = help2 + Messages.get((Lang)lang, (String)"viaEmail.help.bye", (Object[])new Object[]{Config.getSiteName()});
        return help2;
    }

    private static String getHelpMessage(Lang lang, User to) {
        return EmailHandler.getHelpMessage(lang, to, null);
    }

    private static String getHelpMessage(Lang lang, User to, List<String> errors) {
        User user = to;
        String string = null;
        string = user.getName();
        return EmailHandler.getHelpMessage(lang, string, errors);
    }

    private static void reply(IMAPMessage origin, String username, String emailAddress, String msg) {
        HtmlEmail email = new HtmlEmail();
        try {
            email.setFrom(Config.getEmailFromSmtp(), Config.getSiteName());
            email.addTo(emailAddress, username);
            String subject = !origin.getSubject().toLowerCase().startsWith("re:") ? "Re: " + origin.getSubject() : origin.getSubject();
            email.setSubject(subject);
            email.setTextMsg(msg);
            email.setCharset("utf-8");
            email.setSentDate(new Date());
            email.addHeader("In-Reply-To", origin.getMessageID());
            email.addHeader("References", origin.getMessageID());
            Mailer.send((Email)email);
            String escapedTitle = email.getSubject().replace("\"", "\\\"");
            String logEntry = String.format("\"%s\" %s", escapedTitle, email.getToAddresses());
            Logger.of((String)"mail").info(logEntry);
        }
        catch (Exception e) {
            Logger.warn((String)("Failed to send an email: " + email + "\n" + ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    private static void reply(IMAPMessage origin, User to, String msg) {
        User user = to;
        String string = null;
        String string2 = string = user.getName();
        user = to;
        string = null;
        string = user.getEmail();
        EmailHandler.reply(origin, string2, string, msg);
    }

    private static Set<EmailAddressWithDetail> getMailAddressesToYobi(Address[] addresses) {
        HashSet<EmailAddressWithDetail> addressesToYobi = new HashSet<EmailAddressWithDetail>();
        if (addresses != null) {
            for (Address recipient : addresses) {
                EmailAddressWithDetail address = new EmailAddressWithDetail(((InternetAddress)recipient).getAddress());
                if (!address.isToYobi()) continue;
                addressesToYobi.add(address);
            }
        }
        return addressesToYobi;
    }

    private static void log(@Nonnull IMAPMessage message, long startTime, Exception exception) throws MessagingException {
        String time = Long.valueOf(startTime) != null ? System.currentTimeMillis() - startTime + "ms" : "-";
        String entry = String.format("%s %s %s", IMAPMessageUtil.asString(message), exception == null ? "SUCCESS" : "FAILED", time);
        if (exception != null && !(exception instanceof MailHandlerException)) {
            Logger.of((String)"mail.in").error(entry, (Throwable)exception);
        } else {
            Logger.of((String)"mail.in").info(entry);
        }
    }

    @Nonnull
    public static Set<Resource> findResourcesByMessageId(String messageId) {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set originalEmails = OriginalEmail.finder.where().eq("messageId", (Object)messageId).findSet();
        if (originalEmails.size() > 0) {
            Iterator iterator = originalEmails.iterator();
            while (iterator.hasNext()) {
                OriginalEmail originalEmail;
                OriginalEmail originalEmail2 = originalEmail = (OriginalEmail)((Object)iterator.next());
                Object object = null;
                ResourceType resourceType = object = originalEmail2.getResourceType();
                originalEmail2 = originalEmail;
                object = null;
                object = originalEmail2.getResourceId();
                resources.add(Resource.get(resourceType, (String)object));
            }
            return resources;
        }
        try {
            String resourcePath = IMAPMessageUtil.getIdLeftFromMessageId(messageId);
            Resource resource = Resource.findByPath(resourcePath);
            if (resource != null) {
                resources.add(resource);
            }
        }
        catch (Exception e) {
            Logger.info((String)("Error while finding a resource by message-id '" + messageId + "'"), (Throwable)e);
        }
        return resources;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static class MailHeader {
        private final IMAPMessage message;
        private final String name;

        public MailHeader(@Nonnull IMAPMessage message, @Nonnull String name) {
            this.message = message;
            this.name = name;
        }

        public boolean containsIgnoreCase(@Nonnull String expectedValue) throws MessagingException {
            String[] values = this.message.getHeader(this.name);
            if (values == null) {
                return false;
            }
            for (String value : values) {
                int semicolon = value.indexOf(59);
                if (semicolon >= 0) {
                    value = value.substring(0, semicolon);
                }
                if (!value.trim().equalsIgnoreCase(expectedValue)) continue;
                return true;
            }
            return false;
        }
    }
}

