/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import data.Exchanger;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class DefaultExchanger
implements Exchanger {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final String DATA_BATCH_SIZE_KEY = "data.batch.size";

    protected Long timestamp(Timestamp timestamp) {
        if (timestamp != null) {
            return timestamp.getTime();
        }
        return null;
    }

    protected Long date(Date date) {
        if (date != null) {
            return date.getTime();
        }
        return null;
    }

    protected Timestamp timestamp(long time) {
        if (time == 0L) {
            return null;
        }
        return new Timestamp(time);
    }

    protected Date date(long time) {
        if (time == 0L) {
            return null;
        }
        return new Date(time);
    }

    protected void setNullableLong(PreparedStatement ps, short index2, JsonNode node, String column) throws SQLException {
        if (node.get(column).isNull()) {
            ps.setNull(index2, -5);
        } else {
            ps.setLong(index2, node.get(column).longValue());
        }
    }

    protected String clobString(@Nullable Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        Reader reader = clob.getCharacterStream();
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((Reader)reader, (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setClob(PreparedStatement ps, short index2, JsonNode node, String column) throws SQLException {
        String value = node.get(column).textValue();
        if (value == null) {
            ps.setNull(index2, 2005);
        } else {
            Clob clob = ps.getConnection().createClob();
            clob.setString(1L, value);
            ps.setClob((int)index2, clob);
        }
    }

    protected String values(int size) {
        String values = "VALUES (";
        for (int i = 0; i < size - 1; ++i) {
            values = values + "?, ";
        }
        values = values + "?)";
        return values;
    }

    protected void putLong(JsonGenerator generator, String fieldName, ResultSet rs, short index2) throws SQLException, IOException {
        generator.writeFieldName(fieldName);
        long value = rs.getLong(index2);
        if (rs.wasNull()) {
            generator.writeNull();
        } else {
            generator.writeNumber(value);
        }
    }

    protected void putInt(JsonGenerator generator, String fieldName, ResultSet rs, short index2) throws SQLException, IOException {
        generator.writeFieldName(fieldName);
        int value = rs.getInt(index2);
        if (rs.wasNull()) {
            generator.writeNull();
        } else {
            generator.writeNumber(value);
        }
    }

    protected void putString(JsonGenerator generator, String fieldName, ResultSet rs, short index2) throws SQLException, IOException {
        generator.writeFieldName(fieldName);
        String string = rs.getString(index2);
        if (string == null) {
            generator.writeNull();
        } else {
            generator.writeString(string);
        }
    }

    protected void putBoolean(JsonGenerator generator, String fieldName, ResultSet rs, short index2) throws SQLException, IOException {
        generator.writeFieldName(fieldName);
        generator.writeBoolean(rs.getBoolean(index2));
    }

    protected void putTimestamp(JsonGenerator generator, String fieldName, ResultSet rs, short index2) throws SQLException, IOException {
        generator.writeFieldName(fieldName);
        Timestamp timestamp = rs.getTimestamp(index2);
        if (timestamp == null) {
            generator.writeNull();
        } else {
            generator.writeNumber(timestamp.getTime());
        }
    }

    protected void putDate(JsonGenerator generator, String fieldName, ResultSet rs, short index2) throws SQLException, IOException {
        generator.writeFieldName(fieldName);
        Date date = rs.getDate(index2);
        if (date == null) {
            generator.writeNull();
        } else {
            generator.writeNumber(date.getTime());
        }
    }

    protected void putClob(JsonGenerator generator, String fieldName, ResultSet rs, short index2) throws SQLException, IOException {
        generator.writeFieldName(fieldName);
        String clobString = this.clobString(rs.getClob(index2));
        if (clobString == null) {
            generator.writeNull();
        } else {
            generator.writeString(clobString);
        }
    }

    @Override
    public void exportData(String dbName, String catalogName, final JsonGenerator generator, JdbcTemplate jdbcTemplate) throws IOException {
        generator.writeFieldName(this.getTable());
        generator.writeStartArray();
        final int[] rowCount = new int[]{0};
        jdbcTemplate.query(this.getSelectSql(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                try {
                    generator.writeStartObject();
                    DefaultExchanger.this.setNode(generator, rs);
                    generator.writeEndObject();
                    rowCount[0] = rowCount[0] + 1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
        generator.writeEndArray();
        Logger.info((String)"exported {{}} {}", (Object[])new Object[]{rowCount[0], this.getTable()});
        if (this.hasSequence()) {
            String sequenceName = this.sequenceName();
            long sequenceValue = 0L;
            if (dbName.equalsIgnoreCase("MySQL")) {
                String sql = String.format("SELECT `AUTO_INCREMENT` FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s'", catalogName, this.getTable());
                sequenceValue = (Long)jdbcTemplate.queryForObject(sql, Long.class);
            } else if (dbName.equalsIgnoreCase("H2")) {
                sequenceValue = (Long)jdbcTemplate.queryForObject("CALL NEXT VALUE FOR " + sequenceName, Long.class);
            }
            generator.writeFieldName(sequenceName);
            generator.writeNumber(sequenceValue);
            Logger.info((String)"exported sequence {{}}", (Object[])new Object[]{this.sequenceName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(String dbName, JsonParser parser, JdbcTemplate jdbcTemplate) throws IOException {
        DataSourceTransactionManager tm = new DataSourceTransactionManager(jdbcTemplate.getDataSource());
        TransactionStatus ts = tm.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            if (dbName.equals("MySQL")) {
                jdbcTemplate.update("SET FOREIGN_KEY_CHECKS = 0");
                jdbcTemplate.update("SET NAMES 'utf8mb4'");
            }
            Configuration config = Configuration.root();
            int batchSize = config.getInt(DATA_BATCH_SIZE_KEY, Integer.valueOf(100));
            if (parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = parser.getCurrentName();
                Logger.debug((String)"importing {}", (Object[])new Object[]{fieldName});
                if (fieldName.equalsIgnoreCase(this.getTable())) {
                    this.truncateTable(jdbcTemplate);
                    JsonToken current = parser.nextToken();
                    if (current == JsonToken.START_ARRAY) {
                        this.importDataFromArray(parser, jdbcTemplate, batchSize);
                        this.importSequence(dbName, parser, jdbcTemplate);
                    } else {
                        Logger.info((String)"Error: records should be an array: skipping.");
                        parser.skipChildren();
                    }
                }
            }
            tm.commit(ts);
        }
        catch (Exception e) {
            e.printStackTrace();
            tm.rollback(ts);
        }
        finally {
            if (dbName.equals("MySQL")) {
                jdbcTemplate.update("SET FOREIGN_KEY_CHECKS = 1");
            }
        }
    }

    private void importSequence(String dbName, JsonParser parser, JdbcTemplate jdbcTemplate) throws IOException {
        if (this.hasSequence()) {
            JsonToken current;
            String fieldName;
            JsonToken fieldNameToken = parser.nextToken();
            if (fieldNameToken == JsonToken.FIELD_NAME && (fieldName = parser.getCurrentName()).equalsIgnoreCase(this.sequenceName()) && (current = parser.nextToken()) == JsonToken.VALUE_NUMBER_INT) {
                long sequenceValue = parser.getNumberValue().longValue();
                if (dbName.equals("MySQL")) {
                    jdbcTemplate.execute("ALTER TABLE " + this.getTable() + " AUTO_INCREMENT = " + sequenceValue);
                } else if (dbName.equals("H2")) {
                    jdbcTemplate.execute("ALTER SEQUENCE " + this.sequenceName() + " RESTART WITH " + sequenceValue);
                }
            }
            Logger.info((String)"imported sequence {{}}", (Object[])new Object[]{this.sequenceName()});
        }
    }

    private void importDataFromArray(JsonParser parser, JdbcTemplate jdbcTemplate, int batchSize) throws IOException {
        int importedNodesCount = 0;
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            JsonNode node = (JsonNode)parser.readValueAsTree();
            nodes.add(node);
            if (nodes.size() != batchSize) continue;
            importedNodesCount += this.batchUpdate(jdbcTemplate, nodes).length;
            nodes.clear();
        }
        if (nodes.size() > 0) {
            importedNodesCount += this.batchUpdate(jdbcTemplate, nodes).length;
        }
        Logger.info((String)"imported {{}} {}", (Object[])new Object[]{importedNodesCount, this.getTable()});
    }

    private void truncateTable(JdbcTemplate jdbcTemplate) {
        Logger.debug((String)"truncate table {}", (Object[])new Object[]{this.getTable()});
        jdbcTemplate.execute("TRUNCATE TABLE " + this.getTable());
        Logger.debug((String)"truncated table {}", (Object[])new Object[]{this.getTable()});
    }

    private int[] batchUpdate(JdbcTemplate jdbcTemplate, final List<JsonNode> nodes) {
        int[] updateCounts = jdbcTemplate.batchUpdate(this.getInsertSql(), new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                DefaultExchanger.this.setPreparedStatement(ps, (JsonNode)nodes.get(i));
            }

            public int getBatchSize() {
                return nodes.size();
            }
        });
        return updateCounts;
    }

    protected abstract void setPreparedStatement(PreparedStatement var1, JsonNode var2) throws SQLException;

    protected abstract void setNode(JsonGenerator var1, ResultSet var2) throws IOException, SQLException;

    protected abstract String getInsertSql();

    protected abstract String getSelectSql();

    protected boolean hasSequence() {
        return true;
    }

    protected String sequenceName() {
        return this.getTable() + "_SEQ";
    }
}

