/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import data.Exchanger;
import data.exchangers.AssigneeDataExchanger;
import data.exchangers.AttachmentDataExchanger;
import data.exchangers.CommentThreadDataExchanger;
import data.exchangers.CommentThreadUserDataExchanger;
import data.exchangers.CommitCommentDataExchanger;
import data.exchangers.EmailDataExchanger;
import data.exchangers.IssueCommentDataExchanger;
import data.exchangers.IssueCommentVoterDataExchanger;
import data.exchangers.IssueDataExchanger;
import data.exchangers.IssueEventDataExchanger;
import data.exchangers.IssueIssueLabelDataExchanger;
import data.exchangers.IssueLabelCategoryDataExchanger;
import data.exchangers.IssueLabelDataExchanger;
import data.exchangers.IssueVoterDataExchanger;
import data.exchangers.LabelDataExchanger;
import data.exchangers.MentionDataExchanger;
import data.exchangers.MilestoneDataExchanger;
import data.exchangers.NotificationEventDataExchanger;
import data.exchangers.NotificationEventUserDataExchanger;
import data.exchangers.NotificationMailDataExchanger;
import data.exchangers.OrganizationDataExchanger;
import data.exchangers.OrganizationUserDataExchanger;
import data.exchangers.OriginalEmailDataExchanger;
import data.exchangers.PostingCommentDataExchanger;
import data.exchangers.PostingDataExchanger;
import data.exchangers.ProjectDataExchanger;
import data.exchangers.ProjectLabelDataExchanger;
import data.exchangers.ProjectMenuDataExchanger;
import data.exchangers.ProjectPushedBranchDataExchanger;
import data.exchangers.ProjectTransferDataExchanger;
import data.exchangers.ProjectUserDataExchanger;
import data.exchangers.ProjectVisitationDataExchanger;
import data.exchangers.PropertyDataExchanger;
import data.exchangers.PullRequestCommitDataExchanger;
import data.exchangers.PullRequestDataExchanger;
import data.exchangers.PullRequestEventDataExchanger;
import data.exchangers.PullRequestReviewersDataExchanger;
import data.exchangers.RecentlyVisitedProjectsDataExchanger;
import data.exchangers.ReviewCommentDataExchanger;
import data.exchangers.RoleDataExchanger;
import data.exchangers.SiteAdminDataExchanger;
import data.exchangers.UnwatchDataExchanger;
import data.exchangers.UserDataExchanger;
import data.exchangers.UserEnrolledOrganizationDataExchanger;
import data.exchangers.UserEnrolledProjectDataExchanger;
import data.exchangers.UserProjectNotificationDataExchanger;
import data.exchangers.WatchDataExchanger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.sql.DataSource;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.DB;

@Service
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DataService {
    private List<Exchanger> exchangers = new ArrayList<Exchanger>();
    private static final Comparator<Exchanger> COMPARATOR = new Comparator<Exchanger>(){

        @Override
        public int compare(Exchanger ex1, Exchanger ex2) {
            return ex1.getTable().compareTo(ex2.getTable());
        }
    };
    String dataSourceName;

    public DataService() {
        this.exchangers.add(new AssigneeDataExchanger());
        this.exchangers.add(new AttachmentDataExchanger());
        this.exchangers.add(new CommentThreadDataExchanger());
        this.exchangers.add(new CommentThreadUserDataExchanger());
        this.exchangers.add(new CommitCommentDataExchanger());
        this.exchangers.add(new EmailDataExchanger());
        this.exchangers.add(new IssueCommentDataExchanger());
        this.exchangers.add(new IssueCommentVoterDataExchanger());
        this.exchangers.add(new IssueDataExchanger());
        this.exchangers.add(new IssueEventDataExchanger());
        this.exchangers.add(new IssueIssueLabelDataExchanger());
        this.exchangers.add(new IssueLabelCategoryDataExchanger());
        this.exchangers.add(new IssueLabelDataExchanger());
        this.exchangers.add(new IssueVoterDataExchanger());
        this.exchangers.add(new LabelDataExchanger());
        this.exchangers.add(new MentionDataExchanger());
        this.exchangers.add(new MilestoneDataExchanger());
        this.exchangers.add(new NotificationEventDataExchanger());
        this.exchangers.add(new NotificationEventUserDataExchanger());
        this.exchangers.add(new NotificationMailDataExchanger());
        this.exchangers.add(new OrganizationDataExchanger());
        this.exchangers.add(new OrganizationUserDataExchanger());
        this.exchangers.add(new OriginalEmailDataExchanger());
        this.exchangers.add(new PostingCommentDataExchanger());
        this.exchangers.add(new PostingDataExchanger());
        this.exchangers.add(new ProjectDataExchanger());
        this.exchangers.add(new ProjectLabelDataExchanger());
        this.exchangers.add(new ProjectMenuDataExchanger());
        this.exchangers.add(new ProjectPushedBranchDataExchanger());
        this.exchangers.add(new ProjectTransferDataExchanger());
        this.exchangers.add(new ProjectUserDataExchanger());
        this.exchangers.add(new ProjectVisitationDataExchanger());
        this.exchangers.add(new PropertyDataExchanger());
        this.exchangers.add(new PullRequestCommitDataExchanger());
        this.exchangers.add(new PullRequestDataExchanger());
        this.exchangers.add(new PullRequestEventDataExchanger());
        this.exchangers.add(new PullRequestReviewersDataExchanger());
        this.exchangers.add(new RecentlyVisitedProjectsDataExchanger());
        this.exchangers.add(new ReviewCommentDataExchanger());
        this.exchangers.add(new RoleDataExchanger());
        this.exchangers.add(new SiteAdminDataExchanger());
        this.exchangers.add(new UnwatchDataExchanger());
        this.exchangers.add(new UserDataExchanger());
        this.exchangers.add(new UserEnrolledOrganizationDataExchanger());
        this.exchangers.add(new UserEnrolledProjectDataExchanger());
        this.exchangers.add(new UserProjectNotificationDataExchanger());
        this.exchangers.add(new WatchDataExchanger());
        Collections.sort(this.exchangers, COMPARATOR);
        this.dataSourceName = Configuration.root().getString("ebeanconfig.datasource.default", "default");
    }

    public InputStream exportData() {
        final DateTime start = DateTime.now();
        DataSource dataSource = DB.getDataSource((String)this.dataSourceName);
        final JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        final String dbName = this.getDBName(dataSource);
        final String catalogName = this.getCatalogName(dataSource);
        ObjectMapper mapper = DataService.getObjectMapper();
        final JsonFactory factory = mapper.getFactory();
        PipedInputStream in = new PipedInputStream();
        try {
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        JsonGenerator generator = factory.createGenerator((OutputStream)out, JsonEncoding.UTF8);
                        generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
                        generator.writeStartObject();
                        for (Exchanger exchanger : DataService.this.exchangers) {
                            exchanger.exportData(dbName, catalogName, generator, jdbcTemplate);
                        }
                        generator.writeEndObject();
                        generator.close();
                        DateTime end = DateTime.now();
                        Duration duration = new Duration((ReadableInstant)start, (ReadableInstant)end);
                        Logger.info((String)"Data export took {{}}", (Object[])new Object[]{duration.getStandardSeconds()});
                    }
                    catch (IOException e) {
                        Logger.error((String)"Failed to export data");
                    }
                }
            }).start();
            return in;
        }
        catch (IOException e) {
            Logger.error((String)"Failed to export data");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String getCatalogName(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String string = connection.getCatalog();
            return string;
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("failed to get connection", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new CleanupFailureDataAccessException("failed to close connection", (Throwable)e);
                }
            }
        }
    }

    public void importData(File file) throws IOException {
        DateTime start = DateTime.now();
        ObjectMapper mapper = DataService.getObjectMapper();
        JsonFactory factory = mapper.getFactory();
        JsonParser parser = factory.createParser(file);
        JsonToken current = parser.nextToken();
        if (current != JsonToken.START_OBJECT) {
            Logger.info((String)"Data import failed cause of root if not an object.");
            return;
        }
        DataSource dataSource = DB.getDataSource((String)this.dataSourceName);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        String dbName = this.getDBName(dataSource);
        this.disableReferentialIntegtiry(dbName, jdbcTemplate);
        String message = "";
        try {
            for (Exchanger exchanger : this.exchangers) {
                exchanger.importData(dbName, parser, jdbcTemplate);
            }
            message = "Data import done. it took {{}}";
            this.enableReferentialIntegrity(dbName, jdbcTemplate);
        }
        catch (Exception e) {
            try {
                message = "Data import failed. it took {{}}";
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.enableReferentialIntegrity(dbName, jdbcTemplate);
                DateTime end = DateTime.now();
                Duration duration = new Duration((ReadableInstant)start, (ReadableInstant)end);
                Logger.info((String)message, (Object[])new Object[]{duration.getStandardSeconds()});
                throw throwable;
            }
        }
        DateTime end = DateTime.now();
        Duration duration = new Duration((ReadableInstant)start, (ReadableInstant)end);
        Logger.info((String)message, (Object[])new Object[]{duration.getStandardSeconds()});
    }

    private String getDBName(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("failed to get meta data", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new CleanupFailureDataAccessException("failed to close connection", (Throwable)e);
                }
            }
        }
    }

    private void enableReferentialIntegrity(String dbName, JdbcTemplate jdbcTemplate) {
        if (dbName.equals("H2")) {
            for (Exchanger exchanger : this.exchangers) {
                jdbcTemplate.update("ALTER TABLE " + exchanger.getTable() + " SET REFERENTIAL_INTEGRITY TRUE");
            }
            jdbcTemplate.update("SET REFERENTIAL_INTEGRITY TRUE");
        }
    }

    private void disableReferentialIntegtiry(String dbName, JdbcTemplate jdbcTemplate) {
        if (dbName.equals("H2")) {
            jdbcTemplate.update("SET REFERENTIAL_INTEGRITY FALSE");
            for (Exchanger exchanger : this.exchangers) {
                jdbcTemplate.update("ALTER TABLE " + exchanger.getTable() + " SET REFERENTIAL_INTEGRITY FALSE");
            }
        }
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }
}

