/*
 * Decompiled with CFR 0.152.
 */
package controllers.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Set;
import models.AbstractPosting;
import models.Issue;
import models.Posting;
import models.Project;
import models.User;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Result;
import utils.RouteUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class WatcherApi
extends Controller {
    @Transactional
    public static Result getWatchers(String owner, String projectName, Long number) {
        int LIMIT = 100;
        int counter = 0;
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        AbstractPosting posting = null;
        String type = WatcherApi.request().getQueryString("type");
        if (StringUtils.isNotEmpty((CharSequence)type) && type.equals("issues")) {
            posting = AbstractPosting.findByNumber(Issue.finder, project2, number);
        } else if (StringUtils.isNotEmpty((CharSequence)type) && type.equals("posts")) {
            posting = AbstractPosting.findByNumber(Posting.finder, project2, number);
        } else {
            return WatcherApi.ok();
        }
        Set<User> watchers2 = posting.getWatchers();
        ObjectNode json = Json.newObject();
        ArrayList<ObjectNode> watcherList = new ArrayList<ObjectNode>();
        for (User user : watchers2) {
            ++counter;
            ObjectNode watcher = Json.newObject();
            User user2 = user;
            String string = null;
            string = user2.getName();
            watcher.put("name", string);
            watcher.put("url", RouteUtil.getUrl(user));
            watcherList.add(watcher);
            if (counter != 100) continue;
            break;
        }
        json.put("totalWatchers", watchers2.size());
        json.put("watchersInList", counter);
        json.put("watchers", Json.toJson(watcherList));
        return WatcherApi.ok((JsonNode)json);
    }
}

