/*
 * Decompiled with CFR 0.152.
 */
package controllers.api;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import models.AbstractPosting;
import models.Assignee;
import models.FavoriteIssue;
import models.FavoriteOrganization;
import models.FavoriteProject;
import models.Issue;
import models.IssueComment;
import models.NotificationMail;
import models.Organization;
import models.Posting;
import models.PostingComment;
import models.Project;
import models.Statistics;
import models.User;
import models.enumeration.IssueFilterType;
import models.enumeration.UserState;
import models.support.IssueSearchCondition;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.util.ByteSource;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.With;
import utils.JodaDateUtil;
import utils.SHA256Util;
import utils.SiteManagerAuthAction;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class UserApi
extends Controller {
    private static final int HASH_ITERATIONS = 1024;
    private static final String AUTHORIZATION_HEADER_PREFIX = "token";
    private static final int AUTHORIZATION_HEADER_MIN_LENGTH = 2;
    private static final String HOSTNAME = Configuration.root().getString("application.hostname", "http://localhost");

    @Transactional
    public static Result toggleFoveriteProject(String projectId) {
        if (projectId == null) {
            return UserApi.badRequest((String)"Wrong project id");
        }
        boolean isFavored = UserApp.currentUser().toggleFavoriteProject(Long.valueOf(projectId));
        ObjectNode json = Json.newObject();
        json.put("projectId", projectId);
        json.put("favored", isFavored);
        return UserApi.ok((JsonNode)json);
    }

    @Transactional
    public static Result getFoveriteProjects() {
        ObjectNode json = Json.newObject();
        ArrayList<ObjectNode> projects2 = new ArrayList<ObjectNode>();
        ArrayList<Object> projectIds = new ArrayList<Object>();
        for (FavoriteProject favoriteProject : UserApp.currentUser().favoriteProjects) {
            ObjectNode project2 = Json.newObject();
            Object object = favoriteProject;
            Object object2 = null;
            object = object2 = ((FavoriteProject)((Object)object)).getProject();
            object2 = null;
            object2 = ((Project)object).getId();
            project2.put("projectId", (Long)object2);
            object = favoriteProject;
            object2 = null;
            object2 = ((FavoriteProject)((Object)object)).getProjectName();
            project2.put("projectName", (String)object2);
            object = favoriteProject;
            object2 = null;
            object2 = ((FavoriteProject)((Object)object)).getOwner();
            project2.put("owner", (String)object2);
            projects2.add(project2);
            object = favoriteProject;
            object2 = null;
            object = object2 = ((FavoriteProject)((Object)object)).getProject();
            object2 = null;
            object2 = ((Project)object).getId();
            projectIds.add(object2);
        }
        json.put("projectIds", Json.toJson(projectIds));
        json.put("projects", Json.toJson(projects2));
        return UserApi.ok((JsonNode)json);
    }

    @Transactional
    public static Result toggleFoveriteIssue(String issueId) {
        if (issueId == null) {
            return UserApi.badRequest((String)"Wrong issue id");
        }
        boolean isFavored = UserApp.currentUser().toggleFavoriteIssue(Long.valueOf(issueId));
        ObjectNode json = Json.newObject();
        json.put("issueId", issueId);
        json.put("favored", isFavored);
        if (isFavored) {
            json.put("message", Messages.get((String)"issue.favorite.added", (Object[])new Object[0]));
        } else {
            json.put("message", Messages.get((String)"issue.favorite.deleted", (Object[])new Object[0]));
        }
        return UserApi.ok((JsonNode)json);
    }

    @Transactional
    public static Result getFoveriteIssues() {
        ObjectNode json = Json.newObject();
        ArrayList<ObjectNode> issues2 = new ArrayList<ObjectNode>();
        ArrayList<Object> issueIds = new ArrayList<Object>();
        for (FavoriteIssue favoriteIssue : UserApp.currentUser().favoriteIssues) {
            ObjectNode project2 = Json.newObject();
            Object object = favoriteIssue;
            Object object2 = null;
            object = object2 = ((FavoriteIssue)((Object)object)).getIssue();
            object2 = null;
            object2 = ((AbstractPosting)object).getId();
            project2.put("issueId", (Long)object2);
            object = favoriteIssue;
            object2 = null;
            object = object2 = ((FavoriteIssue)((Object)object)).getIssue();
            object2 = null;
            object2 = ((AbstractPosting)object).getTitle();
            project2.put("issueTitle", (String)object2);
            object = favoriteIssue;
            object2 = null;
            object2 = ((FavoriteIssue)((Object)object)).getIssue();
            project2.put("issueAuthorName", ((Issue)object2).author.getPureNameOnly());
            issues2.add(project2);
            object = favoriteIssue;
            object2 = null;
            object = object2 = ((FavoriteIssue)((Object)object)).getIssue();
            object2 = null;
            object2 = ((AbstractPosting)object).getId();
            issueIds.add(object2);
        }
        json.put("projectIds", Json.toJson(issueIds));
        json.put("projects", Json.toJson(issues2));
        return UserApi.ok((JsonNode)json);
    }

    @Transactional
    public static Result getIssuesByUser(String filter, int page, int pageNum) {
        ObjectNode result2 = Json.newObject();
        if (!UserApi.isAuthored(UserApi.request())) {
            return UserApi.unauthorized((JsonNode)result2.put("message", "unauthorized request"));
        }
        String token = UserApi.request().getHeader("Authorization").split(AUTHORIZATION_HEADER_PREFIX)[1].replaceAll("\\s", "");
        User user = User.findByUserToken(token);
        IssueSearchCondition issueSearchCondition = new IssueSearchCondition();
        int n = page - 1;
        IssueSearchCondition issueSearchCondition2 = issueSearchCondition;
        issueSearchCondition2.setPageNum(n);
        ExpressionList<Issue> el = issueSearchCondition.getExpressionListByFilter(IssueFilterType.getValue(filter), user);
        issueSearchCondition2 = issueSearchCondition;
        n = 0;
        n = issueSearchCondition2.getPageNum();
        Page issues2 = el.findPagingList(pageNum).getPage(n);
        return UserApi.issuesAsJson((Page<Issue>)issues2);
    }

    private static Result issuesAsJson(Page<Issue> issues2) {
        ObjectNode listData = Json.newObject();
        ArrayNode array = Json.newObject().arrayNode();
        List issueList2 = issues2.getList();
        for (Issue issue2 : issueList2) {
            ObjectNode result2 = Json.newObject();
            Object object = issue2;
            Object object2 = null;
            object2 = ((AbstractPosting)object).getId();
            result2.put("id", object2);
            result2.put("number", issue2.getNumber());
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getState();
            result2.put("state", ((Enum)object2).toString());
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getTitle();
            result2.put("title", (String)object2);
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getCreatedDate();
            result2.put("createdDate", JodaDateUtil.getDateString((Date)object2, "yyyy-MM-dd'T'HH:mm:ssZ"));
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getUpdatedDate();
            result2.put("updatedDate", JodaDateUtil.getDateString((Date)object2, "yyyy-MM-dd'T'HH:mm:ssZ"));
            ObjectNode authorNode = Json.newObject();
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getAuthorId();
            authorNode.put("id", object2);
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getAuthorLoginId();
            authorNode.put("loginId", (String)object2);
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getAuthorName();
            authorNode.put("name", (String)object2);
            result2.put("author", (JsonNode)authorNode);
            ObjectNode assigneeNode = Json.newObject();
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getAssignee();
            if (object2 != null) {
                object = issue2;
                object2 = null;
                object2 = ((Issue)object).getAssignee();
                object = object2;
                object2 = null;
                object2 = ((Assignee)((Object)object)).getId();
                assigneeNode.put("id", object2);
                object = issue2;
                object2 = null;
                object2 = ((Issue)object).getAssignee();
                object = object2;
                object2 = null;
                object2 = ((Assignee)((Object)object)).getUser();
                object = object2;
                object2 = null;
                object2 = ((User)object).getLoginId();
                assigneeNode.put("loginId", (String)object2);
                object = issue2;
                object2 = null;
                object2 = ((Issue)object).getAssignee();
                object = object2;
                object2 = null;
                object2 = ((Assignee)((Object)object)).getUser();
                object = object2;
                object2 = null;
                object2 = ((User)object).getName();
                assigneeNode.put("name", (String)object2);
            }
            result2.put("assignee", (JsonNode)assigneeNode);
            ObjectNode projectNode = Json.newObject();
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getProject();
            object = object2;
            object2 = null;
            object2 = ((Project)object).getId();
            projectNode.put("id", object2);
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getProject();
            object = object2;
            object2 = null;
            object2 = ((Project)object).getName();
            projectNode.put("name", (String)object2);
            result2.put("project", (JsonNode)projectNode);
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getProject();
            object = object2;
            object2 = null;
            object2 = ((Project)object).getOwner();
            result2.put("owner", (String)object2);
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getProject();
            object = object2;
            object2 = null;
            object2 = ((Project)object).getOwner();
            StringBuilder stringBuilder = new StringBuilder().append(HOSTNAME).append("/").append((String)object2).append("/");
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getProject();
            object = object2;
            object2 = null;
            object2 = ((Project)object).getName();
            result2.put("refUrl", stringBuilder.append((String)object2).append("/issue/").append(issue2.getNumber()).toString());
            array.add((JsonNode)result2);
        }
        listData.put("result", (JsonNode)array);
        return UserApi.ok((JsonNode)listData);
    }

    @Transactional
    public static Result toggleFoveriteOrganization(String organizationId) {
        if (organizationId == null) {
            return UserApi.badRequest((String)"Wrong organization id");
        }
        boolean isFavored = UserApp.currentUser().toggleFavoriteOrganization(Long.valueOf(organizationId));
        ObjectNode json = Json.newObject();
        json.put("organizationId", organizationId);
        json.put("favored", isFavored);
        return UserApi.ok((JsonNode)json);
    }

    @Transactional
    public static Result getFoveriteOrganizations() {
        ObjectNode json = Json.newObject();
        ArrayList<ObjectNode> organizations = new ArrayList<ObjectNode>();
        ArrayList<Object> organizationIds = new ArrayList<Object>();
        for (FavoriteOrganization favoriteOrganization : UserApp.currentUser().favoriteOrganizations) {
            ObjectNode organization2 = Json.newObject();
            Object object = favoriteOrganization;
            Object object2 = null;
            object = object2 = ((FavoriteOrganization)((Object)object)).getOrganization();
            object2 = null;
            object2 = ((Organization)object).getId();
            organization2.put("organizationId", (Long)object2);
            object = favoriteOrganization;
            object2 = null;
            object2 = ((FavoriteOrganization)((Object)object)).getOrganizationName();
            organization2.put("organizationName", (String)object2);
            organizations.add(organization2);
            object = favoriteOrganization;
            object2 = null;
            object = object2 = ((FavoriteOrganization)((Object)object)).getOrganization();
            object2 = null;
            object2 = ((Organization)object).getId();
            organizationIds.add(object2);
        }
        json.put("organizationIds", Json.toJson(organizationIds));
        json.put("organizations", Json.toJson(organizations));
        return UserApi.ok((JsonNode)json);
    }

    @Transactional
    public static Result newUser() {
        ObjectNode result2 = Json.newObject();
        JsonNode json = UserApi.request().body().asJson();
        if (json == null) {
            return UserApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        if (!UserApp.currentUser().isSiteManager()) {
            return UserApi.badRequest((JsonNode)result2.put("message", "User creation with api is allowed by Site admin only."));
        }
        JsonNode usersNode = json.findValue("users");
        if (usersNode == null || !usersNode.isArray()) {
            return UserApi.badRequest((JsonNode)result2.put("message", "No users key exists or value must be array!"));
        }
        ArrayList<JsonNode> createdUsers = new ArrayList<JsonNode>();
        for (JsonNode userNode : usersNode) {
            createdUsers.add(UserApi.createUserNode(userNode));
        }
        return UserApi.created((JsonNode)Json.toJson(createdUsers));
    }

    @Transactional
    public static Result newToken() {
        ObjectNode result2 = Json.newObject();
        JsonNode json = UserApi.request().body().asJson();
        if (json == null) {
            return UserApi.badRequest((JsonNode)result2.put("message", "Empty request data"));
        }
        String loginIdOrEmail = json.findValue("id").asText();
        String password = json.findValue("password").asText();
        if (!UserApi.isValidUser(loginIdOrEmail)) {
            return UserApi.unauthorized((JsonNode)result2.put("message", "No valid user by id"));
        }
        User user = User.findByLoginKey(loginIdOrEmail);
        if (!UserApi.checkUserPassword(user, password)) {
            return UserApi.unauthorized((JsonNode)result2.put("message", "No user by id and password"));
        }
        UserApp.addUserInfoToSession(user);
        result2.put("access_token", UserApi.getNewUserToken(user));
        return UserApi.ok((JsonNode)Json.toJson((Object)result2));
    }

    @AnonymousCheck(requiresLogin=true)
    public static Result statistics(String loginId) {
        User user = User.findByLoginId(loginId);
        if (user.isAnonymous()) {
            return UserApi.ok((JsonNode)Json.toJson((Object)Statistics.empty()));
        }
        Integer issueCount = Issue.countAllCreatedBy(user);
        Integer postingCount = Posting.countAllCreatedBy(user);
        Integer assignedIssueCount = Issue.countAllAssignedBy(user);
        Integer issueCommentCount = IssueComment.countAllCreatedBy(user);
        Integer postingCommentCount = PostingComment.countAllCreatedBy(user);
        Integer issueVoterCount = Issue.countVoterOf(user);
        Integer issueCommentVoterCount = IssueComment.countVoterOf(user);
        Statistics statistics2 = new Statistics();
        Integer n = issueCount;
        Statistics statistics3 = statistics2;
        statistics3.setIssue(n);
        n = postingCount;
        statistics3 = statistics2;
        statistics3.setPosting(n);
        n = assignedIssueCount;
        statistics3 = statistics2;
        statistics3.setAssignedIssue(n);
        n = issueCommentCount;
        statistics3 = statistics2;
        statistics3.setIssueComment(n);
        n = postingCommentCount;
        statistics3 = statistics2;
        statistics3.setPostingComment(n);
        n = issueVoterCount;
        statistics3 = statistics2;
        statistics3.setIssueVoter(n);
        n = issueCommentVoterCount;
        statistics3 = statistics2;
        statistics3.setIssueCommentVoter(n);
        return UserApi.ok((JsonNode)Json.toJson((Object)statistics2));
    }

    public static boolean isAuthored(Http.Request request) {
        String header2 = request.getHeader("Authorization");
        if (header2 == null) {
            return false;
        }
        String[] tokenValues = header2.split(AUTHORIZATION_HEADER_PREFIX);
        if (tokenValues.length < 2) {
            return false;
        }
        String token = tokenValues[1].replaceAll("\\s", "");
        return !User.findByUserToken(token).isAnonymous();
    }

    public static String getAuthorizationToken(Http.Request request) {
        String header2 = request.getHeader("Authorization");
        String[] tokenValues = header2.split(AUTHORIZATION_HEADER_PREFIX);
        return tokenValues[1].replaceAll("\\s", "");
    }

    public static User getAuthorizedUser(String token) {
        return User.findByUserToken(token);
    }

    @With(value={SiteManagerAuthAction.class})
    public static Result users() {
        List users2 = User.find.select("id, login_id, name, email, state, is_guest").where().eq("state", (Object)UserState.ACTIVE).findList();
        ArrayList res = new ArrayList();
        for (User user : users2) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            User user2 = user;
            Object object = null;
            object = user2.getId();
            m.put("id", object);
            user2 = user;
            object = null;
            object = user2.getLoginId();
            m.put("login_id", object);
            user2 = user;
            object = null;
            object = user2.getName();
            m.put("name", object);
            user2 = user;
            object = null;
            object = user2.getEmail();
            m.put("email", object);
            user2 = user;
            object = null;
            object = user2.getState();
            m.put("state", object);
            user2 = user;
            boolean bl = false;
            bl = user2.getIsGuest();
            m.put("is_guest", bl);
            res.add(m);
        }
        return UserApi.ok((JsonNode)Json.toJson(res));
    }

    @With(value={SiteManagerAuthAction.class})
    public static Result updateUserState(String loginId) {
        User user = User.findByLoginId(loginId);
        if (user.isAnonymous()) {
            return UserApi.unauthorized();
        }
        JsonNode body = UserApi.request().body().asJson();
        if (body == null) {
            return UserApi.badRequest((String)"Empty json body");
        }
        UserState state = UserApi.findUserState(body);
        if (state == null) {
            return UserApi.badRequest();
        }
        if (state == UserState.SITE_ADMIN) {
            return UserApi.forbidden();
        }
        Object object = state;
        User user2 = user;
        user2.setState((UserState)((Object)object));
        user.save();
        HashMap<String, UserState> res = new HashMap<String, UserState>();
        user2 = user;
        object = null;
        object = user2.getId();
        res.put("id", (UserState)((Object)object));
        user2 = user;
        object = null;
        object = user2.getLoginId();
        res.put("login_id", (UserState)((Object)object));
        user2 = user;
        object = null;
        object = user2.getState();
        res.put("state", (UserState)((Object)object));
        return UserApi.ok((JsonNode)Json.toJson(res));
    }

    private static UserState findUserState(JsonNode json) {
        JsonNode state = json.findValue("state");
        String text = Optional.ofNullable(state).map(JsonNode::asText).map(String::toUpperCase).orElse("");
        return UserState.of(text);
    }

    private static boolean isValidUser(String loginIdOrEmail) {
        block5: {
            block4: {
                User user = User.findByLoginKey(loginIdOrEmail);
                if (user == null || user == User.anonymous) {
                    return false;
                }
                User user2 = user;
                UserState userState = null;
                userState = user2.getState();
                if (userState == UserState.LOCKED) break block4;
                user2 = user;
                userState = null;
                userState = user2.getState();
                if (userState != UserState.DELETED) break block5;
            }
            return false;
        }
        return true;
    }

    private static boolean checkUserPassword(User user, String password) {
        User user2 = user;
        String string = null;
        string = user2.getPasswordSalt();
        String hashedPassword = new Sha256Hash((Object)password, (Object)ByteSource.Util.bytes((String)string), 1024).toBase64();
        user2 = user;
        string = null;
        string = user2.getPassword();
        return StringUtils.equals((CharSequence)string, (CharSequence)hashedPassword);
    }

    private static String getNewUserToken(User user) {
        String token;
        String string = token = SHA256Util.hashBasedNow();
        User user2 = user;
        user2.setToken(string);
        user.save();
        return token;
    }

    public static JsonNode createUserNode(JsonNode userNode) {
        ObjectNode createdUserNode = Json.newObject();
        String loginId = userNode.findValue("loginId").asText();
        String name = userNode.findValue("name").asText();
        String email = userNode.findValue("email").asText();
        if (!NotificationMail.isAllowedEmailDomains(email)) {
            return UserApi.notAllowedDomainEmailUser(userNode);
        }
        User found = User.findByEmail(email);
        if (!found.isAnonymous()) {
            return UserApi.alreadyExistedUser(userNode);
        }
        User user = new User();
        String string = loginId;
        User user2 = user;
        user2.setLoginId(string);
        string = name;
        user2 = user;
        user2.setName(string);
        string = email;
        user2 = user;
        user2.setEmail(string);
        string = new SecureRandomNumberGenerator().nextBytes().toBase64();
        user2 = user;
        user2.setPassword(string);
        createdUserNode.put("status", 201);
        createdUserNode.put("reason", "Created");
        createdUserNode.put("user", UserApi.successfullyCreatedUserNode(UserApp.createNewUser(user)));
        return createdUserNode;
    }

    private static JsonNode successfullyCreatedUserNode(User created) {
        ObjectNode createdUserNode = Json.newObject();
        User user = created;
        Object object = null;
        object = user.getId();
        createdUserNode.put("id", (Long)object);
        user = created;
        object = null;
        object = user.getLoginId();
        createdUserNode.put("loginId", (String)object);
        user = created;
        object = null;
        object = user.getName();
        createdUserNode.put("name", (String)object);
        user = created;
        object = null;
        object = user.getEmail();
        createdUserNode.put("email", (String)object);
        return createdUserNode;
    }

    private static JsonNode notAllowedDomainEmailUser(JsonNode userNode) {
        ObjectNode createdUserNode = Json.newObject();
        String message = Messages.get((String)"user.unacceptable.email.domain", (Object[])new Object[0]);
        UserApi.loggingUser(userNode, message);
        createdUserNode.put("status", 403);
        createdUserNode.put("reason", "Forbidden");
        createdUserNode.put("message", message);
        createdUserNode.put("user", userNode);
        return createdUserNode;
    }

    private static JsonNode alreadyExistedUser(JsonNode userNode) {
        ObjectNode createdUserNode = Json.newObject();
        String message = "Already exists!";
        UserApi.loggingUser(userNode, message);
        createdUserNode.put("status", 409);
        createdUserNode.put("reason", "Conflict");
        createdUserNode.put("message", message);
        createdUserNode.put("user", userNode);
        return createdUserNode;
    }

    private static void loggingUser(JsonNode userNode, String message) {
        String name = userNode.findValue("name").asText();
        String email = userNode.findValue("email").asText();
        Logger.warn((String)message);
        Logger.warn((String)("Rejected: " + name + " with " + email));
    }
}

