/*
 * Decompiled with CFR 0.152.
 */
package controllers.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.UserApp;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsCreatable;
import controllers.api.IssueApi;
import controllers.routes;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import models.AbstractPosting;
import models.Assignee;
import models.Attachment;
import models.Comment;
import models.Issue;
import models.IssueLabel;
import models.IssueLabelCategory;
import models.Label;
import models.Milestone;
import models.Organization;
import models.OrganizationUser;
import models.Posting;
import models.Project;
import models.ProjectMenuSetting;
import models.ProjectUser;
import models.Role;
import models.TitleHead;
import models.User;
import models.enumeration.Operation;
import models.enumeration.ProjectScope;
import models.enumeration.ResourceType;
import models.enumeration.RoleType;
import models.enumeration.State;
import org.apache.commons.lang3.StringUtils;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Result;
import playRepository.RepositoryService;
import utils.AccessControl;
import utils.CacheStore;
import utils.Config;
import utils.JodaDateUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ProjectApi
extends Controller {
    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");

    @IsAllowed(value=Operation.DELETE)
    public static Result exports(String owner, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        ObjectNode json = Json.newObject();
        Project project3 = project2;
        Collection<AbstractPosting> collection = null;
        collection = project3.getOwner();
        json.put("owner", (String)((Object)collection));
        project3 = project2;
        collection = null;
        collection = project3.getName();
        json.put("projectName", (String)((Object)collection));
        project3 = project2;
        collection = null;
        collection = project3.getOverview();
        json.put("projectDescription", (String)((Object)collection));
        project3 = project2;
        collection = null;
        collection = project3.getCreatedDate();
        json.put("projectCreatedDate", ProjectApi.getDateString((Date)((Object)collection)));
        project3 = project2;
        collection = null;
        collection = project3.getVcs();
        json.put("projectVcs", (String)((Object)collection));
        json.put("projectScope", ProjectApi.getProjectScope(project2));
        json.put("assignees", Json.toJson((Object)ProjectApi.getAssginees(project2).toArray()));
        json.put("authors", Json.toJson((Object)ProjectApi.getAuthors(project2).toArray()));
        json.put("memberCount", project2.members().size());
        json.put("members", project2.members().size());
        Optional.ofNullable(project2.members()).ifPresent(members2 -> json.put("members", ProjectApi.composeMembersJson(project2)));
        project3 = project2;
        collection = null;
        collection = project3.getIssues();
        json.put("issueCount", collection.size());
        project3 = project2;
        collection = null;
        collection = project3.getPosts();
        json.put("postCount", collection.size());
        project3 = project2;
        collection = null;
        collection = project3.getMilestones();
        json.put("milestoneCount", collection.size());
        project3 = project2;
        collection = null;
        collection = project3.getIssueLabels();
        json.put("labels", ProjectApi.getAllLabels(collection));
        json.put("issues", ProjectApi.composePosts(project2, Issue.finder));
        json.put("posts", ProjectApi.composePosts(project2, Posting.finder));
        project3 = project2;
        collection = null;
        collection = project3.getMilestones();
        json.put("milestones", Json.toJson(collection.stream().map(ProjectApi::getMilestoneNode).collect(Collectors.toList())));
        return ProjectApi.ok((JsonNode)json);
    }

    private static String getProjectScope(Project project2) {
        Project project3 = project2;
        ProjectScope projectScope = null;
        projectScope = project3.getProjectScope();
        switch (projectScope) {
            case PRIVATE: {
                return "PRIVATE";
            }
            case PROTECTED: {
                return "PROTECTED";
            }
            case PUBLIC: {
                return "PUBLIC";
            }
        }
        return "PRIVATE";
    }

    public static List<ObjectNode> getAssginees(Project project2) {
        ArrayList<ObjectNode> members2 = new ArrayList<ObjectNode>();
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getAssignees();
        Iterator<Assignee> iterator = object2.iterator();
        while (iterator.hasNext()) {
            Assignee assignee = iterator.next();
            ObjectNode member = Json.newObject();
            object = assignee;
            object2 = null;
            object = object2 = ((Assignee)((Object)object)).getUser();
            object2 = null;
            object2 = ((User)object).getLoginId();
            member.put("loginId", (String)object2);
            object = assignee;
            object2 = null;
            object = object2 = ((Assignee)((Object)object)).getUser();
            object2 = null;
            object2 = ((User)object).getName();
            member.put("name", (String)object2);
            object = assignee;
            object2 = null;
            object = object2 = ((Assignee)((Object)object)).getUser();
            object2 = null;
            object2 = ((User)object).getEmail();
            member.put("email", (String)object2);
            members2.add(member);
        }
        return members2;
    }

    public static List<ObjectNode> getAuthors(Project project2) {
        ArrayList<ObjectNode> authors = new ArrayList<ObjectNode>();
        for (User user : project2.findAuthors()) {
            ObjectNode member = Json.newObject();
            User user2 = user;
            String string = null;
            string = user2.getLoginId();
            member.put("loginId", string);
            user2 = user;
            string = null;
            string = user2.getName();
            member.put("name", string);
            user2 = user;
            string = null;
            string = user2.getEmail();
            member.put("email", string);
            authors.add(member);
        }
        return authors;
    }

    @Transactional
    public static Result newProject(String owner) throws Exception {
        Object object;
        Model model;
        Organization organization2;
        JsonNode json;
        block8: {
            User currentUser;
            ObjectNode result2;
            block7: {
                result2 = Json.newObject();
                json = ProjectApi.request().body().asJson();
                if (json == null) {
                    return ProjectApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
                }
                currentUser = UserApp.currentUser();
                if (!currentUser.isSiteManager()) {
                    return ProjectApi.badRequest((JsonNode)result2.put("message", "User creation with api is allowed by Site admin only."));
                }
                Project existed = Project.findByOwnerAndProjectName(owner, json.findValue("projectName").asText());
                if (existed != null) {
                    result2.put("status", 409);
                    result2.put("reason", "Conflict");
                    result2.put("project", ProjectApi.createdProjectNode(existed));
                    return ProjectApi.badRequest((JsonNode)result2);
                }
                organization2 = Organization.findByName(owner);
                if (!AccessControl.isGlobalResourceCreatable(currentUser)) break block7;
                if (!Organization.isNameExist(owner)) break block8;
                model = organization2;
                object = null;
                Object object2 = object = model.getId();
                model = currentUser;
                object = null;
                object = model.getId();
                if (OrganizationUser.isAdmin((Long)object2, (Long)object)) break block8;
            }
            model = currentUser;
            object = null;
            object = model.getName();
            return ProjectApi.forbidden((JsonNode)result2.put("message", Messages.get((String)("'" + (String)object + "' has no permission"), (Object[])new Object[0])));
        }
        Project project2 = new Project();
        object = owner;
        model = project2;
        model.setOwner((String)object);
        object = json.findValue("projectName").asText();
        model = project2;
        model.setName((String)object);
        object = ProjectApi.getProjectDescription(json);
        model = project2;
        model.setOverview((String)object);
        object = ProjectApi.getProjectVcs(json);
        model = project2;
        model.setVcs((String)object);
        object = IssueApi.parseDateString(json.findValue("projectCreatedDate"));
        model = project2;
        model.setCreatedDate((Date)object);
        object = ProjectApi.parseProjectScope(json);
        model = project2;
        model.setProjectScope((ProjectScope)((Object)object));
        if (Organization.isNameExist(owner)) {
            object = organization2;
            model = project2;
            model.setOrganization((Organization)object);
        }
        ProjectUser.assignRole(User.SITE_MANAGER_ID, Project.create(project2), RoleType.SITEMANAGER);
        RepositoryService.createRepository(project2);
        ProjectApi.saveMenuSettingsToDefault(project2);
        ProjectApi.addProjectMembers(json, project2);
        model = project2;
        object = null;
        Object object3 = object = model.getOwner();
        model = project2;
        object = null;
        object = model.getName();
        String string = CacheStore.getProjectCacheKey((String)object3, (String)object);
        model = project2;
        object = null;
        object = model.getId();
        CacheStore.projectMap.put(string, (Long)object);
        return ProjectApi.created((JsonNode)ProjectApi.createdProjectNode(project2));
    }

    private static ProjectScope parseProjectScope(JsonNode json) {
        JsonNode scopeNode = json.findValue("projectScope");
        if (scopeNode == null || StringUtils.isEmpty((CharSequence)scopeNode.asText())) {
            return ProjectScope.PRIVATE;
        }
        switch (scopeNode.asText()) {
            case "PRIVATE": {
                return ProjectScope.PRIVATE;
            }
            case "PUBLIC": {
                return ProjectScope.PUBLIC;
            }
            case "PROTECTED": {
                return ProjectScope.PROTECTED;
            }
        }
        return ProjectScope.PRIVATE;
    }

    private static String getProjectDescription(JsonNode json) {
        JsonNode projectDescription = json.findValue("projectDescription");
        if (projectDescription == null) {
            return "";
        }
        return projectDescription.asText();
    }

    private static void addProjectMembers(JsonNode json, Project project2) {
        JsonNode membersNode = json.findValue("members");
        if (membersNode != null && membersNode.isArray()) {
            for (JsonNode memberNode : membersNode) {
                Long l;
                Model model;
                String mail2 = memberNode.findValue("email").asText();
                User member = User.findByEmail(mail2);
                if (member.isAnonymous()) continue;
                String role = memberNode.findValue("role").asText();
                if ("member".equalsIgnoreCase(role)) {
                    model = member;
                    l = null;
                    Long l2 = l = model.getId();
                    model = project2;
                    l = null;
                    l = model.getId();
                    ProjectUser.assignRole(l2, l, RoleType.MEMBER);
                    continue;
                }
                if ("manager".equalsIgnoreCase(role)) {
                    model = member;
                    l = null;
                    Long l3 = l = model.getId();
                    model = project2;
                    l = null;
                    l = model.getId();
                    ProjectUser.assignRole(l3, l, RoleType.MANAGER);
                    continue;
                }
                Logger.warn((String)("Unknown role type: " + member));
            }
            project2.cleanEnrolledUsers();
        }
    }

    private static String getProjectVcs(JsonNode json) {
        JsonNode projectVcs = json.findValue("projectVcs");
        if (projectVcs == null) {
            return "GIT";
        }
        return projectVcs.asText();
    }

    private static JsonNode createdProjectNode(Project project2) {
        ObjectNode created = Json.newObject();
        Project project3 = project2;
        Object object = null;
        object = project3.getId();
        created.put("id", (Long)object);
        project3 = project2;
        object = null;
        object = project3.getOwner();
        created.put("owner", (String)object);
        project3 = project2;
        object = null;
        object = project3.getName();
        created.put("name", (String)object);
        project3 = project2;
        object = null;
        object = project3.getOverview();
        created.put("overview", (String)object);
        project3 = project2;
        object = null;
        object = project3.getVcs();
        created.put("vcs", (String)object);
        return created;
    }

    private static void saveMenuSettingsToDefault(Project project2) {
        ProjectMenuSetting projectMenuSetting = new ProjectMenuSetting();
        boolean bl = true;
        Model model = projectMenuSetting;
        model.setCode(bl);
        bl = true;
        model = projectMenuSetting;
        model.setIssue(bl);
        bl = true;
        model = projectMenuSetting;
        model.setPullRequest(bl);
        bl = true;
        model = projectMenuSetting;
        model.setReview(bl);
        bl = true;
        model = projectMenuSetting;
        model.setMilestone(bl);
        bl = true;
        model = projectMenuSetting;
        model.setBoard(bl);
        Model model2 = project2;
        model = projectMenuSetting;
        model.setProject((Project)model2);
        projectMenuSetting.save();
        model2 = projectMenuSetting;
        model = project2;
        model.setMenuSetting((ProjectMenuSetting)model2);
        project2.update();
    }

    @IsAllowed(value=Operation.READ)
    public static JsonNode projectLabels(Project project2) {
        HashMap<Long, Map<String, String>> labels2 = new HashMap<Long, Map<String, String>>();
        Iterator<Label> iterator = project2.labels.iterator();
        while (iterator.hasNext()) {
            Label label;
            Label label2 = label = iterator.next();
            Long l = null;
            l = label2.getId();
            labels2.put(l, ProjectApi.convertToMap(label));
        }
        return Json.toJson(labels2);
    }

    private static Map<String, String> convertToMap(Label label) {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        Label label2 = label;
        String string = null;
        string = label2.getCategory();
        tagMap.put("category", string);
        label2 = label;
        string = null;
        string = label2.getName();
        tagMap.put("name", string);
        return tagMap;
    }

    private static <T> JsonNode composePosts(Project project2, Model.Finder<Long, T> finder) {
        List result2 = AbstractPosting.findByProject(finder, project2).stream().map(posting -> ProjectApi.getResult((AbstractPosting)posting)).collect(Collectors.toList());
        return Json.toJson(result2);
    }

    public static ObjectNode getResult(AbstractPosting posting) {
        List<ObjectNode> comments;
        List<Attachment> attachments;
        ObjectNode json = Json.newObject();
        json.put("number", posting.getNumber());
        Object object = posting;
        Object object2 = null;
        object2 = ((AbstractPosting)object).getId();
        json.put("id", (Long)object2);
        object = posting;
        object2 = null;
        object2 = ((AbstractPosting)object).getTitle();
        json.put("title", (String)object2);
        json.put("type", posting.asResource().getType().toString());
        json.put("author", ProjectApi.composeAuthorJson(posting.getAuthor()));
        object = posting;
        object2 = null;
        object2 = ((AbstractPosting)object).getCreatedDate();
        json.put("createdAt", JodaDateUtil.getDateString((Date)object2, "yyyy-MM-dd'T'HH:mm:ssZ"));
        object = posting;
        object2 = null;
        object2 = ((AbstractPosting)object).getUpdatedDate();
        json.put("updatedAt", JodaDateUtil.getDateString((Date)object2, "yyyy-MM-dd'T'HH:mm:ssZ"));
        object = posting;
        object2 = null;
        object2 = ((AbstractPosting)object).getBody();
        json.put("body", (String)object2);
        object = posting;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getOwner();
        json.put("owner", (String)object2);
        object = posting;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getName();
        json.put("projectName", (String)object2);
        if (posting.asResource().getType() == ResourceType.ISSUE_POST) {
            Issue issue2 = (Issue)posting;
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getAssignee();
            Optional.ofNullable(object2).ifPresent(assignee -> json.put("assignees", ProjectApi.composeAssigneeJson(issue2)));
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getState();
            json.put("state", ((Enum)object2).toString());
            Optional.ofNullable(issue2.getLabels()).ifPresent(labels2 -> {
                if (labels2.size() > 0) {
                    json.put("labels", ProjectApi.composeLabelJson(labels2));
                }
            });
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getMilestone();
            Optional.ofNullable(object2).ifPresent(milestone2 -> {
                Milestone milestone3 = milestone2;
                Long l = null;
                l = milestone3.getId();
                json.put("milestoneId", l);
            });
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getMilestone();
            Optional.ofNullable(object2).ifPresent(milestone2 -> {
                Milestone milestone3 = milestone2;
                String string = null;
                string = milestone3.getTitle();
                json.put("milestoneTitle", string);
            });
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getDueDate();
            Optional.ofNullable(object2).ifPresent(dueDate -> json.put("dueDate", ProjectApi.getDateString(dueDate)));
            object = posting;
            object2 = null;
            object = object2 = ((AbstractPosting)object).getProject();
            object2 = null;
            Object object3 = object2 = ((Project)object).getOwner();
            object = posting;
            object2 = null;
            object = object2 = ((AbstractPosting)object).getProject();
            object2 = null;
            object2 = ((Project)object).getName();
            String refUrl = Config.getScheme() + "://" + Config.getHostport() + routes.IssueApp.issue((String)object3, (String)object2, posting.getNumber()).url();
            json.put("refUrl", refUrl);
        }
        if ((attachments = Attachment.findByContainer(posting.asResource())).size() > 0) {
            json.put("attachments", Json.toJson(attachments));
        }
        if ((comments = ProjectApi.composePlainCommentsJson(posting)).size() > 0) {
            json.put("comments", Json.toJson(comments));
        }
        return json;
    }

    private static String getDateString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd a hh:mm:ss Z", Locale.ENGLISH);
        return df.format(date);
    }

    private static JsonNode composeAuthorJson(User user) {
        ObjectNode authorNode = Json.newObject();
        User user2 = user;
        String string = null;
        string = user2.getLoginId();
        authorNode.put("loginId", string);
        user2 = user;
        string = null;
        string = user2.getName();
        authorNode.put("name", string);
        user2 = user;
        string = null;
        string = user2.getEmail();
        authorNode.put("email", string);
        return authorNode;
    }

    public static JsonNode composeAssigneeJson(Issue issue2) {
        ArrayList<ObjectNode> assignees = new ArrayList<ObjectNode>();
        Model model = issue2;
        Object object = null;
        Assignee assignee = object = model.getAssignee();
        ObjectNode assigneelNode = Json.newObject();
        model = assignee;
        object = null;
        object = model.getUser();
        model = object;
        object = null;
        object = model.getLoginId();
        assigneelNode.put("loginId", (String)object);
        model = assignee;
        object = null;
        object = model.getUser();
        model = object;
        object = null;
        object = model.getName();
        assigneelNode.put("name", (String)object);
        model = assignee;
        object = null;
        object = model.getUser();
        model = object;
        object = null;
        object = model.getEmail();
        assigneelNode.put("email", (String)object);
        assignees.add(assigneelNode);
        return Json.toJson(assignees);
    }

    private static JsonNode composeMembersJson(Project project2) {
        ArrayList<ObjectNode> members2 = new ArrayList<ObjectNode>();
        for (ProjectUser projectUser : project2.members()) {
            Object object = projectUser;
            Object object2 = null;
            object2 = ((ProjectUser)((Object)object)).getUser();
            User user = object2;
            ObjectNode memberNode = Json.newObject();
            object = user;
            object2 = null;
            object2 = ((User)object).getLoginId();
            memberNode.put("loginId", (String)object2);
            object = user;
            object2 = null;
            object2 = ((User)object).getName();
            memberNode.put("name", (String)object2);
            object = projectUser;
            object2 = null;
            object = object2 = ((ProjectUser)((Object)object)).getRole();
            object2 = null;
            object2 = ((Role)((Object)object)).getName();
            memberNode.put("role", (String)object2);
            object = user;
            object2 = null;
            object2 = ((User)object).getEmail();
            memberNode.put("email", (String)object2);
            members2.add(memberNode);
        }
        return Json.toJson(members2);
    }

    private static JsonNode composeLabelJson(Set<IssueLabel> issueLabels2) {
        ArrayList<ObjectNode> labels2 = new ArrayList<ObjectNode>();
        for (IssueLabel label : issueLabels2) {
            ObjectNode labelNode = Json.newObject();
            Object object = label;
            Object object2 = null;
            object2 = ((IssueLabel)object).getName();
            labelNode.put("labelName", (String)object2);
            object = label;
            object2 = null;
            object2 = ((IssueLabel)object).getColor();
            labelNode.put("labelColor", (String)object2);
            object = label;
            object2 = null;
            object = object2 = ((IssueLabel)object).getCategory();
            object2 = null;
            object2 = ((IssueLabelCategory)object).getName();
            labelNode.put("category", (String)object2);
            labels2.add(labelNode);
        }
        return Json.toJson(labels2);
    }

    public static JsonNode getAllLabels(List<IssueLabel> issueLabels2) {
        ArrayList<ObjectNode> labels2 = new ArrayList<ObjectNode>();
        for (IssueLabel label : issueLabels2) {
            ObjectNode labelNode = Json.newObject();
            Object object = label;
            Object object2 = null;
            object2 = ((IssueLabel)object).getName();
            labelNode.put("labelName", (String)object2);
            object = label;
            object2 = null;
            object2 = ((IssueLabel)object).getColor();
            labelNode.put("labelColor", (String)object2);
            object = label;
            object2 = null;
            object = object2 = ((IssueLabel)object).getCategory();
            object2 = null;
            object2 = ((IssueLabelCategory)object).getName();
            labelNode.put("category", (String)object2);
            object = label;
            object2 = null;
            object = object2 = ((IssueLabel)object).getCategory();
            boolean bl = false;
            bl = ((IssueLabelCategory)object).getIsExclusive();
            labelNode.put("isExclusive", bl);
            labels2.add(labelNode);
        }
        return Json.toJson(labels2);
    }

    public static List<ObjectNode> composePlainCommentsJson(AbstractPosting posting) {
        HashMap<Long, ObjectNode> commentMap = new HashMap<Long, ObjectNode>();
        HashMap<Long, ArrayList<ObjectNode>> childCommentMap = new HashMap<Long, ArrayList<ObjectNode>>();
        for (Comment comment : posting.getComments()) {
            Long l;
            Comment comment2;
            Comment parentComment = comment.getParentComment();
            if (parentComment != null) {
                comment2 = comment.getParentComment();
                l = null;
                Long parentId = l = comment2.getId();
                ObjectNode childCommentNode = ProjectApi.getCommentNode(comment);
                ArrayList<ObjectNode> childCommentList = (ArrayList<ObjectNode>)childCommentMap.get(parentId);
                if (childCommentList == null) {
                    childCommentList = new ArrayList<ObjectNode>();
                }
                childCommentList.add(childCommentNode);
                childCommentMap.put(parentId, childCommentList);
                continue;
            }
            ObjectNode commentNode = ProjectApi.getCommentNode(comment);
            comment2 = comment;
            l = null;
            l = comment2.getId();
            commentMap.put(l, commentNode);
        }
        for (Long l : childCommentMap.keySet()) {
            ObjectNode comment = (ObjectNode)commentMap.get(l);
            comment.set("childComments", Json.toJson(childCommentMap.get(l)));
        }
        return new ArrayList<ObjectNode>(commentMap.values());
    }

    private static ObjectNode getCommentNode(Comment comment) {
        ObjectNode commentNode = Json.newObject();
        Comment comment2 = comment;
        Object object = null;
        object = comment2.getId();
        commentNode.put("id", (Long)object);
        commentNode.put("type", comment.asResource().getType().toString());
        comment2 = comment;
        object = null;
        object = comment2.getAuthorId();
        User commentAuthor = (User)User.find.byId(object);
        commentNode.put("author", ProjectApi.composeAuthorJson(commentAuthor));
        comment2 = comment;
        object = null;
        object = comment2.getCreatedDate();
        commentNode.put("createdAt", JodaDateUtil.getDateString((Date)object, "yyyy-MM-dd'T'HH:mm:ssZ"));
        comment2 = comment;
        object = null;
        object = comment2.getContents();
        commentNode.put("body", (String)object);
        List<Attachment> attachments = Attachment.findByContainer(comment.asResource());
        if (attachments.size() > 0) {
            commentNode.put("attachments", Json.toJson(attachments));
        }
        return commentNode;
    }

    public static ObjectNode getMilestoneNode(Milestone m) {
        ObjectNode node = Json.newObject();
        Milestone milestone2 = m;
        Object object = null;
        object = milestone2.getId();
        node.put("id", (Long)object);
        milestone2 = m;
        object = null;
        object = milestone2.getTitle();
        node.put("title", (String)object);
        milestone2 = m;
        object = null;
        object = milestone2.getState();
        node.put("state", ((State)((Object)object)).state());
        milestone2 = m;
        object = null;
        object = milestone2.getContents();
        node.put("description", (String)object);
        milestone2 = m;
        object = null;
        object = milestone2.getDueDate();
        Optional.ofNullable(object).ifPresent(dueDate -> node.put("dueDate", ProjectApi.getDateString(dueDate)));
        return node;
    }

    @Transactional
    @IsCreatable(value=ResourceType.ISSUE_LABEL)
    public static Result newLabel(String owner, String projectName) {
        ObjectNode result2 = Json.newObject();
        JsonNode json = ProjectApi.request().body().asJson();
        if (json == null) {
            return ProjectApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        JsonNode labelsNode = json.findValue("labels");
        if (labelsNode == null || !labelsNode.isArray()) {
            return ProjectApi.badRequest((JsonNode)result2.put("message", "No issues key exists or value wasn't array!"));
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        ArrayList<JsonNode> createdLabels = new ArrayList<JsonNode>();
        for (JsonNode labelNode : labelsNode) {
            createdLabels.add(ProjectApi.createLabelNode(labelNode, project2));
        }
        project2.update();
        return ProjectApi.created((JsonNode)Json.toJson(createdLabels));
    }

    private static JsonNode createLabelNode(JsonNode json, Project project2) {
        IssueLabel label;
        Model model;
        Object object;
        String labelName = json.findValue("labelName").asText();
        String labelColor = json.findValue("labelColor").asText();
        String categoryName = json.findValue("category").asText();
        boolean isExclusive = json.findValue("isExclusive").isBoolean();
        IssueLabelCategory category2 = IssueLabelCategory.findByName(categoryName, project2);
        if (category2 == null) {
            category2 = new IssueLabelCategory();
            object = project2;
            model = category2;
            model.setProject((Project)object);
            object = categoryName;
            model = category2;
            model.setName((String)object);
            category2.save();
        }
        if ((label = IssueLabel.findByName(labelName, categoryName, project2)) != null) {
            return ProjectApi.existedLabel(json);
        }
        label = new IssueLabel();
        object = category2;
        model = label;
        model.setCategory((IssueLabelCategory)object);
        object = labelColor;
        model = label;
        model.setColor((String)object);
        object = labelName;
        model = label;
        model.setName((String)object);
        object = project2;
        model = label;
        model.setProject((Project)object);
        label.save();
        ObjectNode result2 = Json.newObject();
        result2.put("status", 201);
        model = label;
        object = null;
        object = model.getName();
        result2.put("label", (String)object);
        model = category2;
        object = null;
        object = model.getName();
        result2.put("category", (String)object);
        model = label;
        object = null;
        object = model.getColor();
        result2.put("labelColor", (String)object);
        model = category2;
        boolean bl = false;
        bl = model.getIsExclusive();
        result2.put("isExclusive", bl);
        return result2;
    }

    private static JsonNode existedLabel(JsonNode labelNode) {
        ObjectNode createdUserNode = Json.newObject();
        String message = Messages.get((String)"label.error.duplicated", (Object[])new Object[0]);
        createdUserNode.put("status", 409);
        createdUserNode.put("reason", "Conflict");
        createdUserNode.put("message", message);
        createdUserNode.put("user", labelNode);
        return createdUserNode;
    }

    @Transactional
    @IsAllowed(value=Operation.READ)
    public static Result titleHeads(String owner, String projectName, String query) {
        if (!ProjectApi.request().accepts("application/json")) {
            return ProjectApi.status((int)406);
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        ArrayList<ObjectNode> searched = new ArrayList<ObjectNode>();
        searched.addAll(ProjectApi.getherTitleHeads(project2, query));
        searched.addAll(ProjectApi.getherProjectLabels(project2));
        ObjectNode result2 = Json.newObject();
        result2.put("result", Json.toJson(searched));
        return ProjectApi.ok((JsonNode)result2);
    }

    private static List<ObjectNode> getherProjectLabels(Project project2) {
        ArrayList<ObjectNode> searched = new ArrayList<ObjectNode>();
        Project project3 = project2;
        List<IssueLabel> list2 = null;
        list2 = project3.getIssueLabels();
        for (IssueLabel label : list2) {
            searched.add(ProjectApi.getIssueLabelNode(label));
        }
        return searched;
    }

    private static List<ObjectNode> getherTitleHeads(Project project2, String query) {
        ArrayList<ObjectNode> searched = new ArrayList<ObjectNode>();
        List<TitleHead> titleHeads2 = TitleHead.findByProject(project2, query);
        for (TitleHead titleHead : titleHeads2) {
            searched.add(ProjectApi.getTitleHeadNode(titleHead));
        }
        return searched;
    }

    private static ObjectNode getTitleHeadNode(TitleHead titleHead) {
        ObjectNode titleHeadNode = Json.newObject();
        TitleHead titleHead2 = titleHead;
        String string = null;
        string = titleHead2.getHeadKeyword();
        titleHeadNode.put("name", string);
        titleHead2 = titleHead;
        int n = 0;
        n = titleHead2.getFrequency();
        titleHeadNode.put("frequency", n);
        titleHeadNode.put("category", "");
        titleHead2 = titleHead;
        String string2 = null;
        string2 = titleHead2.getHeadKeyword();
        titleHeadNode.put("searchText", string2);
        return titleHeadNode;
    }

    private static ObjectNode getIssueLabelNode(IssueLabel label) {
        ObjectNode labelNode = Json.newObject();
        Object object = label;
        Object object2 = null;
        object2 = ((IssueLabel)object).getName();
        labelNode.put("name", (String)object2);
        labelNode.put("frequency", 0);
        object = label;
        object2 = null;
        object = object2 = ((IssueLabel)object).getCategory();
        object2 = null;
        object2 = ((IssueLabelCategory)object).getName();
        labelNode.put("category", (String)object2);
        object = label;
        object2 = null;
        object = object2 = ((IssueLabel)object).getCategory();
        object2 = null;
        object2 = ((IssueLabelCategory)object).getId();
        labelNode.put("categoryId", (Long)object2);
        object = label;
        object2 = null;
        object2 = ((IssueLabel)object).getId();
        labelNode.put("id", (Long)object2);
        object = label;
        object2 = null;
        object2 = ((IssueLabel)object).getColor();
        labelNode.put("labelColor", (String)object2);
        object = label;
        object2 = null;
        object = object2 = ((IssueLabel)object).getCategory();
        boolean bl = false;
        bl = ((IssueLabelCategory)object).getIsExclusive();
        labelNode.put("isExclusive", bl);
        object = label;
        Object object3 = null;
        object3 = ((IssueLabel)object).getName();
        StringBuilder stringBuilder = new StringBuilder().append((String)object3).append("/");
        object = label;
        object3 = null;
        object = object3 = ((IssueLabel)object).getCategory();
        object3 = null;
        object3 = ((IssueLabelCategory)object).getName();
        labelNode.put("searchText", stringBuilder.append((String)object3).toString());
        return labelNode;
    }
}

