/*
 * Decompiled with CFR 0.152.
 */
package controllers.api;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Junction;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AbstractPostingApp;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsCreatable;
import controllers.api.ProjectApi;
import controllers.api.UserApi;
import controllers.routes;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import models.AbstractPosting;
import models.Assignee;
import models.Attachment;
import models.Comment;
import models.Issue;
import models.IssueComment;
import models.IssueEvent;
import models.IssueLabel;
import models.IssueSharer;
import models.Milestone;
import models.NotificationEvent;
import models.Organization;
import models.Posting;
import models.PostingComment;
import models.Project;
import models.ProjectUser;
import models.User;
import models.enumeration.EventType;
import models.enumeration.Operation;
import models.enumeration.ProjectScope;
import models.enumeration.ResourceType;
import models.enumeration.State;
import models.enumeration.UserState;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import play.Configuration;
import play.Logger;
import play.api.mvc.Codec;
import play.core.enhancers.PropertiesEnhancer;
import play.core.j.JavaResults;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.libs.F;
import play.libs.Json;
import play.libs.ws.WS;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.WSResponse;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.ErrorViews;
import utils.JodaDateUtil;
import utils.Markdown;
import utils.RouteUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IssueApi
extends AbstractPostingApp {
    public static String TRANSLATION_API = Configuration.root().getString("application.extras.translation.api", "");
    public static String TRANSLATION_HEADER_KEY = Configuration.root().getString("application.extras.translation.headerKey", "");
    public static String TRANSLATION_HEADER_VALUE = Configuration.root().getString("application.extras.translation.headerValue", "");
    public static final int TRANSLATE_TEXT_LENGTH_LIMIT = 4500;
    public static final String NEWLINE = "\r\n";
    private static Supplier<WSRequestHolder> translatorWsRequestHolderSupplier = () -> WS.url((String)TRANSLATION_API).setContentType("application/x-www-form-urlencoded; charset=UTF-8").setHeader("Accept", "application/json,application/x-www-form-urlencoded,text/html,*/*").setHeader(TRANSLATION_HEADER_KEY, TRANSLATION_HEADER_VALUE);

    @Transactional
    public static Result imports(String owner, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        try {
            String postNumber = IssueApi.request().getQueryString("postNumber");
            Long number = Optional.ofNullable(postNumber).map(Long::parseLong).orElseThrow(NumberFormatException::new);
            Posting posting = Posting.findByNumber(project2, number);
            Issue issue2 = Issue.from(posting);
            issue2.save();
            Map<String, String> postingCommentIdToIssueCommentIdMap = IssueApi.copyCommentsToIssue(posting.comments, issue2);
            IssueApi.copyAttachmentsToIssue(posting, issue2);
            IssueApi.copyAttachmentsToIssueComments(postingCommentIdToIssueCommentIdMap);
            IssueApi.removePosting(posting);
            ObjectNode json = Json.newObject();
            json.put("number", issue2.getNumber());
            return IssueApi.ok((JsonNode)json);
        }
        catch (NumberFormatException numberFormatException) {
            String errorMessage = String.format("IssueApi.imports() error with NumberFormatException. owner: %s, projectName: %s - ", owner, projectName);
            Logger.error((String)errorMessage, (Throwable)numberFormatException);
            return IssueApi.badRequest();
        }
    }

    private static void copyAttachmentsToIssue(Posting from, Issue to) {
        Posting posting = from;
        Long l = null;
        l = posting.getId();
        List<Attachment> attachments = Attachment.findByContainer(ResourceType.BOARD_POST, String.valueOf(l));
        attachments.forEach(attachment -> {
            Attachment newAttachment = Attachment.copyAs(attachment);
            Model model = to;
            Object object = null;
            object = model.getId();
            object = String.valueOf(object);
            model = newAttachment;
            model.setContainerId((String)object);
            object = ResourceType.ISSUE_POST;
            model = newAttachment;
            model.setContainerType((ResourceType)((Object)((Object)object)));
            newAttachment.save();
            attachment.delete();
        });
    }

    private static void copyAttachmentsToIssueComments(Map<String, String> postingCommentIdToIssueCommentIdMap) {
        List<Attachment> attachments = postingCommentIdToIssueCommentIdMap.keySet().stream().flatMap(postingCommentId -> Attachment.findByContainer(ResourceType.NONISSUE_COMMENT, String.valueOf(postingCommentId)).stream()).collect(Collectors.toList());
        attachments.forEach(attachment -> {
            Attachment attachment2 = attachment;
            Object object = null;
            object = attachment2.getContainerId();
            String containerId = (String)postingCommentIdToIssueCommentIdMap.get(object);
            Attachment newAttachment = Attachment.copyAs(attachment);
            object = containerId;
            attachment2 = newAttachment;
            attachment2.setContainerId((String)object);
            object = ResourceType.ISSUE_COMMENT;
            attachment2 = newAttachment;
            attachment2.setContainerType((ResourceType)((Object)((Object)object)));
            newAttachment.save();
            attachment.delete();
        });
    }

    private static void removePosting(Posting posting) {
        posting.deleteOnly();
    }

    private static Map<String, String> copyCommentsToIssue(Collection<PostingComment> postingComments, Issue issue2) {
        List<PostingComment> topLevelPostingComments = postingComments.stream().filter(postingComment -> Objects.isNull(postingComment.getParentComment())).collect(Collectors.toList());
        List<PostingComment> secondLevelPostingComments = postingComments.stream().filter(postingComment -> Objects.nonNull(postingComment.getParentComment())).collect(Collectors.toList());
        HashMap<String, String> postingCommentIdToIssueCommentIdMap = new HashMap<String, String>();
        ArrayList issueComments = new ArrayList();
        topLevelPostingComments.forEach(topLevelPostingComment -> {
            IssueComment issueComment = IssueComment.from(topLevelPostingComment, issue2);
            issueComment.save();
            Comment comment = topLevelPostingComment;
            Long l = null;
            l = comment.getId();
            String string = String.valueOf(l);
            comment = issueComment;
            l = null;
            l = comment.getId();
            postingCommentIdToIssueCommentIdMap.put(string, String.valueOf(l));
            issueComments.add(issueComment);
        });
        secondLevelPostingComments.forEach(secondLevelPostingComment -> {
            Comment comment = secondLevelPostingComment.getParentComment();
            Object object = null;
            object = comment.getId();
            String parentCommentId = (String)postingCommentIdToIssueCommentIdMap.get(String.valueOf(object));
            IssueComment issueComment = IssueComment.from(secondLevelPostingComment, issue2);
            object = parentCommentId;
            comment = issueComment;
            comment.setParentCommentId((String)object);
            issueComment.setParentComment((Comment)IssueComment.find.byId((Object)Long.valueOf(parentCommentId)));
            issueComment.save();
            issueComments.add(issueComment);
        });
        return postingCommentIdToIssueCommentIdMap;
    }

    @Transactional
    public static Result updateIssueLabel(String owner, String projectName, Long number) {
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((String)"Expecting Json data");
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        HashSet<IssueLabel> labels2 = new HashSet<IssueLabel>();
        for (JsonNode node : json) {
            Long labelId = Long.parseLong(node.asText());
            labels2.add((IssueLabel)IssueLabel.finder.byId((Object)labelId));
        }
        Object object = labels2;
        Model model = issue2;
        model.setLabels((Set<IssueLabel>)object);
        issue2.save();
        ObjectNode result2 = Json.newObject();
        model = project2;
        object = null;
        object = model.getOwner();
        result2.put("id", (String)object);
        result2.put("labels", Json.toJson((Object)issue2.labels.size()));
        return IssueApi.ok((JsonNode)result2);
    }

    @Transactional
    public static Result getIssue(String owner, String projectName, Long number) {
        ObjectNode result2 = Json.newObject();
        if (!UserApi.isAuthored(IssueApi.request())) {
            return IssueApi.unauthorized((JsonNode)result2.put("message", "unauthorized request"));
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        if (project2 == null) {
            return IssueApi.badRequest((JsonNode)result2.put("message", "no project by request"));
        }
        Issue issue2 = Issue.findByNumber(project2, number);
        if (issue2 == null) {
            return IssueApi.badRequest((JsonNode)result2.put("message", "no issue by request"));
        }
        ObjectNode json = ProjectApi.getResult(issue2);
        return IssueApi.ok((JsonNode)Json.newObject().set("result", Json.toJson((Object)IssueApi.addIssueEvents(issue2, json))));
    }

    private static ObjectNode addIssueEvents(Issue issue2, ObjectNode json) {
        Issue issue3 = issue2;
        List<IssueEvent> list2 = null;
        list2 = issue3.getEvents();
        if (list2.size() > 0) {
            json.put("events", (JsonNode)IssueApi.getIssueEvents(issue2));
        }
        return json;
    }

    private static ArrayNode getIssueEvents(Issue issue2) {
        ArrayNode array = Json.newObject().arrayNode();
        Model model = issue2;
        Object object = null;
        object = model.getEvents();
        if (object.size() > 0) {
            model = issue2;
            object = null;
            object = model.getEvents();
            Iterator<IssueEvent> iterator = object.iterator();
            while (iterator.hasNext()) {
                IssueEvent event = iterator.next();
                ObjectNode result2 = Json.newObject();
                model = event;
                object = null;
                object = model.getSenderLoginId();
                User sender = User.findByLoginId((String)object);
                model = event;
                object = null;
                object = model.getId();
                result2.put("id", (Long)object);
                model = event;
                object = null;
                object = model.getCreated();
                result2.put("createdDate", JodaDateUtil.getDateString((Date)object, "yyyy-MM-dd'T'HH:mm:ssZ"));
                model = event;
                object = null;
                object = model.getEventType();
                result2.put("eventType", ((EventType)((Object)object)).toString());
                model = event;
                object = null;
                object = model.getEventType();
                result2.put("eventDescription", ((EventType)((Object)object)).getDescr());
                model = event;
                object = null;
                object = model.getOldValue();
                result2.put("oldValue", (String)object);
                model = event;
                object = null;
                object = model.getNewValue();
                result2.put("newValue", (String)object);
                result2.put("actor", IssueApi.getActorJson(sender));
                array.add((JsonNode)result2);
            }
        }
        return array;
    }

    private static JsonNode getActorJson(User user) {
        ObjectNode result2 = Json.newObject();
        result2.put("name", user.getPureNameOnly());
        User user2 = user;
        String string = null;
        string = user2.getLoginId();
        result2.put("loginId", string);
        user2 = user;
        string = null;
        string = user2.getEnglishName();
        result2.put("englishName", string);
        return result2;
    }

    @Transactional
    @IsCreatable(value=ResourceType.ISSUE_POST)
    public static Result newIssues(String owner, String projectName) {
        ObjectNode result2 = Json.newObject();
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        JsonNode issuesNode = json.findValue("issues");
        if (issuesNode == null || !issuesNode.isArray()) {
            return IssueApi.badRequest((JsonNode)result2.put("message", "No issues key exists or value wasn't array!"));
        }
        boolean sendNotification = json.findValue("sendNotification") != null && json.findValue("sendNotification").asBoolean();
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        ArrayList<JsonNode> createdIssues = new ArrayList<JsonNode>();
        for (JsonNode issueNode : issuesNode) {
            createdIssues.add(IssueApi.createIssuesNode(issueNode, project2, sendNotification));
        }
        return IssueApi.created((JsonNode)Json.toJson(createdIssues));
    }

    @Transactional
    public static Result updateIssue(String owner, String projectName, Long number) {
        ObjectNode result2 = Json.newObject();
        if (!UserApi.isAuthored(IssueApi.request())) {
            return IssueApi.unauthorized((JsonNode)result2.put("message", "unauthorized request"));
        }
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        User user = UserApi.getAuthorizedUser(UserApi.getAuthorizationToken(IssueApi.request()));
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        return IssueApi.updateIssueNode(json, project2, issue2, user);
    }

    @Transactional
    public static Result updateIssueState(String owner, String projectName, Long number) {
        ObjectNode result2 = Json.newObject();
        if (!UserApi.isAuthored(IssueApi.request())) {
            return IssueApi.unauthorized((JsonNode)result2.put("message", "unauthorized request"));
        }
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        User user = UserApi.getAuthorizedUser(UserApi.getAuthorizationToken(IssueApi.request()));
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        State newIssueState = IssueApi.findIssueState(json);
        Issue issue3 = issue2;
        State state = null;
        state = issue3.getState();
        if (!newIssueState.equals((Object)state)) {
            issue3 = issue2;
            state = null;
            state = issue3.getState();
            IssueApi.addNewIssueEvent(issue2, user, EventType.ISSUE_STATE_CHANGED, state.state(), newIssueState.state());
        }
        state = newIssueState;
        issue3 = issue2;
        issue3.setState(state);
        issue2.save();
        result2 = ProjectApi.getResult(issue2);
        return IssueApi.ok((JsonNode)Json.newObject().set("result", Json.toJson((Object)IssueApi.addIssueEvents(issue2, result2))));
    }

    @Transactional
    public static Result updateIssueContent(String owner, String projectName, Long number) {
        User user = UserApp.currentUser();
        if (user.isAnonymous()) {
            return IssueApi.unauthorized((JsonNode)Json.newObject().put("message", "unauthorized request"));
        }
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((JsonNode)Json.newObject().put("message", "Expecting Json data"));
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        if (!AccessControl.isAllowed(user, issue2.asResource(), Operation.UPDATE)) {
            return IssueApi.forbidden((JsonNode)Json.newObject().put("message", "Forbidden request"));
        }
        String content = json.findValue("content").asText();
        String original = json.findValue("original").asText();
        Issue issue3 = issue2;
        String string = null;
        string = issue3.getBody();
        if (IssueApi.isModifiedByOthers(string, original)) {
            issue3 = issue2;
            string = null;
            string = issue3.getBody();
            return IssueApi.conflicted(string);
        }
        string = content;
        issue3 = issue2;
        issue3.setBody(string);
        issue2.update();
        return IssueApi.ok((JsonNode)ProjectApi.getResult(issue2));
    }

    private static Result updateIssueNode(JsonNode json, Project project2, Issue issue2, User user) {
        String newAssignee;
        Object object;
        Object object2 = json.findValue("title").asText();
        Object object3 = issue2;
        ((AbstractPosting)object3).setTitle((String)object2);
        object2 = json.findValue("body").asText();
        object3 = issue2;
        ((AbstractPosting)object3).setBody((String)object2);
        object2 = IssueApi.findMilestone(json.findValue("milestoneTitle"), project2);
        object3 = issue2;
        ((Issue)object3).setMilestone((Milestone)object2);
        object2 = JodaDateUtil.now();
        object3 = issue2;
        ((AbstractPosting)object3).setUpdatedDate((Date)object2);
        String state = json.findValue("state").asText();
        object3 = issue2;
        object2 = null;
        object2 = ((Issue)object3).getState();
        if (!state.equals(((Enum)object2).toString())) {
            object3 = issue2;
            object2 = null;
            object2 = ((Issue)object3).getState();
            IssueApi.addNewIssueEvent(issue2, user, EventType.ISSUE_STATE_CHANGED, ((State)((Object)object2)).state(), State.valueOf(state).state());
        }
        object2 = IssueApi.findIssueState(json);
        object3 = issue2;
        ((Issue)object3).setState((State)((Object)object2));
        JsonNode assigneeNode = json.findValue("assignees").get(0);
        object3 = issue2;
        object2 = null;
        object2 = ((Issue)object3).getAssignee();
        if (object2 != null) {
            object3 = issue2;
            object2 = null;
            object3 = object2 = ((Issue)object3).getAssignee();
            object2 = null;
            object3 = object2 = ((Assignee)((Object)object3)).getUser();
            object2 = null;
            object2 = ((User)object3).getLoginId();
            object = object2;
        } else {
            object = "";
        }
        String oldAssignee = object;
        String string = newAssignee = assigneeNode != null ? assigneeNode.findValue("loginId").asText() : "";
        if (!oldAssignee.equals(newAssignee)) {
            oldAssignee = oldAssignee.length() == 0 ? null : oldAssignee;
            newAssignee = newAssignee.length() == 0 ? null : newAssignee;
            IssueApi.addNewIssueEvent(issue2, user, EventType.ISSUE_ASSIGNEE_CHANGED, oldAssignee, newAssignee);
        }
        object2 = IssueApi.findAssginee(json.findValue("assignees"), project2);
        object3 = issue2;
        ((Issue)object3).setAssignee((Assignee)((Object)object2));
        issue2.save();
        ObjectNode issueNode = ProjectApi.getResult(issue2);
        return IssueApi.ok((JsonNode)Json.newObject().set("result", Json.toJson((Object)IssueApi.addIssueEvents(issue2, issueNode))));
    }

    private static void addNewIssueEvent(Issue issue2, User user, EventType eventType, String oldValue, String newValue) {
        IssueEvent issueEvent = new IssueEvent();
        Object object = issue2;
        Model model = issueEvent;
        model.setIssue((Issue)object);
        model = user;
        object = null;
        object = model.getLoginId();
        model = issueEvent;
        model.setSenderLoginId((String)object);
        object = oldValue;
        model = issueEvent;
        model.setOldValue((String)object);
        object = newValue;
        model = issueEvent;
        model.setNewValue((String)object);
        object = new Date();
        model = issueEvent;
        model.setCreated((Date)object);
        object = eventType;
        model = issueEvent;
        model.setEventType((EventType)((Object)object));
        issueEvent.save();
    }

    private static JsonNode createIssuesNode(JsonNode json, Project project2, boolean sendNotification) {
        JsonNode files = json.findValue("temporaryUploadFiles");
        Issue issue2 = new Issue();
        issue2.setAuthor(IssueApi.findAuthor(json.findValue("author")));
        Object object = project2;
        Model model = issue2;
        model.setProject((Project)object);
        object = json.findValue("title").asText();
        model = issue2;
        model.setTitle((String)object);
        object = json.findValue("body").asText();
        model = issue2;
        model.setBody((String)object);
        object = IssueApi.findIssueState(json);
        model = issue2;
        model.setState((State)((Object)object));
        object = IssueApi.parseDateString(json.findValue("createdAt"));
        model = issue2;
        model.setCreatedDate((Date)object);
        object = IssueApi.parseDateString(json.findValue("updatedAt"));
        model = issue2;
        model.setUpdatedDate((Date)object);
        object = IssueApi.findAssginee(json.findValue("assignees"), project2);
        model = issue2;
        model.setAssignee((Assignee)((Object)object));
        object = IssueApi.findMilestone(json.findValue("milestoneTitle"), project2);
        model = issue2;
        model.setMilestone((Milestone)object);
        object = IssueApi.findDueDate(json.findValue("dueDate"));
        model = issue2;
        model.setDueDate((Date)object);
        IssueApi.updateLabels(json, issue2, project2);
        int n = 0;
        model = issue2;
        model.setNumOfComments(n);
        if (json.findValue("number") != null && json.findValue("number").asLong() > 0L) {
            issue2.saveWithNumber(json.findValue("number").asLong());
        } else {
            issue2.save();
        }
        IssueApi.attachUploadFilesToPost(files, issue2.asResource());
        ObjectNode result2 = Json.newObject();
        result2.put("status", 201);
        model = project2;
        String string = null;
        String string2 = string = model.getOwner();
        model = project2;
        string = null;
        string = model.getName();
        result2.put("location", routes.IssueApp.issue(string2, string, issue2.getNumber()).toString());
        if (sendNotification) {
            NotificationEvent.afterNewIssue(issue2);
        }
        return result2;
    }

    private static void updateLabels(JsonNode json, Issue issue2, Project project2) {
        JsonNode labelsNode = json.findValue("labels");
        if (labelsNode != null && labelsNode.isArray()) {
            for (JsonNode labelNode : labelsNode) {
                IssueLabel issueLabel = IssueLabel.findByName(labelNode.findValue("labelName").asText(), labelNode.findValue("category").asText(), project2);
                if (issueLabel == null) continue;
                if (issue2.labels == null) {
                    HashSet<IssueLabel> hashSet = new HashSet<IssueLabel>();
                    Issue issue3 = issue2;
                    issue3.setLabels(hashSet);
                }
                issue2.labels.add(issueLabel);
            }
        }
    }

    private static Milestone findMilestone(JsonNode milestoneTitle, Project project2) {
        if (milestoneTitle != null) {
            return Milestone.findMilestoneByTitle(project2, milestoneTitle.asText());
        }
        return null;
    }

    private static Date findDueDate(JsonNode dueDateNode) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd a hh:mm:ss Z", Locale.ENGLISH);
        if (dueDateNode != null) {
            try {
                return df.parse(dueDateNode.asText());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static State findIssueState(JsonNode json) {
        JsonNode issueNode = json.findValue("state");
        if (issueNode == null) {
            return State.OPEN;
        }
        if ("OPEN".equalsIgnoreCase(issueNode.asText())) {
            return State.OPEN;
        }
        return State.CLOSED;
    }

    public static Result commentNotiRecivers(String ownerName, String projectName, Long number) {
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((JsonNode)Json.newObject().put("message", "Expecting Json data"));
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        User user = UserApp.currentUser();
        String commentText = json.findValue("comment").asText();
        String parentCommentId = json.findValue("parentCommentId").asText();
        IssueComment comment = new IssueComment(issue2, user, commentText);
        Object object = JodaDateUtil.now();
        IssueComment issueComment = comment;
        issueComment.setCreatedDate((Date)object);
        comment.setAuthor(user);
        object = issue2;
        issueComment = comment;
        issueComment.setIssue((Issue)object);
        if (StringUtils.isNotBlank((CharSequence)parentCommentId)) {
            object = parentCommentId;
            issueComment = comment;
            issueComment.setParentCommentId((String)object);
            comment.setParentComment((Comment)IssueComment.find.byId((Object)json.findValue("parentCommentId").asLong()));
        }
        Set<User> receivers = NotificationEvent.getMandatoryReceivers(comment, EventType.NEW_COMMENT);
        ArrayList<ObjectNode> users2 = new ArrayList<ObjectNode>();
        for (User receiver : receivers) {
            IssueApi.addUserToUsers(receiver, users2);
        }
        ObjectNode result2 = Json.newObject();
        result2.put("receivers", Json.toJson(users2));
        return IssueApi.ok((JsonNode)result2);
    }

    @Transactional
    public static Result newIssueComment(String ownerName, String projectName, Long number) throws IOException {
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((String)"Expecting Json data");
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        if (IssueApi.request().getHeader("Authorization") != null) {
            ObjectNode result2 = Json.newObject();
            if (!UserApi.isAuthored(IssueApi.request())) {
                return IssueApi.unauthorized((JsonNode)result2.put("message", "unauthorized request"));
            }
            User user = UserApi.getAuthorizedUser(UserApi.getAuthorizationToken(IssueApi.request()));
            String comment = json.findValue("comment").asText();
            return IssueApi.createCommentUsingToken(issue2, user, comment);
        }
        return IssueApi.createCommentByUser(project2, issue2, json);
    }

    public static boolean isModifiedByOthers(String current, String fromView) {
        String fromViewChecksum;
        String currentChecksum = DigestUtils.sha1Hex((String)current.replaceAll("\r", "").trim());
        return !currentChecksum.equals(fromViewChecksum = DigestUtils.sha1Hex((String)fromView.replaceAll("\r", "").trim()));
    }

    public static Result detectChange(String ownerName, String projectName, Long number) {
        Object object;
        Model model;
        int currentNumOfComments;
        if (UserApp.currentUser().isAnonymous()) {
            return IssueApi.unauthorized((JsonNode)Json.newObject().put("message", "unauthorized request"));
        }
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((JsonNode)Json.newObject().put("message", "Expecting Json data"));
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        ObjectNode result2 = Json.newObject();
        String receivedChecksum = json.findValue("issueBodyChecksum").asText();
        int receivedNumOfComments = json.findValue("numOfComments").asInt();
        if (receivedNumOfComments < (currentNumOfComments = issue2.computeNumOfComments())) {
            IssueComment issueComment = issue2.comments.get(issue2.comments.size() - 1);
            model = issueComment;
            object = null;
            object = model.getAuthorLoginId();
            result2.put("commentAuthorName", User.findByLoginId((String)object).getDisplayName());
        }
        model = issue2;
        object = null;
        object = model.getBody();
        String hex = DigestUtils.sha1Hex((String)object);
        result2.put("issueBodyChanged", !hex.equals(receivedChecksum));
        result2.put("numOfComments", currentNumOfComments);
        result2.put("issueBodyChecksum", hex);
        model = issue2;
        object = null;
        object = model.getUpdatedDate();
        result2.put("issueUpdateDate", ((Date)object).getTime());
        result2.put("result", "ok");
        return IssueApi.ok((JsonNode)result2);
    }

    public static Results.Status conflicted(String content) {
        ObjectNode result2 = Json.newObject();
        result2.put("message", "Already modified by someone.");
        result2.put("storedContent", content);
        return new Results.Status(JavaResults.Conflict(), (JsonNode)result2, Codec.javaSupported((String)"utf-8"));
    }

    @Transactional
    public static Result updateIssueComment(String ownerName, String projectName, Long number, Long commentId) {
        IssueComment issueComment;
        User user = UserApp.currentUser();
        if (user.isAnonymous()) {
            return IssueApi.unauthorized((JsonNode)Json.newObject().put("message", "unauthorized request"));
        }
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((JsonNode)Json.newObject().put("message", "Expecting Json data"));
        }
        String comment = json.findValue("content").asText();
        String original = json.findValue("original").asText();
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        IssueComment issueComment2 = issueComment = issue2.findCommentByCommentId(commentId);
        String string = null;
        string = issueComment2.getContents();
        if (IssueApi.isModifiedByOthers(string, original)) {
            issueComment2 = issueComment;
            string = null;
            string = issueComment2.getContents();
            return IssueApi.conflicted(string);
        }
        if (!AccessControl.isAllowed(user, issueComment.asResource(), Operation.UPDATE)) {
            return IssueApi.forbidden((JsonNode)Json.newObject().put("message", "Forbidden request"));
        }
        string = comment;
        issueComment2 = issueComment;
        issueComment2.setContents(string);
        issueComment.save();
        ObjectNode commentNode = IssueApi.getCommentJsonNode(issueComment);
        ObjectNode authorNode = IssueApi.getAuthorJsonNode(user);
        commentNode.set("author", Json.toJson((Object)authorNode));
        ObjectNode result2 = Json.newObject();
        result2.set("result", (JsonNode)commentNode);
        return IssueApi.ok((JsonNode)result2);
    }

    private static Result createCommentByUser(Project project2, Issue issue2, JsonNode json) {
        if (!AccessControl.isResourceCreatable(UserApp.currentUser(), issue2.asResource(), ResourceType.ISSUE_COMMENT)) {
            return IssueApi.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        User user = IssueApi.findAuthor(json.findValue("author"));
        String body = json.findValue("body").asText();
        IssueComment issueComment = IssueApi.createComment(issue2, user, body, json.findValue("createdAt"));
        IssueApi.attachUploadFilesToPost(json.findValue("temporaryUploadFiles"), issueComment.asResource());
        ObjectNode result2 = Json.newObject();
        result2.put("status", 201);
        result2.put("location", RouteUtil.getUrl(issueComment));
        return IssueApi.created((JsonNode)result2);
    }

    private static Result createCommentUsingToken(Issue issue2, User user, String comment) {
        IssueApi.createComment(issue2, user, comment, null);
        ObjectNode result2 = ProjectApi.getResult(issue2);
        return IssueApi.created((JsonNode)Json.newObject().set("result", Json.toJson((Object)IssueApi.addIssueEvents(issue2, result2))));
    }

    private static IssueComment createComment(Issue issue2, User user, String comment, JsonNode dateNode) {
        IssueComment issueComment = new IssueComment(issue2, user, comment);
        Object object = dateNode == null ? JodaDateUtil.now() : IssueApi.parseDateString(dateNode);
        IssueComment issueComment2 = issueComment;
        issueComment2.setCreatedDate((Date)object);
        issueComment.setAuthor(user);
        object = issue2;
        issueComment2 = issueComment;
        issueComment2.setIssue((Issue)object);
        issueComment.save();
        return issueComment;
    }

    public static ObjectNode getCommentJsonNode(Comment comment) {
        ObjectNode commentNode = Json.newObject();
        Comment comment2 = comment;
        Object object = null;
        object = comment2.getId();
        commentNode.put("id", (Long)object);
        comment2 = comment;
        object = null;
        object = comment2.getContents();
        commentNode.put("contents", (String)object);
        comment2 = comment;
        object = null;
        object = comment2.getCreatedDate();
        commentNode.put("createdDate", JodaDateUtil.getDateString((Date)object, "yyyy-MM-dd'T'HH:mm:ssZ"));
        return commentNode;
    }

    public static ObjectNode getAuthorJsonNode(User user) {
        ObjectNode authorNode = Json.newObject();
        User user2 = user;
        Object object = null;
        object = user2.getId();
        authorNode.put("id", (Long)object);
        user2 = user;
        object = null;
        object = user2.getLoginId();
        authorNode.put("loginId", (String)object);
        user2 = user;
        object = null;
        object = user2.getName();
        authorNode.put("name", (String)object);
        return authorNode;
    }

    public static User findAuthor(JsonNode authorNode) {
        if (authorNode != null) {
            String email = authorNode.findValue("email").asText();
            User originalAuthor = User.findByEmail(email);
            if (originalAuthor != null) {
                return originalAuthor;
            }
            UserApi.createUserNode(authorNode);
            return User.findByEmail(email);
        }
        User user = User.findUserIfTokenExist(UserApp.currentUser());
        if (user.isAnonymous()) {
            Logger.error((String)"Import error caused by unknown user import!");
        }
        return user;
    }

    private static Assignee findAssginee(JsonNode assigneesNode, @Nonnull Project project2) {
        JsonNode assigneeNode;
        User user;
        if (assigneesNode != null && assigneesNode.isArray() && assigneesNode.size() > 0 && !(user = User.findByEmail((assigneeNode = assigneesNode.get(0)).findValue("email").asText())).isAnonymous()) {
            Model model = user;
            Long l = null;
            Long l2 = l = model.getId();
            model = project2;
            l = null;
            l = model.getId();
            return Assignee.add(l2, l);
        }
        return null;
    }

    public static Date parseDateString(JsonNode dateStringNode) {
        if (dateStringNode == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd a hh:mm:ss Z", Locale.ENGLISH);
        try {
            return df.parse(dateStringNode.asText());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @IsAllowed(value=Operation.READ)
    public static Result findAssignableUsersOfProject(String ownerName, String projectName, String query) {
        if (!IssueApi.request().accepts("application/json")) {
            return IssueApi.status((int)406);
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        ArrayList<ObjectNode> users2 = new ArrayList<ObjectNode>();
        if (StringUtils.isEmpty((CharSequence)query)) {
            IssueApi.addUserToUsersWithCustomName(UserApp.currentUser(), users2, Messages.get((String)"issue.assignToMe", (Object[])new Object[0]));
            for (User user : project2.getAssignableUsers()) {
                IssueApi.addUserToUsers(user, users2);
            }
            return IssueApi.ok((JsonNode)Json.toJson(users2));
        }
        ExpressionList<User> el = IssueApi.getUserExpressionList(query, IssueApi.request().getQueryString("type"));
        int total = el.findRowCount();
        if (total > 10) {
            el.setMaxRows(10);
            IssueApi.response().setHeader("Content-Range", "items 10/" + total);
        }
        IssueApi.gatheringUsersFromExpressionList(project2, users2, el);
        return IssueApi.ok((JsonNode)Json.toJson(users2));
    }

    private static void gatheringUsersFromExpressionList(Project project2, List<ObjectNode> users2, ExpressionList<User> el) {
        for (User user : el.findList()) {
            if (project2.isPublic()) {
                IssueApi.addUserToUsers(user, users2);
                continue;
            }
            if (!user.isMemberOf(project2)) {
                if (!project2.hasGroup()) continue;
                Project project3 = project2;
                Organization organization2 = null;
                organization2 = project3.getOrganization();
                if (!user.isMemberOf(organization2)) {
                    project3 = project2;
                    organization2 = null;
                    organization2 = project3.getOrganization();
                    if (!user.isAdminOf(organization2)) continue;
                }
            }
            IssueApi.addUserToUsers(user, users2);
        }
    }

    @IsAllowed(value=Operation.READ)
    public static Result findAssignableUsers(String ownerName, String projectName, Long number, String query) {
        if (!IssueApi.request().accepts("application/json")) {
            return IssueApi.status((int)406);
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        ArrayList<ObjectNode> users2 = new ArrayList<ObjectNode>();
        if (StringUtils.isEmpty((CharSequence)query)) {
            User issueAuthor = issue2.getAuthor();
            if (issue2.hasAssignee()) {
                IssueApi.addMyself(issue2, users2);
                IssueApi.addAuthorIfNotMeAndNotAssginee(issue2, users2, issueAuthor);
                IssueApi.addUserToUsersWithCustomName(User.anonymous, users2, Messages.get((String)"issue.noAssignee", (Object[])new Object[0]));
                Model model = issue2;
                Model model2 = null;
                model2 = model.getAssignee();
                model = model2;
                model2 = null;
                model2 = model.getUser();
                IssueApi.addUserToUsers((User)model2, users2);
            } else {
                IssueApi.addUserToUsersWithCustomName(UserApp.currentUser(), users2, Messages.get((String)"issue.assignToMe", (Object[])new Object[0]));
                IssueApi.addAuthorIfNotMe(issue2, users2, issueAuthor);
            }
            for (User user : project2.getAssignableUsersAndAssignee(issue2)) {
                IssueApi.addUserToUsers(user, users2);
            }
            return IssueApi.ok((JsonNode)Json.toJson(users2));
        }
        ExpressionList<User> el = IssueApi.getUserExpressionList(query, IssueApi.request().getQueryString("type"));
        int total = el.findRowCount();
        if (total > 10) {
            el.setMaxRows(10);
            IssueApi.response().setHeader("Content-Range", "items 10/" + total);
        }
        IssueApi.gatheringUsersFromExpressionList(project2, users2, el);
        return IssueApi.ok((JsonNode)Json.toJson(users2));
    }

    private static ExpressionList<User> getUserExpressionList(String query, String searchType) {
        Junction el = User.find.select("loginId, name").where().eq("state", (Object)UserState.ACTIVE).disjunction();
        if (StringUtils.isNotBlank((CharSequence)searchType)) {
            el.eq(searchType, (Object)query);
        } else {
            el.icontains("loginId", query);
            el.icontains("name", query);
            el.icontains("englishName", query);
            el.endJunction();
        }
        return el;
    }

    private static ExpressionList<Project> getProjectExpressionList(String query, String searchType) {
        Junction el = Project.find.select("id, name").where().eq("projectScope", (Object)ProjectScope.PUBLIC).disjunction();
        el.icontains("name", query);
        el.endJunction();
        return el;
    }

    private static void addAuthorIfNotMe(Issue issue2, List<ObjectNode> users2, User issueAuthor) {
        User user = issue2.getAuthor();
        String string = null;
        String string2 = string = user.getLoginId();
        user = UserApp.currentUser();
        string = null;
        string = user.getLoginId();
        if (!string2.equals(string)) {
            IssueApi.addUserToUsersWithCustomName(issueAuthor, users2, Messages.get((String)"issue.assignToAuthor", (Object[])new Object[0]));
        }
    }

    private static void addAuthorIfNotMeAndNotAssginee(Issue issue2, List<ObjectNode> users2, User issueAuthor) {
        Object object = issue2.getAuthor();
        Object object2 = null;
        String string = object2 = ((User)object).getLoginId();
        object = UserApp.currentUser();
        object2 = null;
        object2 = ((User)object).getLoginId();
        if (!string.equals(object2)) {
            object = issue2.getAuthor();
            object2 = null;
            String string2 = object2 = ((User)object).getLoginId();
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getAssignee();
            object = object2;
            object2 = null;
            object2 = ((Assignee)((Object)object)).getUser();
            object = object2;
            object2 = null;
            object2 = ((User)object).getLoginId();
            if (!string2.equals(object2)) {
                IssueApi.addUserToUsersWithCustomName(issueAuthor, users2, Messages.get((String)"issue.assignToAuthor", (Object[])new Object[0]));
            }
        }
    }

    private static void addMyself(Issue issue2, List<ObjectNode> users2) {
        Object object = UserApp.currentUser();
        Object object2 = null;
        String string = object2 = ((User)object).getLoginId();
        object = issue2;
        object2 = null;
        object2 = ((Issue)object).getAssignee();
        object = object2;
        object2 = null;
        object2 = ((Assignee)((Object)object)).getUser();
        object = object2;
        object2 = null;
        object2 = ((User)object).getLoginId();
        if (!string.equals(object2)) {
            IssueApi.addUserToUsersWithCustomName(UserApp.currentUser(), users2, Messages.get((String)"issue.assignToMe", (Object[])new Object[0]));
        }
    }

    static void addUserToUsers(User user, List<ObjectNode> users2) {
        ObjectNode userNode = Json.newObject();
        User user2 = user;
        String string = null;
        string = user2.getLoginId();
        userNode.put("loginId", string);
        userNode.put("name", user.getDisplayName());
        userNode.put("pureNameOnly", user.getPureNameOnly());
        userNode.put("avatarUrl", user.avatarUrl());
        userNode.put("type", "user");
        if (!users2.contains(userNode)) {
            users2.add(userNode);
        }
    }

    static void addProjectToProjects(Project project2, List<ObjectNode> projects2) {
        ObjectNode projectNode = Json.newObject();
        Project project3 = project2;
        Object object = null;
        object = project3.getId();
        projectNode.put("loginId", (Long)object);
        project3 = project2;
        object = null;
        object = project3.getOwner();
        StringBuilder stringBuilder = new StringBuilder().append((String)object).append("/");
        project3 = project2;
        object = null;
        object = project3.getName();
        projectNode.put("name", stringBuilder.append((String)object).toString());
        projectNode.put("avatarUrl", "");
        projectNode.put("type", "project");
        if (!projects2.contains(projectNode)) {
            projects2.add(projectNode);
        }
    }

    private static void addUserToUsersWithCustomName(User user, List<ObjectNode> users2, String name) {
        ObjectNode userNode = Json.newObject();
        User user2 = user;
        String string = null;
        string = user2.getLoginId();
        userNode.put("loginId", string);
        userNode.put("name", name);
        userNode.put("avatarUrl", "");
        if (!users2.contains(userNode)) {
            users2.add(userNode);
        }
    }

    public static Result updateAssginees(String owner, String projectName, Long number) {
        ObjectNode result2 = Json.newObject();
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        if (AccessControl.isAllowed(UserApp.currentUser(), issue2.asResource(), Operation.UPDATE)) {
            JsonNode assignees = json.findValue("assignees");
            if (assignees == null || assignees.size() == 0) {
                return IssueApi.badRequest((JsonNode)result2.put("message", "No assignee"));
            }
            boolean assigneeChanged = false;
            for (JsonNode assgineeNode : assignees) {
                Assignee newAssignee;
                Object object;
                Model model;
                User assigneeUser = User.findByLoginId(assgineeNode.asText());
                Model oldAssignee = null;
                if (issue2.hasAssignee()) {
                    model = issue2;
                    object = null;
                    object = model.getAssignee();
                    model = object;
                    object = null;
                    oldAssignee = object = model.getUser();
                }
                assigneeChanged = !issue2.assignedUserEquals(newAssignee = IssueApi.getAssignee(project2, assigneeUser));
                object = newAssignee;
                model = issue2;
                model.setAssignee((Assignee)((Object)object));
                object = JodaDateUtil.now();
                model = issue2;
                model.setUpdatedDate((Date)object);
                issue2.update();
                if (assigneeChanged) {
                    NotificationEvent notiEvent = NotificationEvent.afterAssigneeChanged((User)oldAssignee, issue2);
                    model = UserApp.currentUser();
                    object = null;
                    object = model.getLoginId();
                    IssueEvent.addFromNotificationEvent(notiEvent, issue2, (String)object);
                }
                IssueApi.composeResultJson(result2, assigneeUser);
            }
        }
        result2.put("issue", routes.IssueApp.issue(owner, projectName, number).url());
        return IssueApi.ok((JsonNode)result2);
    }

    private static void composeResultJson(ObjectNode result2, User assigneeUser) {
        ObjectNode node = Json.newObject();
        User user = assigneeUser;
        String string = null;
        string = user.getLoginId();
        node.put("loginId", string);
        if (assigneeUser.isAnonymous()) {
            node.put("name", Messages.get((String)"common.none", (Object[])new Object[0]));
        } else {
            node.put("name", assigneeUser.getDisplayName());
        }
        result2.put("assignee", (JsonNode)node);
    }

    private static Assignee getAssignee(Project project2, User assigneeUser) {
        Assignee newAssignee;
        if (assigneeUser.isAnonymous()) {
            newAssignee = null;
        } else {
            Model model = assigneeUser;
            Long l = null;
            Long l2 = l = model.getId();
            model = project2;
            l = null;
            l = model.getId();
            newAssignee = Assignee.add(l2, l);
        }
        return newAssignee;
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static F.Promise<Result> translate() {
        if (StringUtils.isBlank((CharSequence)TRANSLATION_API)) {
            return F.Promise.promise(() -> IssueApi.status((int)412, (String)"Precondition Failed"));
        }
        JsonNode json = IssueApi.request().body().asJson();
        String owner = json.findValue("owner").asText();
        String projectName = json.findValue("projectName").asText();
        String type = json.findValue("type").asText();
        long number = json.findValue("number").asLong();
        String text = "";
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        switch (type) {
            case "issue": {
                Issue issue2;
                Issue issue3 = issue2 = Issue.findByNumber(project2, number);
                String string = null;
                string = issue3.getTitle();
                StringBuilder stringBuilder = new StringBuilder().append("Title: ").append(string).append(NEWLINE).append(NEWLINE);
                issue3 = issue2;
                string = null;
                string = issue3.getBody();
                text = stringBuilder.append(string).toString();
                break;
            }
            case "posting": {
                Posting posting;
                Posting posting2 = posting = Posting.findByNumber(project2, number);
                String string = null;
                string = posting2.getTitle();
                StringBuilder stringBuilder = new StringBuilder().append("Title: ").append(string).append(NEWLINE).append(NEWLINE);
                posting2 = posting;
                string = null;
                string = posting2.getBody();
                text = stringBuilder.append(string).toString();
                break;
            }
            case "issue-comment": {
                IssueComment issueComment = (IssueComment)IssueComment.find.byId((Object)number);
                String string = null;
                text = string = issueComment.getContents();
                break;
            }
            case "post-comment": {
                PostingComment postingComment = (PostingComment)PostingComment.find.byId((Object)number);
                String string = null;
                text = string = postingComment.getContents();
                break;
            }
        }
        return IssueApi.getTranslation(text, project2, translatorWsRequestHolderSupplier);
    }

    private static F.Promise<WSResponse> translate(String text, WSRequestHolder translator) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return F.Promise.pure(null);
        }
        return translator.post("source=ko&target=en&text=" + text);
    }

    private static List<String> merge(List<String> texts) {
        ArrayList<String> results = new ArrayList<String>();
        int chunkLength = 0;
        String chunk = "";
        for (int i = 0; i < texts.size(); ++i) {
            String text = texts.get(i);
            if (chunkLength + text.length() < 4500) {
                chunk = chunk + text;
                chunk = chunk + NEWLINE;
                chunkLength += text.length();
                continue;
            }
            results.add(chunk);
            chunk = text;
            chunk = chunk + NEWLINE;
            chunkLength = text.length();
        }
        results.add(chunk);
        return results;
    }

    private static F.Promise<Result> getTranslations(List<String> texts, Project project2, Supplier<WSRequestHolder> translatorSupplier) {
        WSRequestHolder translator = translatorSupplier.get();
        List<String> mergedTexts = IssueApi.merge(texts);
        List promises = mergedTexts.stream().map(text -> IssueApi.translate(text, translator)).collect(Collectors.toList());
        return F.Promise.sequence(promises).map(results -> results.stream().map(jsonNode -> {
            if (jsonNode == null) {
                return NEWLINE;
            }
            JsonNode resultNode = jsonNode.asJson().findPath("result");
            JsonNode translatedTextNode = resultNode.findPath("translatedText");
            return translatedTextNode.textValue();
        }).collect(Collectors.toList())).map(translatedList -> {
            String translated = String.join((CharSequence)NEWLINE, translatedList);
            ObjectNode node = Json.newObject();
            node.put("translated", Markdown.render(translated, project2));
            return IssueApi.ok((JsonNode)node);
        });
    }

    private static F.Promise<Result> getTranslation(String text, Project project2, Supplier<WSRequestHolder> by) {
        List<String> texts = Arrays.asList(text.replaceAll("&", "%26").split(NEWLINE));
        return IssueApi.getTranslations(texts, project2, by);
    }

    @AnonymousCheck
    public static Result findSharerByloginIds(String ownerName, String projectName, Long number, String commaSeperatedIds) {
        if (!IssueApi.request().accepts("application/json")) {
            return IssueApi.status((int)406);
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        List list2 = IssueApi.getExpressionListByExtractingLoginIds(issue2, commaSeperatedIds).findList();
        IssueApi.sortListByAddedDate(list2);
        ArrayList<ObjectNode> users2 = new ArrayList<ObjectNode>();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            IssueSharer sharer;
            IssueSharer issueSharer = sharer = (IssueSharer)((Object)iterator.next());
            User user = null;
            user = issueSharer.getUser();
            IssueApi.addUserToUsers(user, users2);
        }
        return IssueApi.ok((JsonNode)Json.toJson(users2));
    }

    private static void sortListByAddedDate(List<IssueSharer> list2) {
        list2.sort(new Comparator<IssueSharer>(){

            @Override
            public int compare(IssueSharer o1, IssueSharer o2) {
                IssueSharer issueSharer = o1;
                Date date = null;
                Date date2 = date = issueSharer.getCreated();
                issueSharer = o2;
                date = null;
                date = issueSharer.getCreated();
                return date2.compareTo(date);
            }
        });
    }

    private static ExpressionList<IssueSharer> getExpressionListByExtractingLoginIds(Issue issue2, String query) {
        String[] queryItems = query.split(",");
        Issue issue3 = issue2;
        Long l = null;
        l = issue3.getId();
        ExpressionList el = IssueSharer.find.where().in("loginId", Arrays.asList(queryItems)).eq("issue.id", (Object)l);
        return el;
    }

    @IsAllowed(value=Operation.READ)
    public static Result findSharableUsers(String ownerName, String projectName, Long number, String query) {
        if (!IssueApi.request().accepts("application/json")) {
            return IssueApi.status((int)406);
        }
        ArrayList<ObjectNode> results = new ArrayList<ObjectNode>();
        ExpressionList<User> userExpressionList = IssueApi.getUserExpressionList(query, IssueApi.request().getQueryString("type"));
        ExpressionList<Project> projectExpressionList = IssueApi.getProjectExpressionList(query, IssueApi.request().getQueryString("type"));
        int total = userExpressionList.findRowCount() + projectExpressionList.findRowCount();
        if (total > 10) {
            userExpressionList.setMaxRows(5);
            projectExpressionList.setMaxRows(5);
            IssueApi.response().setHeader("Content-Range", "items 10/" + total);
        }
        for (User user : userExpressionList.findList()) {
            IssueApi.addUserToUsers(user, results);
        }
        for (Project project2 : projectExpressionList.findList()) {
            IssueApi.addProjectToProjects(project2, results);
        }
        return IssueApi.ok((JsonNode)Json.toJson(results));
    }

    public static Result updateSharer(String owner, String projectName, Long number) {
        JsonNode json = IssueApi.request().body().asJson();
        if (json == null) {
            return IssueApi.badRequest((JsonNode)Json.newObject().put("message", "Expecting Json data"));
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        if (!AccessControl.isAllowed(UserApp.currentUser(), issue2.asResource(), Operation.UPDATE)) {
            return IssueApi.forbidden((JsonNode)Json.newObject().put("message", "Permission denied"));
        }
        JsonNode sharer = json.findValue("sharer");
        if (IssueApi.noSharer(sharer)) {
            return IssueApi.badRequest((JsonNode)Json.newObject().put("message", "No sharer"));
        }
        String action = json.findValue("action").asText();
        ObjectNode result2 = IssueApi.changeSharer(sharer, issue2, action);
        return IssueApi.ok((JsonNode)result2);
    }

    public static Result upvoteWeight(String owner, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        if (!AccessControl.isAllowed(UserApp.currentUser(), issue2.asResource(), Operation.UPDATE)) {
            return IssueApi.forbidden((JsonNode)Json.newObject().put("message", "Permission denied"));
        }
        Issue issue3 = issue2;
        Integer n = null;
        n = issue3.getWeight();
        n = n + 1;
        issue3 = issue2;
        issue3.setWeight(n);
        issue2.update();
        ObjectNode result2 = Json.newObject();
        issue3 = issue2;
        n = null;
        n = issue3.getWeight();
        result2.put("weight", n);
        return IssueApi.ok((JsonNode)result2);
    }

    public static Result downvoteWeight(String owner, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        if (!AccessControl.isAllowed(UserApp.currentUser(), issue2.asResource(), Operation.UPDATE)) {
            return IssueApi.forbidden((JsonNode)Json.newObject().put("message", "Permission denied"));
        }
        Issue issue3 = issue2;
        Integer n = null;
        n = issue3.getWeight();
        n = n - 1;
        issue3 = issue2;
        issue3.setWeight(n);
        issue2.update();
        ObjectNode result2 = Json.newObject();
        issue3 = issue2;
        n = null;
        n = issue3.getWeight();
        result2.put("weight", n);
        return IssueApi.ok((JsonNode)result2);
    }

    private static ObjectNode changeSharer(JsonNode sharer, Issue issue2, String action) {
        ObjectNode result2 = Json.newObject();
        ArrayList<String> users2 = new ArrayList<String>();
        if (sharer.findValue("type").asText().equals("project")) {
            IssueApi.changeSharerByProject(sharer.findValue("loginId").asLong(), issue2, action, result2, users2);
        } else {
            IssueApi.changeSharerByUser(sharer.findValue("loginId").asText(), issue2, action, result2, users2);
        }
        IssueApi.sendNotification(users2, issue2, action);
        return result2;
    }

    private static void changeSharerByUser(String loginId, Issue issue2, String action, ObjectNode result2, List<String> users2) {
        if ("add".equalsIgnoreCase(action)) {
            IssueApi.addSharer(issue2, loginId);
        } else if ("delete".equalsIgnoreCase(action)) {
            IssueApi.removeSharer(issue2, loginId);
        } else {
            Logger.error((String)("Unknown issue sharing action: " + issue2 + ":" + action + " by " + UserApp.currentUser()));
        }
        users2.add(loginId);
        IssueApi.setShareActionToResponse(action, result2);
        result2.put("sharer", User.findByLoginId(loginId).getDisplayName());
    }

    private static void changeSharerByProject(Long projectId, Issue issue2, String action, ObjectNode result2, List<String> users2) {
        Object object;
        Object object2;
        List<ProjectUser> projectUsers = ProjectUser.findMemberListByProject(projectId);
        for (ProjectUser projectUser : projectUsers) {
            if ("add".equalsIgnoreCase(action)) {
                object2 = projectUser;
                object = null;
                object2 = object = ((ProjectUser)((Object)object2)).getUser();
                object = null;
                object = ((User)object2).getLoginId();
                IssueApi.addSharer(issue2, (String)object);
            } else if ("delete".equalsIgnoreCase(action)) {
                object2 = projectUser;
                object = null;
                object2 = object = ((ProjectUser)((Object)object2)).getUser();
                object = null;
                object = ((User)object2).getLoginId();
                IssueApi.removeSharer(issue2, (String)object);
            } else {
                Logger.error((String)("Unknown issue sharing action: " + issue2 + ":" + action + " by " + UserApp.currentUser()));
            }
            object2 = projectUser;
            object = null;
            object2 = object = ((ProjectUser)((Object)object2)).getUser();
            object = null;
            object = ((User)object2).getLoginId();
            users2.add((String)object);
        }
        IssueApi.setShareActionToResponse(action, result2);
        object2 = (Project)Project.find.byId((Object)projectId);
        object = null;
        object = ((Project)object2).getName();
        result2.put("sharer", (String)object);
    }

    private static void setShareActionToResponse(String action, ObjectNode result2) {
        if ("add".equalsIgnoreCase(action)) {
            result2.put("action", "added");
        } else if ("delete".equalsIgnoreCase(action)) {
            result2.put("action", "deleted");
        } else {
            result2.put("action", "Do nothing. Unsupported action: " + action);
        }
    }

    private static void sendNotification(final List<String> users2, final Issue issue2, final String action) {
        Runnable preUpdateHook = new Runnable(){

            @Override
            public void run() {
                for (String sharerLoginId : users2) {
                    IssueApi.addSharerChangedNotification(issue2, sharerLoginId, action);
                }
            }
        };
        preUpdateHook.run();
    }

    private static void addSharerChangedNotification(Issue issue2, String sharerLoginId, String action) {
        NotificationEvent notiEvent = NotificationEvent.afterIssueSharerChanged(issue2, sharerLoginId, action);
        User user = UserApp.currentUser();
        String string = null;
        string = user.getLoginId();
        IssueEvent.addFromNotificationEventWithoutSkipEvent(notiEvent, issue2, string);
    }

    private static boolean noSharer(JsonNode sharers2) {
        return sharers2 == null || sharers2.size() == 0;
    }

    private static void addSharer(Issue issue2, String loginId) {
        Issue issue3 = issue2;
        Object object = null;
        object = issue3.getId();
        IssueSharer issueSharer = (IssueSharer)((Object)IssueSharer.find.where().eq("loginId", (Object)loginId).eq("issue.id", object).findUnique());
        if (issueSharer == null) {
            issueSharer = IssueSharer.createSharer(loginId, issue2);
            issueSharer.save();
        }
        issue3 = issue2;
        object = null;
        object = issue3.getSharers();
        object.add(issueSharer);
    }

    private static void removeSharer(Issue issue2, String loginId) {
        Issue issue3 = issue2;
        Object object = null;
        object = issue3.getId();
        IssueSharer issueSharer = (IssueSharer)((Object)IssueSharer.find.where().eq("loginId", (Object)loginId).eq("issue.id", object).findUnique());
        issueSharer.delete();
        issue3 = issue2;
        object = null;
        object = issue3.getSharers();
        object.remove((Object)issueSharer);
    }
}

