/*
 * Decompiled with CFR 0.152.
 */
package controllers.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AbstractPostingApp;
import controllers.UserApp;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsCreatable;
import controllers.api.IssueApi;
import controllers.api.ProjectApi;
import controllers.routes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import models.IssueLabel;
import models.Posting;
import models.PostingComment;
import models.Project;
import models.User;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.Json;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.ErrorViews;
import utils.RouteUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class BoardApi
extends AbstractPostingApp {
    @Transactional
    public static Result updatePostLabel(String owner, String projectName, Long number) {
        JsonNode json = BoardApi.request().body().asJson();
        if (json == null) {
            return BoardApi.badRequest((String)"Expecting Json data");
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Posting posting = Posting.findByNumber(project2, number);
        HashSet<IssueLabel> labels2 = new HashSet<IssueLabel>();
        for (JsonNode node : json) {
            Long labelId = Long.parseLong(node.asText());
            labels2.add((IssueLabel)IssueLabel.finder.byId((Object)labelId));
        }
        Set<IssueLabel> set = labels2;
        Model model = posting;
        model.setLabels(set);
        posting.save();
        ObjectNode result2 = Json.newObject();
        model = project2;
        set = null;
        set = model.getOwner();
        result2.put("id", (String)((Object)set));
        model = posting;
        set = null;
        set = model.getLabels();
        result2.put("labels", Json.toJson((Object)set.size()));
        return BoardApi.ok((JsonNode)result2);
    }

    @IsAllowed(value=Operation.READ, resourceType=ResourceType.BOARD_POST)
    public static Result getPosts(String owner, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Posting post2 = Posting.findByNumber(project2, number);
        ObjectNode json = Json.newObject();
        Posting posting = post2;
        String string = null;
        string = posting.getTitle();
        json.put("title", string);
        posting = post2;
        string = null;
        string = posting.getBody();
        json.put("body", string);
        posting = post2;
        string = null;
        string = posting.getAuthorLoginId();
        json.put("author", string);
        return BoardApi.ok((JsonNode)json);
    }

    @Transactional
    @IsCreatable(value=ResourceType.BOARD_POST)
    public static Result newPostings(String owner, String projectName) {
        ObjectNode result2 = Json.newObject();
        JsonNode json = BoardApi.request().body().asJson();
        if (json == null) {
            return BoardApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        JsonNode postingsNode = json.findValue("posts");
        if (postingsNode == null || !postingsNode.isArray()) {
            return BoardApi.badRequest((JsonNode)result2.put("message", "No posts key exists or value wasn't array!"));
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        ArrayList<JsonNode> createdPostings = new ArrayList<JsonNode>();
        for (JsonNode postingNode : postingsNode) {
            createdPostings.add(BoardApi.createPostingNode(postingNode, project2));
        }
        return BoardApi.created((JsonNode)Json.toJson(createdPostings));
    }

    private static JsonNode createPostingNode(JsonNode json, Project project2) {
        JsonNode files = json.findValue("temporaryUploadFiles");
        Posting posting = new Posting();
        posting.setAuthor(IssueApi.findAuthor(json.findValue("author")));
        Object object = project2;
        Model model = posting;
        model.setProject((Project)object);
        object = json.findValue("title").asText();
        model = posting;
        model.setTitle((String)object);
        object = json.findValue("body").asText();
        model = posting;
        model.setBody((String)object);
        object = IssueApi.parseDateString(json.findValue("createdAt"));
        model = posting;
        model.setCreatedDate((Date)object);
        object = IssueApi.parseDateString(json.findValue("updatedAt"));
        model = posting;
        model.setUpdatedDate((Date)object);
        int n = 0;
        model = posting;
        model.setNumOfComments(n);
        if (json.findValue("number") != null && json.findValue("number").asLong() > 0L) {
            posting.saveWithNumber(json.findValue("number").asLong());
        } else {
            posting.save();
        }
        BoardApi.attachUploadFilesToPost(files, posting.asResource());
        ObjectNode result2 = Json.newObject();
        result2.put("status", 201);
        model = project2;
        String string = null;
        String string2 = string = model.getOwner();
        model = project2;
        string = null;
        string = model.getName();
        result2.put("location", routes.BoardApp.post(string2, string, posting.getNumber()).toString());
        return result2;
    }

    @Transactional
    public static Result updatePostingContent(String owner, String projectName, Long number) {
        User user = UserApp.currentUser();
        if (user.isAnonymous()) {
            return BoardApi.unauthorized((JsonNode)Json.newObject().put("message", "unauthorized request"));
        }
        JsonNode json = BoardApi.request().body().asJson();
        if (json == null) {
            return BoardApi.badRequest((JsonNode)Json.newObject().put("message", "Expecting Json data"));
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Posting posting = Posting.findByNumber(project2, number);
        if (!AccessControl.isAllowed(user, posting.asResource(), Operation.UPDATE)) {
            return BoardApi.forbidden((JsonNode)Json.newObject().put("message", "Forbidden request"));
        }
        String content = json.findValue("content").asText();
        String original = json.findValue("original").asText();
        Posting posting2 = posting;
        String string = null;
        string = posting2.getBody();
        if (IssueApi.isModifiedByOthers(string, original)) {
            posting2 = posting;
            string = null;
            string = posting2.getBody();
            return IssueApi.conflicted(string);
        }
        string = content;
        posting2 = posting;
        posting2.setBody(string);
        posting.update();
        return BoardApi.ok((JsonNode)ProjectApi.getResult(posting));
    }

    @Transactional
    @IsCreatable(value=ResourceType.NONISSUE_COMMENT)
    public static Result newPostingComment(String ownerName, String projectName, Long number) throws IOException {
        JsonNode json = BoardApi.request().body().asJson();
        if (json == null) {
            return BoardApi.badRequest((String)"Expecting Json data");
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Posting posting = Posting.findByNumber(project2, number);
        if (!AccessControl.isResourceCreatable(UserApp.currentUser(), posting.asResource(), ResourceType.NONISSUE_COMMENT)) {
            return BoardApi.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        User user = IssueApi.findAuthor(json.findValue("author"));
        String body = json.findValue("body").asText();
        PostingComment comment = new PostingComment(posting, user, body);
        Object object = IssueApi.parseDateString(json.findValue("createdAt"));
        PostingComment postingComment = comment;
        postingComment.setCreatedDate((Date)object);
        comment.setAuthor(user);
        object = posting;
        postingComment = comment;
        postingComment.setPosting((Posting)object);
        comment.save();
        Logger.warn((String)json.findValue("temporaryUploadFiles").asText());
        BoardApi.attachUploadFilesToPost(json.findValue("temporaryUploadFiles"), comment.asResource());
        ObjectNode result2 = Json.newObject();
        result2.put("status", 201);
        result2.put("location", RouteUtil.getUrl(comment));
        return BoardApi.created((JsonNode)result2);
    }

    @Transactional
    public static Result updatePostingComment(String ownerName, String projectName, Long number, Long commentId) {
        ObjectNode result2 = Json.newObject();
        User user = UserApp.currentUser();
        if (user.isAnonymous()) {
            return BoardApi.unauthorized((JsonNode)result2.put("message", "unauthorized request"));
        }
        JsonNode json = BoardApi.request().body().asJson();
        if (json == null) {
            return BoardApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Posting posting = Posting.findByNumber(project2, number);
        PostingComment postingComment = posting.findCommentByCommentId(commentId);
        if (!AccessControl.isAllowed(user, postingComment.asResource(), Operation.UPDATE)) {
            return BoardApi.forbidden((JsonNode)Json.newObject().put("message", "Forbidden request"));
        }
        String comment = json.findValue("content").asText();
        String original = json.findValue("original").asText();
        PostingComment postingComment2 = postingComment;
        String string = null;
        string = postingComment2.getContents();
        if (IssueApi.isModifiedByOthers(string, original)) {
            postingComment2 = postingComment;
            string = null;
            string = postingComment2.getContents();
            return IssueApi.conflicted(string);
        }
        string = comment;
        postingComment2 = postingComment;
        postingComment2.setContents(string);
        postingComment.save();
        ObjectNode commentNode = IssueApi.getCommentJsonNode(postingComment);
        ObjectNode authorNode = IssueApi.getAuthorJsonNode(user);
        commentNode.set("author", Json.toJson((Object)authorNode));
        result2.set("result", (JsonNode)commentNode);
        return BoardApi.ok((JsonNode)result2);
    }
}

