/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import models.Project;
import models.User;
import models.UserProjectNotification;
import models.Watch;
import models.enumeration.EventType;
import models.enumeration.Operation;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.ErrorViews;

@AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class WatchProjectApp
extends Controller {
    @IsAllowed(value=Operation.READ)
    @Transactional
    public static Result watch(String userName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        Watch.watch(project2.asResource());
        return WatchProjectApp.ok();
    }

    @IsAllowed(value=Operation.READ)
    @Transactional
    public static Result unwatch(String loginId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        Watch.unwatch(project2.asResource());
        UserProjectNotification.deleteUnwatchedProjectNotifications(UserApp.currentUser(), project2);
        return WatchProjectApp.ok();
    }

    public static Result toggle(Long projectId, String notificationType) {
        EventType notiType = EventType.valueOf(notificationType);
        Project project2 = (Project)Project.find.byId((Object)projectId);
        User user = UserApp.currentUser();
        if (project2 == null) {
            return WatchProjectApp.notFound((Content)ErrorViews.NotFound.render("error.notfound.project"));
        }
        if (!AccessControl.isAllowed(user, project2.asResource(), Operation.READ)) {
            return WatchProjectApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        if (!Watch.isWatching(user, project2.asResource())) {
            return WatchProjectApp.badRequest((String)Messages.get((String)"error.notfound.watch", (Object[])new Object[0]));
        }
        UserProjectNotification userProjectNotification = UserProjectNotification.findOne(user, project2, notiType);
        if (userProjectNotification == null) {
            if (UserProjectNotification.isNotifiedByDefault(notiType)) {
                UserProjectNotification.unwatchExplictly(user, project2, notiType);
            } else {
                UserProjectNotification.watchExplictly(user, project2, notiType);
            }
        } else {
            userProjectNotification.toggle(notiType);
        }
        return WatchProjectApp.ok();
    }
}

